/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.command;

import com.bstek.dorado.data.provider.Page;
import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import java.util.Collection;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryPageCommand
implements Command<Page<?>> {
    private DetachedCriteria detachedCriteria;
    private Page<?> page;

    public QueryPageCommand(DetachedCriteria detachedCriteria, Page<?> page) {
        this.detachedCriteria = detachedCriteria;
        this.page = page;
    }

    public Page<?> execute(Context context) {
        Session session = context.getSession();
        int pageSize = this.page.getPageSize();
        int startIndex = (this.page.getPageNo() - 1) * pageSize;
        Criteria criteria = this.detachedCriteria.getExecutableCriteria(session);
        criteria.setFirstResult(startIndex).setMaxResults(pageSize);
        this.page.setEntities((Collection)criteria.list());
        Object object = criteria.setProjection(Projections.rowCount()).uniqueResult();
        int totalCount = 0;
        if (object instanceof Long) {
            totalCount = ((Long)object).intValue();
        } else if (object instanceof Integer) {
            totalCount = (Integer)object;
        }
        this.page.setEntityCount(totalCount);
        return this.page;
    }
}

