/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.serializer.impl;

import com.bstek.uflo.designer.model.AssignmentType;
import com.bstek.uflo.designer.model.SwimlaneAssignee;
import com.bstek.uflo.designer.model.node.Node;
import com.bstek.uflo.designer.model.process.Process;
import com.bstek.uflo.designer.model.process.Swimlane;
import com.bstek.uflo.designer.serializer.ProcessSerializer;
import com.bstek.uflo.designer.serializer.ShapeSerializer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="uflo.designer.processSerializer")
public class DefaultProcessSerializer
implements ProcessSerializer,
ApplicationContextAware {
    private Collection<ShapeSerializer> shapeSerializerColl;

    public Document execute(Process process) throws Exception {
        String desc;
        Date effectDate;
        String categoryId;
        String eventHandlerBean;
        String startProcessUrl;
        String key;
        Assert.notNull((Object)process);
        Document document = DocumentHelper.createDocument();
        Element processElement = document.addElement("uflo-process");
        String name = process.getName();
        if (StringUtils.isNotEmpty((String)name)) {
            processElement.addAttribute("name", name);
        }
        if (StringUtils.isNotEmpty((String)(key = process.getKey()))) {
            processElement.addAttribute("key", key);
        }
        if (StringUtils.isNotEmpty((String)(startProcessUrl = process.getStartProcessUrl()))) {
            processElement.addAttribute("start-process-url", startProcessUrl);
        }
        if (StringUtils.isNotEmpty((String)(eventHandlerBean = process.getEventHandlerBean()))) {
            processElement.addAttribute("event-handler-bean", eventHandlerBean);
        }
        if (StringUtils.isNotEmpty((String)(categoryId = process.getCategoryId()))) {
            processElement.addAttribute("category-id", categoryId);
        }
        if ((effectDate = process.getEffectDate()) != null) {
            processElement.addAttribute("effect-date", FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(effectDate));
        }
        if (StringUtils.isNotEmpty((String)(desc = process.getDescription()))) {
            Element descriptionElement = processElement.addElement("description");
            descriptionElement.addText(desc);
        }
        this.serializerSwimlane(process, processElement);
        this.serializerNode(process, processElement);
        return document;
    }

    private void serializerSwimlane(Process process, Element processElement) {
        List<Swimlane> swimlanes = process.getSwimlanes();
        if (swimlanes != null) {
            for (Swimlane swimlane : swimlanes) {
                List<SwimlaneAssignee> swimlaneAssignees;
                String assignmentType = swimlane.getAssignmentType();
                if (!StringUtils.isNotEmpty((String)assignmentType)) continue;
                Element swimlaneElement = processElement.addElement("swimlane");
                swimlaneElement.addAttribute("name", swimlane.getName());
                swimlaneElement.addAttribute("assignment-type", swimlane.getAssignmentType());
                if (assignmentType.equals(AssignmentType.Expression.name())) {
                    swimlaneElement.addAttribute("expression", swimlane.getExpression());
                    continue;
                }
                if (assignmentType.equals(AssignmentType.Handler.name())) {
                    swimlaneElement.addAttribute("assignment-handler-bean", swimlane.getAssignmentHandlerBean());
                    continue;
                }
                if (!assignmentType.equals(AssignmentType.Assignee.name()) || (swimlaneAssignees = swimlane.getSwimlaneAssignees()) == null) continue;
                for (SwimlaneAssignee swimlaneAssignee : swimlaneAssignees) {
                    Element swimlaneAssigneeElement = swimlaneElement.addElement("assignee");
                    swimlaneAssigneeElement.addAttribute("id", swimlaneAssignee.getId());
                    swimlaneAssigneeElement.addAttribute("name", swimlaneAssignee.getName());
                    swimlaneAssigneeElement.addAttribute("provider-id", swimlaneAssignee.getProviderId());
                }
            }
        }
    }

    private void serializerNode(Process process, Element processElement) {
        List<Node> nodes = process.getNodes();
        for (Node node : nodes) {
            for (ShapeSerializer shapeSerializer : this.shapeSerializerColl) {
                if (!shapeSerializer.support(node)) continue;
                shapeSerializer.execute(processElement, node);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.shapeSerializerColl = applicationContext.getBeansOfType(ShapeSerializer.class).values();
    }
}

