/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.graph.impl;

import com.bstek.uflo.designer.graph.GraphService;
import com.bstek.uflo.designer.model.Point;
import com.bstek.uflo.designer.model.Rectangle;
import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.edge.Connection;
import com.bstek.uflo.designer.model.node.Node;
import com.bstek.uflo.designer.model.process.Process;
import com.bstek.uflo.designer.security.manager.SecurityManager;
import com.bstek.uflo.designer.security.model.NodeEntry;
import com.bstek.uflo.designer.security.model.NodeSecurityAttribute;
import com.bstek.uflo.designer.security.model.ProcessAttribute;
import com.bstek.uflo.designer.security.model.ProcessEntry;
import com.bstek.uflo.designer.utils.EscapeUtils;
import com.bstek.uflo.designer.utils.JSONUtils;
import com.bstek.uflo.designer.utils.ShapeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="uflo.designer.graphService")
public class GraphServiceImpl
implements GraphService {
    @Autowired
    @Qualifier(value="uflo.designer.SecurityManager")
    private SecurityManager securityManager;

    @Override
    public Process serializer(Document doc) throws Exception {
        Element root = doc.getRootElement();
        String entityData = root.attributeValue("entityData");
        Process process = StringUtils.isNotEmpty((String)entityData) ? JSONUtils.fromJSON(EscapeUtils.unescape(entityData), Process.class) : new Process("process");
        process.cleanUselessValue();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (Object elementObj : root.elements()) {
            Object obj;
            Element element = (Element)elementObj;
            String clazz = element.attributeValue("clazz");
            String nodeEntryId = element.attributeValue("nodeEntryId");
            entityData = element.attributeValue("entityData");
            Object obj2 = obj = StringUtils.isNotEmpty((String)entityData) ? JSONUtils.fromJSON(EscapeUtils.unescape(entityData), Class.forName(clazz)) : Class.forName(clazz).newInstance();
            if (obj instanceof Shape) {
                this.fillCommonAttributeValue((Shape)obj, element);
            }
            if (obj instanceof Connection) {
                Connection connection = (Connection)obj;
                connection.cleanUselessValue();
                connection.setName(EscapeUtils.unescape(element.attributeValue("toLabel")));
                String from = element.attributeValue("from");
                String to = element.attributeValue("to");
                if (!StringUtils.isNotEmpty((String)from) || !StringUtils.isNotEmpty((String)to)) continue;
                String fromNodeId = from.substring(0, element.attributeValue("from").indexOf("_TERMINAL"));
                String toNodeId = to.substring(0, element.attributeValue("to").indexOf("_TERMINAL"));
                String vertices = EscapeUtils.unescape(element.attributeValue("vertices"));
                connection.setFromNodeId(fromNodeId);
                connection.setToNodeId(toNodeId);
                connection.setVertices(this.buildConnectionPoints(vertices));
                connection.setNodeEntryId(nodeEntryId);
                connections.add(connection);
                continue;
            }
            if (!(obj instanceof Node)) continue;
            Node node = (Node)obj;
            node.cleanUselessValue();
            node.setName(EscapeUtils.unescape(element.attributeValue("label")));
            process.getNodes().add(node);
            if (!StringUtils.isNotEmpty((String)nodeEntryId)) continue;
            this.securityManager.updateNodeEntry(nodeEntryId, node.getName());
        }
        for (Connection connection : connections) {
            String fromNodeId = connection.getFromNodeId();
            String toNodeId = connection.getToNodeId();
            Node fromNode = ShapeUtils.findNodeById(process.getNodes(), fromNodeId);
            Node toNode = ShapeUtils.findNodeById(process.getNodes(), toNodeId);
            if (fromNode == null || toNode == null) continue;
            String nodeEntryId = connection.getNodeEntryId();
            if (StringUtils.isNotEmpty((String)nodeEntryId)) {
                String name = connection.getName();
                if (!StringUtils.isNotEmpty((String)name)) {
                    name = "to " + toNode.getName();
                }
                this.securityManager.updateNodeEntry(nodeEntryId, name);
            }
            connection.setFromNode(fromNode);
            connection.setToNode(toNode);
            fromNode.getOutConnections().add(connection);
        }
        return process;
    }

    @Override
    public Document deserializer(Process process) throws Exception {
        String toNodeId;
        List<Connection> connections = process.getConnections();
        List<Node> nodes = process.getNodes();
        ArrayList<Map<String, String>> cellAttributeList = new ArrayList<Map<String, String>>();
        HashMap<String, String> cellAttribute = null;
        for (Connection connection : connections) {
            String fromNodeId = connection.getFromNodeId();
            String toNodeName = connection.getToNodeName();
            Node fromNode = ShapeUtils.findNodeById(process.getNodes(), fromNodeId);
            Node toNode = ShapeUtils.findNodeByName(process.getNodes(), toNodeName);
            toNodeId = toNode.getId();
            connection.setToNodeId(toNodeId);
            if (StringUtils.isNotEmpty((String)fromNode.getToNodeId())) {
                fromNode.setToNodeId(String.valueOf(fromNode.getToNodeId()) + "," + toNodeId);
            } else {
                fromNode.setToNodeId(toNodeId);
            }
            if (StringUtils.isNotEmpty((String)fromNode.getToConnectionId())) {
                fromNode.setToConnectionId(String.valueOf(fromNode.getToConnectionId()) + "," + connection.getId());
            } else {
                fromNode.setToConnectionId(connection.getId());
            }
            if (StringUtils.isNotEmpty((String)toNode.getFromNodeId())) {
                toNode.setFromNodeId(String.valueOf(toNode.getFromNodeId()) + "," + fromNodeId);
            } else {
                toNode.setFromNodeId(fromNodeId);
            }
            if (StringUtils.isNotEmpty((String)toNode.getFromConnectionId())) {
                toNode.setFromConnectionId(String.valueOf(toNode.getFromConnectionId()) + "," + connection.getId());
            } else {
                toNode.setFromConnectionId(connection.getId());
            }
            cellAttribute = new HashMap();
            cellAttribute.put("id", connection.getId());
            cellAttribute.put("shapeType", connection.getShapeType());
            cellAttribute.put("shapeId", connection.getShapeId());
            cellAttribute.put("style", EscapeUtils.escape(connection.getEdgeStyle()));
            cellAttribute.put("toLabel", EscapeUtils.escape(connection.getName()));
            cellAttribute.put("value", connection.getEdgeValue(fromNode, toNode));
            cellAttribute.put("geom", EscapeUtils.escape(connection.getEdgeGeomValue(fromNode, toNode)));
            cellAttribute.put("from", connection.getEdgeFromValue());
            cellAttribute.put("to", connection.getEdgeToValue());
            cellAttribute.put("entityData", EscapeUtils.escape(connection.toJSON()));
            this.addSecurityAttribute(process.getProcessEntry(), connection, cellAttribute);
            cellAttributeList.add(cellAttribute);
        }
        for (Node node : nodes) {
            String fromNodeId;
            cellAttribute = new HashMap<String, String>();
            int x = node.getRectangle().getPoint().getX();
            int y = node.getRectangle().getPoint().getY();
            int width = node.getRectangle().getWidth();
            int height = node.getRectangle().getHeight();
            cellAttribute.put("id", node.getId());
            cellAttribute.put("x", String.valueOf(x));
            cellAttribute.put("y", String.valueOf(y));
            cellAttribute.put("width", String.valueOf(width));
            cellAttribute.put("height", String.valueOf(height));
            cellAttribute.put("label", node.getName());
            cellAttribute.put("shapeId", node.getShapeId());
            cellAttribute.put("shapeType", node.getShapeType());
            cellAttribute.put("value", node.getShapeValue());
            cellAttribute.put("geom", node.getShapeGeomValue());
            cellAttribute.put("entityData", EscapeUtils.escape(node.toJSON()));
            toNodeId = node.getToNodeId();
            if (StringUtils.isNotEmpty((String)toNodeId)) {
                cellAttribute.put("to", toNodeId);
                cellAttribute.put("toEdge", node.getToConnectionId());
            }
            if (StringUtils.isNotEmpty((String)(fromNodeId = node.getFromNodeId()))) {
                cellAttribute.put("from", fromNodeId);
                cellAttribute.put("fromEdge", node.getFromConnectionId());
            }
            this.addSecurityAttribute(process.getProcessEntry(), node, cellAttribute);
            cellAttributeList.add(cellAttribute);
        }
        Document document = this.buildDocument(process, cellAttributeList);
        return document;
    }

    private void addSecurityAttribute(ProcessEntry processEntry, Shape shape, Map<String, String> cellAttribute) throws Exception {
        List<NodeEntry> nodeEntryList;
        if (processEntry != null && (nodeEntryList = processEntry.getNodeEntrylist()) != null) {
            NodeEntry nodeEntry;
            String name = null;
            if (shape instanceof Connection) {
                Connection con = (Connection)shape;
                name = StringUtils.isNotEmpty((String)con.getName()) ? con.getName() : "to " + con.getToNodeName();
            } else if (shape instanceof Node) {
                name = ((Node)shape).getName();
            }
            if (StringUtils.isNotEmpty(name) && (nodeEntry = this.findNodeEntry(name, nodeEntryList)) != null && nodeEntry.isPersistence()) {
                cellAttribute.put("nodeEntryId", nodeEntry.getId());
                String nodeEntryData = JSONUtils.toJSON(nodeEntry);
                cellAttribute.put("nodeEntryData", EscapeUtils.escape(nodeEntryData));
            }
        }
    }

    private NodeEntry findNodeEntry(String name, List<NodeEntry> nodeEntryList) {
        for (NodeEntry nodeEntry : nodeEntryList) {
            if (!nodeEntry.getName().equals(name)) continue;
            return nodeEntry;
        }
        return null;
    }

    private Document buildDocument(Process process, List<Map<String, String>> cellAttributeList) throws Exception {
        ProcessEntry processEntry = process.getProcessEntry();
        String rootEntityJsonData = EscapeUtils.escape(process.toJSON());
        Document document = DocumentHelper.createDocument();
        Element opengraphElement = document.addElement("opengraph");
        opengraphElement.addAttribute("width", "10000");
        opengraphElement.addAttribute("height", "10000");
        opengraphElement.addAttribute("entityData", rootEntityJsonData);
        if (processEntry != null) {
            List<NodeSecurityAttribute> nodeSecurityAttributeList;
            List<ProcessAttribute> processAttributeList = processEntry.getProcessAttributeList();
            if (processAttributeList != null) {
                String processAttributes = JSONUtils.toJSON(processAttributeList);
                opengraphElement.addAttribute("processAttributes", EscapeUtils.escape(processAttributes));
            }
            if ((nodeSecurityAttributeList = processEntry.getNodeSecurityAttributeList()) != null) {
                String nodeSecurityAttributes = JSONUtils.toJSON(nodeSecurityAttributeList);
                opengraphElement.addAttribute("nodeSecurityAttributes", EscapeUtils.escape(nodeSecurityAttributes));
            }
        }
        for (Map<String, String> cell : cellAttributeList) {
            Element cellElement = opengraphElement.addElement("cell");
            for (Map.Entry<String, String> entry : cell.entrySet()) {
                cellElement.addAttribute(entry.getKey(), entry.getValue());
            }
        }
        return document;
    }

    private void fillCommonAttributeValue(Shape shape, Element element) {
        shape.setId(element.attributeValue("id"));
        int x = Integer.parseInt(element.attributeValue("x"));
        int y = Integer.parseInt(element.attributeValue("y"));
        int width = Integer.parseInt(element.attributeValue("width"));
        int height = Integer.parseInt(element.attributeValue("height"));
        Point point = new Point(x, y);
        shape.setRectangle(new Rectangle(point, width, height));
    }

    private List<Point> buildConnectionPoints(String vertices) throws Exception {
        ArrayList<Point> points = new ArrayList<Point>();
        Pattern pattern = Pattern.compile(".(\\d+,\\d+).");
        Matcher matcher = pattern.matcher(vertices);
        while (matcher.find()) {
            Integer[] values = JSONUtils.fromJSON(matcher.group(), Integer[].class);
            points.add(new Point(values[0], values[1]));
        }
        return points;
    }
}

