/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.deserializer.impl;

import com.bstek.uflo.designer.deserializer.impl.NodeDeserializer;
import com.bstek.uflo.designer.model.DecisionType;
import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.node.Decision;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service
public class DecisionDeserializer
extends NodeDeserializer {
    public Shape execute(Element currentElement) throws Exception {
        Decision decision = new Decision();
        super.deserializeCommonAttribute(decision, currentElement);
        String expression = currentElement.attributeValue("expression");
        String handlerBean = currentElement.attributeValue("handler-bean");
        if (StringUtils.isNotEmpty((String)expression)) {
            decision.setDecisionType(DecisionType.Expression.name());
        } else if (StringUtils.isNotEmpty((String)handlerBean)) {
            decision.setDecisionType(DecisionType.Handler.name());
        } else {
            decision.setDecisionType(null);
        }
        decision.setExpression(expression);
        decision.setHandlerBean(handlerBean);
        return decision;
    }

    public boolean support(String name) {
        return name.equals("decision");
    }
}

