/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.view.security;

import com.bstek.dorado.annotation.DataProvider;
import com.bstek.dorado.annotation.DataResolver;
import com.bstek.dorado.data.entity.EntityState;
import com.bstek.dorado.data.entity.EntityUtils;
import com.bstek.dorado.data.provider.Criteria;
import com.bstek.dorado.data.provider.Page;
import com.bstek.dorado.util.Assert;
import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.designer.command.DeleteObjectCommand;
import com.bstek.uflo.designer.command.QueryPageCommand;
import com.bstek.uflo.designer.command.QueryUniqueResultCommand;
import com.bstek.uflo.designer.command.SaveObjectCommand;
import com.bstek.uflo.designer.command.UpdateObjectCommand;
import com.bstek.uflo.designer.security.command.DeleteProcessEntryCascadedCommand;
import com.bstek.uflo.designer.security.manager.SecurityManager;
import com.bstek.uflo.designer.security.model.NodeAttribute;
import com.bstek.uflo.designer.security.model.NodeEntry;
import com.bstek.uflo.designer.security.model.ProcessAttribute;
import com.bstek.uflo.designer.security.model.ProcessEntry;
import com.bstek.uflo.designer.security.model.ProcessEntryAssignee;
import com.bstek.uflo.model.ProcessDefinition;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller(value="ufloProcessSecurityMaintain")
public class UfloProcessSecurityMaintain {
    public static final String BEAN_ID = "ufloProcessSecurityMaintain";
    @Autowired
    @Qualifier(value="uflo.commandService")
    private CommandService commandService;
    @Autowired
    @Qualifier(value="uflo.designer.SecurityManager")
    private SecurityManager securityManager;

    @DataProvider
    public void loadProcessEntry(Page<ProcessEntry> page, Criteria criteria) {
        DetachedCriteria dc = DetachedCriteria.forClass(ProcessEntry.class);
        this.commandService.executeCommand((Command)new QueryPageCommand(dc, page));
    }

    @DataProvider
    public void loadProcessEntryAssignee(Page<ProcessEntryAssignee> page, String processEntryId) {
        Assert.notNull((Object)processEntryId);
        DetachedCriteria dc = DetachedCriteria.forClass(ProcessEntryAssignee.class);
        dc.add((Criterion)Restrictions.eq((String)"processEntryId", (Object)processEntryId));
        this.commandService.executeCommand((Command)new QueryPageCommand(dc, page));
    }

    @DataResolver
    public void saveProcessEntry(List<ProcessEntry> processEntryList) throws Exception {
        for (ProcessEntry processEntry : processEntryList) {
            EntityState state = EntityUtils.getState((Object)processEntry);
            if (state.equals((Object)EntityState.NEW)) {
                processEntry.setId(UUID.randomUUID().toString());
                processEntry.setCreateDate(new Date());
                this.commandService.executeCommand(new SaveObjectCommand<ProcessEntry>(processEntry));
            }
            if (state.equals((Object)EntityState.MODIFIED)) {
                this.commandService.executeCommand(new UpdateObjectCommand<ProcessEntry>(processEntry));
            }
            if (state.equals((Object)EntityState.DELETED)) {
                this.commandService.executeCommand((Command)new DeleteProcessEntryCascadedCommand(processEntry.getId()));
            }
            if (processEntry.getProcessAttributeList() != null) {
                this.saveProcessAttribute(processEntry);
            }
            if (processEntry.getNodeEntrylist() != null) {
                this.saveNodeEntry(processEntry);
            }
            if (processEntry.getProcessEntryAssigneeList() == null) continue;
            this.saveProcessEntryAssignee(processEntry);
        }
    }

    public void saveNodeEntry(ProcessEntry processEntry) throws Exception {
        for (NodeEntry nodeEntry : processEntry.getNodeEntrylist()) {
            nodeEntry.setProcessEntryId(processEntry.getId());
            EntityState state = EntityUtils.getState((Object)nodeEntry);
            if (state.equals((Object)EntityState.MODIFIED)) {
                NodeEntry dbNodeEntry = this.securityManager.findDbNodeEntryByNodeName(processEntry.getId(), nodeEntry.getName());
                if (dbNodeEntry == null) {
                    this.commandService.executeCommand(new UpdateObjectCommand<NodeEntry>(nodeEntry));
                } else {
                    dbNodeEntry.setRemovable(nodeEntry.isRemovable());
                    dbNodeEntry.setModifiable(nodeEntry.isModifiable());
                    this.commandService.executeCommand(new UpdateObjectCommand<NodeEntry>(dbNodeEntry));
                }
            }
            if (state.equals((Object)EntityState.NONE)) {
                DetachedCriteria dc = DetachedCriteria.forClass(NodeEntry.class);
                dc.add((Criterion)Restrictions.eq((String)"id", (Object)nodeEntry.getId()));
                NodeEntry dbNodeEntry = (NodeEntry)this.commandService.executeCommand(new QueryUniqueResultCommand(dc));
                if (dbNodeEntry == null) {
                    this.commandService.executeCommand(new UpdateObjectCommand<NodeEntry>(nodeEntry));
                }
            }
            if (nodeEntry.getNodeAttributeList() == null) continue;
            this.saveNodeAttribute(nodeEntry);
        }
    }

    public void saveNodeAttribute(NodeEntry nodeEntry) throws Exception {
        for (NodeAttribute nodeAttribute : nodeEntry.getNodeAttributeList()) {
            nodeAttribute.setNodeEntryId(nodeEntry.getId());
            EntityState state = EntityUtils.getState((Object)nodeAttribute);
            if (!state.equals((Object)EntityState.MODIFIED)) continue;
            boolean exist = false;
            List<NodeAttribute> dbNodeAttribute = this.securityManager.findDbNodeAttribute(nodeEntry.getId());
            if (dbNodeAttribute != null) {
                for (NodeAttribute na : dbNodeAttribute) {
                    if (!na.getName().equals(nodeAttribute.getName())) continue;
                    na.setAuthorityType(nodeAttribute.getAuthorityType());
                    exist = true;
                    this.commandService.executeCommand(new UpdateObjectCommand<NodeAttribute>(na));
                }
            }
            if (exist) continue;
            this.commandService.executeCommand(new UpdateObjectCommand<NodeAttribute>(nodeAttribute));
        }
    }

    public void saveProcessAttribute(ProcessEntry processEntry) throws Exception {
        for (ProcessAttribute processAttribute : processEntry.getProcessAttributeList()) {
            processAttribute.setProcessEntryId(processEntry.getId());
            EntityState state = EntityUtils.getState((Object)processAttribute);
            if (!state.equals((Object)EntityState.MODIFIED)) continue;
            boolean exist = false;
            List<ProcessAttribute> dbProcessAttribute = this.securityManager.findDbProcessAttribute(processEntry.getId());
            if (dbProcessAttribute != null) {
                for (ProcessAttribute pa : dbProcessAttribute) {
                    if (!pa.getName().equals(processAttribute.getName())) continue;
                    pa.setAuthorityType(processAttribute.getAuthorityType());
                    exist = true;
                    this.commandService.executeCommand(new UpdateObjectCommand<ProcessAttribute>(pa));
                }
            }
            if (exist) continue;
            this.commandService.executeCommand(new UpdateObjectCommand<ProcessAttribute>(processAttribute));
        }
    }

    public void saveProcessEntryAssignee(ProcessEntry processEntry) {
        for (ProcessEntryAssignee processEntryAssignee : processEntry.getProcessEntryAssigneeList()) {
            EntityState state = EntityUtils.getState((Object)processEntryAssignee);
            if (state.equals((Object)EntityState.NEW)) {
                processEntryAssignee.setId(UUID.randomUUID().toString());
                processEntryAssignee.setProcessEntryId(processEntry.getId());
                this.commandService.executeCommand(new SaveObjectCommand<ProcessEntryAssignee>(processEntryAssignee));
            }
            if (state.equals((Object)EntityState.MODIFIED)) {
                this.commandService.executeCommand(new UpdateObjectCommand<ProcessEntryAssignee>(processEntryAssignee));
            }
            if (!state.equals((Object)EntityState.DELETED)) continue;
            this.commandService.executeCommand(new DeleteObjectCommand<ProcessEntryAssignee>(processEntryAssignee));
        }
    }

    @DataProvider
    public List<ProcessDefinition> findProcess() throws Exception {
        return this.securityManager.findDbProcess();
    }

    @DataProvider
    public List<NodeEntry> findNodeEntry(String processEntryId, long processId) throws Exception {
        Assert.notNull((Object)processId);
        return this.securityManager.findNodeEntryByProcessId(processEntryId, processId);
    }

    @DataProvider
    public List<NodeAttribute> findNodeAttribute(String nodeEntryId, String nodeType) throws Exception {
        Assert.notNull((Object)nodeEntryId);
        return this.securityManager.findNodeAttributeByNodeType(nodeEntryId, nodeType);
    }

    @DataProvider
    public List<ProcessAttribute> findProcessAttribute(String processEntryId) throws Exception {
        Assert.notNull((Object)processEntryId);
        return this.securityManager.findProcessAttribute(processEntryId);
    }
}

