/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.view;

import com.bstek.dorado.annotation.DataProvider;
import com.bstek.dorado.annotation.Expose;
import com.bstek.dorado.data.provider.Criteria;
import com.bstek.dorado.data.provider.Criterion;
import com.bstek.dorado.data.provider.Page;
import com.bstek.dorado.data.provider.filter.SingleValueFilterCriterion;
import com.bstek.dorado.view.View;
import com.bstek.dorado.view.manager.ViewConfig;
import com.bstek.dorado.view.manager.ViewConfigManager;
import com.bstek.dorado.view.widget.HtmlContainer;
import com.bstek.dorado.web.DoradoContext;
import com.bstek.uflo.console.controller.AssigneeInfo;
import com.bstek.uflo.designer.controller.FileKeyManager;
import com.bstek.uflo.designer.convert.ConvertService;
import com.bstek.uflo.designer.deploy.DeployService;
import com.bstek.uflo.designer.model.process.Process;
import com.bstek.uflo.designer.security.model.ProcessEntry;
import com.bstek.uflo.form.model.FormInfo;
import com.bstek.uflo.form.model.TableInfo;
import com.bstek.uflo.form.service.FormService;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.process.assign.Assignee;
import com.bstek.uflo.process.assign.AssigneeProvider;
import com.bstek.uflo.process.assign.Entity;
import com.bstek.uflo.process.assign.PageQuery;
import com.bstek.uflo.process.handler.ActionHandler;
import com.bstek.uflo.process.handler.AssignmentHandler;
import com.bstek.uflo.process.handler.ConditionHandler;
import com.bstek.uflo.process.handler.CountersignHandler;
import com.bstek.uflo.process.handler.DecisionHandler;
import com.bstek.uflo.process.handler.ForeachHandler;
import com.bstek.uflo.process.handler.NodeEventHandler;
import com.bstek.uflo.process.handler.ProcessEventHandler;
import com.bstek.uflo.process.handler.ReminderHandler;
import com.bstek.uflo.process.listener.TaskListener;
import com.bstek.uflo.process.node.FormTemplateProvider;
import com.bstek.uflo.process.node.reminder.CalendarInfo;
import com.bstek.uflo.process.node.reminder.CalendarProvider;
import com.bstek.uflo.query.ProcessQuery;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.utils.EnvironmentUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller(value="ufloDesignerMaintain")
public class UfloDesignerMaintain {
    public static final String BEAN_ID = "ufloDesignerMaintain";
    @Autowired
    @Qualifier(value="uflo.designer.convertService")
    private ConvertService convertService;
    @Autowired
    @Qualifier(value="uflo.designer.deployService")
    private DeployService deployService;
    @Autowired
    @Qualifier(value="uflo.processService")
    private ProcessService processService;
    @Autowired
    @Qualifier(value="uflo.form.formService")
    private FormService formService;
    @Autowired
    private ViewConfigManager viewConfigManager;

    public void onInitView(View view) {
        HtmlContainer htmlContainer = (HtmlContainer)view.getComponent("processNodeList");
        if (htmlContainer != null) {
            htmlContainer.setContent(this.buildProcessNodeHtml());
        }
        DoradoContext.getCurrent().setAttribute("view", "uflo_server_url", (Object)this.buildDeployUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Expose
    public String deployProcess(Map<String, Object> data) throws Exception {
        String graphData = (String)data.get("xmlData");
        String serverUrl = (String)data.get("serverUrl");
        Process process = this.convertService.graphToModel(graphData);
        File file = this.convertService.modelToUflo(process);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            String string = this.deployService.remoteDeploy(fileInputStream, serverUrl);
            return string;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Expose
    public void updateProcess(Map<String, Object> data) throws Exception {
        String graphData = (String)data.get("xmlData");
        long processId = Long.valueOf(data.get("processId").toString());
        Process process = this.convertService.graphToModel(graphData);
        File file = this.convertService.modelToUflo(process);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.deployService.nativeDeploy(fileInputStream, processId);
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Expose
    public String loadGraphData(String key) throws Exception {
        String fileKey = FileKeyManager.getFileKey(key);
        if (StringUtils.isNotEmpty((String)fileKey)) {
            File file = new File(fileKey);
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                String graphXmlData;
                String ufloXmlData = IOUtils.toString((InputStream)fileInputStream, (String)"UTF-8");
                Process process = this.convertService.ufloToModel(ufloXmlData);
                String string = graphXmlData = this.convertService.modelToGraph(process);
                return string;
            }
            finally {
                fileInputStream.close();
            }
        }
        return null;
    }

    @Expose
    public String saveDesignData(Map<String, Object> data) throws Exception {
        String graphData = (String)data.get("xmlData");
        Process process = this.convertService.graphToModel(graphData);
        File file = this.convertService.modelToUflo(process);
        String fileId = UUID.randomUUID().toString();
        DoradoContext.getCurrent().getRequest().getSession().setAttribute(fileId, (Object)file.getAbsolutePath());
        return fileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildProcessNodeHtml() {
        InputStream processNodeStream = this.getClass().getResourceAsStream("/dorado/resources/processNode.html");
        try {
            String string = IOUtils.toString((InputStream)processNodeStream, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                processNodeStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String buildDeployUrl() {
        HttpServletRequest request = DoradoContext.getCurrent().getRequest();
        String url = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/dorado/uflo/deploy.process";
        return url;
    }

    @DataProvider
    public void loadProcess(Page<ProcessDefinition> page, Criteria criteria) throws Exception {
        ProcessQuery query = this.processService.createProcessQuery();
        query.addOrderDesc("createDate");
        if (criteria != null) {
            List list = criteria.getCriterions();
            for (Criterion c : list) {
                if (!(c instanceof SingleValueFilterCriterion)) continue;
                SingleValueFilterCriterion sc = (SingleValueFilterCriterion)c;
                String name = sc.getProperty();
                if (name.equals("id")) {
                    query.id(((Long)sc.getValue()).longValue());
                }
                if (name.equals("key")) {
                    query.keyLike("%" + sc.getValue() + "%");
                }
                if (!name.equals("name")) continue;
                query.nameLike("%" + sc.getValue() + "%");
            }
        }
        query.page((page.getPageNo() - 1) * page.getPageSize(), page.getPageSize());
        page.setEntityCount(query.count());
        page.setEntities((Collection)query.list());
    }

    @Expose
    public void deleteProcessDefinition(long processId) throws Exception {
        this.processService.deleteProcess(processId);
    }

    @Expose
    @Transactional
    public Map<String, Object> findProcessDefinitionXml(long processId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!StringUtils.isNotEmpty((String)EnvironmentUtils.getEnvironment().getLoginUser())) {
            result.put("nologin", true);
        }
        String ufloXmlData = this.convertService.findProcessDefinitionXml(processId);
        Process process = this.convertService.ufloToModel(ufloXmlData, processId);
        ProcessEntry processEntry = process.getProcessEntry();
        String graphXmlData = this.convertService.modelToGraph(process);
        result.put("data", graphXmlData);
        if (processEntry != null) {
            result.put("modifiable", processEntry.isModifiable());
            result.put("addable", processEntry.isAddable());
        }
        return result;
    }

    @Expose
    public Set<String> findHanderBean(String dataType, String property) {
        WebApplicationContext context = DoradoContext.getAttachedWebApplicationContext();
        if (property.equals("eventHandlerBean")) {
            if (dataType.equals("dataTypeProcess")) {
                return context.getBeansOfType(ProcessEventHandler.class).keySet();
            }
            return context.getBeansOfType(NodeEventHandler.class).keySet();
        }
        if (property.equals("handlerBean")) {
            if (dataType.equals("dataTypeDecision")) {
                return context.getBeansOfType(DecisionHandler.class).keySet();
            }
            if (dataType.equals("dataTypeConnection")) {
                return context.getBeansOfType(ConditionHandler.class).keySet();
            }
            if (dataType.equals("dataTypeAction")) {
                return context.getBeansOfType(ActionHandler.class).keySet();
            }
            if (dataType.equals("dataTypeForeach")) {
                return context.getBeansOfType(ForeachHandler.class).keySet();
            }
        } else {
            if (property.equals("taskListenerBean")) {
                return context.getBeansOfType(TaskListener.class).keySet();
            }
            if (property.equals("formTemplate")) {
                HashSet<String> set = new HashSet<String>();
                for (FormTemplateProvider provider : context.getBeansOfType(FormTemplateProvider.class).values()) {
                    set.add(provider.getFormTemplate());
                }
                return set;
            }
            if (property.equals("reminderHandlerBean")) {
                return context.getBeansOfType(ReminderHandler.class).keySet();
            }
            if (property.equals("assignmentHandlerBean")) {
                return context.getBeansOfType(AssignmentHandler.class).keySet();
            }
            if (property.equals("countersignHandler")) {
                return context.getBeansOfType(CountersignHandler.class).keySet();
            }
        }
        return null;
    }

    @DataProvider
    public List<CalendarInfo> findCalendarInfos() {
        ArrayList<CalendarInfo> result = new ArrayList<CalendarInfo>();
        Collection calendarProviderList = DoradoContext.getAttachedWebApplicationContext().getBeansOfType(CalendarProvider.class).values();
        for (CalendarProvider calendarProvider : calendarProviderList) {
            List calendarInfoList = calendarProvider.getCalendarInfos();
            if (calendarInfoList == null || calendarInfoList.size() <= 0) continue;
            result.addAll(calendarInfoList);
        }
        return result;
    }

    @DataProvider
    public List<AssigneeInfo> findAssigneeInfos() {
        Map assigneeProviderMap = DoradoContext.getAttachedWebApplicationContext().getBeansOfType(AssigneeProvider.class);
        ArrayList<AssigneeInfo> result = new ArrayList<AssigneeInfo>();
        for (Map.Entry entry : assigneeProviderMap.entrySet()) {
            AssigneeProvider assigneeProvider = (AssigneeProvider)entry.getValue();
            if (assigneeProvider.disable()) continue;
            AssigneeInfo info = new AssigneeInfo();
            info.setName(((AssigneeProvider)entry.getValue()).getName());
            info.setTree(((AssigneeProvider)entry.getValue()).isTree());
            info.setProviderId((String)entry.getKey());
            result.add(info);
        }
        return result;
    }

    @DataProvider
    public void loadGridAssignees(Page<Assignee> page, Criteria criteria, Map<String, Object> parameter) throws Exception {
        PageQuery pageQuery = new PageQuery(page.getPageNo(), page.getPageSize());
        if (criteria != null) {
            List list = criteria.getCriterions();
            String id = null;
            String name = null;
            for (Criterion c : list) {
                if (!(c instanceof SingleValueFilterCriterion)) continue;
                SingleValueFilterCriterion sc = (SingleValueFilterCriterion)c;
                String property = sc.getProperty();
                if (property.equals("id")) {
                    id = (String)sc.getValue();
                }
                if (!property.equals("name")) continue;
                name = (String)sc.getValue();
            }
            Entity queryParameter = new Entity(id, name);
            pageQuery.setQueryParameter(queryParameter);
        }
        String providerId = (String)parameter.get("providerId");
        String parentId = (String)parameter.get("parentId");
        this.getAssigneeProvider(providerId).queryEntities(pageQuery, parentId);
        List<Assignee> assignees = this.buildEntitys(pageQuery.getResult(), providerId);
        page.setEntityCount(pageQuery.getRecordCount());
        page.setEntities(assignees);
    }

    @DataProvider
    public List<Assignee> loadTreeAssignees(Map<String, Object> parameter) throws Exception {
        String providerId = (String)parameter.get("providerId");
        String parentId = (String)parameter.get("parentId");
        String name = (String)parameter.get("name");
        PageQuery pageQuery = new PageQuery(1, 1000);
        if (name != null) {
            Entity queryParameter = new Entity(name, name);
            pageQuery.setQueryParameter(queryParameter);
        }
        this.getAssigneeProvider(providerId).queryEntities(pageQuery, parentId);
        List<Assignee> assignees = this.buildEntitys(pageQuery.getResult(), providerId);
        return assignees;
    }

    @DataProvider
    public List<TableInfo> loadTableInfo() {
        return this.formService.queryTableInfo();
    }

    @DataProvider
    public List<FormInfo> loadFormInfos(long tableId) {
        return this.formService.queryFormInfos(tableId);
    }

    private List<Assignee> buildEntitys(Collection<Entity> entitys, String providerId) {
        ArrayList<Assignee> assignees = new ArrayList<Assignee>();
        if (entitys != null) {
            for (Entity entity : entitys) {
                Assignee assignee = new Assignee();
                assignee.setId(entity.getId());
                assignee.setName(entity.getName());
                assignee.setProviderId(providerId);
                assignee.setChosen(entity.isChosen());
                assignees.add(assignee);
            }
        }
        return assignees;
    }

    private AssigneeProvider getAssigneeProvider(String providerId) {
        return (AssigneeProvider)DoradoContext.getAttachedWebApplicationContext().getBeansOfType(AssigneeProvider.class).get(providerId);
    }

    public ViewConfig getViewConfig(DoradoContext context, String viewName) throws Exception {
        ViewConfig viewConfig = (ViewConfig)context.getAttribute(viewName);
        if (viewConfig == null) {
            viewConfig = this.viewConfigManager.getViewConfig(viewName);
            context.setAttribute(viewName, (Object)viewConfig);
        }
        return viewConfig;
    }
}

