/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.security.manager.impl;

import com.bstek.dorado.util.Assert;
import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.designer.command.QueryListCommand;
import com.bstek.uflo.designer.command.QueryUniqueResultCommand;
import com.bstek.uflo.designer.convert.ConvertService;
import com.bstek.uflo.designer.model.Mapping;
import com.bstek.uflo.designer.model.edge.Connection;
import com.bstek.uflo.designer.model.node.Node;
import com.bstek.uflo.designer.model.process.Process;
import com.bstek.uflo.designer.security.AuthorizeAttribute;
import com.bstek.uflo.designer.security.attribute.ProcessAuthorizeAttribute;
import com.bstek.uflo.designer.security.command.UpdateNodeEntryCommand;
import com.bstek.uflo.designer.security.manager.SecurityManager;
import com.bstek.uflo.designer.security.model.AuthorityType;
import com.bstek.uflo.designer.security.model.NodeAttribute;
import com.bstek.uflo.designer.security.model.NodeEntry;
import com.bstek.uflo.designer.security.model.ProcessAttribute;
import com.bstek.uflo.designer.security.model.ProcessEntry;
import com.bstek.uflo.designer.security.model.ProcessEntryAssignee;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.query.ProcessQuery;
import com.bstek.uflo.service.ProcessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="uflo.designer.SecurityManager")
public class SecurityServiceManager
implements SecurityManager,
ApplicationContextAware {
    @Autowired
    @Qualifier(value="uflo.processService")
    private ProcessService processService;
    @Autowired
    @Qualifier(value="uflo.designer.convertService")
    private ConvertService convertService;
    @Autowired
    @Qualifier(value="uflo.commandService")
    private CommandService commandService;
    private Collection<AuthorizeAttribute> authorizeAttributeColl;

    @Override
    public List<ProcessDefinition> findDbProcess() throws Exception {
        ProcessQuery query = this.processService.createProcessQuery();
        query.addOrderDesc("createDate");
        return (List)query.list();
    }

    @Override
    public List<NodeEntry> findDbNodeEntry(String processEntryId) throws Exception {
        DetachedCriteria dc = DetachedCriteria.forClass(NodeEntry.class);
        dc.add((Criterion)Restrictions.eq((String)"processEntryId", (Object)processEntryId));
        return (List)this.commandService.executeCommand((Command)new QueryListCommand(dc));
    }

    @Override
    public NodeEntry findDbNodeEntryByNodeName(String processEntryId, String nodeName) throws Exception {
        DetachedCriteria dc = DetachedCriteria.forClass(NodeEntry.class);
        dc.add((Criterion)Restrictions.eq((String)"processEntryId", (Object)processEntryId));
        dc.add((Criterion)Restrictions.eq((String)"name", (Object)nodeName));
        return (NodeEntry)this.commandService.executeCommand(new QueryUniqueResultCommand(dc));
    }

    private NodeEntry findNodeEntryByNodeName(List<NodeEntry> dbNodeEntryList, String name) throws Exception {
        Assert.notNull((Object)name);
        for (NodeEntry nodeEntry : dbNodeEntryList) {
            if (!nodeEntry.getName().equals(name)) continue;
            return nodeEntry;
        }
        return null;
    }

    @Override
    public List<NodeEntry> findNodeEntryByProcessId(String processEntryId, long processId) throws Exception {
        String ufloXmlData = this.convertService.findProcessDefinitionXml(processId);
        Process process = this.convertService.ufloToModel(ufloXmlData);
        ArrayList<NodeEntry> resultNodeEntryList = new ArrayList<NodeEntry>();
        List<NodeEntry> dbNodeEntryList = this.findDbNodeEntry(processEntryId);
        NodeEntry nodeEntry = null;
        List<Node> nodeList = process.getNodes();
        for (Node node : nodeList) {
            NodeEntry dbNodeEntry = this.findNodeEntryByNodeName(dbNodeEntryList, node.getName());
            if (dbNodeEntry == null) {
                nodeEntry = new NodeEntry(UUID.randomUUID().toString(), node.getName(), node.getClass().getSimpleName(), true, true);
            } else {
                nodeEntry = new NodeEntry(dbNodeEntry.getId(), dbNodeEntry.getName(), node.getClass().getSimpleName(), dbNodeEntry.isRemovable(), dbNodeEntry.isModifiable());
                nodeEntry.setPersistence(true);
            }
            resultNodeEntryList.add(nodeEntry);
        }
        List<Connection> connectionList = process.getConnections();
        for (Connection connection : connectionList) {
            NodeEntry dbNodeEntry;
            if (!StringUtils.isNotEmpty((String)connection.getName())) {
                connection.setName("to " + connection.getToNodeName());
            }
            if ((dbNodeEntry = this.findNodeEntryByNodeName(dbNodeEntryList, connection.getName())) == null) {
                nodeEntry = new NodeEntry(UUID.randomUUID().toString(), connection.getName(), connection.getClass().getSimpleName(), true, true);
            } else {
                nodeEntry = new NodeEntry(dbNodeEntry.getId(), dbNodeEntry.getName(), connection.getClass().getSimpleName(), dbNodeEntry.isRemovable(), dbNodeEntry.isModifiable());
                nodeEntry.setPersistence(true);
            }
            resultNodeEntryList.add(nodeEntry);
        }
        return resultNodeEntryList;
    }

    @Override
    public List<NodeAttribute> findNodeAttributeByNodeType(String nodeEntryId, String nodeType) throws Exception {
        ArrayList<NodeAttribute> nodeAttributeList = new ArrayList<NodeAttribute>();
        NodeAttribute nodeAttribute = null;
        for (AuthorizeAttribute authorizeAttribute : this.authorizeAttributeColl) {
            List<Mapping> mappingList;
            if (!authorizeAttribute.support(nodeType.toLowerCase()) || (mappingList = authorizeAttribute.getAttributes()) == null) continue;
            List<NodeAttribute> dbNodeAttribute = this.findDbNodeAttribute(nodeEntryId);
            for (Mapping mapping : mappingList) {
                nodeAttribute = this.buildNodeAttribute(mapping, dbNodeAttribute);
                nodeAttributeList.add(nodeAttribute);
            }
        }
        return nodeAttributeList;
    }

    @Override
    public List<ProcessAttribute> findProcessAttribute(String processEntryId) throws Exception {
        ArrayList<ProcessAttribute> processAttributeList = new ArrayList<ProcessAttribute>();
        ProcessAttribute processAttribute = null;
        for (AuthorizeAttribute authorizeAttribute : this.authorizeAttributeColl) {
            List<Mapping> mappingList;
            if (!(authorizeAttribute instanceof ProcessAuthorizeAttribute) || (mappingList = authorizeAttribute.getAttributes()) == null) continue;
            List<ProcessAttribute> dbProcessAttribute = this.findDbProcessAttribute(processEntryId);
            for (Mapping mapping : mappingList) {
                processAttribute = this.buildProcessAttribute(mapping, dbProcessAttribute);
                processAttributeList.add(processAttribute);
            }
        }
        return processAttributeList;
    }

    @Override
    public List<ProcessAttribute> findDbProcessAttribute(String processEntryId) throws Exception {
        DetachedCriteria dc = DetachedCriteria.forClass(ProcessAttribute.class);
        dc.add((Criterion)Restrictions.eq((String)"processEntryId", (Object)processEntryId));
        return (List)this.commandService.executeCommand((Command)new QueryListCommand(dc));
    }

    @Override
    public List<NodeAttribute> findDbNodeAttribute(String nodeEntryId) throws Exception {
        DetachedCriteria dc = DetachedCriteria.forClass(NodeAttribute.class);
        dc.add((Criterion)Restrictions.eq((String)"nodeEntryId", (Object)nodeEntryId));
        return (List)this.commandService.executeCommand((Command)new QueryListCommand(dc));
    }

    private ProcessAttribute buildProcessAttribute(Mapping mapping, List<ProcessAttribute> dbProcessAttribute) {
        if (dbProcessAttribute != null) {
            for (ProcessAttribute pa : dbProcessAttribute) {
                if (!pa.getName().equals(mapping.getKey())) continue;
                return pa;
            }
        }
        return new ProcessAttribute(UUID.randomUUID().toString(), mapping.getKey(), mapping.getLabel(), AuthorityType.Write);
    }

    private NodeAttribute buildNodeAttribute(Mapping mapping, List<NodeAttribute> dbNodeAttribute) {
        if (dbNodeAttribute != null) {
            for (NodeAttribute na : dbNodeAttribute) {
                if (!na.getName().equals(mapping.getKey())) continue;
                return na;
            }
        }
        return new NodeAttribute(UUID.randomUUID().toString(), mapping.getKey(), mapping.getLabel(), AuthorityType.Write);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.authorizeAttributeColl = applicationContext.getBeansOfType(AuthorizeAttribute.class).values();
    }

    @Override
    public List<ProcessEntry> findDbProcessEntry(long processId) throws Exception {
        DetachedCriteria dc = DetachedCriteria.forClass(ProcessEntry.class);
        dc.add((Criterion)Restrictions.eq((String)"processId", (Object)processId));
        dc.addOrder(Order.desc((String)"createDate"));
        return (List)this.commandService.executeCommand((Command)new QueryListCommand(dc));
    }

    @Override
    public List<ProcessEntryAssignee> findDbProcessEntryAssignee(String processEntryId) throws Exception {
        DetachedCriteria dc = DetachedCriteria.forClass(ProcessEntryAssignee.class);
        dc.add((Criterion)Restrictions.eq((String)"processEntryId", (Object)processEntryId));
        return (List)this.commandService.executeCommand((Command)new QueryListCommand(dc));
    }

    @Override
    public void updateNodeEntry(String nodeEntryId, String nodeName) throws Exception {
        this.commandService.executeCommand((Command)new UpdateNodeEntryCommand(nodeEntryId, nodeName));
    }

    @Override
    public Collection<AuthorizeAttribute> getAuthorizeAttributes() throws Exception {
        return this.authorizeAttributeColl;
    }
}

