/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.security;

import com.bstek.dorado.annotation.PropertyDef;
import com.bstek.uflo.designer.model.Mapping;
import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.security.AuthorizeAttribute;
import com.bstek.uflo.designer.security.annotation.SecurityAttribute;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShapeAuthorizeAttribute
implements AuthorizeAttribute {
    @Override
    public List<Mapping> getAttributes() {
        ArrayList<Mapping> mappingList = new ArrayList<Mapping>();
        Stack<Class<?>> stack = this.getShapeClassStack();
        while (!stack.isEmpty()) {
            Field[] fields;
            Class<?> clazz = stack.pop();
            for (Field field : fields = clazz.getDeclaredFields()) {
                String key = null;
                String label = null;
                SecurityAttribute securityAttribute = field.getAnnotation(SecurityAttribute.class);
                if (securityAttribute == null) continue;
                key = securityAttribute.key();
                label = securityAttribute.label();
                if (!StringUtils.isNotEmpty((String)key)) {
                    key = field.getName();
                }
                if (!StringUtils.isNotEmpty((String)label)) {
                    PropertyDef propertyDef = field.getAnnotation(PropertyDef.class);
                    if (propertyDef != null) {
                        label = propertyDef.label();
                    }
                    if (!StringUtils.isNotEmpty((String)label)) {
                        label = key;
                    }
                }
                mappingList.add(new Mapping(key, label));
            }
        }
        return mappingList;
    }

    private Stack<Class<?>> getShapeClassStack() {
        Stack stack = new Stack();
        this.buildShapeClass(this.getShapeClass(), stack);
        return stack;
    }

    private void buildShapeClass(Class<?> clazz, Stack<Class<?>> stack) {
        stack.push(clazz);
        Class<?> superClazz = clazz.getSuperclass();
        if (!superClazz.equals(Shape.class)) {
            this.buildShapeClass(superClazz, stack);
        }
    }

    @Override
    public abstract boolean support(String var1);

    public abstract Class<?> getShapeClass();
}

