/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.designer.controller;

import com.bstek.dorado.web.resolver.AbstractResolver;
import com.bstek.uflo.designer.controller.FileKeyManager;
import com.bstek.uflo.designer.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.ModelAndView;

public class UploadFileResolver
extends AbstractResolver {
    protected ModelAndView doHandleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.doUpload(request, response);
        }
        catch (Exception e) {
            response.setCharacterEncoding("UTF-8");
            response.getWriter().print(e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipartFile multipartFile;
        String name;
        MultipartHttpServletRequest multiPartReq = null;
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
        if (!(request instanceof MultipartHttpServletRequest) && multipartResolver.isMultipart(request)) {
            multiPartReq = multipartResolver.resolveMultipart(request);
        } else if (request instanceof MultipartHttpServletRequest) {
            multiPartReq = (MultipartHttpServletRequest)request;
        }
        if (multiPartReq != null && (name = (multipartFile = multiPartReq.getFile("file")).getOriginalFilename()).endsWith(".xml")) {
            InputStream input = multipartFile.getInputStream();
            String fileKey = UUID.randomUUID().toString();
            File fileLocation = new File(FileUtils.getTempDirectory(), fileKey + ".uflo.xml");
            FileOutputStream output = new FileOutputStream(fileLocation);
            try {
                IOUtils.copy((InputStream)input, (OutputStream)output);
                FileKeyManager.putFileKey(fileKey, fileLocation.getAbsolutePath());
                response.getWriter().print("{key:'" + fileKey + "'}");
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
    }
}

