/*!
 * jQuery contextMenu - Plugin for simple contextMenu handling
 *
 * Version: 1.5.25
 *
 * Authors: Rodney Rehm, Addy Osmani (patches for FF)
 * Web: http://medialize.github.com/jQuery-contextMenu/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *   GPL v3 http://opensource.org/licenses/GPL-3.0
 *
 */
(function(l,f){l.support.htmlMenuitem=("HTMLMenuItemElement" in window);
l.support.htmlCommand=("HTMLCommandElement" in window);
l.support.eventSelectstart=("onselectstart" in document.documentElement);
var j=null,g=false,d=l(window),a=0,b={},k={},o={},h={selector:null,appendTo:null,trigger:"right",autoHide:false,delay:200,determinePosition:function(s){if(l.ui&&l.ui.position){s.css("display","block").position({my:"center top",at:"center bottom",of:this,offset:"0 5",collision:"fit"}).css("display","none")
}else{var t=this.offset();
t.top+=this.outerHeight();
t.left+=this.outerWidth()/2-s.outerWidth()/2;
s.css(t)
}},position:function(u,B,z){var w=this,v;
if(!B&&!z){u.determinePosition.call(this,u.$menu);
return
}else{if(B==="maintain"&&z==="maintain"){v=u.$menu.position()
}else{var A=u.$trigger.parents().andSelf().filter(function(){return l(this).css("position")=="fixed"
}).length;
if(A){z-=d.scrollTop();
B-=d.scrollLeft()
}v={top:z,left:B}
}}var s=d.scrollTop()+d.height(),C=d.scrollLeft()+d.width(),D=u.$menu.height(),t=u.$menu.width();
if(v.top+D>s){v.top-=D
}if(v.left+t>C){v.left-=t
}u.$menu.css(v)
},positionSubmenu:function(s){if(l.ui&&l.ui.position){s.css("display","block").position({my:"left top",at:"right top",of:this,collision:"fit"}).css("display","")
}else{var t={top:0,left:this.outerWidth()};
s.css(t)
}},zIndex:1,animation:{duration:50,show:"slideDown",hide:"slideUp"},events:{show:l.noop,hide:l.noop},callback:null,items:{}},p={timer:null,pageX:null,pageY:null},r=function(u){var t=0,s=u;
while(true){t=Math.max(t,parseInt(s.css("z-index"),10)||0);
s=s.parent();
if(!s||!s.length||"html body".indexOf(s.prop("nodeName").toLowerCase())>-1){break
}}return t
},n={abortevent:function(s){s.preventDefault();
s.stopImmediatePropagation()
},contextmenu:function(u){var t=l(this);
u.preventDefault();
u.stopImmediatePropagation();
if(u.data.trigger!="right"&&u.originalEvent){return
}if(!t.hasClass("context-menu-disabled")){j=t;
if(u.data.build){var s=u.data.build(j,u);
if(s===false){return
}u.data=l.extend(true,{},h,u.data,s||{});
if(!u.data.items||l.isEmptyObject(u.data.items)){if(window.console){(console.error||console.log)("No items specified to show in contextMenu")
}throw new Error("No Items sepcified")
}u.data.$trigger=j;
m.create(u.data)
}m.show.call(t,u.data,u.pageX,u.pageY)
}},click:function(s){s.preventDefault();
s.stopImmediatePropagation();
l(this).trigger(l.Event("contextmenu",{data:s.data,pageX:s.pageX,pageY:s.pageY}))
},mousedown:function(t){var s=l(this);
if(j&&j.length&&!j.is(s)){j.data("contextMenu").$menu.trigger("contextmenu:hide")
}if(t.button==2){j=s.data("contextMenuActive",true)
}},mouseup:function(t){var s=l(this);
if(s.data("contextMenuActive")&&j&&j.length&&j.is(s)&&!s.hasClass("context-menu-disabled")){t.preventDefault();
t.stopImmediatePropagation();
j=s;
s.trigger(l.Event("contextmenu",{data:t.data,pageX:t.pageX,pageY:t.pageY}))
}s.removeData("contextMenuActive")
},mouseenter:function(u){var t=l(this),s=l(u.relatedTarget),v=l(document);
if(s.is(".context-menu-list")||s.closest(".context-menu-list").length){return
}if(j&&j.length){return
}p.pageX=u.pageX;
p.pageY=u.pageY;
p.data=u.data;
v.on("mousemove.contextMenuShow",n.mousemove);
p.timer=setTimeout(function(){p.timer=null;
v.off("mousemove.contextMenuShow");
j=t;
t.trigger(l.Event("contextmenu",{data:p.data,pageX:p.pageX,pageY:p.pageY}))
},u.data.delay)
},mousemove:function(s){p.pageX=s.pageX;
p.pageY=s.pageY
},mouseleave:function(t){var s=l(t.relatedTarget);
if(s.is(".context-menu-list")||s.closest(".context-menu-list").length){return
}try{clearTimeout(p.timer)
}catch(t){}p.timer=null
},layerClick:function(v){var z=l(this),B=z.data("contextMenuRoot"),t=false,u=v.button,C=v.pageX,A=v.pageY,w,s,D;
v.preventDefault();
v.stopImmediatePropagation();
z.on("mouseup",function(){t=true
});
setTimeout(function(){var E,y;
if((B.trigger=="left"&&u==0)||(B.trigger=="right"&&u==2)){if(document.elementFromPoint){B.$layer.hide();
w=document.elementFromPoint(C-d.scrollLeft(),A-d.scrollTop());
B.$layer.show();
D=[];
for(var x in b){D.push(x)
}w=l(w).closest(D.join(", "));
if(w.length){if(w.is(B.$trigger[0])){B.position.call(B.$trigger,B,C,A);
return
}}}else{s=B.$trigger.offset();
E=l(window);
s.top+=E.scrollTop();
if(s.top<=v.pageY){s.left+=E.scrollLeft();
if(s.left<=v.pageX){s.bottom=s.top+B.$trigger.outerHeight();
if(s.bottom>=v.pageY){s.right=s.left+B.$trigger.outerWidth();
if(s.right>=v.pageX){B.position.call(B.$trigger,B,C,A);
return
}}}}}}y=function(F){if(F){F.preventDefault();
F.stopImmediatePropagation()
}B.$menu.trigger("contextmenu:hide");
if(w&&w.length){setTimeout(function(){w.contextMenu({x:C,y:A})
},50)
}};
if(t){y()
}else{z.on("mouseup",y)
}},50)
},keyStop:function(t,s){if(!s.isInput){t.preventDefault()
}t.stopPropagation()
},key:function(x){var v=j.data("contextMenu")||{},t=v.$menu.children(),y;
switch(x.keyCode){case 9:case 38:n.keyStop(x,v);
if(v.isInput){if(x.keyCode==9&&x.shiftKey){x.preventDefault();
v.$selected&&v.$selected.find("input, textarea, select").blur();
v.$menu.trigger("prevcommand");
return
}else{if(x.keyCode==38&&v.$selected.find("input, textarea, select").prop("type")=="checkbox"){x.preventDefault();
return
}}}else{if(x.keyCode!=9||x.shiftKey){v.$menu.trigger("prevcommand");
return
}}case 40:n.keyStop(x,v);
if(v.isInput){if(x.keyCode==9){x.preventDefault();
v.$selected&&v.$selected.find("input, textarea, select").blur();
v.$menu.trigger("nextcommand");
return
}else{if(x.keyCode==40&&v.$selected.find("input, textarea, select").prop("type")=="checkbox"){x.preventDefault();
return
}}}else{v.$menu.trigger("nextcommand");
return
}break;
case 37:n.keyStop(x,v);
if(v.isInput||!v.$selected||!v.$selected.length){break
}if(!v.$selected.parent().hasClass("context-menu-root")){var w=v.$selected.parent().parent();
v.$selected.trigger("contextmenu:blur");
v.$selected=w;
return
}break;
case 39:n.keyStop(x,v);
if(v.isInput||!v.$selected||!v.$selected.length){break
}var u=v.$selected.data("contextMenu")||{};
if(u.$menu&&v.$selected.hasClass("context-menu-submenu")){v.$selected=null;
u.$selected=null;
u.$menu.trigger("nextcommand");
return
}break;
case 35:case 36:if(v.$selected&&v.$selected.find("input, textarea, select").length){return
}else{(v.$selected&&v.$selected.parent()||v.$menu).children(":not(.disabled, .not-selectable)")[x.keyCode==36?"first":"last"]().trigger("contextmenu:focus");
x.preventDefault();
return
}break;
case 13:n.keyStop(x,v);
if(v.isInput){if(v.$selected&&!v.$selected.is("textarea, select")){x.preventDefault();
return
}break
}v.$selected&&v.$selected.trigger("mouseup");
return;
case 32:case 33:case 34:n.keyStop(x,v);
return;
case 27:n.keyStop(x,v);
v.$menu.trigger("contextmenu:hide");
return;
default:var s=(String.fromCharCode(x.keyCode)).toUpperCase();
if(v.accesskeys[s]){v.accesskeys[s].$node.trigger(v.accesskeys[s].$menu?"contextmenu:focus":"mouseup");
return
}break
}x.stopPropagation();
v.$selected&&v.$selected.trigger(x)
},prevItem:function(w){w.stopPropagation();
var v=l(this).data("contextMenu")||{};
if(v.$selected){var s=v.$selected;
v=v.$selected.parent().data("contextMenu")||{};
v.$selected=s
}var u=v.$menu.children(),t=!v.$selected||!v.$selected.prev().length?u.last():v.$selected.prev(),y=t;
while(t.hasClass("disabled")||t.hasClass("not-selectable")){if(t.prev().length){t=t.prev()
}else{t=u.last()
}if(t.is(y)){return
}}if(v.$selected){n.itemMouseleave.call(v.$selected.get(0),w)
}n.itemMouseenter.call(t.get(0),w);
var x=t.find("input, textarea, select");
if(x.length){x.focus()
}},nextItem:function(w){w.stopPropagation();
var v=l(this).data("contextMenu")||{};
if(v.$selected){var s=v.$selected;
v=v.$selected.parent().data("contextMenu")||{};
v.$selected=s
}var u=v.$menu.children(),t=!v.$selected||!v.$selected.next().length?u.first():v.$selected.next(),y=t;
while(t.hasClass("disabled")||t.hasClass("not-selectable")){if(t.next().length){t=t.next()
}else{t=u.first()
}if(t.is(y)){return
}}if(v.$selected){n.itemMouseleave.call(v.$selected.get(0),w)
}n.itemMouseenter.call(t.get(0),w);
var x=t.find("input, textarea, select");
if(x.length){x.focus()
}},focusInput:function(w){var v=l(this).closest(".context-menu-item"),u=v.data(),t=u.contextMenu,s=u.contextMenuRoot;
s.$selected=t.$selected=v;
s.isInput=t.isInput=true
},blurInput:function(w){var v=l(this).closest(".context-menu-item"),u=v.data(),t=u.contextMenu,s=u.contextMenuRoot;
s.isInput=t.isInput=false
},menuMouseenter:function(t){var s=l(this).data().contextMenuRoot;
s.hovering=true
},menuMouseleave:function(t){var s=l(this).data().contextMenuRoot;
if(s.$layer&&s.$layer.is(t.relatedTarget)){s.hovering=false
}},itemMouseenter:function(w){var v=l(this),u=v.data(),t=u.contextMenu,s=u.contextMenuRoot;
s.hovering=true;
if(w&&s.$layer&&s.$layer.is(w.relatedTarget)){w.preventDefault();
w.stopImmediatePropagation()
}(t.$menu?t:s).$menu.children(".hover").trigger("contextmenu:blur");
if(v.hasClass("disabled")||v.hasClass("not-selectable")){t.$selected=null;
return
}v.trigger("contextmenu:focus")
},itemMouseleave:function(w){var v=l(this),u=v.data(),t=u.contextMenu,s=u.contextMenuRoot;
if(s!==t&&s.$layer&&s.$layer.is(w.relatedTarget)){s.$selected&&s.$selected.trigger("contextmenu:blur");
w.preventDefault();
w.stopImmediatePropagation();
s.$selected=t.$selected=t.$node;
return
}v.trigger("contextmenu:blur")
},itemClick:function(x){var w=l(this),v=w.data(),u=v.contextMenu,s=v.contextMenuRoot,t=v.contextMenuKey,y;
if(!u.items[t]||w.hasClass("disabled")||w.hasClass("context-menu-submenu")){return
}x.preventDefault();
x.stopImmediatePropagation();
if(l.isFunction(s.callbacks[t])){y=s.callbacks[t]
}else{if(l.isFunction(s.callback)){y=s.callback
}else{return
}}if(y.call(s.$trigger,t,s)!==false){s.$menu.trigger("contextmenu:hide")
}else{if(s.$menu.parent().length){m.update.call(s.$trigger,s)
}}},inputClick:function(s){s.stopImmediatePropagation()
},hideMenu:function(u,t){var s=l(this).data("contextMenuRoot");
m.hide.call(s.$trigger,s,t&&t.force)
},focusItem:function(w){w.stopPropagation();
var v=l(this),u=v.data(),t=u.contextMenu,s=u.contextMenuRoot;
v.addClass("hover").siblings(".hover").trigger("contextmenu:blur");
t.$selected=s.$selected=v;
if(t.$node){s.positionSubmenu.call(t.$node,t.$menu)
}},blurItem:function(w){w.stopPropagation();
var v=l(this),u=v.data(),t=u.contextMenu,s=u.contextMenuRoot;
v.removeClass("hover");
t.$selected=null
}},m={show:function(u,s,A){var v=l(this),w,t={};
l("#context-menu-layer").trigger("mousedown");
u.$trigger=v;
if(u.events.show.call(v,u)===false){j=null;
return
}m.update.call(v,u);
u.position.call(v,u,s,A);
if(u.zIndex){t.zIndex=r(v)+u.zIndex
}m.layer.call(u.$menu,u,t.zIndex);
u.$menu.find("ul").css("zIndex",t.zIndex+1);
u.$menu.css(t)[u.animation.show](u.animation.duration);
v.data("contextMenu",u);
l(document).off("keydown.contextMenu").on("keydown.contextMenu",n.key);
if(u.autoHide){var z=v.position();
z.right=z.left+v.outerWidth();
z.bottom=z.top+this.outerHeight();
l(document).on("mousemove.contextMenuAutoHide",function(x){if(u.$layer&&!u.hovering&&(!(x.pageX>=z.left&&x.pageX<=z.right)||!(x.pageY>=z.top&&x.pageY<=z.bottom))){u.$menu.trigger("contextmenu:hide")
}})
}},hide:function(s,t){var v=l(this);
if(!s){s=v.data("contextMenu")||{}
}if(!t&&s.events&&s.events.hide.call(v,s)===false){return
}if(s.$layer){setTimeout((function(w){return function(){w.remove()
}
})(s.$layer),10);
try{delete s.$layer
}catch(u){s.$layer=null
}}j=null;
s.$menu.find(".hover").trigger("contextmenu:blur");
s.$selected=null;
l(document).off(".contextMenuAutoHide").off("keydown.contextMenu");
s.$menu&&s.$menu[s.animation.hide](s.animation.duration,function(){if(s.build){s.$menu.remove();
l.each(s,function(w,x){switch(w){case"ns":case"selector":case"build":case"trigger":return true;
default:s[w]=f;
try{delete s[w]
}catch(y){}return true
}})
}})
},create:function(t,s){if(s===f){s=t
}t.$menu=l('<ul class="context-menu-list '+(t.className||"")+'"></ul>').data({contextMenu:t,contextMenuRoot:s});
l.each(["callbacks","commands","inputs"],function(v,u){t[u]={};
if(!s[u]){s[u]={}
}});
s.accesskeys||(s.accesskeys={});
l.each(t.items,function(w,x){var B=l('<li class="context-menu-item '+(x.className||"")+'"></li>'),u=null,A=null;
x.$node=B.data({contextMenu:t,contextMenuRoot:s,contextMenuKey:w});
if(x.accesskey){var y=c(x.accesskey);
for(var v=0,z;
z=y[v];
v++){if(!s.accesskeys[z]){s.accesskeys[z]=x;
x._name=x.name.replace(new RegExp("("+z+")","i"),'<span class="context-menu-accesskey">$1</span>');
break
}}}if(typeof x=="string"){B.addClass("context-menu-separator not-selectable")
}else{if(x.type&&o[x.type]){o[x.type].call(B,x,t,s);
l.each([t,s],function(D,C){C.commands[w]=x;
if(l.isFunction(x.callback)){C.callbacks[w]=x.callback
}})
}else{if(x.type=="html"){B.addClass("context-menu-html not-selectable")
}else{if(x.type){u=l("<label></label>").appendTo(B);
l("<span></span>").html(x._name||x.name).appendTo(u);
B.addClass("context-menu-input");
t.hasTypes=true;
l.each([t,s],function(D,C){C.commands[w]=x;
C.inputs[w]=x
})
}else{if(x.items){x.type="sub"
}}}switch(x.type){case"text":A=l('<input type="text" value="1" name="context-menu-input-'+w+'" value="">').val(x.value||"").appendTo(u);
break;
case"textarea":A=l('<textarea name="context-menu-input-'+w+'"></textarea>').val(x.value||"").appendTo(u);
if(x.height){A.height(x.height)
}break;
case"checkbox":A=l('<input type="checkbox" value="1" name="context-menu-input-'+w+'" value="">').val(x.value||"").prop("checked",!!x.selected).prependTo(u);
break;
case"radio":A=l('<input type="radio" value="1" name="context-menu-input-'+x.radio+'" value="">').val(x.value||"").prop("checked",!!x.selected).prependTo(u);
break;
case"select":A=l('<select name="context-menu-input-'+w+'">').appendTo(u);
if(x.options){l.each(x.options,function(C,D){l("<option></option>").val(C).text(D).appendTo(A)
});
A.val(x.selected)
}break;
case"sub":l("<span></span>").html(x._name||x.name).appendTo(B);
x.appendTo=x.$node;
m.create(x,s);
B.data("contextMenu",x).addClass("context-menu-submenu");
x.callback=null;
break;
case"html":l(x.html).appendTo(B);
break;
default:l.each([t,s],function(D,C){C.commands[w]=x;
if(l.isFunction(x.callback)){C.callbacks[w]=x.callback
}});
l("<span></span>").html(x._name||x.name||"").appendTo(B);
break
}if(x.type&&x.type!="sub"&&x.type!="html"){A.on("focus",n.focusInput).on("blur",n.blurInput);
if(x.events){A.on(x.events,t)
}}if(x.icon){B.addClass("icon icon-"+x.icon)
}}}x.$input=A;
x.$label=u;
B.appendTo(t.$menu);
if(!t.hasTypes&&l.support.eventSelectstart){B.on("selectstart.disableTextSelect",n.abortevent)
}});
if(!t.$node){t.$menu.css("display","none").addClass("context-menu-root")
}t.$menu.appendTo(t.appendTo||document.body)
},update:function(t,s){var u=this;
if(s===f){s=t;
t.$menu.find("ul").andSelf().css({position:"static",display:"block"}).each(function(){var v=l(this);
v.width(v.css("position","absolute").width()).css("position","static")
}).css({position:"",display:""})
}t.$menu.children().each(function(){var v=l(this),w=v.data("contextMenuKey"),y=t.items[w],x=(l.isFunction(y.disabled)&&y.disabled.call(u,w,s))||y.disabled===true;
v[x?"addClass":"removeClass"]("disabled");
if(y.type){v.find("input, select, textarea").prop("disabled",x);
switch(y.type){case"text":case"textarea":y.$input.val(y.value||"");
break;
case"checkbox":case"radio":y.$input.val(y.value||"").prop("checked",!!y.selected);
break;
case"select":y.$input.val(y.selected||"");
break
}}if(y.$menu){m.update.call(u,y,s)
}})
},layer:function(t,u){var s=t.$layer=l('<div id="context-menu-layer" style="position:fixed; z-index:'+u+'; top:0; left:0; opacity: 0; filter: alpha(opacity=0); background-color: #000;"></div>').css({height:d.height(),width:d.width(),display:"block"}).data("contextMenuRoot",t).insertBefore(this).on("contextmenu",n.abortevent).on("mousedown",n.layerClick);
if(!l.support.fixedPosition){s.css({position:"absolute",height:l(document).height()})
}return s
}};
function c(x){var v=x.split(/\s+/),w=[];
for(var u=0,s;
s=v[u];
u++){s=s[0].toUpperCase();
w.push(s)
}return w
}l.fn.contextMenu=function(s){if(s===f){this.first().trigger("contextmenu")
}else{if(s.x&&s.y){this.first().trigger(l.Event("contextmenu",{pageX:s.x,pageY:s.y}))
}else{if(s==="hide"){var t=this.data("contextMenu").$menu;
t&&t.trigger("contextmenu:hide")
}else{if(s){this.removeClass("context-menu-disabled")
}else{if(!s){this.addClass("context-menu-disabled")
}}}}}return this
};
l.contextMenu=function(s,t){if(typeof s!="string"){t=s;
s="create"
}if(typeof t=="string"){t={selector:t}
}else{if(t===f){t={}
}}var x=l.extend(true,{},h,t||{}),w=l(document);
switch(s){case"create":if(!x.selector){throw new Error("No selector specified")
}if(x.selector.match(/.context-menu-(list|item|input)($|\s)/)){throw new Error('Cannot bind to selector "'+x.selector+'" as it contains a reserved className')
}if(!x.build&&(!x.items||l.isEmptyObject(x.items))){throw new Error("No Items sepcified")
}a++;
x.ns=".contextMenu"+a;
b[x.selector]=x.ns;
k[x.ns]=x;
if(!x.trigger){x.trigger="right"
}if(!g){w.on({"contextmenu:hide.contextMenu":n.hideMenu,"prevcommand.contextMenu":n.prevItem,"nextcommand.contextMenu":n.nextItem,"contextmenu.contextMenu":n.abortevent,"mouseenter.contextMenu":n.menuMouseenter,"mouseleave.contextMenu":n.menuMouseleave},".context-menu-list").on("mouseup.contextMenu",".context-menu-input",n.inputClick).on({"mouseup.contextMenu":n.itemClick,"contextmenu:focus.contextMenu":n.focusItem,"contextmenu:blur.contextMenu":n.blurItem,"contextmenu.contextMenu":n.abortevent,"mouseenter.contextMenu":n.itemMouseenter,"mouseleave.contextMenu":n.itemMouseleave},".context-menu-item");
g=true
}w.on("contextmenu"+x.ns,x.selector,x,n.contextmenu);
switch(x.trigger){case"hover":w.on("mouseenter"+x.ns,x.selector,x,n.mouseenter).on("mouseleave"+x.ns,x.selector,x,n.mouseleave);
break;
case"left":w.on("click"+x.ns,x.selector,x,n.click);
break
}if(!x.build){m.create(x)
}break;
case"destroy":if(!x.selector){w.off(".contextMenu .contextMenuAutoHide");
l.each(b,function(y,z){w.off(z)
});
b={};
k={};
a=0;
g=false;
l("#context-menu-layer, .context-menu-list").remove()
}else{if(b[x.selector]){var u=l(".context-menu-list").filter(":visible");
if(u.length&&u.data().contextMenuRoot.$trigger.is(x.selector)){u.trigger("contextmenu:hide",{force:true})
}try{if(k[b[x.selector]].$menu){k[b[x.selector]].$menu.remove()
}delete k[b[x.selector]]
}catch(v){k[b[x.selector]]=null
}w.off(b[x.selector])
}}break;
case"html5":if((!l.support.htmlCommand&&!l.support.htmlMenuitem)||(typeof t=="boolean"&&t)){l('menu[type="context"]').each(function(){if(this.id){l.contextMenu({selector:"[contextmenu="+this.id+"]",items:l.contextMenu.fromMenu(this)})
}}).css("display","none")
}break;
default:throw new Error('Unknown operation "'+s+'"')
}return this
};
l.contextMenu.setInputValues=function(s,t){if(t===f){t={}
}l.each(s.inputs,function(u,v){switch(v.type){case"text":case"textarea":v.value=t[u]||"";
break;
case"checkbox":v.selected=t[u]?true:false;
break;
case"radio":v.selected=(t[v.radio]||"")==v.value?true:false;
break;
case"select":v.selected=t[u]||"";
break
}})
};
l.contextMenu.getInputValues=function(s,t){if(t===f){t={}
}l.each(s.inputs,function(u,v){switch(v.type){case"text":case"textarea":case"select":t[u]=v.$input.val();
break;
case"checkbox":t[u]=v.$input.prop("checked");
break;
case"radio":if(v.$input.prop("checked")){t[v.radio]=v.value
}break
}});
return t
};
function e(s){return(s.id&&l('label[for="'+s.id+'"]').val())||s.name
}function q(u,t,s){if(!s){s=0
}t.each(function(){var v=l(this),y=this,z=this.nodeName.toLowerCase(),w,x;
if(z=="label"&&v.find("input, textarea, select").length){w=v.text();
v=v.children().first();
y=v.get(0);
z=y.nodeName.toLowerCase()
}switch(z){case"menu":x={name:v.attr("label"),items:{}};
s=q(x.items,v.children(),s);
break;
case"a":case"button":x={name:v.text(),disabled:!!v.attr("disabled"),callback:(function(){return function(){v.click()
}
})()};
break;
case"menuitem":case"command":switch(v.attr("type")){case f:case"command":case"menuitem":x={name:v.attr("label"),disabled:!!v.attr("disabled"),callback:(function(){return function(){v.click()
}
})()};
break;
case"checkbox":x={type:"checkbox",disabled:!!v.attr("disabled"),name:v.attr("label"),selected:!!v.attr("checked")};
break;
case"radio":x={type:"radio",disabled:!!v.attr("disabled"),name:v.attr("label"),radio:v.attr("radiogroup"),value:v.attr("id"),selected:!!v.attr("checked")};
break;
default:x=f
}break;
case"hr":x="-------";
break;
case"input":switch(v.attr("type")){case"text":x={type:"text",name:w||e(y),disabled:!!v.attr("disabled"),value:v.val()};
break;
case"checkbox":x={type:"checkbox",name:w||e(y),disabled:!!v.attr("disabled"),selected:!!v.attr("checked")};
break;
case"radio":x={type:"radio",name:w||e(y),disabled:!!v.attr("disabled"),radio:!!v.attr("name"),value:v.val(),selected:!!v.attr("checked")};
break;
default:x=f;
break
}break;
case"select":x={type:"select",name:w||e(y),disabled:!!v.attr("disabled"),selected:v.val(),options:{}};
v.children().each(function(){x.options[this.value]=l(this).text()
});
break;
case"textarea":x={type:"textarea",name:w||e(y),disabled:!!v.attr("disabled"),value:v.val()};
break;
case"label":break;
default:x={type:"html",html:v.clone(true)};
break
}if(x){s++;
u["key"+s]=x
}});
return s
}l.contextMenu.fromMenu=function(t){var u=l(t),s={};
q(s,u.children());
return s
};
l.contextMenu.defaults=h;
l.contextMenu.types=o
})(jQuery);
(function(j){var e="0.3.4",k="hasOwnProperty",b=/[\.\/]/,a="*",g=function(){},f=function(n,m){return n-m
},d,h,l={n:{}},c=function(m,C){var v=l,s=h,w=Array.prototype.slice.call(arguments,2),y=c.listeners(m),x=0,u=false,p,o=[],t={},q=[],n=d,A=[];
d=m;
h=0;
for(var r=0,B=y.length;
r<B;
r++){if("zIndex" in y[r]){o.push(y[r].zIndex);
if(y[r].zIndex<0){t[y[r].zIndex]=y[r]
}}}o.sort(f);
while(o[x]<0){p=t[o[x++]];
q.push(p.apply(C,w));
if(h){h=s;
return q
}}for(r=0;
r<B;
r++){p=y[r];
if("zIndex" in p){if(p.zIndex==o[x]){q.push(p.apply(C,w));
if(h){break
}do{x++;
p=t[o[x]];
p&&q.push(p.apply(C,w));
if(h){break
}}while(p)
}else{t[p.zIndex]=p
}}else{q.push(p.apply(C,w));
if(h){break
}}}h=s;
d=n;
return q.length?q:null
};
c.listeners=function(m){var u=m.split(b),s=l,y,t,n,q,x,p,r,v,w=[s],o=[];
for(q=0,x=u.length;
q<x;
q++){v=[];
for(p=0,r=w.length;
p<r;
p++){s=w[p].n;
t=[s[u[q]],s[a]];
n=2;
while(n--){y=t[n];
if(y){v.push(y);
o=o.concat(y.f||[])
}}}w=v
}return o
};
c.on=function(m,p){var r=m.split(b),q=l;
for(var n=0,o=r.length;
n<o;
n++){q=q.n;
!q[r[n]]&&(q[r[n]]={n:{}});
q=q[r[n]]
}q.f=q.f||[];
for(n=0,o=q.f.length;
n<o;
n++){if(q.f[n]==p){return g
}}q.f.push(p);
return function(s){if(+s==+s){p.zIndex=+s
}}
};
c.stop=function(){h=1
};
c.nt=function(m){if(m){return new RegExp("(?:\\.|\\/|^)"+m+"(?:\\.|\\/|$)").test(d)
}return d
};
c.off=c.unbind=function(n,s){var u=n.split(b),t,w,o,q,x,p,r,v=[l];
for(q=0,x=u.length;
q<x;
q++){for(p=0;
p<v.length;
p+=o.length-2){o=[p,1];
t=v[p].n;
if(u[q]!=a){if(t[u[q]]){o.push(t[u[q]])
}}else{for(w in t){if(t[k](w)){o.push(t[w])
}}}v.splice.apply(v,o)
}}for(q=0,x=v.length;
q<x;
q++){t=v[q];
while(t.n){if(s){if(t.f){for(p=0,r=t.f.length;
p<r;
p++){if(t.f[p]==s){t.f.splice(p,1);
break
}}!t.f.length&&delete t.f
}for(w in t.n){if(t.n[k](w)&&t.n[w].f){var m=t.n[w].f;
for(p=0,r=m.length;
p<r;
p++){if(m[p]==s){m.splice(p,1);
break
}}!m.length&&delete t.n[w].f
}}}else{delete t.f;
for(w in t.n){if(t.n[k](w)&&t.n[w].f){delete t.n[w].f
}}}t=t.n
}}};
c.once=function(m,n){var o=function(){var p=n.apply(this,arguments);
c.unbind(m,o);
return p
};
return c.on(m,o)
};
c.version=e;
c.toString=function(){return"You are running Eve "+e
};
(typeof module!="undefined"&&module.exports)?(module.exports=c):(typeof define!="undefined"?(define("eve",[],function(){return c
})):(j.eve=c))
})(this);
(function(){function aR(g){if(aR.is(g,"function")){return ao?g():eve.on("raphael.DOMload",g)
}else{if(aR.is(g,bd)){return aR._engine.create[bG](aR,g.splice(0,3+aR.is(g[0],aL))).add(g)
}else{var b=Array.prototype.slice.call(arguments,0);
if(aR.is(b[b.length-1],"function")){var d=b.pop();
return ao?d.call(aR._engine.create[bG](aR,b)):eve.on("raphael.DOMload",function(){d.call(aR._engine.create[bG](aR,b))
})
}else{return aR._engine.create[bG](aR,arguments)
}}}}aR.version="2.1.0";
aR.eve=eve;
var ao,a=/[, ]+/,bw={circle:1,rect:1,path:1,ellipse:1,text:1,image:1},br=/\{(\d+)\}/g,bJ="prototype",ak="hasOwnProperty",aA={doc:document,win:window},s={was:Object.prototype[ak].call(aA.win,"Raphael"),is:aA.win.Raphael},bF=function(){this.ca=this.customAttributes={}
},a4,bo="appendChild",bG="apply",bE="concat",Z="createTouch" in aA.doc,aX="",aQ=" ",bH=String,F="split",Q="click dblclick mousedown mousemove mouseout mouseover mouseup touchstart touchmove touchend touchcancel"[F](aQ),bx={mousedown:"touchstart",mousemove:"touchmove",mouseup:"touchend"},bK=bH.prototype.toLowerCase,au=Math,m=au.max,bm=au.min,aw=au.abs,bp=au.pow,aV=au.PI,aL="number",aj="string",bd="array",a5="toString",a9="fill",a1=Object.prototype.toString,bz={},j="push",f=aR._ISURL=/^url\(['"]?([^\)]+?)['"]?\)$/i,A=/^\s*((#[a-f\d]{6})|(#[a-f\d]{3})|rgba?\(\s*([\d\.]+%?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+%?(?:\s*,\s*[\d\.]+%?)?)\s*\)|hsba?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+(?:%?\s*,\s*[\d\.]+)?)%?\s*\)|hsla?\(\s*([\d\.]+(?:deg|\xb0|%)?\s*,\s*[\d\.]+%?\s*,\s*[\d\.]+(?:%?\s*,\s*[\d\.]+)?)%?\s*\))\s*$/i,av={"NaN":1,"Infinity":1,"-Infinity":1},c=/^(?:cubic-)?bezier\(([^,]+),([^,]+),([^,]+),([^\)]+)\)/,ah=au.round,z="setAttribute",an=parseFloat,U=parseInt,bt=bH.prototype.toUpperCase,r=aR._availableAttrs={"arrow-end":"none","arrow-start":"none",blur:0,"clip-rect":"0 0 1e9 1e9",cursor:"default",cx:0,cy:0,fill:"#fff","fill-opacity":1,font:'10px "Arial"',"font-family":'"Arial"',"font-size":"10","font-style":"normal","font-weight":400,gradient:0,height:0,href:"http://raphaeljs.com/","letter-spacing":0,opacity:1,path:"M0,0",r:0,rx:0,ry:0,src:"",stroke:"#000","stroke-dasharray":"","stroke-linecap":"butt","stroke-linejoin":"butt","stroke-miterlimit":0,"stroke-opacity":1,"stroke-width":1,target:"_blank","text-anchor":"middle",title:"Raphael",transform:"",width:0,x:0,y:0,"shape-rendering":"crispEdges"},ar=aR._availableAnimAttrs={blur:aL,"clip-rect":"csv",cx:aL,cy:aL,fill:"colour","fill-opacity":aL,"font-size":aL,height:aL,opacity:aL,path:"path",r:aL,rx:aL,ry:aL,stroke:"colour","stroke-opacity":aL,"stroke-width":aL,transform:"transform",width:aL,x:aL,y:aL},ac=/[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]/g,bi=/[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*,[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*/,n={hs:1,rg:1},bg=/,?([achlmqrstvxz]),?/gi,a0=/([achlmrqstvz])[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029,]*((-?\d*\.?\d*(?:e[\-+]?\d+)?[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*,?[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*)+)/ig,ai=/([rstm])[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029,]*((-?\d*\.?\d*(?:e[\-+]?\d+)?[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*,?[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*)+)/ig,aP=/(-?\d*\.?\d*(?:e[\-+]?\d+)?)[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*,?[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*/ig,aW=aR._radial_gradient=/^r(?:\(([^,]+?)[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*,[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\u2028\u2029]*([^\)]+?)\))?/,aU={},bq=function(g,d){return g.key-d.key
},u=function(g,d){return an(g)-an(d)
},I=function(){},bB=function(b){return b
},az=aR._rectPath=function(b,R,d,g,E){if(E){return[["M",b+E,R],["l",d-E*2,0],["a",E,E,0,0,1,E,E],["l",0,g-E*2],["a",E,E,0,0,1,-E,E],["l",E*2-d,0],["a",E,E,0,0,1,-E,-E],["l",0,E*2-g],["a",E,E,0,0,1,E,-E],["z"]]
}return[["M",b,R],["l",d,0],["l",0,g],["l",-d,0],["z"]]
},K=function(b,E,g,d){if(d==null){d=g
}return[["M",b,E],["m",0,-d],["a",g,d,0,1,1,0,2*d],["a",g,d,0,1,1,0,-2*d],["z"]]
},N=aR._getPath={group:function(b){throw new TypeError("Not support for group element!")
},path:function(b){return b.attr("path")
},circle:function(d){var b=d.attrs;
return K(b.cx,b.cy,b.r)
},ellipse:function(d){var b=d.attrs;
return K(b.cx,b.cy,b.rx,b.ry)
},rect:function(d){var b=d.attrs;
return az(b.x,b.y,b.width,b.height,b.r)
},image:function(d){var b=d.attrs;
return az(b.x,b.y,b.width,b.height)
},text:function(b){var d=b._getBBox();
return az(d.x,d.y,d.width,d.height)
},foreignObject:function(d){var b=d.attrs;
return az(b.x,b.y,b.width,b.height)
}},L=aR.mapPath=function(bN,S){if(!S){return bN
}var bL,R,g,b,bM,E,d;
bN=W(bN);
for(g=0,bM=bN.length;
g<bM;
g++){d=bN[g];
for(b=1,E=d.length;
b<E;
b+=2){bL=S.x(d[b],d[b+1]);
R=S.y(d[b],d[b+1]);
d[b]=bL;
d[b+1]=R
}}return bN
};
aR._g=aA;
aR.type=(aA.win.SVGAngle||aA.doc.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1")?"SVG":"VML");
if(aR.type=="VML"){var aE=aA.doc.createElement("div"),aH;
aE.innerHTML='<v:shape adj="1"/>';
aH=aE.firstChild;
aH.style.behavior="url(#default#VML)";
if(!(aH&&typeof aH.adj=="object")){return(aR.type=aX)
}aE=null
}aR.svg=!(aR.vml=aR.type=="VML");
aR._Paper=bF;
aR.fn=a4=bF.prototype=aR.prototype;
aR._id=0;
aR._oid=0;
aR.is=function(d,b){b=bK.call(b);
if(b=="finite"){return !av[ak](+d)
}if(b=="array"){return d instanceof Array
}return(b=="null"&&d===null)||(b==typeof d&&d!==null)||(b=="object"&&d===Object(d))||(b=="array"&&Array.isArray&&Array.isArray(d))||a1.call(d).slice(8,-1).toLowerCase()==b
};
function X(g){if(Object(g)!==g){return g
}var d=new g.constructor;
for(var b in g){if(g[ak](b)){d[b]=X(g[b])
}}return d
}aR.angle=function(R,bL,g,S,d,E){if(d==null){var b=R-g,bM=bL-S;
if(!b&&!bM){return 0
}return(180+au.atan2(-bM,-b)*180/aV+360)%360
}else{return aR.angle(R,bL,d,E)-aR.angle(g,S,d,E)
}};
aR.rad=function(b){return b%360*aV/180
};
aR.deg=function(b){return b*180/aV%360
};
aR.snapTo=function(d,E,b){b=aR.is(b,"finite")?b:10;
if(aR.is(d,bd)){var g=d.length;
while(g--){if(aw(d[g]-E)<=b){return d[g]
}}}else{d=+d;
var R=E%d;
if(R<b){return E-R
}if(R>d-b){return E-R+d
}}return E
};
var h=aR.createUUID=(function(b,d){return function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(b,d).toUpperCase()
}
})(/[xy]/g,function(g){var d=au.random()*16|0,b=g=="x"?d:(d&3|8);
return b.toString(16)
});
aR.setWindow=function(b){eve("raphael.setWindow",aR,aA.win,b);
aA.win=b;
aA.doc=aA.win.document;
if(aR._engine.initWin){aR._engine.initWin(aA.win)
}};
var bf=function(g){if(aR.vml){var b=/^\s+|\s+$/g;
var R;
try{var S=new ActiveXObject("htmlfile");
S.write("<body>");
S.close();
R=S.body
}catch(bL){R=createPopup().document.body
}var d=R.createTextRange();
bf=aG(function(bM){try{R.style.color=bH(bM).replace(b,aX);
var bN=d.queryCommandValue("ForeColor");
bN=((bN&255)<<16)|(bN&65280)|((bN&16711680)>>>16);
return"#"+("000000"+bN.toString(16)).slice(-6)
}catch(bO){return"none"
}})
}else{var E=aA.doc.createElement("i");
E.title="Rapha\xebl Colour Picker";
E.style.display="none";
aA.doc.body.appendChild(E);
bf=aG(function(bM){E.style.color=bM;
return aA.doc.defaultView.getComputedStyle(E,aX).getPropertyValue("color")
})
}return bf(g)
},aI=function(){return"hsb("+[this.h,this.s,this.b]+")"
},M=function(){return"hsl("+[this.h,this.s,this.l]+")"
},x=function(){return this.hex
},aY=function(S,R,d){if(R==null&&aR.is(S,"object")&&"r" in S&&"g" in S&&"b" in S){d=S.b;
R=S.g;
S=S.r
}if(R==null&&aR.is(S,aj)){var E=aR.getRGB(S);
S=E.r;
R=E.g;
d=E.b
}if(S>1||R>1||d>1){S/=255;
R/=255;
d/=255
}return[S,R,d]
},a2=function(S,R,d,bL){S*=255;
R*=255;
d*=255;
var E={r:S,g:R,b:d,hex:aR.rgb(S,R,d),toString:x};
aR.is(bL,"finite")&&(E.opacity=bL);
return E
};
aR.color=function(b){var d;
if(aR.is(b,"object")&&"h" in b&&"s" in b&&"b" in b){d=aR.hsb2rgb(b);
b.r=d.r;
b.g=d.g;
b.b=d.b;
b.hex=d.hex
}else{if(aR.is(b,"object")&&"h" in b&&"s" in b&&"l" in b){d=aR.hsl2rgb(b);
b.r=d.r;
b.g=d.g;
b.b=d.b;
b.hex=d.hex
}else{if(aR.is(b,"string")){b=aR.getRGB(b)
}if(aR.is(b,"object")&&"r" in b&&"g" in b&&"b" in b){d=aR.rgb2hsl(b);
b.h=d.h;
b.s=d.s;
b.l=d.l;
d=aR.rgb2hsb(b);
b.v=d.b
}else{b={hex:"none"};
b.r=b.g=b.b=b.h=b.s=b.v=b.l=-1
}}}b.toString=x;
return b
};
aR.hsb2rgb=function(bL,bO,bM,E){if(this.is(bL,"object")&&"h" in bL&&"s" in bL&&"b" in bL){bM=bL.b;
bO=bL.s;
bL=bL.h;
E=bL.o
}bL*=360;
var S,bN,d,g,b;
bL=(bL%360)/60;
b=bM*bO;
g=b*(1-aw(bL%2-1));
S=bN=d=bM-b;
bL=~~bL;
S+=[b,g,0,0,g,b][bL];
bN+=[g,b,b,g,0,0][bL];
d+=[0,0,g,b,b,g][bL];
return a2(S,bN,d,E)
};
aR.hsl2rgb=function(bM,bO,S,E){if(this.is(bM,"object")&&"h" in bM&&"s" in bM&&"l" in bM){S=bM.l;
bO=bM.s;
bM=bM.h
}if(bM>1||bO>1||S>1){bM/=360;
bO/=100;
S/=100
}bM*=360;
var bL,bN,d,g,b;
bM=(bM%360)/60;
b=2*bO*(S<0.5?S:1-S);
g=b*(1-aw(bM%2-1));
bL=bN=d=S-b/2;
bM=~~bM;
bL+=[b,g,0,0,g,b][bM];
bN+=[g,b,b,g,0,0][bM];
d+=[0,0,g,b,b,g][bM];
return a2(bL,bN,d,E)
};
aR.rgb2hsb=function(bN,bM,d){d=aY(bN,bM,d);
bN=d[0];
bM=d[1];
d=d[2];
var bL,R,E,bO;
E=m(bN,bM,d);
bO=E-bm(bN,bM,d);
bL=(bO==0?null:E==bN?(bM-d)/bO:E==bM?(d-bN)/bO+2:(bN-bM)/bO+4);
bL=((bL+360)%6)*60/360;
R=bO==0?0:bO/E;
return{h:bL,s:R,b:E,toString:aI}
};
aR.rgb2hsl=function(d,bM,bP){bP=aY(d,bM,bP);
d=bP[0];
bM=bP[1];
bP=bP[2];
var bQ,bL,bO,bN,R,E;
bN=m(d,bM,bP);
R=bm(d,bM,bP);
E=bN-R;
bQ=(E==0?null:bN==d?(bM-bP)/E:bN==bM?(bP-d)/E+2:(d-bM)/E+4);
bQ=((bQ+360)%6)*60/360;
bO=(bN+R)/2;
bL=(E==0?0:bO<0.5?E/(2*bO):E/(2-2*bO));
return{h:bQ,s:bL,l:bO,toString:M}
};
aR._path2string=function(){return this.join(",").replace(bg,"$1")
};
function bk(E,g){for(var b=0,d=E.length;
b<d;
b++){if(E[b]===g){return E.push(E.splice(b,1)[0])
}}}function aG(E,d,b){function g(){var R=Array.prototype.slice.call(arguments,0),bL=R.join("\u2400"),S=g.cache=g.cache||{},bM=g.count=g.count||[];
if(S[ak](bL)){bk(bM,bL);
return b?b(S[bL]):S[bL]
}bM.length>=1000&&delete S[bM.shift()];
bM.push(bL);
S[bL]=E[bG](d,R);
return b?b(S[bL]):S[bL]
}return g
}var bv=aR._preload=function(g,d){var b=aA.doc.createElement("img");
b.style.cssText="position:absolute;left:-9999em;top:-9999em";
b.onload=function(){d.call(this);
this.onload=null;
aA.doc.body.removeChild(this)
};
b.onerror=function(){aA.doc.body.removeChild(this)
};
aA.doc.body.appendChild(b);
b.src=g
};
function aq(){return this.hex
}aR.getRGB=aG(function(b){if(!b||!!((b=bH(b)).indexOf("-")+1)){return{r:-1,g:-1,b:-1,hex:"none",error:1,toString:aq}
}if(b=="none"){return{r:-1,g:-1,b:-1,hex:"none",toString:aq}
}!(n[ak](b.toLowerCase().substring(0,2))||b.charAt()=="#")&&(b=bf(b));
var R,d,g,bL,E,bN,bM,S=b.match(A);
if(S){if(S[2]){bL=U(S[2].substring(5),16);
g=U(S[2].substring(3,5),16);
d=U(S[2].substring(1,3),16)
}if(S[3]){bL=U((bN=S[3].charAt(3))+bN,16);
g=U((bN=S[3].charAt(2))+bN,16);
d=U((bN=S[3].charAt(1))+bN,16)
}if(S[4]){bM=S[4][F](bi);
d=an(bM[0]);
bM[0].slice(-1)=="%"&&(d*=2.55);
g=an(bM[1]);
bM[1].slice(-1)=="%"&&(g*=2.55);
bL=an(bM[2]);
bM[2].slice(-1)=="%"&&(bL*=2.55);
S[1].toLowerCase().slice(0,4)=="rgba"&&(E=an(bM[3]));
bM[3]&&bM[3].slice(-1)=="%"&&(E/=100)
}if(S[5]){bM=S[5][F](bi);
d=an(bM[0]);
bM[0].slice(-1)=="%"&&(d*=2.55);
g=an(bM[1]);
bM[1].slice(-1)=="%"&&(g*=2.55);
bL=an(bM[2]);
bM[2].slice(-1)=="%"&&(bL*=2.55);
(bM[0].slice(-3)=="deg"||bM[0].slice(-1)=="\xb0")&&(d/=360);
S[1].toLowerCase().slice(0,4)=="hsba"&&(E=an(bM[3]));
bM[3]&&bM[3].slice(-1)=="%"&&(E/=100);
return aR.hsb2rgb(d,g,bL,E)
}if(S[6]){bM=S[6][F](bi);
d=an(bM[0]);
bM[0].slice(-1)=="%"&&(d*=2.55);
g=an(bM[1]);
bM[1].slice(-1)=="%"&&(g*=2.55);
bL=an(bM[2]);
bM[2].slice(-1)=="%"&&(bL*=2.55);
(bM[0].slice(-3)=="deg"||bM[0].slice(-1)=="\xb0")&&(d/=360);
S[1].toLowerCase().slice(0,4)=="hsla"&&(E=an(bM[3]));
bM[3]&&bM[3].slice(-1)=="%"&&(E/=100);
return aR.hsl2rgb(d,g,bL,E)
}S={r:d,g:g,b:bL,toString:aq};
S.hex="#"+(16777216|bL|(g<<8)|(d<<16)).toString(16).slice(1);
aR.is(E,"finite")&&(S.opacity=E);
return S
}return{r:-1,g:-1,b:-1,hex:"none",error:1,toString:aq}
},aR);
aR.hsb=aG(function(E,g,d){return aR.hsb2rgb(E,g,d).hex
});
aR.hsl=aG(function(g,d,b){return aR.hsl2rgb(g,d,b).hex
});
aR.rgb=aG(function(R,E,d){return"#"+(16777216|d|(E<<8)|(R<<16)).toString(16).slice(1)
});
aR.getColor=function(d){var g=this.getColor.start=this.getColor.start||{h:0,s:1,b:d||0.75},b=this.hsb2rgb(g.h,g.s,g.b);
g.h+=0.075;
if(g.h>1){g.h=0;
g.s-=0.2;
g.s<=0&&(this.getColor.start={h:0,s:1,b:g.b})
}return b.hex
};
aR.getColor.reset=function(){delete this.start
};
function bb(E,bL){var S=[];
for(var g=0,b=E.length;
b-2*!bL>g;
g+=2){var R=[{x:+E[g-2],y:+E[g-1]},{x:+E[g],y:+E[g+1]},{x:+E[g+2],y:+E[g+3]},{x:+E[g+4],y:+E[g+5]}];
if(bL){if(!g){R[0]={x:+E[b-2],y:+E[b-1]}
}else{if(b-4==g){R[3]={x:+E[0],y:+E[1]}
}else{if(b-2==g){R[2]={x:+E[0],y:+E[1]};
R[3]={x:+E[2],y:+E[3]}
}}}}else{if(b-4==g){R[3]=R[2]
}else{if(!g){R[0]={x:+E[g],y:+E[g+1]}
}}}S.push(["C",(-R[0].x+6*R[1].x+R[2].x)/6,(-R[0].y+6*R[1].y+R[2].y)/6,(R[1].x+6*R[2].x-R[3].x)/6,(R[1].y+6*R[2].y-R[3].y)/6,R[2].x,R[2].y])
}return S
}aR.parsePathString=function(b){if(!b){return null
}var g=Y(b);
if(g.arr){return aZ(g.arr)
}var E={a:7,c:6,h:1,l:2,m:2,r:4,q:4,s:4,t:2,v:1,z:0},d=[];
if(aR.is(b,bd)&&aR.is(b[0],bd)){d=aZ(b)
}if(!d.length){bH(b).replace(a0,function(S,R,bN){var bM=[],bL=R.toLowerCase();
bN.replace(aP,function(bP,bO){bO&&bM.push(+bO)
});
if(bL=="m"&&bM.length>2){d.push([R][bE](bM.splice(0,2)));
bL="l";
R=R=="m"?"l":"L"
}if(bL=="r"){d.push([R][bE](bM))
}else{while(bM.length>=E[bL]){d.push([R][bE](bM.splice(0,E[bL])));
if(!E[bL]){break
}}}})
}d.toString=aR._path2string;
g.arr=aZ(d);
return d
};
aR.parseTransformString=aG(function(d){if(!d){return null
}var g={r:3,s:4,t:2,m:6},b=[];
if(aR.is(d,bd)&&aR.is(d[0],bd)){b=aZ(d)
}if(!b.length){bH(d).replace(ai,function(R,E,bM){var bL=[],S=bK.call(E);
bM.replace(aP,function(bO,bN){bN&&bL.push(+bN)
});
b.push([E][bE](bL))
})
}b.toString=aR._path2string;
return b
});
var Y=function(d){var b=Y.ps=Y.ps||{};
if(b[d]){b[d].sleep=100
}else{b[d]={sleep:100}
}setTimeout(function(){for(var g in b){if(b[ak](g)&&g!=d){b[g].sleep--;
!b[g].sleep&&delete b[g]
}}});
return b[d]
};
aR.findDotsAtSegment=function(d,b,b3,b1,bL,R,bO,bM,bW){var bT=1-bW,bY=bp(bT,3),bZ=bp(bT,2),bQ=bW*bW,bN=bQ*bW,bS=bY*d+bZ*3*bW*b3+bT*3*bW*bW*bL+bN*bO,bP=bY*b+bZ*3*bW*b1+bT*3*bW*bW*R+bN*bM,bX=d+2*bW*(b3-d)+bQ*(bL-2*b3+d),bV=b+2*bW*(b1-b)+bQ*(R-2*b1+b),b2=b3+2*bW*(bL-b3)+bQ*(bO-2*bL+b3),b0=b1+2*bW*(R-b1)+bQ*(bM-2*R+b1),bU=bT*d+bW*b3,bR=bT*b+bW*b1,E=bT*bL+bW*bO,g=bT*R+bW*bM,S=(90-au.atan2(bX-b2,bV-b0)*180/aV);
(bX>b2||bV<b0)&&(S+=180);
return{x:bS,y:bP,m:{x:bX,y:bV},n:{x:b2,y:b0},start:{x:bU,y:bR},end:{x:E,y:g},alpha:S}
};
aR.bezierBBox=function(d,b,E,g,bN,bL,S,R){if(!aR.is(d,"array")){d=[d,b,E,g,bN,bL,S,R]
}var bM=ba.apply(null,d);
return{x:bM.min.x,y:bM.min.y,x2:bM.max.x,y2:bM.max.y,width:bM.max.x-bM.min.x,height:bM.max.y-bM.min.y}
};
aR.isPointInsideBBox=function(d,b,g){return b>=d.x&&b<=d.x2&&g>=d.y&&g<=d.y2
};
aR.isBBoxIntersect=function(g,d){var b=aR.isPointInsideBBox;
return b(d,g.x,g.y)||b(d,g.x2,g.y)||b(d,g.x,g.y2)||b(d,g.x2,g.y2)||b(g,d.x,d.y)||b(g,d.x2,d.y)||b(g,d.x,d.y2)||b(g,d.x2,d.y2)||(g.x<d.x2&&g.x>d.x||d.x<g.x2&&d.x>g.x)&&(g.y<d.y2&&g.y>d.y||d.y<g.y2&&d.y>g.y)
};
function bj(b,bL,S,R,E){var g=-3*bL+9*S-9*R+3*E,d=b*g+6*bL-12*S+6*R;
return b*d-3*bL+3*S
}function q(bW,R,bV,g,bU,d,bR,b,bO){if(bO==null){bO=1
}bO=bO>1?1:bO<0?0:bO;
var bP=bO/2,bQ=12,bL=[-0.1252,0.1252,-0.3678,0.3678,-0.5873,0.5873,-0.7699,0.7699,-0.9041,0.9041,-0.9816,0.9816],bT=[0.2491,0.2491,0.2335,0.2335,0.2032,0.2032,0.1601,0.1601,0.1069,0.1069,0.0472,0.0472],E=0;
for(var bS=0;
bS<bQ;
bS++){var bM=bP*bL[bS]+bP,bN=bj(bM,bW,bV,bU,bR),bX=bj(bM,R,g,d,b),S=bN*bN+bX*bX;
E+=bT[bS]*au.sqrt(S)
}return bP*E
}function C(g,bQ,d,bP,b,bN,bS,bM,bO){if(bO<0||q(g,bQ,d,bP,b,bN,bS,bM)<bO){return
}var bR=1,E=bR/2,S=bR-E,R,bL=0.01;
R=q(g,bQ,d,bP,b,bN,bS,bM,S);
while(aw(R-bO)>bL){E/=2;
S+=(R<bO?1:-1)*E;
R=q(g,bQ,d,bP,b,bN,bS,bM,S)
}return S
}function O(E,bR,g,bP,b,bO,bT,bN){if(m(E,g)<bm(b,bT)||bm(E,g)>m(b,bT)||m(bR,bP)<bm(bO,bN)||bm(bR,bP)>m(bO,bN)){return
}var bM=(E*bP-bR*g)*(b-bT)-(E-g)*(b*bN-bO*bT),bL=(E*bP-bR*g)*(bO-bN)-(bR-bP)*(b*bN-bO*bT),R=(E-g)*(bO-bN)-(bR-bP)*(b-bT);
if(!R){return
}var bS=bM/R,bQ=bL/R,S=+bS.toFixed(2),d=+bQ.toFixed(2);
if(S<+bm(E,g).toFixed(2)||S>+m(E,g).toFixed(2)||S<+bm(b,bT).toFixed(2)||S>+m(b,bT).toFixed(2)||d<+bm(bR,bP).toFixed(2)||d>+m(bR,bP).toFixed(2)||d<+bm(bO,bN).toFixed(2)||d>+m(bO,bN).toFixed(2)){return
}return{x:bS,y:bQ}
}function ay(d,b){return af(d,b)
}function t(d,b){return af(d,b,1)
}function af(b2,b1,b0){var E=aR.bezierBBox(b2),d=aR.bezierBBox(b1);
if(!aR.isBBoxIntersect(E,d)){return b0?0:[]
}var bV=q.apply(0,b2),bU=q.apply(0,b1),bM=~~(bV/5),bL=~~(bU/5),bS=[],bR=[],g={},b3=b0?0:[];
for(var bX=0;
bX<bM+1;
bX++){var bT=aR.findDotsAtSegment.apply(aR,b2.concat(bX/bM));
bS.push({x:bT.x,y:bT.y,t:bX/bM})
}for(bX=0;
bX<bL+1;
bX++){bT=aR.findDotsAtSegment.apply(aR,b1.concat(bX/bL));
bR.push({x:bT.x,y:bT.y,t:bX/bL})
}for(bX=0;
bX<bM;
bX++){for(var bW=0;
bW<bL;
bW++){var bZ=bS[bX],b=bS[bX+1],bY=bR[bW],S=bR[bW+1],bQ=aw(b.x-bZ.x)<0.001?"y":"x",bP=aw(S.x-bY.x)<0.001?"y":"x",R=O(bZ.x,bZ.y,b.x,b.y,bY.x,bY.y,S.x,S.y);
if(R){if(g[R.x.toFixed(4)]==R.y.toFixed(4)){continue
}g[R.x.toFixed(4)]=R.y.toFixed(4);
var bO=bZ.t+aw((R[bQ]-bZ[bQ])/(b[bQ]-bZ[bQ]))*(b.t-bZ.t),bN=bY.t+aw((R[bP]-bY[bP])/(S[bP]-bY[bP]))*(S.t-bY.t);
if(bO>=0&&bO<=1&&bN>=0&&bN<=1){if(b0){b3++
}else{b3.push({x:R.x,y:R.y,t1:bO,t2:bN})
}}}}}return b3
}aR.pathIntersection=function(d,b){return D(d,b)
};
aR.pathIntersectionNumber=function(d,b){return D(d,b,1)
};
function D(g,b,bW){g=aR._path2curve(g);
b=aR._path2curve(b);
var bU,S,bT,E,bR,bL,d,bO,b0,bZ,b1=bW?0:[];
for(var bS=0,bM=g.length;
bS<bM;
bS++){var bY=g[bS];
if(bY[0]=="M"){bU=bR=bY[1];
S=bL=bY[2]
}else{if(bY[0]=="C"){b0=[bU,S].concat(bY.slice(1));
bU=b0[6];
S=b0[7]
}else{b0=[bU,S,bU,S,bR,bL,bR,bL];
bU=bR;
S=bL
}for(var bQ=0,bV=b.length;
bQ<bV;
bQ++){var bX=b[bQ];
if(bX[0]=="M"){bT=d=bX[1];
E=bO=bX[2]
}else{if(bX[0]=="C"){bZ=[bT,E].concat(bX.slice(1));
bT=bZ[6];
E=bZ[7]
}else{bZ=[bT,E,bT,E,d,bO,d,bO];
bT=d;
E=bO
}var bN=af(b0,bZ,bW);
if(bW){b1+=bN
}else{for(var bP=0,R=bN.length;
bP<R;
bP++){bN[bP].segment1=bS;
bN[bP].segment2=bQ;
bN[bP].bez1=b0;
bN[bP].bez2=bZ
}b1=b1.concat(bN)
}}}}}return b1
}aR.isPointInsidePath=function(d,b,E){var g=aR.pathBBox(d);
return aR.isPointInsideBBox(g,b,E)&&D(d,[["M",b,E],["H",g.x2+10]],1)%2==1
};
aR._removedFactory=function(b){return function(){eve("raphael.log",null,"Rapha\xebl: you are calling to method \u201c"+b+"\u201d of removed object",b)
}
};
var am=aR.pathBBox=function(bT){var bN=Y(bT);
if(bN.bbox){return bN.bbox
}if(!bT){return{x:0,y:0,width:0,height:0,x2:0,y2:0}
}bT=W(bT);
var bQ=0,bP=0,R=[],d=[],g;
for(var bL=0,bS=bT.length;
bL<bS;
bL++){g=bT[bL];
if(g[0]=="M"){bQ=g[1];
bP=g[2];
R.push(bQ);
d.push(bP)
}else{var bM=ba(bQ,bP,g[1],g[2],g[3],g[4],g[5],g[6]);
R=R[bE](bM.min.x,bM.max.x);
d=d[bE](bM.min.y,bM.max.y);
bQ=g[5];
bP=g[6]
}}var b=bm[bG](0,R),bR=bm[bG](0,d),S=m[bG](0,R),E=m[bG](0,d),bO={x:b,y:bR,x2:S,y2:E,width:S-b,height:E-bR};
bN.bbox=X(bO);
return bO
},aZ=function(d){var b=X(d);
b.toString=aR._path2string;
return b
},aC=aR._pathToRelative=function(E){var bM=Y(E);
if(bM.rel){return aZ(bM.rel)
}if(!aR.is(E,bd)||!aR.is(E&&E[0],bd)){E=aR.parsePathString(E)
}var bP=[],bR=0,bQ=0,bU=0,bT=0,g=0;
if(E[0][0]=="M"){bR=E[0][1];
bQ=E[0][2];
bU=bR;
bT=bQ;
g++;
bP.push(["M",bR,bQ])
}for(var bL=g,bV=E.length;
bL<bV;
bL++){var b=bP[bL]=[],bS=E[bL];
if(bS[0]!=bK.call(bS[0])){b[0]=bK.call(bS[0]);
switch(b[0]){case"a":b[1]=bS[1];
b[2]=bS[2];
b[3]=bS[3];
b[4]=bS[4];
b[5]=bS[5];
b[6]=+(bS[6]-bR).toFixed(3);
b[7]=+(bS[7]-bQ).toFixed(3);
break;
case"v":b[1]=+(bS[1]-bQ).toFixed(3);
break;
case"m":bU=bS[1];
bT=bS[2];
default:for(var S=1,bN=bS.length;
S<bN;
S++){b[S]=+(bS[S]-((S%2)?bR:bQ)).toFixed(3)
}}}else{b=bP[bL]=[];
if(bS[0]=="m"){bU=bS[1]+bR;
bT=bS[2]+bQ
}for(var R=0,d=bS.length;
R<d;
R++){bP[bL][R]=bS[R]
}}var bO=bP[bL].length;
switch(bP[bL][0]){case"z":bR=bU;
bQ=bT;
break;
case"h":bR+=+bP[bL][bO-1];
break;
case"v":bQ+=+bP[bL][bO-1];
break;
default:bR+=+bP[bL][bO-2];
bQ+=+bP[bL][bO-1]
}}bP.toString=aR._path2string;
bM.rel=aZ(bP);
return bP
},w=aR._pathToAbsolute=function(bQ){var g=Y(bQ);
if(g.abs){return aZ(g.abs)
}if(!aR.is(bQ,bd)||!aR.is(bQ&&bQ[0],bd)){bQ=aR.parsePathString(bQ)
}if(!bQ||!bQ.length){return[["M",0,0]]
}var bW=[],bL=0,S=0,bO=0,bN=0,E=0;
if(bQ[0][0]=="M"){bL=+bQ[0][1];
S=+bQ[0][2];
bO=bL;
bN=S;
E++;
bW[0]=["M",bL,S]
}var bV=bQ.length==3&&bQ[0][0]=="M"&&bQ[1][0].toUpperCase()=="R"&&bQ[2][0].toUpperCase()=="Z";
for(var bP,b,bT=E,bM=bQ.length;
bT<bM;
bT++){bW.push(bP=[]);
b=bQ[bT];
if(b[0]!=bt.call(b[0])){bP[0]=bt.call(b[0]);
switch(bP[0]){case"A":bP[1]=b[1];
bP[2]=b[2];
bP[3]=b[3];
bP[4]=b[4];
bP[5]=b[5];
bP[6]=+(b[6]+bL);
bP[7]=+(b[7]+S);
break;
case"V":bP[1]=+b[1]+S;
break;
case"H":bP[1]=+b[1]+bL;
break;
case"R":var R=[bL,S][bE](b.slice(1));
for(var bS=2,bU=R.length;
bS<bU;
bS++){R[bS]=+R[bS]+bL;
R[++bS]=+R[bS]+S
}bW.pop();
bW=bW[bE](bb(R,bV));
break;
case"M":bO=+b[1]+bL;
bN=+b[2]+S;
default:for(bS=1,bU=b.length;
bS<bU;
bS++){bP[bS]=+b[bS]+((bS%2)?bL:S)
}}}else{if(b[0]=="R"){R=[bL,S][bE](b.slice(1));
bW.pop();
bW=bW[bE](bb(R,bV));
bP=["R"][bE](b.slice(-2))
}else{for(var bR=0,d=b.length;
bR<d;
bR++){bP[bR]=b[bR]
}}}switch(bP[0]){case"Z":bL=bO;
S=bN;
break;
case"H":bL=bP[1];
break;
case"V":S=bP[1];
break;
case"M":bO=bP[bP.length-2];
bN=bP[bP.length-1];
default:bL=bP[bP.length-2];
S=bP[bP.length-1]
}}bW.toString=aR._path2string;
g.abs=aZ(bW);
return bW
},bI=function(d,E,b,g){return[d,E,b,g,b,g]
},bn=function(d,E,bL,R,b,g){var S=1/3,bM=2/3;
return[S*d+bM*bL,S*E+bM*R,S*b+bM*bL,S*g+bM*R,b,g]
},ae=function(bS,cn,b1,bZ,bT,bN,E,bR,cm,bU){var bY=aV*120/180,b=aV/180*(+bT||0),b5=[],b2,cj=aG(function(cp,cs,co){var cr=cp*au.cos(co)-cs*au.sin(co),cq=cp*au.sin(co)+cs*au.cos(co);
return{x:cr,y:cq}
});
if(!bU){b2=cj(bS,cn,-b);
bS=b2.x;
cn=b2.y;
b2=cj(bR,cm,-b);
bR=b2.x;
cm=b2.y;
var d=au.cos(aV/180*bT),bP=au.sin(aV/180*bT),b7=(bS-bR)/2,b6=(cn-cm)/2;
var ch=(b7*b7)/(b1*b1)+(b6*b6)/(bZ*bZ);
if(ch>1){ch=au.sqrt(ch);
b1=ch*b1;
bZ=ch*bZ
}var g=b1*b1,ca=bZ*bZ,cc=(bN==E?-1:1)*au.sqrt(aw((g*ca-g*b6*b6-ca*b7*b7)/(g*b6*b6+ca*b7*b7))),bW=cc*b1*b6/bZ+(bS+bR)/2,bV=cc*-bZ*b7/b1+(cn+cm)/2,bM=au.asin(((cn-bV)/bZ).toFixed(9)),bL=au.asin(((cm-bV)/bZ).toFixed(9));
bM=bS<bW?aV-bM:bM;
bL=bR<bW?aV-bL:bL;
bM<0&&(bM=aV*2+bM);
bL<0&&(bL=aV*2+bL);
if(E&&bM>bL){bM=bM-aV*2
}if(!E&&bL>bM){bL=bL-aV*2
}}else{bM=bU[0];
bL=bU[1];
bW=bU[2];
bV=bU[3]
}var bQ=bL-bM;
if(aw(bQ)>bY){var bX=bL,b0=bR,bO=cm;
bL=bM+bY*(E&&bL>bM?1:-1);
bR=bW+b1*au.cos(bL);
cm=bV+bZ*au.sin(bL);
b5=ae(bR,cm,b1,bZ,bT,0,E,b0,bO,[bL,bX,bW,bV])
}bQ=bL-bM;
var S=au.cos(bM),cl=au.sin(bM),R=au.cos(bL),ck=au.sin(bL),b8=au.tan(bQ/4),cb=4/3*b1*b8,b9=4/3*bZ*b8,ci=[bS,cn],cg=[bS+cb*cl,cn-b9*S],cf=[bR+cb*ck,cm-b9*R],cd=[bR,cm];
cg[0]=2*ci[0]-cg[0];
cg[1]=2*ci[1]-cg[1];
if(bU){return[cg,cf,cd][bE](b5)
}else{b5=[cg,cf,cd][bE](b5).join()[F](",");
var b3=[];
for(var ce=0,b4=b5.length;
ce<b4;
ce++){b3[ce]=ce%2?cj(b5[ce-1],b5[ce],b).y:cj(b5[ce],b5[ce+1],b).x
}return b3
}},ag=function(d,b,E,g,bN,bM,bL,S,bO){var R=1-bO;
return{x:bp(R,3)*d+bp(R,2)*3*bO*E+R*3*bO*bO*bN+bp(bO,3)*bL,y:bp(R,3)*b+bp(R,2)*3*bO*g+R*3*bO*bO*bM+bp(bO,3)*S}
},ba=aG(function(E,d,S,R,bV,bU,bR,bO){var bT=(bV-2*S+E)-(bR-2*bV+S),bQ=2*(S-E)-2*(bV-S),bN=E-S,bM=(-bQ+au.sqrt(bQ*bQ-4*bT*bN))/2/bT,bL=(-bQ-au.sqrt(bQ*bQ-4*bT*bN))/2/bT,bP=[d,bO],bS=[E,bR],g;
aw(bM)>"1e12"&&(bM=0.5);
aw(bL)>"1e12"&&(bL=0.5);
if(bM>0&&bM<1){g=ag(E,d,S,R,bV,bU,bR,bO,bM);
bS.push(g.x);
bP.push(g.y)
}if(bL>0&&bL<1){g=ag(E,d,S,R,bV,bU,bR,bO,bL);
bS.push(g.x);
bP.push(g.y)
}bT=(bU-2*R+d)-(bO-2*bU+R);
bQ=2*(R-d)-2*(bU-R);
bN=d-R;
bM=(-bQ+au.sqrt(bQ*bQ-4*bT*bN))/2/bT;
bL=(-bQ-au.sqrt(bQ*bQ-4*bT*bN))/2/bT;
aw(bM)>"1e12"&&(bM=0.5);
aw(bL)>"1e12"&&(bL=0.5);
if(bM>0&&bM<1){g=ag(E,d,S,R,bV,bU,bR,bO,bM);
bS.push(g.x);
bP.push(g.y)
}if(bL>0&&bL<1){g=ag(E,d,S,R,bV,bU,bR,bO,bL);
bS.push(g.x);
bP.push(g.y)
}return{min:{x:bm[bG](0,bS),y:bm[bG](0,bP)},max:{x:m[bG](0,bS),y:m[bG](0,bP)}}
}),W=aR._path2curve=aG(function(bU,bP){var bN=!bP&&Y(bU);
if(!bP&&bN.curve){return aZ(bN.curve)
}var E=w(bU),bQ=bP&&w(bP),bR={x:0,y:0,bx:0,by:0,X:0,Y:0,qx:null,qy:null},d={x:0,y:0,bx:0,by:0,X:0,Y:0,qx:null,qy:null},S=function(bW,bX){var bV,bY;
if(!bW){return["C",bX.x,bX.y,bX.x,bX.y,bX.x,bX.y]
}!(bW[0] in {T:1,Q:1})&&(bX.qx=bX.qy=null);
switch(bW[0]){case"M":bX.X=bW[1];
bX.Y=bW[2];
break;
case"A":bW=["C"][bE](ae[bG](0,[bX.x,bX.y][bE](bW.slice(1))));
break;
case"S":bV=bX.x+(bX.x-(bX.bx||bX.x));
bY=bX.y+(bX.y-(bX.by||bX.y));
bW=["C",bV,bY][bE](bW.slice(1));
break;
case"T":bX.qx=bX.x+(bX.x-(bX.qx||bX.x));
bX.qy=bX.y+(bX.y-(bX.qy||bX.y));
bW=["C"][bE](bn(bX.x,bX.y,bX.qx,bX.qy,bW[1],bW[2]));
break;
case"Q":bX.qx=bW[1];
bX.qy=bW[2];
bW=["C"][bE](bn(bX.x,bX.y,bW[1],bW[2],bW[3],bW[4]));
break;
case"L":bW=["C"][bE](bI(bX.x,bX.y,bW[1],bW[2]));
break;
case"H":bW=["C"][bE](bI(bX.x,bX.y,bW[1],bX.y));
break;
case"V":bW=["C"][bE](bI(bX.x,bX.y,bX.x,bW[1]));
break;
case"Z":bW=["C"][bE](bI(bX.x,bX.y,bX.X,bX.Y));
break
}return bW
},b=function(bV,bW){if(bV[bW].length>7){bV[bW].shift();
var bX=bV[bW];
while(bX.length){bV.splice(bW++,0,["C"][bE](bX.splice(0,6)))
}bV.splice(bW,1);
bS=m(E.length,bQ&&bQ.length||0)
}},g=function(bZ,bY,bW,bV,bX){if(bZ&&bY&&bZ[bX][0]=="M"&&bY[bX][0]!="M"){bY.splice(bX,0,["M",bV.x,bV.y]);
bW.bx=0;
bW.by=0;
bW.x=bZ[bX][1];
bW.y=bZ[bX][2];
bS=m(E.length,bQ&&bQ.length||0)
}};
for(var bM=0,bS=m(E.length,bQ&&bQ.length||0);
bM<bS;
bM++){E[bM]=S(E[bM],bR);
b(E,bM);
bQ&&(bQ[bM]=S(bQ[bM],d));
bQ&&b(bQ,bM);
g(E,bQ,bR,d,bM);
g(bQ,E,d,bR,bM);
var bL=E[bM],bT=bQ&&bQ[bM],R=bL.length,bO=bQ&&bT.length;
bR.x=bL[R-2];
bR.y=bL[R-1];
bR.bx=an(bL[R-4])||bR.x;
bR.by=an(bL[R-3])||bR.y;
d.bx=bQ&&(an(bT[bO-4])||d.x);
d.by=bQ&&(an(bT[bO-3])||d.y);
d.x=bQ&&bT[bO-2];
d.y=bQ&&bT[bO-1]
}if(!bQ){bN.curve=aZ(E)
}return bQ?[E,bQ]:E
},null,aZ),v=aR._parseDots=aG(function(bO){var bN=[];
for(var S=0,bP=bO.length;
S<bP;
S++){var b={},bM=bO[S].match(/^([^:]*):?([\d\.]*)/);
b.color=aR.getRGB(bM[1]);
if(b.color.error){return null
}b.color=b.color.hex;
bM[2]&&(b.offset=bM[2]+"%");
bN.push(b)
}for(S=1,bP=bN.length-1;
S<bP;
S++){if(!bN[S].offset){var g=an(bN[S-1].offset||0),E=0;
for(var R=S+1;
R<bP;
R++){if(bN[R].offset){E=bN[R].offset;
break
}}if(!E){E=100;
R=bP
}E=an(E);
var bL=(E-g)/(R-S+1);
for(;
S<R;
S++){g+=bL;
bN[S].offset=g+"%"
}}}return bN
}),aK=aR._tear=function(b,d){b==d.top&&(d.top=b.prev);
b==d.bottom&&(d.bottom=b.next);
b.next&&(b.next.prev=b.prev);
b.prev&&(b.prev.next=b.next)
},ap=aR._tofront=function(b,d){if(d.top===b){return
}aK(b,d);
b.next=null;
b.prev=d.top;
d.top.next=b;
d.top=b
},p=aR._toback=function(b,d){if(d.bottom===b){return
}aK(b,d);
b.next=d.bottom;
b.prev=null;
d.bottom.prev=b;
d.bottom=b
},G=aR._insertafter=function(d,b,g){aK(d,g);
b==g.top&&(g.top=d);
b.next&&(b.next.prev=d);
d.next=b.next;
d.prev=b;
b.next=d
},aT=aR._insertbefore=function(d,b,g){aK(d,g);
b==g.bottom&&(g.bottom=d);
b.prev&&(b.prev.next=d);
d.prev=b.prev;
b.prev=d;
d.next=b
},bl=aR.toMatrix=function(g,b){var E=am(g),d={_:{transform:aX},getBBox:function(){return E
}};
aO(d,b);
return d.matrix
},T=aR.transformPath=function(d,b){return L(d,bl(d,b))
},aO=aR._extractTransform=function(d,bZ){if(bZ==null){return d._.transform
}bZ=bH(bZ).replace(/\.{3}|\u2026/g,d._.transform||aX);
var bR=aR.parseTransformString(bZ),bP=0,bN=0,bM=0,bT=1,bS=1,b0=d._,bU=new aF;
b0.transform=bR||[];
if(bR){for(var bV=0,bO=bR.length;
bV<bO;
bV++){var bQ=bR[bV],b=bQ.length,R=bH(bQ[0]).toLowerCase(),bY=bQ[0]!=R,bL=bY?bU.invert():0,bX,E,bW,g,S;
if(R=="t"&&b==3){if(bY){bX=bL.x(0,0);
E=bL.y(0,0);
bW=bL.x(bQ[1],bQ[2]);
g=bL.y(bQ[1],bQ[2]);
bU.translate(bW-bX,g-E)
}else{bU.translate(bQ[1],bQ[2])
}}else{if(R=="r"){if(b==2){S=S||d.getBBox(1);
bU.rotate(bQ[1],S.x+S.width/2,S.y+S.height/2);
bP+=bQ[1]
}else{if(b==4){if(bY){bW=bL.x(bQ[2],bQ[3]);
g=bL.y(bQ[2],bQ[3]);
bU.rotate(bQ[1],bW,g)
}else{bU.rotate(bQ[1],bQ[2],bQ[3])
}bP+=bQ[1]
}}}else{if(R=="s"){if(b==2||b==3){S=S||d.getBBox(1);
bU.scale(bQ[1],bQ[b-1],S.x+S.width/2,S.y+S.height/2);
bT*=bQ[1];
bS*=bQ[b-1]
}else{if(b==5){if(bY){bW=bL.x(bQ[3],bQ[4]);
g=bL.y(bQ[3],bQ[4]);
bU.scale(bQ[1],bQ[2],bW,g)
}else{bU.scale(bQ[1],bQ[2],bQ[3],bQ[4])
}bT*=bQ[1];
bS*=bQ[2]
}}}else{if(R=="m"&&b==7){bU.add(bQ[1],bQ[2],bQ[3],bQ[4],bQ[5],bQ[6])
}}}}b0.dirtyT=1;
d.matrix=bU
}}d.matrix=bU;
b0.sx=bT;
b0.sy=bS;
b0.deg=bP;
b0.dx=bN=bU.e;
b0.dy=bM=bU.f;
if(bT==1&&bS==1&&!bP&&b0.bbox){b0.bbox.x+=+bN;
b0.bbox.y+=+bM
}else{b0.dirtyT=1
}},l=function(d){var b=d[0];
switch(b.toLowerCase()){case"t":return[b,0,0];
case"m":return[b,1,0,0,1,0,0];
case"r":if(d.length==4){return[b,0,d[2],d[3]]
}else{return[b,0]
}case"s":if(d.length==5){return[b,1,1,d[3],d[4]]
}else{if(d.length==3){return[b,1,1]
}else{return[b,1]
}}}},aB=aR._equaliseTransform=function(R,E){E=bH(E).replace(/\.{3}|\u2026/g,R);
R=aR.parseTransformString(R)||[];
E=aR.parseTransformString(E)||[];
var b=m(R.length,E.length),bN=[],bO=[],g=0,d,S,bM,bL;
for(;
g<b;
g++){bM=R[g]||l(E[g]);
bL=E[g]||l(bM);
if((bM[0]!=bL[0])||(bM[0].toLowerCase()=="r"&&(bM[2]!=bL[2]||bM[3]!=bL[3]))||(bM[0].toLowerCase()=="s"&&(bM[3]!=bL[3]||bM[4]!=bL[4]))){return
}bN[g]=[];
bO[g]=[];
for(d=0,S=m(bM.length,bL.length);
d<S;
d++){d in bM&&(bN[g][d]=bM[d]);
d in bL&&(bO[g][d]=bL[d])
}}return{from:bN,to:bO}
};
aR._getContainer=function(b,R,g,E){var d;
d=E==null&&!aR.is(b,"object")?aA.doc.getElementById(b):b;
if(d==null){return
}if(d.tagName){if(R==null){return{container:d,width:d.style.pixelWidth||d.offsetWidth,height:d.style.pixelHeight||d.offsetHeight}
}else{return{container:d,width:R,height:g}
}}return{container:1,x:b,y:R,width:g,height:E}
};
aR.pathToRelative=aC;
aR._engine={};
aR.path2curve=W;
aR.matrix=function(E,g,bM,bL,S,R){return new aF(E,g,bM,bL,S,R)
};
function aF(E,g,bM,bL,S,R){if(E!=null){this.a=+E;
this.b=+g;
this.c=+bM;
this.d=+bL;
this.e=+S;
this.f=+R
}else{this.a=1;
this.b=0;
this.c=0;
this.d=1;
this.e=0;
this.f=0
}}(function(g){g.add=function(bU,bR,bP,bN,bL,S){var R=[[],[],[]],E=[[this.a,this.c,this.e],[this.b,this.d,this.f],[0,0,1]],bT=[[bU,bP,bL],[bR,bN,S],[0,0,1]],bS,bQ,bO,bM;
if(bU&&bU instanceof aF){bT=[[bU.a,bU.c,bU.e],[bU.b,bU.d,bU.f],[0,0,1]]
}for(bS=0;
bS<3;
bS++){for(bQ=0;
bQ<3;
bQ++){bM=0;
for(bO=0;
bO<3;
bO++){bM+=E[bS][bO]*bT[bO][bQ]
}R[bS][bQ]=bM
}}this.a=R[0][0];
this.b=R[1][0];
this.c=R[0][1];
this.d=R[1][1];
this.e=R[0][2];
this.f=R[1][2]
};
g.invert=function(){var R=this,E=R.a*R.d-R.b*R.c;
return new aF(R.d/E,-R.b/E,-R.c/E,R.a/E,(R.c*R.f-R.d*R.e)/E,(R.b*R.e-R.a*R.f)/E)
};
g.clone=function(){return new aF(this.a,this.b,this.c,this.d,this.e,this.f)
};
g.translate=function(E,R){this.add(1,0,0,1,E,R)
};
g.scale=function(R,bL,E,S){bL==null&&(bL=R);
(E||S)&&this.add(1,0,0,1,E,S);
this.add(R,0,0,bL,0,0);
(E||S)&&this.add(1,0,0,1,-E,-S)
};
g.rotate=function(R,E,bM){R=aR.rad(R);
E=E||0;
bM=bM||0;
var bL=+au.cos(R).toFixed(9),S=+au.sin(R).toFixed(9);
this.add(bL,S,-S,bL,E,bM);
this.add(1,0,0,1,-E,-bM)
};
g.x=function(E,R){return E*this.a+R*this.c+this.e
};
g.y=function(E,R){return E*this.b+R*this.d+this.f
};
g.get=function(E){return +this[bH.fromCharCode(97+E)].toFixed(4)
};
g.toString=function(){return aR.svg?"matrix("+[this.get(0),this.get(1),this.get(2),this.get(3),this.get(4),this.get(5)].join()+")":[this.get(0),this.get(2),this.get(1),this.get(3),0,0].join()
};
g.toFilter=function(){return"progid:DXImageTransform.Microsoft.Matrix(M11="+this.get(0)+", M12="+this.get(2)+", M21="+this.get(1)+", M22="+this.get(3)+", Dx="+this.get(4)+", Dy="+this.get(5)+", sizingmethod='auto expand')"
};
g.offset=function(){return[this.e.toFixed(4),this.f.toFixed(4)]
};
function d(E){return E[0]*E[0]+E[1]*E[1]
}function b(E){var R=au.sqrt(d(E));
E[0]&&(E[0]/=R);
E[1]&&(E[1]/=R)
}g.split=function(){var R={};
R.dx=this.e;
R.dy=this.f;
var bL=[[this.a,this.c],[this.b,this.d]];
R.scalex=au.sqrt(d(bL[0]));
b(bL[0]);
R.shear=bL[0][0]*bL[1][0]+bL[0][1]*bL[1][1];
bL[1]=[bL[1][0]-bL[0][0]*R.shear,bL[1][1]-bL[0][1]*R.shear];
R.scaley=au.sqrt(d(bL[1]));
b(bL[1]);
R.shear/=R.scaley;
var E=-bL[0][1],S=bL[1][1];
if(S<0){R.rotate=aR.deg(au.acos(S));
if(E<0){R.rotate=360-R.rotate
}}else{R.rotate=aR.deg(au.asin(E))
}R.isSimple=!+R.shear.toFixed(9)&&(R.scalex.toFixed(9)==R.scaley.toFixed(9)||!R.rotate);
R.isSuperSimple=!+R.shear.toFixed(9)&&R.scalex.toFixed(9)==R.scaley.toFixed(9)&&!R.rotate;
R.noRotation=!+R.shear.toFixed(9)&&!R.rotate;
return R
};
g.toTransformString=function(E){var R=E||this[F]();
if(R.isSimple){R.scalex=+R.scalex.toFixed(4);
R.scaley=+R.scaley.toFixed(4);
R.rotate=+R.rotate.toFixed(4);
return(R.dx||R.dy?"t"+[R.dx,R.dy]:aX)+(R.scalex!=1||R.scaley!=1?"s"+[R.scalex,R.scaley,0,0]:aX)+(R.rotate?"r"+[R.rotate,0,0]:aX)
}else{return"m"+[this.get(0),this.get(1),this.get(2),this.get(3),this.get(4),this.get(5)]
}}
})(aF.prototype);
var V=navigator.userAgent.match(/Version\/(.*?)\s/)||navigator.userAgent.match(/Chrome\/(\d+)/);
if((navigator.vendor=="Apple Computer, Inc.")&&(V&&V[1]<4||navigator.platform.slice(0,2)=="iP")||(navigator.vendor=="Google Inc."&&V&&V[1]<8)){a4.safari=function(){var b=this.rect(-99,-99,this.width+99,this.height+99).attr({stroke:"none"});
setTimeout(function(){b.remove()
})
}
}else{a4.safari=I
}var P=function(){this.returnValue=false
},bD=function(){return this.originalEvent.preventDefault()
},a8=function(){this.cancelBubble=true
},aJ=function(){return this.originalEvent.stopPropagation()
},aD=(function(){if(aA.doc.addEventListener){return function(S,E,g,d){var b=Z&&bx[E]?bx[E]:E,R=function(bQ){var bP=aA.doc.documentElement.scrollTop||aA.doc.body.scrollTop,bR=aA.doc.documentElement.scrollLeft||aA.doc.body.scrollLeft,bL=bQ.clientX+bR,bS=bQ.clientY+bP;
if(Z&&bx[ak](E)){for(var bN=0,bO=bQ.targetTouches&&bQ.targetTouches.length;
bN<bO;
bN++){if(bQ.targetTouches[bN].target==S){var bM=bQ;
bQ=bQ.targetTouches[bN];
bQ.originalEvent=bM;
bQ.preventDefault=bD;
bQ.stopPropagation=aJ;
break
}}}return g.call(d,bQ,bL,bS)
};
S.addEventListener(b,R,false);
return function(){S.removeEventListener(b,R,false);
return true
}
}
}else{if(aA.doc.attachEvent){return function(S,E,g,d){var R=function(bN){bN=bN||aA.win.event;
var bM=aA.doc.documentElement.scrollTop||aA.doc.body.scrollTop,bO=aA.doc.documentElement.scrollLeft||aA.doc.body.scrollLeft,bL=bN.clientX+bO,bP=bN.clientY+bM;
bN.preventDefault=bN.preventDefault||P;
bN.stopPropagation=bN.stopPropagation||a8;
return g.call(d,bN,bL,bP)
};
S.attachEvent("on"+E,R);
var b=function(){S.detachEvent("on"+E,R);
return true
};
return b
}
}}})(),be=[],by=function(bM){var bP=bM.clientX,bO=bM.clientY,bR=aA.doc.documentElement.scrollTop||aA.doc.body.scrollTop,bS=aA.doc.documentElement.scrollLeft||aA.doc.body.scrollLeft,g,E=be.length;
while(E--){g=be[E];
if(Z){var S=bM.touches.length,R;
while(S--){R=bM.touches[S];
if(R.identifier==g.el._drag.id){bP=R.clientX;
bO=R.clientY;
(bM.originalEvent?bM.originalEvent:bM).preventDefault();
break
}}}else{bM.preventDefault()
}var d=g.el.node,b,bL=d.nextSibling,bQ=d.parentNode,bN=d.style.display;
aA.win.opera&&bQ.removeChild(d);
d.style.display="none";
b=g.el.paper.getElementByPoint(bP,bO);
d.style.display=bN;
aA.win.opera&&(bL?bQ.insertBefore(d,bL):bQ.appendChild(d));
b&&eve("raphael.drag.over."+g.el.id,g.el,b);
bP+=bS;
bO+=bR;
eve("raphael.drag.move."+g.el.id,g.move_scope||g.el,bP-g.el._drag.x,bO-g.el._drag.y,bP,bO,bM)
}},e=function(g){aR.unmousemove(by).unmouseup(e);
var d=be.length,b;
while(d--){b=be[d];
b.el._drag={};
eve("raphael.drag.end."+b.el.id,b.end_scope||b.start_scope||b.move_scope||b.el,g)
}be=[]
},bh=aR.el={};
for(var ax=Q.length;
ax--;
){(function(b){aR[b]=bh[b]=function(g,d){if(aR.is(g,"function")){this.events=this.events||[];
this.events.push({name:b,f:g,unbind:aD(this.shape||this.node||aA.doc,b,g,d||this)})
}return this
};
aR["un"+b]=bh["un"+b]=function(E){var g=this.events||[],d=g.length;
while(d--){if(g[d].name==b&&g[d].f==E){g[d].unbind();
g.splice(d,1);
!g.length&&delete this.events;
return this
}}return this
}
})(Q[ax])
}bh.data=function(d,E){var g=aU[this.id]=aU[this.id]||{};
if(arguments.length==1){if(aR.is(d,"object")){for(var b in d){if(d[ak](b)){this.data(b,d[b])
}}return this
}eve("raphael.data.get."+this.id,this,g[d],d);
return g[d]
}g[d]=E;
eve("raphael.data.set."+this.id,this,E,d);
return this
};
bh.removeData=function(b){if(b==null){aU[this.id]={}
}else{aU[this.id]&&delete aU[this.id][b]
}return this
};
bh.hover=function(E,b,g,d){return this.mouseover(E,g).mouseout(b,d||g)
};
bh.unhover=function(d,b){return this.unmouseover(d).unmouseout(b)
};
var bu=[];
bh.drag=function(d,S,R,b,g,E){function bL(bN){(bN.originalEvent||bN).preventDefault();
var bM=aA.doc.documentElement.scrollTop||aA.doc.body.scrollTop,bO=aA.doc.documentElement.scrollLeft||aA.doc.body.scrollLeft;
this._drag.x=bN.clientX+bO;
this._drag.y=bN.clientY+bM;
this._drag.id=bN.identifier;
!be.length&&aR.mousemove(by).mouseup(e);
be.push({el:this,move_scope:b,start_scope:g,end_scope:E});
S&&eve.on("raphael.drag.start."+this.id,S);
d&&eve.on("raphael.drag.move."+this.id,d);
R&&eve.on("raphael.drag.end."+this.id,R);
eve("raphael.drag.start."+this.id,g||b||this,bN.clientX+bO,bN.clientY+bM,bN)
}this._drag={};
bu.push({el:this,start:bL});
this.mousedown(bL);
return this
};
bh.onDragOver=function(b){b?eve.on("raphael.drag.over."+this.id,b):eve.unbind("raphael.drag.over."+this.id)
};
bh.undrag=function(){var b=bu.length;
while(b--){if(bu[b].el==this){this.unmousedown(bu[b].start);
bu.splice(b,1);
eve.unbind("raphael.drag.*."+this.id)
}}!bu.length&&aR.unmousemove(by).unmouseup(e)
};
a4.group=function(b,g){var d=aR._engine.group(this,b||0,g||0);
this.__set__&&this.__set__.push(d);
return d
};
a4.circle=function(b,E,g){var d=aR._engine.circle(this,b||0,E||0,g||0);
this.__set__&&this.__set__.push(d);
return d
};
a4.rect=function(b,S,d,E,R){var g=aR._engine.rect(this,b||0,S||0,d||0,E||0,R||0);
this.__set__&&this.__set__.push(g);
return g
};
a4.ellipse=function(b,R,E,g){var d=aR._engine.ellipse(this,b||0,R||0,E||0,g||0);
this.__set__&&this.__set__.push(d);
return d
};
a4.path=function(b){b&&!aR.is(b,aj)&&!aR.is(b[0],bd)&&(b+=aX);
var d=aR._engine.path(aR.format[bG](aR,arguments),this);
this.__set__&&this.__set__.push(d);
return d
};
a4.image=function(R,b,S,d,E){var g=aR._engine.image(this,R||"about:blank",b||0,S||0,d||0,E||0);
this.__set__&&this.__set__.push(g);
return g
};
a4.text=function(b,E,g){var d=aR._engine.text(this,b||0,E||0,bH(g));
this.__set__&&this.__set__.push(d);
return d
};
a4.foreignObject=function(R,b,S,d,E){var g=aR._engine.foreignObject(this,b||0,S||0,d||0,E||0,R);
this.__set__&&this.__set__.push(g);
return g
};
a4.set=function(d){!aR.is(d,"array")&&(d=Array.prototype.splice.call(arguments,0,arguments.length));
var b=new al(d);
this.__set__&&this.__set__.push(b);
return b
};
a4.setStart=function(b){this.__set__=b||this.set()
};
a4.setFinish=function(d){var b=this.__set__;
delete this.__set__;
return b
};
a4.setSize=function(d,b){return aR._engine.setSize.call(this,d,b)
};
a4.setViewBox=function(b,R,d,E,g){return aR._engine.setViewBox.call(this,b,R,d,E,g)
};
a4.top=a4.bottom=null;
a4.raphael=aR;
var bs=function(g){var R=g.getBoundingClientRect(),bN=g.ownerDocument,S=bN.body,b=bN.documentElement,E=b.clientTop||S.clientTop||0,bL=b.clientLeft||S.clientLeft||0,bM=R.top+(aA.win.pageYOffset||b.scrollTop||S.scrollTop)-E,d=R.left+(aA.win.pageXOffset||b.scrollLeft||S.scrollLeft)-bL;
return{y:bM,x:d}
};
a4.getElementByPoint=function(d,bM){var bL=this,g=bL.canvas,S=aA.doc.elementFromPoint(d,bM);
if(aA.win.opera&&S.tagName=="svg"){var R=bs(g),E=g.createSVGRect();
E.x=d-R.x;
E.y=bM-R.y;
E.width=E.height=1;
var b=g.getIntersectionList(E,null);
if(b.length){S=b[b.length-1]
}}if(!S){return null
}while(S.parentNode&&S!=g.parentNode&&!S.raphael){S=S.parentNode
}S==bL.canvas.parentNode&&(S=g);
S=S&&S.raphael?bL.getById(S.raphaelid):null;
return S
};
a4.getById=function(d){var b=this.bottom;
while(b){if(b.id==d){return b
}b=b.next
}return null
};
a4.forEach=function(g,b){var d=this.bottom;
while(d){if(g.call(b,d)===false){return this
}d=d.next
}return this
};
a4.getElementsByPoint=function(b,g){var d=this.set();
this.forEach(function(E){if(E.isPointInside(b,g)){d.push(E)
}});
return d
};
function y(){return this.x+aQ+this.y
}function at(){return this.x+aQ+this.y+aQ+this.width+" \xd7 "+this.height
}bh.isPointInside=function(b,g){var d=this.realPath=this.realPath||N[this.type](this);
return aR.isPointInsidePath(d,b,g)
};
bh.getBBox=function(d){if(this.removed){return{}
}var b=this._;
if(d){if(b.dirty||!b.bboxwt){this.realPath=N[this.type](this);
b.bboxwt=am(this.realPath);
b.bboxwt.toString=at;
b.dirty=0
}return b.bboxwt
}if(b.dirty||b.dirtyT||!b.bbox){if(b.dirty||!this.realPath){b.bboxwt=0;
this.realPath=N[this.type](this)
}b.bbox=am(L(this.realPath,this.matrix));
b.bbox.toString=at;
b.dirty=b.dirtyT=0
}return b.bbox
};
bh.clone=function(){if(this.removed){return null
}var b=this.paper[this.type]().attr(this.attr());
this.__set__&&this.__set__.push(b);
return b
};
bh.glow=function(bL){if(this.type=="text"){return null
}bL=bL||{};
var g={width:(bL.width||10)+(+this.attr("stroke-width")||1),fill:bL.fill||false,opacity:bL.opacity||0.5,offsetx:bL.offsetx||0,offsety:bL.offsety||0,color:bL.color||"#000"},S=g.width/2,E=this.paper,b=E.set(),R=this.realPath||N[this.type](this);
R=this.matrix?L(R,this.matrix):R;
for(var d=1;
d<S+1;
d++){b.push(E.path(R).attr({stroke:g.color,fill:g.fill?g.color:"none","stroke-linejoin":"round","stroke-linecap":"round","stroke-width":+(g.width/S*d).toFixed(3),opacity:+(g.opacity/S).toFixed(3)}))
}return b.insertBefore(this).translate(g.offsetx,g.offsety)
};
var a7={},k=function(d,b,R,E,bN,bM,bL,S,g){if(g==null){return q(d,b,R,E,bN,bM,bL,S)
}else{return aR.findDotsAtSegment(d,b,R,E,bN,bM,bL,S,C(d,b,R,E,bN,bM,bL,S,g))
}},a6=function(b,d){return function(bT,R,S){bT=W(bT);
var bP,bO,g,bL,E="",bS={},bQ,bN=0;
for(var bM=0,bR=bT.length;
bM<bR;
bM++){g=bT[bM];
if(g[0]=="M"){bP=+g[1];
bO=+g[2]
}else{bL=k(bP,bO,g[1],g[2],g[3],g[4],g[5],g[6]);
if(bN+bL>R){if(d&&!bS.start){bQ=k(bP,bO,g[1],g[2],g[3],g[4],g[5],g[6],R-bN);
E+=["C"+bQ.start.x,bQ.start.y,bQ.m.x,bQ.m.y,bQ.x,bQ.y];
if(S){return E
}bS.start=E;
E=["M"+bQ.x,bQ.y+"C"+bQ.n.x,bQ.n.y,bQ.end.x,bQ.end.y,g[5],g[6]].join();
bN+=bL;
bP=+g[5];
bO=+g[6];
continue
}if(!b&&!d){bQ=k(bP,bO,g[1],g[2],g[3],g[4],g[5],g[6],R-bN);
return{x:bQ.x,y:bQ.y,alpha:bQ.alpha}
}}bN+=bL;
bP=+g[5];
bO=+g[6]
}E+=g.shift()+g
}bS.end=E;
bQ=b?bN:d?bS:aR.findDotsAtSegment(bP,bO,g[0],g[1],g[2],g[3],g[4],g[5],1);
bQ.alpha&&(bQ={x:bQ.x,y:bQ.y,alpha:bQ.alpha});
return bQ
}
};
var aS=a6(1),J=a6(),ad=a6(0,1);
aR.getTotalLength=aS;
aR.getPointAtLength=J;
aR.getSubpath=function(d,E,g){if(this.getTotalLength(d)-g<0.000001){return ad(d,E).end
}var b=ad(d,g,1);
return E?ad(b,E).end:b
};
bh.getTotalLength=function(){if(this.type!="path"){return
}if(this.node.getTotalLength){return this.node.getTotalLength()
}return aS(this.attrs.path)
};
bh.getPointAtLength=function(b){if(this.type!="path"){return
}return J(this.attrs.path,b)
};
bh.getSubpath=function(d,b){if(this.type!="path"){return
}return aR.getSubpath(this.attrs.path,d,b)
};
var o=aR.easing_formulas={linear:function(b){return b
},"<":function(b){return bp(b,1.7)
},">":function(b){return bp(b,0.48)
},"<>":function(bM){var E=0.48-bM/1.04,g=au.sqrt(0.1734+E*E),b=g-E,bL=bp(aw(b),1/3)*(b<0?-1:1),S=-g-E,R=bp(aw(S),1/3)*(S<0?-1:1),d=bL+R+0.5;
return(1-d)*3*d*d+d*d*d
},backIn:function(d){var b=1.70158;
return d*d*((b+1)*d-b)
},backOut:function(d){d=d-1;
var b=1.70158;
return d*d*((b+1)*d+b)+1
},elastic:function(b){if(b==!!b){return b
}return bp(2,-10*b)*au.sin((b-0.075)*(2*aV)/0.3)+1
},bounce:function(E){var d=7.5625,g=2.75,b;
if(E<(1/g)){b=d*E*E
}else{if(E<(2/g)){E-=(1.5/g);
b=d*E*E+0.75
}else{if(E<(2.5/g)){E-=(2.25/g);
b=d*E*E+0.9375
}else{E-=(2.625/g);
b=d*E*E+0.984375
}}}return b
}};
o.easeIn=o["ease-in"]=o["<"];
o.easeOut=o["ease-out"]=o[">"];
o.easeInOut=o["ease-in-out"]=o["<>"];
o["back-in"]=o.backIn;
o["back-out"]=o.backOut;
var ab=[],aN=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(b){setTimeout(b,16)
},bC=function(){var bL=+new Date,bT=0;
for(;
bT<ab.length;
bT++){var bZ=ab[bT];
if(bZ.el.removed||bZ.paused){continue
}var E=bL-bZ.start,bR=bZ.ms,bQ=bZ.easing,bU=bZ.from,bO=bZ.diff,d=bZ.to,bN=bZ.t,S=bZ.el,bP={},b,bX={},b1;
if(bZ.initstatus){E=(bZ.initstatus*bZ.anim.top-bZ.prev)/(bZ.percent-bZ.prev)*bR;
bZ.status=bZ.initstatus;
delete bZ.initstatus;
bZ.stop&&ab.splice(bT--,1)
}else{bZ.status=(bZ.prev+(bZ.percent-bZ.prev)*(E/bR))/bZ.anim.top
}if(E<0){continue
}if(E<bR){var g=bQ(E/bR);
for(var bS in bU){if(bU[ak](bS)){switch(ar[bS]){case aL:b=+bU[bS]+g*bR*bO[bS];
break;
case"colour":b="rgb("+[H(ah(bU[bS].r+g*bR*bO[bS].r)),H(ah(bU[bS].g+g*bR*bO[bS].g)),H(ah(bU[bS].b+g*bR*bO[bS].b))].join(",")+")";
break;
case"path":b=[];
for(var bW=0,bM=bU[bS].length;
bW<bM;
bW++){b[bW]=[bU[bS][bW][0]];
for(var bV=1,bY=bU[bS][bW].length;
bV<bY;
bV++){b[bW][bV]=+bU[bS][bW][bV]+g*bR*bO[bS][bW][bV]
}b[bW]=b[bW].join(aQ)
}b=b.join(aQ);
break;
case"transform":if(bO[bS].real){b=[];
for(bW=0,bM=bU[bS].length;
bW<bM;
bW++){b[bW]=[bU[bS][bW][0]];
for(bV=1,bY=bU[bS][bW].length;
bV<bY;
bV++){b[bW][bV]=bU[bS][bW][bV]+g*bR*bO[bS][bW][bV]
}}}else{var b0=function(b2){return +bU[bS][b2]+g*bR*bO[bS][b2]
};
b=[["m",b0(0),b0(1),b0(2),b0(3),b0(4),b0(5)]]
}break;
case"csv":if(bS=="clip-rect"){b=[];
bW=4;
while(bW--){b[bW]=+bU[bS][bW]+g*bR*bO[bS][bW]
}}break;
default:var R=[][bE](bU[bS]);
b=[];
bW=S.paper.customAttributes[bS].length;
while(bW--){b[bW]=+R[bW]+g*bR*bO[bS][bW]
}break
}bP[bS]=b
}}S.attr(bP);
(function(b4,b2,b3){setTimeout(function(){eve("raphael.anim.frame."+b4,b2,b3)
})
})(S.id,S,bZ.anim)
}else{(function(b4,b3,b2){setTimeout(function(){eve("raphael.anim.frame."+b3.id,b3,b2);
eve("raphael.anim.finish."+b3.id,b3,b2);
aR.is(b4,"function")&&b4.call(b3)
})
})(bZ.callback,S,bZ.anim);
S.attr(d);
ab.splice(bT--,1);
if(bZ.repeat>1&&!bZ.next){for(b1 in d){if(d[ak](b1)){bX[b1]=bZ.totalOrigin[b1]
}}bZ.el.attr(bX);
aM(bZ.anim,bZ.el,bZ.anim.percents[0],null,bZ.totalOrigin,bZ.repeat-1)
}if(bZ.next&&!bZ.stop){aM(bZ.anim,bZ.el,bZ.next,null,bZ.totalOrigin,bZ.repeat)
}}}aR.svg&&S&&S.paper&&S.paper.safari();
ab.length&&aN(bC)
},H=function(b){return b>255?255:b<0?0:b
};
bh.animateWith=function(d,E,g,b,bL,bQ){var S=this;
if(S.removed){bQ&&bQ.call(S);
return S
}var bO=g instanceof bA?g:aR.animation(g,b,bL,bQ),bN,bM;
aM(bO,S,bO.percents[0],null,S.attr());
for(var R=0,bP=ab.length;
R<bP;
R++){if(ab[R].anim==E&&ab[R].el==d){ab[bP-1].start=ab[R].start;
break
}}return S
};
function a3(bS,E,d,bR,bQ,bM){var bN=3*E,bP=3*(bR-E)-bN,b=1-bN-bP,bL=3*d,bO=3*(bQ-d)-bL,bT=1-bL-bO;
function S(bU){return((b*bU+bP)*bU+bN)*bU
}function g(bU,bW){var bV=R(bU,bW);
return((bT*bV+bO)*bV+bL)*bV
}function R(bU,b1){var b0,bZ,bX,bV,bY,bW;
for(bX=bU,bW=0;
bW<8;
bW++){bV=S(bX)-bU;
if(aw(bV)<b1){return bX
}bY=(3*b*bX+2*bP)*bX+bN;
if(aw(bY)<0.000001){break
}bX=bX-bV/bY
}b0=0;
bZ=1;
bX=bU;
if(bX<b0){return b0
}if(bX>bZ){return bZ
}while(b0<bZ){bV=S(bX);
if(aw(bV-bU)<b1){return bX
}if(bU>bV){b0=bX
}else{bZ=bX
}bX=(bZ-b0)/2+b0
}return bX
}return g(bS,1/(200*bM))
}bh.onAnimation=function(b){b?eve.on("raphael.anim.frame."+this.id,b):eve.unbind("raphael.anim.frame."+this.id);
return this
};
function bA(R,g){var d=[],E={};
this.ms=g;
this.times=1;
if(R){for(var b in R){if(R[ak](b)){E[an(b)]=R[b];
d.push(an(b))
}}d.sort(u)
}this.anim=E;
this.top=d[d.length-1];
this.percents=d
}bA.prototype.delay=function(d){var b=new bA(this.anim,this.ms);
b.times=this.times;
b.del=+d||0;
return b
};
bA.prototype.repeat=function(d){var b=new bA(this.anim,this.ms);
b.del=this.del;
b.times=au.floor(m(d,0))||1;
return b
};
function aM(b3,g,b,b1,bL,bP){b=an(b);
var ca,S,bO,cb=[],bV,bU,R,bX=b3.ms,b2={},E={},bR={};
if(b1){for(b6=0,bQ=ab.length;
b6<bQ;
b6++){var b8=ab[b6];
if(b8.el.id==g.id&&b8.anim==b3){if(b8.percent!=b){ab.splice(b6,1);
bO=1
}else{S=b8
}g.attr(b8.totalOrigin);
break
}}}else{b1=+E
}for(var b6=0,bQ=b3.percents.length;
b6<bQ;
b6++){if(b3.percents[b6]==b||b3.percents[b6]>b1*b3.top){b=b3.percents[b6];
bU=b3.percents[b6-1]||0;
bX=bX/b3.top*(b-bU);
bV=b3.percents[b6+1];
ca=b3.anim[b];
break
}else{if(b1){g.attr(b3.anim[b3.percents[b6]])
}}}if(!ca){return
}if(!S){for(var bZ in ca){if(ca[ak](bZ)){if(ar[ak](bZ)||g.paper.customAttributes[ak](bZ)){b2[bZ]=g.attr(bZ);
(b2[bZ]==null)&&(b2[bZ]=r[bZ]);
E[bZ]=ca[bZ];
switch(ar[bZ]){case aL:bR[bZ]=(E[bZ]-b2[bZ])/bX;
break;
case"colour":b2[bZ]=aR.getRGB(b2[bZ]);
var b0=aR.getRGB(E[bZ]);
bR[bZ]={r:(b0.r-b2[bZ].r)/bX,g:(b0.g-b2[bZ].g)/bX,b:(b0.b-b2[bZ].b)/bX};
break;
case"path":var bM=W(b2[bZ],E[bZ]),bT=bM[1];
b2[bZ]=bM[0];
bR[bZ]=[];
for(b6=0,bQ=b2[bZ].length;
b6<bQ;
b6++){bR[bZ][b6]=[0];
for(var b5=1,b7=b2[bZ][b6].length;
b5<b7;
b5++){bR[bZ][b6][b5]=(bT[b6][b5]-b2[bZ][b6][b5])/bX
}}break;
case"transform":var cd=g._,cc=aB(cd[bZ],E[bZ]);
if(cc){b2[bZ]=cc.from;
E[bZ]=cc.to;
bR[bZ]=[];
bR[bZ].real=true;
for(b6=0,bQ=b2[bZ].length;
b6<bQ;
b6++){bR[bZ][b6]=[b2[bZ][b6][0]];
for(b5=1,b7=b2[bZ][b6].length;
b5<b7;
b5++){bR[bZ][b6][b5]=(E[bZ][b6][b5]-b2[bZ][b6][b5])/bX
}}}else{var bY=(g.matrix||new aF),b9={_:{transform:cd.transform},getBBox:function(){return g.getBBox(1)
}};
b2[bZ]=[bY.a,bY.b,bY.c,bY.d,bY.e,bY.f];
aO(b9,E[bZ]);
E[bZ]=b9._.transform;
bR[bZ]=[(b9.matrix.a-bY.a)/bX,(b9.matrix.b-bY.b)/bX,(b9.matrix.c-bY.c)/bX,(b9.matrix.d-bY.d)/bX,(b9.matrix.e-bY.e)/bX,(b9.matrix.f-bY.f)/bX]
}break;
case"csv":var d=bH(ca[bZ])[F](a),bN=bH(b2[bZ])[F](a);
if(bZ=="clip-rect"){b2[bZ]=bN;
bR[bZ]=[];
b6=bN.length;
while(b6--){bR[bZ][b6]=(d[b6]-b2[bZ][b6])/bX
}}E[bZ]=d;
break;
default:d=[][bE](ca[bZ]);
bN=[][bE](b2[bZ]);
bR[bZ]=[];
b6=g.paper.customAttributes[bZ].length;
while(b6--){bR[bZ][b6]=((d[b6]||0)-(bN[b6]||0))/bX
}break
}}}}var bW=ca.easing,b4=aR.easing_formulas[bW];
if(!b4){b4=bH(bW).match(c);
if(b4&&b4.length==5){var bS=b4;
b4=function(ce){return a3(ce,+bS[1],+bS[2],+bS[3],+bS[4],bX)
}
}else{b4=bB
}}R=ca.start||b3.start||+new Date;
b8={anim:b3,percent:b,timestamp:R,start:R+(b3.del||0),status:0,initstatus:b1||0,stop:false,ms:bX,easing:b4,from:b2,diff:bR,to:E,el:g,callback:ca.callback,prev:bU,next:bV,repeat:bP||b3.times,origin:g.attr(),totalOrigin:bL};
ab.push(b8);
if(b1&&!S&&!bO){b8.stop=true;
b8.start=new Date-bX*b1;
if(ab.length==1){return bC()
}}if(bO){b8.start=new Date-b8.ms*b1
}ab.length==1&&aN(bC)
}else{S.initstatus=b1;
S.start=new Date-S.ms*b1
}eve("raphael.anim.start."+g.id,g,b3)
}aR.animation=function(R,d,bL,S){if(R instanceof bA){return R
}if(aR.is(bL,"function")||!bL){S=S||bL||null;
bL=null
}R=Object(R);
d=+d||0;
var E={},g,b;
for(b in R){if(R[ak](b)&&an(b)!=b&&an(b)+"%"!=b){g=true;
E[b]=R[b]
}}if(!g){return new bA(R,d)
}else{bL&&(E.easing=bL);
S&&(E.callback=S);
return new bA({100:E},d)
}};
bh.animate=function(E,b,S,R){var d=this;
if(d.removed){R&&R.call(d);
return d
}var g=E instanceof bA?E:aR.animation(E,b,S,R);
aM(g,d,g.percents[0],null,d.attr());
return d
};
bh.setTime=function(d,b){if(d&&b!=null){this.status(d,bm(b,d.ms)/d.ms)
}return this
};
bh.status=function(R,E){var d=[],g=0,b,S;
if(E!=null){aM(R,this,-1,bm(E,1));
return this
}else{b=ab.length;
for(;
g<b;
g++){S=ab[g];
if(S.el.id==this.id&&(!R||S.anim==R)){if(R){return S.status
}d.push({anim:S.anim,status:S.status})
}}if(R){return 0
}return d
}};
bh.pause=function(d){for(var b=0;
b<ab.length;
b++){if(ab[b].el.id==this.id&&(!d||ab[b].anim==d)){if(eve("raphael.anim.pause."+this.id,this,ab[b].anim)!==false){ab[b].paused=true
}}}return this
};
bh.resume=function(d){for(var b=0;
b<ab.length;
b++){if(ab[b].el.id==this.id&&(!d||ab[b].anim==d)){var g=ab[b];
if(eve("raphael.anim.resume."+this.id,this,g.anim)!==false){delete g.paused;
this.status(g.anim,g.status)
}}}return this
};
bh.stop=function(d){for(var b=0;
b<ab.length;
b++){if(ab[b].el.id==this.id&&(!d||ab[b].anim==d)){if(eve("raphael.anim.stop."+this.id,this,ab[b].anim)!==false){ab.splice(b--,1)
}}}return this
};
function aa(d){for(var b=0;
b<ab.length;
b++){if(ab[b].el.paper==d){ab.splice(b--,1)
}}}eve.on("raphael.remove",aa);
eve.on("raphael.clear",aa);
bh.toString=function(){return"Rapha\xebl\u2019s object"
};
var al=function(b){this.items=[];
this.length=0;
this.type="set";
if(b){for(var d=0,g=b.length;
d<g;
d++){if(b[d]&&(b[d].constructor==bh.constructor||b[d].constructor==al)){this[this.items.length]=this.items[this.items.length]=b[d];
this.length++
}}}},bc=al.prototype;
bc.push=function(){var E,b;
for(var d=0,g=arguments.length;
d<g;
d++){E=arguments[d];
if(E&&(E.constructor==bh.constructor||E.constructor==al)){b=this.items.length;
this[b]=this.items[b]=E;
this.length++
}}return this
};
bc.pop=function(){this.length&&delete this[this.length--];
return this.items.pop()
};
bc.forEach=function(E,b){for(var d=0,g=this.items.length;
d<g;
d++){if(E.call(b,this.items[d],d)===false){return this
}}return this
};
for(var B in bh){if(bh[ak](B)){bc[B]=(function(b){return function(){var d=arguments;
return this.forEach(function(g){g[b][bG](g,d)
})
}
})(B)
}}bc.attr=function(d,S){if(d&&aR.is(d,bd)&&aR.is(d[0],"object")){for(var b=0,R=d.length;
b<R;
b++){this.items[b].attr(d[b])
}}else{for(var g=0,E=this.items.length;
g<E;
g++){this.items[g].attr(d,S)
}}return this
};
bc.clear=function(){while(this.length){this.pop()
}};
bc.splice=function(E,bL,bM){E=E<0?m(this.length+E,0):E;
bL=m(0,bm(this.length-E,bL));
var g=[],b=[],d=[],R;
for(R=2;
R<arguments.length;
R++){d.push(arguments[R])
}for(R=0;
R<bL;
R++){b.push(this[E+R])
}for(;
R<this.length-E;
R++){g.push(this[E+R])
}var S=d.length;
for(R=0;
R<S+g.length;
R++){this.items[E+R]=this[E+R]=R<S?d[R]:g[R-S]
}R=this.items.length=this.length-=bL-S;
while(this[R]){delete this[R++]
}return new al(b)
};
bc.exclude=function(g){for(var b=0,d=this.length;
b<d;
b++){if(this[b]==g){this.splice(b,1);
return true
}}};
bc.animate=function(g,b,bL,bN){(aR.is(bL,"function")||!bL)&&(bN=bL||null);
var S=this.items.length,E=S,bO,bM=this,R;
if(!S){return this
}bN&&(R=function(){!--S&&bN.call(bM)
});
bL=aR.is(bL,aj)?bL:R;
var d=aR.animation(g,b,bL,R);
bO=this.items[--E].animate(d);
while(E--){this.items[E]&&!this.items[E].removed&&this.items[E].animateWith(bO,d,d)
}return this
};
bc.insertAfter=function(d){var b=this.items.length;
while(b--){this.items[b].insertAfter(d)
}return this
};
bc.getBBox=function(){var b=[],S=[],d=[],E=[];
for(var g=this.items.length;
g--;
){if(!this.items[g].removed){var R=this.items[g].getBBox();
b.push(R.x);
S.push(R.y);
d.push(R.x+R.width);
E.push(R.y+R.height)
}}b=bm[bG](0,b);
S=bm[bG](0,S);
d=m[bG](0,d);
E=m[bG](0,E);
return{x:b,y:S,x2:d,y2:E,width:d-b,height:E-S}
};
bc.clone=function(g){g=new al;
for(var b=0,d=this.items.length;
b<d;
b++){g.push(this.items[b].clone())
}return g
};
bc.toString=function(){return"Rapha\xebl\u2018s set"
};
aR.registerFont=function(d){if(!d.face){return d
}this.fonts=this.fonts||{};
var E={w:d.w,face:{},glyphs:{}},g=d.face["font-family"];
for(var bL in d.face){if(d.face[ak](bL)){E.face[bL]=d.face[bL]
}}if(this.fonts[g]){this.fonts[g].push(E)
}else{this.fonts[g]=[E]
}if(!d.svg){E.face["units-per-em"]=U(d.face["units-per-em"],10);
for(var R in d.glyphs){if(d.glyphs[ak](R)){var S=d.glyphs[R];
E.glyphs[R]={w:S.w,k:{},d:S.d&&"M"+S.d.replace(/[mlcxtrv]/g,function(bM){return{l:"L",c:"C",x:"z",t:"m",r:"l",v:"c"}[bM]||"M"
})+"z"};
if(S.k){for(var b in S.k){if(S[ak](b)){E.glyphs[R].k[b]=S.k[b]
}}}}}}return d
};
a4.getFont=function(bM,bN,d,E){E=E||"normal";
d=d||"normal";
bN=+bN||{normal:400,bold:700,lighter:300,bolder:800}[bN]||400;
if(!aR.fonts){return
}var R=aR.fonts[bM];
if(!R){var g=new RegExp("(^|\\s)"+bM.replace(/[^\w\d\s+!~.:_-]/g,aX)+"(\\s|$)","i");
for(var b in aR.fonts){if(aR.fonts[ak](b)){if(g.test(b)){R=aR.fonts[b];
break
}}}}var S;
if(R){for(var bL=0,bO=R.length;
bL<bO;
bL++){S=R[bL];
if(S.face["font-weight"]==bN&&(S.face["font-style"]==d||!S.face["font-style"])&&S.face["font-stretch"]==E){break
}}}return S
};
a4.print=function(bL,S,b,bO,bP,bY,d){bY=bY||"middle";
d=m(bm(d||0,1),-1);
var bX=bH(b)[F](aX),bU=0,bW=0,bS=aX,bZ;
aR.is(bO,b)&&(bO=this.getFont(bO));
if(bO){bZ=(bP||16)/bO.face["units-per-em"];
var E=bO.face.bbox[F](a),bN=+E[0],g=E[3]-E[1],R=0,bQ=+E[1]+(bY=="baseline"?g+(+bO.face.descent):g/2);
for(var bT=0,bM=bX.length;
bT<bM;
bT++){if(bX[bT]=="\n"){bU=0;
bV=0;
bW=0;
R+=g
}else{var bR=bW&&bO.glyphs[bX[bT-1]]||{},bV=bO.glyphs[bX[bT]];
bU+=bW?(bR.w||bO.w)+(bR.k&&bR.k[bX[bT]]||0)+(bO.w*d):0;
bW=1
}if(bV&&bV.d){bS+=aR.transformPath(bV.d,["t",bU*bZ,R*bZ,"s",bZ,bZ,bN,bQ,"t",(bL-bN)/bZ,(S-bQ)/bZ])
}}}return this.path(bS).attr({fill:"#000",stroke:"none"})
};
a4.add=function(E){if(aR.is(E,"array")){var g=this.set(),d=0,R=E.length,b;
for(;
d<R;
d++){b=E[d]||{};
bw[ak](b.type)&&g.push(this[b.type]().attr(b))
}}return g
};
aR.format=function(d,g){var b=aR.is(g,bd)?[0][bE](g):arguments;
d&&aR.is(d,aj)&&b.length-1&&(d=d.replace(br,function(R,E){return b[++E]==null?aX:b[E]
}));
return d||aX
};
aR.fullfill=(function(){var g=/\{([^\}]+)\}/g,b=/(?:(?:^|\.)(.+?)(?=\[|\.|$|\()|\[('|")(.+?)\2\])(\(\))?/g,d=function(S,R,bL){var E=bL;
R.replace(b,function(bO,bN,bM,bQ,bP){bN=bN||bQ;
if(E){if(bN in E){E=E[bN]
}typeof E=="function"&&bP&&(E=E())
}});
E=(E==null||E==bL?S:E)+"";
return E
};
return function(R,E){return String(R).replace(g,function(bL,S){return d(bL,S,E)
})
}
})();
aR.ninja=function(){s.was?(aA.win.Raphael=s.is):delete Raphael;
return aR
};
aR.st=bc;
(function(E,d,g){if(E.readyState==null&&E.addEventListener){E.addEventListener(d,g=function(){E.removeEventListener(d,g,false);
E.readyState="complete"
},false);
E.readyState="loading"
}function b(){(/in/).test(E.readyState)?setTimeout(b,9):aR.eve("raphael.DOMload")
}b()
})(document,"DOMContentLoaded");
s.was?(aA.win.Raphael=aR):(Raphael=aR);
eve.on("raphael.DOMload",function(){ao=true
})
})();
window.Raphael.svg&&function(m){var d="hasOwnProperty",C=String,o=parseFloat,r=parseInt,f=Math,D=f.max,t=f.abs,h=f.pow,g=/[, ]+/,A=m.eve,s="",k=" ";
var p="http://www.w3.org/1999/xlink",z={block:"M5,0 0,2.5 5,5z",open_block:"M5,0 0,2.5 5,5z",classic:"M5,0 0,2.5 5,5 3.5,3 3.5,2z",diamond:"M2.5,0 5,2.5 2.5,5 0,2.5z",open_diamond:"M2.5,0 5,2.5 2.5,5 0,2.5z",open:"M6,1 1,3.5 6,6",oval:"M2.5,0A2.5,2.5,0,0,1,2.5,5 2.5,2.5,0,0,1,2.5,0z",open_oval:"M2.5,0A2.5,2.5,0,0,1,2.5,5 2.5,2.5,0,0,1,2.5,0z"},v={};
m.toString=function(){return"Your browser supports SVG.\nYou are running Rapha\xebl "+this.version
};
var j=function(G,E){if(E){if(typeof G=="string"){G=j(G)
}for(var F in E){if(E[d](F)){if(F.substring(0,6)=="xlink:"){G.setAttributeNS(p,F.substring(6),C(E[F]))
}else{G.setAttribute(F,C(E[F]))
}}}}else{G=m._g.doc.createElementNS("http://www.w3.org/2000/svg",G);
G.style&&(G.style.webkitTapHighlightColor="rgba(0,0,0,0)")
}return G
},a=function(N,R){var P="linear",F=N.id+R,L=0.5,J=0.5,H=N.node,E=N.paper,T=H.style,G=m._g.doc.getElementById(F);
if(!G){R=C(R).replace(m._radial_gradient,function(W,U,X){P="radial";
if(U&&X){L=o(U);
J=o(X);
var V=((J>0.5)*2-1);
h(L-0.5,2)+h(J-0.5,2)>0.25&&(J=f.sqrt(0.25-h(L-0.5,2))*V+0.5)&&J!=0.5&&(J=J.toFixed(5)-0.00001*V)
}return s
});
R=R.split(/\s*\-\s*/);
if(P=="linear"){var K=R.shift();
K=-o(K);
if(isNaN(K)){return null
}var I=[0,0,f.cos(m.rad(K)),f.sin(m.rad(K))],Q=1/(D(t(I[2]),t(I[3]))||1);
I[2]*=Q;
I[3]*=Q;
if(I[2]<0){I[0]=-I[2];
I[2]=0
}if(I[3]<0){I[1]=-I[3];
I[3]=0
}}var O=m._parseDots(R);
if(!O){return null
}F=F.replace(/[\(\)\s,\xb0#]/g,"_");
if(N.gradient&&F!=N.gradient.id){E.defs.removeChild(N.gradient);
delete N.gradient
}if(!N.gradient){G=j(P+"Gradient",{id:F});
N.gradient=G;
j(G,P=="radial"?{fx:L,fy:J}:{x1:I[0],y1:I[1],x2:I[2],y2:I[3],gradientTransform:N.matrix.invert()});
E.defs.appendChild(G);
for(var M=0,S=O.length;
M<S;
M++){G.appendChild(j("stop",{offset:O[M].offset?O[M].offset:M?"100%":"0%","stop-color":O[M].color||"#fff"}))
}}}j(H,{fill:"url(#"+F+")",opacity:1,"fill-opacity":1});
T.fill=s;
T.opacity=1;
T.fillOpacity=1;
return 1
},b=function(F){var E=F.getBBox(1);
j(F.pattern,{patternTransform:F.matrix.invert()+" translate("+E.x+","+E.y+")"})
},c=function(P,R,K){if(P.type=="path"){var E=C(R).toLowerCase().split("-"),O=P.paper,ad=K?"end":"start",T=P.node,Q=P.attrs,J=Q["stroke-width"],Y=E.length,H="classic",W,G,M,U,S,X=J/2,L=7,Z=7,N=5;
while(Y--){switch(E[Y]){case"block":case"open_block":case"classic":case"oval":case"open_oval":case"diamond":case"open_diamond":case"open":case"none":H=E[Y];
break;
case"wide":Z=10;
break;
case"narrow":Z=5;
break;
case"long":L=10;
break;
case"short":L=5;
break
}}if(H=="open"){L+=2;
Z+=2;
N+=2;
M=1;
U=K?L-2:1;
S={fill:"none",stroke:Q.stroke,"stroke-dasharray":0}
}else{if(H=="open_block"||H=="open_diamond"||H=="open_oval"){U=M=L/2;
S={fill:"white","fill-opacity":1,stroke:Q.stroke,"stroke-dasharray":0}
}else{U=M=L/2;
S={fill:Q.stroke,stroke:"none"}
}}if(P._.arrows){if(K){P._.arrows.endPath&&v[P._.arrows.endPath]--;
P._.arrows.endMarker&&v[P._.arrows.endMarker]--
}else{P._.arrows.startPath&&v[P._.arrows.startPath]--;
P._.arrows.startMarker&&v[P._.arrows.startMarker]--
}}else{P._.arrows={}
}if(H!="none"){var F="raphael-marker-"+H,ac="raphael-marker-"+ad+H+L+Z;
if(!m._g.doc.getElementById(F)){O.defs.appendChild(j(j("path"),{"stroke-linecap":"round",d:z[H],id:F}));
v[F]=1
}else{v[F]++
}var I=m._g.doc.getElementById(ac),V;
if(!I){I=j(j("marker"),{id:ac,markerHeight:Z,markerWidth:L,orient:"auto",refX:U,refY:Z/2});
V=j(j("use"),{"xlink:href":"#"+F,transform:(K?"rotate(180 "+L/2+" "+Z/2+") ":s)+"scale("+L/N+","+Z/N+")","stroke-width":(1/((L/N+Z/N)/2)).toFixed(4)});
I.appendChild(V);
O.defs.appendChild(I);
v[ac]=1
}else{v[ac]++;
V=I.getElementsByTagName("use")[0]
}j(V,S);
var ab=M;
if(K){W=P._.arrows.startdx*J||0;
G=m.getTotalLength(Q.path)-ab*J
}else{W=ab*J;
G=m.getTotalLength(Q.path)-(P._.arrows.enddx*J||0)
}S={};
S["marker-"+ad]="url(#"+ac+")";
if(G||W){S.d=Raphael.getSubpath(Q.path,W,G)
}j(T,S);
P._.arrows[ad+"Path"]=F;
P._.arrows[ad+"Marker"]=ac;
P._.arrows[ad+"dx"]=ab;
P._.arrows[ad+"Type"]=H;
P._.arrows[ad+"String"]=R
}else{if(K){W=P._.arrows.startdx*J||0;
G=m.getTotalLength(Q.path)-W
}else{W=0;
G=m.getTotalLength(Q.path)-(P._.arrows.enddx*J||0)
}P._.arrows[ad+"Path"]&&j(T,{d:Raphael.getSubpath(Q.path,W,G)});
delete P._.arrows[ad+"Path"];
delete P._.arrows[ad+"Marker"];
delete P._.arrows[ad+"dx"];
delete P._.arrows[ad+"Type"];
delete P._.arrows[ad+"String"]
}for(S in v){if(v[d](S)&&!v[S]){var aa=m._g.doc.getElementById(S);
aa&&aa.parentNode.removeChild(aa)
}}}},w={"":[0],none:[0],"-":[3,1],".":[1,1],"-.":[3,1,1,1],"-..":[3,1,1,1,1,1],". ":[1,3],"- ":[4,3],"--":[8,3],"- .":[4,3,1,3],"--.":[8,3,1,3],"--..":[8,3,1,3,1,3]},l=function(K,I,J){I=w[C(I).toLowerCase()];
if(I){var G=K.attrs["stroke-width"]||"1",E={round:G,square:G,butt:0}[K.attrs["stroke-linecap"]||J["stroke-linecap"]]||0,H=[],F=I.length;
while(F--){H[F]=I[F]*G+((F%2)?1:-1)*E
}j(K.node,{"stroke-dasharray":H.join(",")})
}},x=function(P,X){var T=P.node,Q=P.attrs,N,N=T.style.visibility;
T.style.visibility="hidden";
for(var S in X){if(X[d](S)){if(!m._availableAttrs[d](S)){continue
}var R=X[S];
Q[S]=R;
switch(S){case"blur":P.blur(R);
break;
case"href":case"title":case"target":var V=T.parentNode;
if(V.tagName.toLowerCase()!="a"){var I=j("a");
V.insertBefore(I,T);
I.appendChild(T);
V=I
}if(S=="target"){V.setAttributeNS(p,"show",R=="blank"?"new":R)
}else{V.setAttributeNS(p,S,R)
}break;
case"cursor":T.style.cursor=R;
break;
case"transform":P.transform(R);
break;
case"arrow-start":c(P,R);
break;
case"arrow-end":c(P,R,1);
break;
case"clip-rect":var F=C(R).split(g);
if(F.length==4){P.clip&&P.clip.parentNode.parentNode.removeChild(P.clip.parentNode);
var G=j("clipPath"),U=j("rect");
G.id=m.createUUID();
j(U,{x:F[0],y:F[1],width:F[2],height:F[3]});
G.appendChild(U);
P.paper.defs.appendChild(G);
j(T,{"clip-path":"url(#"+G.id+")"});
P.clip=U
}if(!R){var O=T.getAttribute("clip-path");
if(O){var W=m._g.doc.getElementById(O.replace(/(^url\(#|\)$)/g,s));
W&&W.parentNode.removeChild(W);
j(T,{"clip-path":s});
delete P.clip
}}break;
case"path":if(P.type=="path"){j(T,{d:R?Q.path=m._pathToAbsolute(R):"M0,0"});
P._.dirty=1;
if(P._.arrows){"startString" in P._.arrows&&c(P,P._.arrows.startString);
"endString" in P._.arrows&&c(P,P._.arrows.endString,1)
}}break;
case"width":T.setAttribute(S,R);
P._.dirty=1;
if(Q.fx){S="x";
R=Q.x
}else{break
}case"x":if(Q.fx){R=-Q.x-(Q.width||0)
}case"rx":if(S=="rx"&&P.type=="rect"){break
}case"cx":T.setAttribute(S,R);
P.pattern&&b(P);
P._.dirty=1;
break;
case"height":T.setAttribute(S,R);
P._.dirty=1;
if(Q.fy){S="y";
R=Q.y
}else{break
}case"y":if(Q.fy){R=-Q.y-(Q.height||0)
}case"ry":if(S=="ry"&&P.type=="rect"){break
}case"cy":T.setAttribute(S,R);
P.pattern&&b(P);
P._.dirty=1;
break;
case"r":if(P.type=="rect"){j(T,{rx:R,ry:R})
}else{T.setAttribute(S,R)
}P._.dirty=1;
break;
case"src":if(P.type=="image"){T.setAttributeNS(p,"href",R)
}break;
case"stroke-width":if(P._.sx!=1||P._.sy!=1){R/=D(t(P._.sx),t(P._.sy))||1
}if(P.paper._vbSize){R*=P.paper._vbSize
}T.setAttribute(S,R);
if(Q["stroke-dasharray"]){l(P,Q["stroke-dasharray"],X)
}if(P._.arrows){"startString" in P._.arrows&&c(P,P._.arrows.startString);
"endString" in P._.arrows&&c(P,P._.arrows.endString,1)
}break;
case"stroke-dasharray":l(P,R,X);
break;
case"fill":var J=C(R).match(m._ISURL);
if(J){G=j("pattern");
var M=j("image");
G.id=m.createUUID();
j(G,{x:0,y:0,patternUnits:"userSpaceOnUse",height:1,width:1});
j(M,{x:0,y:0,"xlink:href":J[1]});
G.appendChild(M);
(function(Y){m._preload(J[1],function(){var Z=this.offsetWidth,aa=this.offsetHeight;
j(Y,{width:Z,height:aa});
j(M,{width:Z,height:aa});
P.paper.safari()
})
})(G);
P.paper.defs.appendChild(G);
j(T,{fill:"url(#"+G.id+")"});
P.pattern=G;
P.pattern&&b(P);
break
}var H=m.getRGB(R);
if(!H.error){delete X.gradient;
delete Q.gradient;
!m.is(Q.opacity,"undefined")&&m.is(X.opacity,"undefined")&&j(T,{opacity:Q.opacity});
!m.is(Q["fill-opacity"],"undefined")&&m.is(X["fill-opacity"],"undefined")&&j(T,{"fill-opacity":Q["fill-opacity"]})
}else{if((P.type=="circle"||P.type=="ellipse"||C(R).charAt()!="r")&&a(P,R)){if("opacity" in Q||"fill-opacity" in Q){var E=m._g.doc.getElementById(T.getAttribute("fill").replace(/^url\(#|\)$/g,s));
if(E){var K=E.getElementsByTagName("stop");
j(K[K.length-1],{"stop-opacity":("opacity" in Q?Q.opacity:1)*("fill-opacity" in Q?Q["fill-opacity"]:1)})
}}Q.gradient=R;
Q.fill="none";
break
}}H[d]("opacity")&&j(T,{"fill-opacity":H.opacity>1?H.opacity/100:H.opacity});
case"stroke":H=m.getRGB(R);
T.setAttribute(S,H.hex);
S=="stroke"&&H[d]("opacity")&&j(T,{"stroke-opacity":H.opacity>1?H.opacity/100:H.opacity});
if(S=="stroke"&&P._.arrows){"startString" in P._.arrows&&c(P,P._.arrows.startString);
"endString" in P._.arrows&&c(P,P._.arrows.endString,1)
}break;
case"gradient":(P.type=="circle"||P.type=="ellipse"||C(R).charAt()!="r")&&a(P,R);
break;
case"opacity":if(Q.gradient&&!Q[d]("stroke-opacity")){j(T,{"stroke-opacity":R>1?R/100:R})
}case"fill-opacity":if(Q.gradient){E=m._g.doc.getElementById(T.getAttribute("fill").replace(/^url\(#|\)$/g,s));
if(E){K=E.getElementsByTagName("stop");
j(K[K.length-1],{"stop-opacity":R})
}break
}case"shape-rendering":T.setAttribute(S,R);
break;
default:S=="font-size"&&(R=r(R,10)+"px");
var L=S.replace(/(\-.)/g,function(Y){return Y.substring(1).toUpperCase()
});
T.style[L]=R;
P._.dirty=1;
T.setAttribute(S,R);
break
}}}q(P,X);
T.style.visibility=N
},B=1.2,q=function(E,I){if(E.type!="text"||!(I[d]("text")||I[d]("font")||I[d]("font-size")||I[d]("x")||I[d]("y"))){return
}var N=E.attrs,G=E.node,P=G.firstChild?r(m._g.doc.defaultView.getComputedStyle(G.firstChild,s).getPropertyValue("font-size"),10):10;
if(I[d]("text")){N.text=I.text;
while(G.firstChild){G.removeChild(G.firstChild)
}var H=C(I.text).split("\n"),F=[],L;
for(var J=0,O=H.length;
J<O;
J++){L=j("tspan");
J&&j(L,{dy:P*B,x:N.x});
L.appendChild(m._g.doc.createTextNode(H[J]));
G.appendChild(L);
F[J]=L
}}else{F=G.getElementsByTagName("tspan");
for(J=0,O=F.length;
J<O;
J++){if(J){j(F[J],{dy:P*B,x:N.x})
}else{j(F[0],{dy:0})
}}}j(G,{x:N.x,y:N.y});
E._.dirty=1;
var K=E._getBBox(),M=N.y-(K.y+K.height/2);
M&&m.is(M,"finite")&&j(F[0],{dy:M})
},u=function(F,E){var H=0,G=0;
this[0]=this.node=F;
F.raphael=true;
this.id=m._oid++;
F.raphaelid=this.id;
this.matrix=m.matrix();
this.realPath=null;
this.paper=E;
this.attrs=this.attrs||{};
this._={transform:[],sx:1,sy:1,deg:0,dx:0,dy:0,dirty:1};
!E.bottom&&(E.bottom=this);
this.prev=E.top;
E.top&&(E.top.next=this);
E.top=this;
this.next=null
},n=m.el;
u.prototype=n;
n.constructor=u;
m._engine.path=function(E,H){var F=j("path");
H.canvas&&H.canvas.appendChild(F);
var G=new u(F,H);
G.type="path";
x(G,{fill:"none",stroke:"#000",path:E});
return G
};
n.rotate=function(F,E,H){if(this.removed){return this
}F=C(F).split(g);
if(F.length-1){E=o(F[1]);
H=o(F[2])
}F=o(F[0]);
(H==null)&&(E=H);
if(E==null||H==null){var G=this.getBBox(1);
E=G.x+G.width/2;
H=G.y+G.height/2
}this.transform(this._.transform.concat([["r",F,E,H]]));
return this
};
n.scale=function(I,G,E,H){if(this.removed){return this
}I=C(I).split(g);
if(I.length-1){G=o(I[1]);
E=o(I[2]);
H=o(I[3])
}I=o(I[0]);
(G==null)&&(G=I);
(H==null)&&(E=H);
if(E==null||H==null){var F=this.getBBox(1)
}E=E==null?F.x+F.width/2:E;
H=H==null?F.y+F.height/2:H;
this.transform(this._.transform.concat([["s",I,G,E,H]]));
return this
};
n.translate=function(F,E){if(this.removed){return this
}F=C(F).split(g);
if(F.length-1){E=o(F[1])
}F=o(F[0])||0;
E=+E||0;
this.transform(this._.transform.concat([["t",F,E]]));
return this
};
n.transform=function(F){var G=this._;
if(F==null){return G.transform
}m._extractTransform(this,F);
this.clip&&j(this.clip,{transform:this.matrix.invert()});
this.pattern&&b(this);
this.node&&j(this.node,{transform:this.matrix});
if(G.sx!=1||G.sy!=1){var E=this.attrs[d]("stroke-width")?this.attrs["stroke-width"]:1;
this.attr({"stroke-width":E})
}return this
};
n.hide=function(){!this.removed&&this.paper.safari(this.node.style.display="none");
return this
};
n.show=function(){!this.removed&&this.paper.safari(this.node.style.display="");
return this
};
n.remove=function(){if(this.removed||!this.node.parentNode){return
}var F=this.paper;
F.__set__&&F.__set__.exclude(this);
A.unbind("raphael.*.*."+this.id);
if(this.gradient){F.defs.removeChild(this.gradient)
}m._tear(this,F);
if(this.node.parentNode.tagName.toLowerCase()=="a"){this.node.parentNode.parentNode.removeChild(this.node.parentNode)
}else{this.node.parentNode.removeChild(this.node)
}for(var E in this){this[E]=typeof this[E]=="function"?m._removedFactory(E):null
}this.removed=true
};
n._getBBox=function(){if(this.node.style.display=="none"){this.show();
var E=true
}var G={};
try{G=this.node.getBBox()
}catch(F){}finally{G=G||{}
}E&&this.hide();
return G
};
n.attr=function(E,N){if(this.removed){return this
}if(E==null){var K={};
for(var M in this.attrs){if(this.attrs[d](M)){K[M]=this.attrs[M]
}}K.gradient&&K.fill=="none"&&(K.fill=K.gradient)&&delete K.gradient;
K.transform=this._.transform;
return K
}if(N==null&&m.is(E,"string")){if(E=="fill"&&this.attrs.fill=="none"&&this.attrs.gradient){return this.attrs.gradient
}if(E=="transform"){return this._.transform
}var L=E.split(g),H={};
for(var I=0,P=L.length;
I<P;
I++){E=L[I];
if(E in this.attrs){H[E]=this.attrs[E]
}else{if(m.is(this.paper.customAttributes[E],"function")){H[E]=this.paper.customAttributes[E].def
}else{H[E]=m._availableAttrs[E]
}}}return P-1?H:H[L[0]]
}if(N==null&&m.is(E,"array")){H={};
for(I=0,P=E.length;
I<P;
I++){H[E[I]]=this.attr(E[I])
}return H
}if(N!=null){var F={};
F[E]=N
}else{if(E!=null&&m.is(E,"object")){F=E
}}for(var O in F){A("raphael.attr."+O+"."+this.id,this,F[O])
}for(O in this.paper.customAttributes){if(this.paper.customAttributes[d](O)&&F[d](O)&&m.is(this.paper.customAttributes[O],"function")){var J=this.paper.customAttributes[O].apply(this,[].concat(F[O]));
this.attrs[O]=F[O];
for(var G in J){if(J[d](G)){F[G]=J[G]
}}}}x(this,F);
return this
};
n.toFront=function(){if(this.removed){return this
}if(this.node.parentNode.tagName.toLowerCase()=="a"){this.node.parentNode.parentNode.appendChild(this.node.parentNode)
}else{this.node.parentNode.appendChild(this.node)
}var E=this.paper;
E.top!=this&&m._tofront(this,E);
return this
};
n.toBack=function(){if(this.removed){return this
}var F=this.node.parentNode;
if(F.tagName.toLowerCase()=="a"){F.parentNode.insertBefore(this.node.parentNode,this.node.parentNode.parentNode.firstChild)
}else{if(F.firstChild!=this.node){F.insertBefore(this.node,this.node.parentNode.firstChild)
}}m._toback(this,this.paper);
var E=this.paper;
return this
};
n.appendChild=function(E){if(this.removed){return this
}if(this.type!=="group"){throw new TypeError("appendChild function supports only the group type!")
}var F=E.node||E[E.length-1].node;
this.node.appendChild(F);
return this
};
n.insertAfter=function(E){if(this.removed){return this
}var F=E.node||E[E.length-1].node;
if(F.nextSibling){F.parentNode.insertBefore(this.node,F.nextSibling)
}else{F.parentNode.appendChild(this.node)
}m._insertafter(this,E,this.paper);
return this
};
n.insertBefore=function(E){if(this.removed){return this
}var F=E.node||E[0].node;
F.parentNode.insertBefore(this.node,F);
m._insertbefore(this,E,this.paper);
return this
};
n.blur=function(F){var E=this;
if(+F!==0){var G=j("filter"),H=j("feGaussianBlur");
E.attrs.blur=F;
G.id=m.createUUID();
j(H,{stdDeviation:+F||1.5});
G.appendChild(H);
E.paper.defs.appendChild(G);
E._blur=G;
j(E.node,{filter:"url(#"+G.id+")"})
}else{if(E._blur){E._blur.parentNode.removeChild(E._blur);
delete E._blur;
delete E.attrs.blur
}E.node.removeAttribute("filter")
}};
m._engine.group=function(F,E,I){var H=j("g");
if(E&&I){H.setAttributeNS(null,"transform","translate("+E+", "+I+")")
}F.canvas&&F.canvas.appendChild(H);
var G=new u(H,F);
G.attrs={x:E,y:I,fill:"none",stroke:"#000"};
G.type="group";
j(H,G.attrs);
return G
};
m._engine.circle=function(F,E,J,I){var H=j("circle");
F.canvas&&F.canvas.appendChild(H);
var G=new u(H,F);
G.attrs={cx:E,cy:J,r:I,fill:"none",stroke:"#000"};
G.type="circle";
j(H,G.attrs);
return G
};
m._engine.rect=function(G,E,L,F,J,K){var I=j("rect");
G.canvas&&G.canvas.appendChild(I);
var H=new u(I,G);
H.attrs={x:E,y:L,width:F,height:J,r:K||0,rx:K||0,ry:K||0,fill:"none",stroke:"#000"};
H.type="rect";
j(I,H.attrs);
return H
};
m._engine.ellipse=function(F,E,K,J,I){var H=j("ellipse");
F.canvas&&F.canvas.appendChild(H);
var G=new u(H,F);
G.attrs={cx:E,cy:K,rx:J,ry:I,fill:"none",stroke:"#000"};
G.type="ellipse";
j(H,G.attrs);
return G
};
m._engine.image=function(G,K,E,L,F,J){var I=j("image");
j(I,{x:E,y:L,width:F,height:J,preserveAspectRatio:"none"});
I.setAttributeNS(p,"href",K);
G.canvas&&G.canvas.appendChild(I);
var H=new u(I,G);
H.attrs={x:E,y:L,width:F,height:J,src:K};
H.type="image";
return H
};
m._engine.text=function(F,E,J,I){var H=j("text");
F.canvas&&F.canvas.appendChild(H);
var G=new u(H,F);
G.attrs={x:E,y:J,"text-anchor":"middle",text:I,font:m._availableAttrs.font,stroke:"none",fill:"#000"};
G.type="text";
x(G,G.attrs);
return G
};
m._engine.foreignObject=function(I,L,K,M,H,G){if((typeof M)!=="number"){G=M;
M=G.offsetWidth;
H=G.offsetHeight
}var J;
if((/msie 9/).test(navigator.userAgent.toLowerCase())||document.documentMode===9){var F=j("div");
I.canvas&&I.canvas.appendChild(F);
J=new u(F,I);
J.attrs={x:L,y:K,width:M,height:H};
J.type="foreignObject";
j(F,J.attrs);
if(G){var E=document.createElement("div");
E.innerHTML=G;
J.node.appendChild(E)
}}else{var F=j("foreignObject");
I.canvas&&I.canvas.appendChild(F);
J=new u(F,I);
J.attrs={x:L,y:K,width:M,height:H};
J.type="foreignObject";
j(F,J.attrs);
if(G){var E=document.createElement("div");
E.innerHTML=G;
J.node.appendChild(E)
}}return J
};
m._engine.setSize=function(F,E){this.width=F||this.width;
this.height=E||this.height;
this.canvas.setAttribute("width",this.width);
this.canvas.setAttribute("height",this.height);
if(this._viewBox){this.setViewBox.apply(this,this._viewBox)
}return this
};
m._engine.create=function(){var H=m._getContainer.apply(0,arguments),F=H&&H.container,L=H.x,K=H.y,G=H.width,M=H.height;
if(!F){throw new Error("SVG container not found.")
}var E=j("svg"),J="overflow:hidden;",I;
L=L||0;
K=K||0;
G=G||512;
M=M||342;
j(E,{height:M,version:1.1,width:G,xmlns:"http://www.w3.org/2000/svg"});
if(F==1){E.style.cssText=J+"position:absolute;left:"+L+"px;top:"+K+"px";
m._g.doc.body.appendChild(E);
I=1
}else{E.style.cssText=J+"position:relative";
if(F.firstChild){F.insertBefore(E,F.firstChild)
}else{F.appendChild(E)
}}F=new m._Paper;
F.width=G;
F.height=M;
F.canvas=E;
F.clear();
F._left=F._top=0;
I&&(F.renderfix=function(){});
F.renderfix();
return F
};
m._engine.setViewBox=function(J,H,L,E,F){A("raphael.setViewBox",this,this._viewBox,[J,H,L,E,F]);
var N=D(L/this.width,E/this.height),I=this.top,M=F?"meet":"xMinYMin",G,K;
if(J==null){if(this._vbSize){N=1
}delete this._vbSize;
G="0 0 "+this.width+k+this.height
}else{this._vbSize=N;
G=J+k+H+k+L+k+E
}j(this.canvas,{viewBox:G,preserveAspectRatio:M});
while(N&&I){K="stroke-width" in I.attrs?I.attrs["stroke-width"]:1;
I.attr({"stroke-width":K});
I._.dirty=1;
I._.dirtyT=1;
I=I.prev
}this._viewBox=[J,H,L,E,!!F];
return this
};
m.prototype.renderfix=function(){var J=this.canvas,E=J.style,I;
try{I=J.getScreenCTM()||J.createSVGMatrix()
}catch(H){I=J.createSVGMatrix()
}var G=-I.e%1,F=-I.f%1;
if(G||F){if(G){this._left=(this._left+G)%1;
E.left=this._left+"px"
}if(F){this._top=(this._top+F)%1;
E.top=this._top+"px"
}}};
m.prototype.clear=function(){m.eve("raphael.clear",this);
var E=this.canvas;
while(E.firstChild){E.removeChild(E.firstChild)
}this.bottom=this.top=null;
(this.desc=j("desc")).appendChild(m._g.doc.createTextNode("Created with Rapha\xebl "+m.version));
E.appendChild(this.desc);
E.appendChild(this.defs=j("defs"))
};
m.prototype.remove=function(){A("raphael.remove",this);
this.canvas.parentNode&&this.canvas.parentNode.removeChild(this.canvas);
for(var E in this){this[E]=typeof this[E]=="function"?m._removedFactory(E):null
}};
var y=m.st;
for(var e in n){if(n[d](e)&&!y[d](e)){y[e]=(function(E){return function(){var F=arguments;
return this.forEach(function(G){G[E].apply(G,F)
})
}
})(e)
}}}(window.Raphael);
window.Raphael.vml&&function(m){var e="hasOwnProperty",G=String,o=parseFloat,h=Math,C=h.round,J=h.max,D=h.min,t=h.abs,w="fill",j=/[, ]+/,B=m.eve,x=" progid:DXImageTransform.Microsoft",l=" ",r="",F={M:"m",L:"l",C:"c",Z:"x",m:"t",l:"r",c:"v",z:"x"},k=/([clmz]),?([^clmz]*)/gi,u=/ progid:\S+Blur\([^\)]+\)/g,I=/-?[^,\s-]+/g,d="position:absolute;left:0;top:0;width:1px;height:1px",b=21600,A={path:1,rect:1,image:1},s={circle:1,ellipse:1},f=function(T){var Q=/[ahqstv]/ig,L=m._pathToAbsolute;
G(T).match(Q)&&(L=m._path2curve);
Q=/[clmz]/g;
if(L==m._pathToAbsolute&&!G(T).match(Q)){var P=G(T).replace(k,function(X,Z,V){var Y=[],U=Z.toLowerCase()=="m",W=F[Z];
V.replace(I,function(aa){if(U&&Y.length==2){W+=Y+F[Z=="m"?"l":"L"];
Y=[]
}Y.push(C(aa*b))
});
return W+Y
});
return P
}var R=L(T),K,E;
P=[];
for(var N=0,S=R.length;
N<S;
N++){K=R[N];
E=R[N][0].toLowerCase();
E=="z"&&(E="x");
for(var M=1,O=K.length;
M<O;
M++){E+=C(K[M]*b)+(M!=O-1?",":r)
}P.push(E)
}return P.join(l)
},p=function(M,L,K){var E=m.matrix();
E.rotate(-M,0.5,0.5);
return{dx:E.x(L,K),dy:E.y(L,K)}
},q=function(S,R,Q,N,M,O){var aa=S._,U=S.matrix,E=aa.fillpos,T=S.node,P=T.style,L=1,K="",W,Y=b/R,X=b/Q;
P.visibility="hidden";
if(!R||!Q){return
}T.coordsize=t(Y)+l+t(X);
P.rotation=O*(R*Q<0?-1:1);
if(O){var Z=p(O,N,M);
N=Z.dx;
M=Z.dy
}R<0&&(K+="x");
Q<0&&(K+=" y")&&(L=-1);
P.flip=K;
T.coordorigin=(N*-Y)+l+(M*-X);
if(E||aa.fillsize){var V=T.getElementsByTagName(w);
V=V&&V[0];
T.removeChild(V);
if(E){Z=p(O,U.x(E[0],E[1]),U.y(E[0],E[1]));
V.position=Z.dx*L+l+Z.dy*L
}if(aa.fillsize){V.size=aa.fillsize[0]*t(R)+l+aa.fillsize[1]*t(Q)
}T.appendChild(V)
}P.visibility="visible"
};
m.toString=function(){return"Your browser doesn\u2019t support SVG. Falling down to VML.\nYou are running Rapha\xebl "+this.version
};
var c=function(E,P,K){var R=G(P).toLowerCase().split("-"),N=K?"end":"start",L=R.length,O="classic",Q="medium",M="medium";
while(L--){switch(R[L]){case"block":case"classic":case"oval":case"diamond":case"open":case"none":O=R[L];
break;
case"open_block":O="block";
break;
case"open_oval":O="oval";
break;
case"open_diamond":O="diamond";
break;
case"wide":case"narrow":M=R[L];
break;
case"long":case"short":Q=R[L];
break
}}var S=E.node.getElementsByTagName("stroke")[0];
S[N+"arrow"]=O;
S[N+"arrowlength"]=Q;
S[N+"arrowwidth"]=M
},y=function(aa,ak){aa.attrs=aa.attrs||{};
var af=aa.node,ao=aa.attrs,W=af.style,S,ai=A[aa.type]&&(ak.x!=ao.x||ak.y!=ao.y||ak.width!=ao.width||ak.height!=ao.height||ak.cx!=ao.cx||ak.cy!=ao.cy||ak.rx!=ao.rx||ak.ry!=ao.ry||ak.r!=ao.r),Z=s[aa.type]&&(ao.cx!=ak.cx||ao.cy!=ak.cy||ao.r!=ak.r||ao.rx!=ak.rx||ao.ry!=ak.ry),ar=aa;
for(var X in ak){if(ak[e](X)){ao[X]=ak[X]
}}if(ai){ao.path=m._getPath[aa.type](aa);
aa._.dirty=1
}ak.href&&(af.href=ak.href);
ak.title&&(af.title=ak.title);
ak.target&&(af.target=ak.target);
ak.cursor&&(W.cursor=ak.cursor);
"blur" in ak&&aa.blur(ak.blur);
if(ak.path&&aa.type=="path"||ai){af.path=f(~G(ao.path).toLowerCase().indexOf("r")?m._pathToAbsolute(ao.path):ao.path);
if(aa.type=="image"){aa._.fillpos=[ao.x,ao.y];
aa._.fillsize=[ao.width,ao.height];
q(aa,1,1,0,0,0)
}}"transform" in ak&&aa.transform(ak.transform);
if(Z){var N=+ao.cx,L=+ao.cy,R=+ao.rx||+ao.r||0,Q=+ao.ry||+ao.r||0;
af.path=m.format("ar{0},{1},{2},{3},{4},{1},{4},{1}x",C((N-R)*b),C((L-Q)*b),C((N+R)*b),C((L+Q)*b),C(N*b))
}if("clip-rect" in ak){var K=G(ak["clip-rect"]).split(j);
if(K.length==4){K[2]=+K[2]+(+K[0]);
K[3]=+K[3]+(+K[1]);
var Y=af.clipRect||m._g.doc.createElement("div"),aq=Y.style;
aq.clip=m.format("rect({1}px {2}px {3}px {0}px)",K);
if(!af.clipRect){aq.position="absolute";
aq.top=0;
aq.left=0;
aq.width=aa.paper.width+"px";
aq.height=aa.paper.height+"px";
af.parentNode.insertBefore(Y,af);
Y.appendChild(af);
af.clipRect=Y
}}if(!ak["clip-rect"]){af.clipRect&&(af.clipRect.style.clip="auto")
}}if(aa.textpath){var am=aa.textpath.style;
ak.font&&(am.font=ak.font);
ak["font-family"]&&(am.fontFamily='"'+ak["font-family"].split(",")[0].replace(/^['"]+|['"]+$/g,r)+'"');
ak["font-size"]&&(am.fontSize=ak["font-size"]);
ak["font-weight"]&&(am.fontWeight=ak["font-weight"]);
ak["font-style"]&&(am.fontStyle=ak["font-style"])
}if("arrow-start" in ak){c(ar,ak["arrow-start"])
}if("arrow-end" in ak){c(ar,ak["arrow-end"],1)
}if(ak.opacity!=null||ak["stroke-width"]!=null||ak.fill!=null||ak.src!=null||ak.stroke!=null||ak["stroke-width"]!=null||ak["stroke-opacity"]!=null||ak["fill-opacity"]!=null||ak["stroke-dasharray"]!=null||ak["stroke-miterlimit"]!=null||ak["stroke-linejoin"]!=null||ak["stroke-linecap"]!=null){var ag=af.getElementsByTagName(w),an=false;
ag=ag&&ag[0];
!ag&&(an=ag=H(w));
if(aa.type=="image"&&ak.src){ag.src=ak.src
}ak.fill&&(ag.on=true);
if(ag.on==null||ak.fill=="none"||ak.fill===null){ag.on=false
}if(ag.on&&ak.fill){var P=G(ak.fill).match(m._ISURL);
if(P){ag.parentNode==af&&af.removeChild(ag);
ag.rotate=true;
ag.src=P[1];
ag.type="tile";
var E=aa.getBBox(1);
ag.position=E.x+l+E.y;
aa._.fillpos=[E.x,E.y];
m._preload(P[1],function(){aa._.fillsize=[this.offsetWidth,this.offsetHeight]
})
}else{ag.color=m.getRGB(ak.fill).hex;
ag.src=r;
ag.type="solid";
if(m.getRGB(ak.fill).error&&(ar.type in {circle:1,ellipse:1}||G(ak.fill).charAt()!="r")&&a(ar,ak.fill,ag)){ao.fill="none";
ao.gradient=ak.fill;
ag.rotate=false
}}}if("fill-opacity" in ak||"opacity" in ak){var O=((+ao["fill-opacity"]+1||2)-1)*((+ao.opacity+1||2)-1)*((+m.getRGB(ak.fill).o+1||2)-1);
O=D(J(O,0),1);
ag.opacity=O;
if(ag.src){ag.color="none"
}}af.appendChild(ag);
var T=(af.getElementsByTagName("stroke")&&af.getElementsByTagName("stroke")[0]),ap=false;
!T&&(ap=T=H("stroke"));
if((ak.stroke&&ak.stroke!="none")||ak["stroke-width"]||ak["stroke-opacity"]!=null||ak["stroke-dasharray"]||ak["stroke-miterlimit"]||ak["stroke-linejoin"]||ak["stroke-linecap"]){T.on=true
}(ak.stroke=="none"||ak.stroke===null||T.on==null||ak.stroke==0||ak["stroke-width"]==0)&&(T.on=false);
var ae=m.getRGB(ak.stroke);
T.on&&ak.stroke&&(T.color=ae.hex);
O=((+ao["stroke-opacity"]+1||2)-1)*((+ao.opacity+1||2)-1)*((+ae.o+1||2)-1);
var ab=(o(ak["stroke-width"])||1)*0.75;
O=D(J(O,0),1);
ak["stroke-width"]==null&&(ab=ao["stroke-width"]);
ak["stroke-width"]&&(T.weight=ab);
ab&&ab<1&&(O*=ab)&&(T.weight=1);
T.opacity=O;
ak["stroke-linejoin"]&&(T.joinstyle=ak["stroke-linejoin"]||"miter");
T.miterlimit=ak["stroke-miterlimit"]||8;
ak["stroke-linecap"]&&(T.endcap=ak["stroke-linecap"]=="butt"?"flat":ak["stroke-linecap"]=="square"?"square":"round");
if(ak["stroke-dasharray"]){var ad={"-":"shortdash",".":"shortdot","-.":"shortdashdot","-..":"shortdashdotdot",". ":"dot","- ":"dash","--":"longdash","- .":"dashdot","--.":"longdashdot","--..":"longdashdotdot"};
T.dashstyle=ad[e](ak["stroke-dasharray"])?ad[ak["stroke-dasharray"]]:r
}ap&&af.appendChild(T)
}if(ar.type=="text"){ar.paper.canvas.style.display=r;
var ah=ar.paper.span,ac=100,M=ao.font&&ao.font.match(/\d+(?:\.\d*)?(?=px)/);
W=ah.style;
ao.font&&(W.font=ao.font);
ao["font-family"]&&(W.fontFamily=ao["font-family"]);
ao["font-weight"]&&(W.fontWeight=ao["font-weight"]);
ao["font-style"]&&(W.fontStyle=ao["font-style"]);
M=o(ao["font-size"]||M&&M[0])||10;
W.fontSize=M*ac+"px";
ar.textpath.string&&(ah.innerHTML=G(ar.textpath.string).replace(/</g,"&#60;").replace(/&/g,"&#38;").replace(/\n/g,"<br>"));
var V=ah.getBoundingClientRect();
ar.W=ao.w=(V.right-V.left)/ac;
ar.H=ao.h=(V.bottom-V.top)/ac;
ar.X=ao.x;
ar.Y=ao.y+ar.H/2;
("x" in ak||"y" in ak)&&(ar.path.v=m.format("m{0},{1}l{2},{1}",C(ao.x*b),C(ao.y*b),C(ao.x*b)+1));
var U=["x","y","text","font","font-family","font-weight","font-style","font-size"];
for(var aj=0,al=U.length;
aj<al;
aj++){if(U[aj] in ak){ar._.dirty=1;
break
}}switch(ao["text-anchor"]){case"start":ar.textpath.style["v-text-align"]="left";
ar.bbx=ar.W/2;
break;
case"end":ar.textpath.style["v-text-align"]="right";
ar.bbx=-ar.W/2;
break;
default:ar.textpath.style["v-text-align"]="center";
ar.bbx=0;
break
}ar.textpath.style["v-text-kern"]=true
}if("shape-rendering" in ak){}},a=function(E,S,V){E.attrs=E.attrs||{};
var T=E.attrs,M=Math.pow,N,O,Q="linear",R=".5 .5";
E.attrs.gradient=S;
S=G(S).replace(m._radial_gradient,function(Y,Z,X){Q="radial";
if(Z&&X){Z=o(Z);
X=o(X);
M(Z-0.5,2)+M(X-0.5,2)>0.25&&(X=h.sqrt(0.25-M(Z-0.5,2))*((X>0.5)*2-1)+0.5);
R=Z+l+X
}return r
});
S=S.split(/\s*\-\s*/);
if(Q=="linear"){var K=S.shift();
K=-o(K);
if(isNaN(K)){return null
}}var P=m._parseDots(S);
if(!P){return null
}E=E.shape||E.node;
if(P.length){E.removeChild(V);
V.on=true;
V.method="none";
V.color=P[0].color;
V.color2=P[P.length-1].color;
var W=[];
for(var L=0,U=P.length;
L<U;
L++){P[L].offset&&W.push(P[L].offset+l+P[L].color)
}V.colors=W.length?W.join():"0% "+V.color;
if(Q=="radial"){V.type="gradientTitle";
V.focus="100%";
V.focussize="0 0";
V.focusposition=R;
V.angle=0
}else{V.type="gradient";
V.angle=(270-K)%360
}E.appendChild(V)
}return 1
},v=function(K,E){this[0]=this.node=K;
K.raphael=true;
this.id=m._oid++;
K.raphaelid=this.id;
this.X=0;
this.Y=0;
this.attrs={};
this.paper=E;
this.matrix=m.matrix();
this._={transform:[],sx:1,sy:1,dx:0,dy:0,deg:0,dirty:1,dirtyT:1};
!E.bottom&&(E.bottom=this);
this.prev=E.top;
E.top&&(E.top.next=this);
E.top=this;
this.next=null
};
var n=m.el;
v.prototype=n;
n.constructor=v;
n.transform=function(N){if(N==null){return this._.transform
}var P=this.paper._viewBoxShift,O=P?"s"+[P.scale,P.scale]+"-1-1t"+[P.dx,P.dy]:r,S;
if(P){S=N=G(N).replace(/\.{3}|\u2026/g,this._.transform||r)
}m._extractTransform(this,O+N);
var T=this.matrix.clone(),V=this.skew,L=this.node,R,M=~G(this.attrs.fill).indexOf("-"),E=!G(this.attrs.fill).indexOf("url(");
T.translate(-0.5,-0.5);
if(E||M||this.type=="image"){V.matrix="1 0 0 1";
V.offset="0 0";
R=T.split();
if((M&&R.noRotation)||!R.isSimple){L.style.filter=T.toFilter();
var Q=this.getBBox(),K=this.getBBox(1),W=Q.x-K.x,U=Q.y-K.y;
L.coordorigin=(W*-b)+l+(U*-b);
q(this,1,1,W,U,0)
}else{L.style.filter=r;
q(this,R.scalex,R.scaley,R.dx,R.dy,R.rotate)
}}else{L.style.filter=r;
V.matrix=G(T);
V.offset=T.offset()
}S&&(this._.transform=S);
return this
};
n.rotate=function(K,E,M){if(this.removed){return this
}if(K==null){return
}K=G(K).split(j);
if(K.length-1){E=o(K[1]);
M=o(K[2])
}K=o(K[0]);
(M==null)&&(E=M);
if(E==null||M==null){var L=this.getBBox(1);
E=L.x+L.width/2;
M=L.y+L.height/2
}this._.dirtyT=1;
this.transform(this._.transform.concat([["r",K,E,M]]));
return this
};
n.translate=function(K,E){if(this.removed){return this
}K=G(K).split(j);
if(K.length-1){E=o(K[1])
}K=o(K[0])||0;
E=+E||0;
if(this._.bbox){this._.bbox.x+=K;
this._.bbox.y+=E
}this.transform(this._.transform.concat([["t",K,E]]));
return this
};
n.scale=function(N,L,E,M){if(this.removed){return this
}N=G(N).split(j);
if(N.length-1){L=o(N[1]);
E=o(N[2]);
M=o(N[3]);
isNaN(E)&&(E=null);
isNaN(M)&&(M=null)
}N=o(N[0]);
(L==null)&&(L=N);
(M==null)&&(E=M);
if(E==null||M==null){var K=this.getBBox(1)
}E=E==null?K.x+K.width/2:E;
M=M==null?K.y+K.height/2:M;
this.transform(this._.transform.concat([["s",N,L,E,M]]));
this._.dirtyT=1;
return this
};
n.hide=function(){!this.removed&&(this.node.style.display="none");
return this
};
n.show=function(){!this.removed&&(this.node.style.display=r);
return this
};
n._getBBox=function(){if(this.removed){return{}
}return{x:this.X+(this.bbx||0)-this.W/2,y:this.Y-this.H,width:this.W,height:this.H}
};
n.remove=function(){if(this.removed||!this.node.parentNode){return
}this.paper.__set__&&this.paper.__set__.exclude(this);
m.eve.unbind("raphael.*.*."+this.id);
m._tear(this,this.paper);
this.node.parentNode.removeChild(this.node);
this.shape&&this.shape.parentNode.removeChild(this.shape);
for(var E in this){this[E]=typeof this[E]=="function"?m._removedFactory(E):null
}this.removed=true
};
n.attr=function(E,S){if(this.removed){return this
}if(E==null){var P={};
for(var R in this.attrs){if(this.attrs[e](R)){P[R]=this.attrs[R]
}}P.gradient&&P.fill=="none"&&(P.fill=P.gradient)&&delete P.gradient;
P.transform=this._.transform;
return P
}if(S==null&&m.is(E,"string")){if(E==w&&this.attrs.fill=="none"&&this.attrs.gradient){return this.attrs.gradient
}var Q=E.split(j),M={};
for(var N=0,U=Q.length;
N<U;
N++){E=Q[N];
if(E in this.attrs){M[E]=this.attrs[E]
}else{if(m.is(this.paper.customAttributes[E],"function")){M[E]=this.paper.customAttributes[E].def
}else{M[E]=m._availableAttrs[E]
}}}return U-1?M:M[Q[0]]
}if(this.attrs&&S==null&&m.is(E,"array")){M={};
for(N=0,U=E.length;
N<U;
N++){M[E[N]]=this.attr(E[N])
}return M
}var K;
if(S!=null){K={};
K[E]=S
}S==null&&m.is(E,"object")&&(K=E);
for(var T in K){B("raphael.attr."+T+"."+this.id,this,K[T])
}if(K){for(T in this.paper.customAttributes){if(this.paper.customAttributes[e](T)&&K[e](T)&&m.is(this.paper.customAttributes[T],"function")){var O=this.paper.customAttributes[T].apply(this,[].concat(K[T]));
this.attrs[T]=K[T];
for(var L in O){if(O[e](L)){K[L]=O[L]
}}}}if(K.text&&this.type=="text"){this.textpath.string=K.text
}y(this,K)
}return this
};
n.toFront=function(){!this.removed&&this.node.parentNode.appendChild(this.node);
this.paper&&this.paper.top!=this&&m._tofront(this,this.paper);
return this
};
n.toBack=function(){if(this.removed){return this
}if(this.node.parentNode.firstChild!=this.node){this.node.parentNode.insertBefore(this.node,this.node.parentNode.firstChild);
m._toback(this,this.paper)
}return this
};
n.appendChild=function(E){if(this.removed){return this
}if(this.type!=="group"){throw new TypeError("appendChild function supports only the group type!")
}var K=E.node||E[E.length-1].node;
this.node.appendChild(K);
return this
};
n.insertAfter=function(E){if(this.removed){return this
}if(E.constructor==m.st.constructor){E=E[E.length-1]
}if(E.node.nextSibling){E.node.parentNode.insertBefore(this.node,E.node.nextSibling)
}else{E.node.parentNode.appendChild(this.node)
}m._insertafter(this,E,this.paper);
return this
};
n.insertBefore=function(E){if(this.removed){return this
}if(E.constructor==m.st.constructor){E=E[0]
}E.node.parentNode.insertBefore(this.node,E.node);
m._insertbefore(this,E,this.paper);
return this
};
n.blur=function(E){var K=this.node.runtimeStyle,L=K.filter;
L=L.replace(u,r);
if(+E!==0){this.attrs.blur=E;
K.filter=L+l+x+".Blur(pixelradius="+(+E||1.5)+")";
K.margin=m.format("-{0}px 0 0 -{0}px",C(+E||1.5))
}else{K.filter=L;
K.margin=0;
delete this.attrs.blur
}};
m._engine.group=function(L,K,O){var M=H("group");
M.coordsize=b+l+b;
if(K&&O){M.coordorigin=K+" "+O
}var N=new v(M,L),E={x:K,y:O,fill:"none",stroke:"#000"};
y(N,E);
L.canvas.appendChild(M);
N.type="group";
return N
};
m._engine.path=function(M,K){var N=H("shape");
N.style.cssText=d;
N.coordsize=b+l+b;
N.coordorigin=K.coordorigin;
var O=new v(N,K),E={fill:"none",stroke:"#000"};
M&&(E.path=M);
O.type="path";
O.path=[];
O.Path=r;
y(O,E);
K.canvas.appendChild(N);
var L=H("skew");
L.on=true;
N.appendChild(L);
O.skew=L;
O.transform(r);
return O
};
m._engine.rect=function(K,P,N,Q,L,E){var R=m._rectPath(P,N,Q,L,E),M=K.path(R),O=M.attrs;
M.X=O.x=P;
M.Y=O.y=N;
M.W=O.width=Q;
M.H=O.height=L;
O.r=E;
O.path=R;
M.type="rect";
return M
};
m._engine.ellipse=function(K,E,P,O,N){var M=K.path(),L=M.attrs;
M.X=E-O;
M.Y=P-N;
M.W=O*2;
M.H=N*2;
M.type="ellipse";
y(M,{cx:E,cy:P,rx:O,ry:N});
return M
};
m._engine.circle=function(K,E,O,N){var M=K.path(),L=M.attrs;
M.X=E-N;
M.Y=O-N;
M.W=M.H=N*2;
M.type="circle";
y(M,{cx:E,cy:O,r:N});
return M
};
m._engine.image=function(K,E,Q,O,R,M){var T=m._rectPath(Q,O,R,M),N=K.path(T).attr({stroke:"none"}),P=N.attrs,L=N.node,S=L.getElementsByTagName(w)[0];
P.src=E;
N.X=P.x=Q;
N.Y=P.y=O;
N.W=P.width=R;
N.H=P.height=M;
P.path=T;
N.type="image";
S.parentNode==L&&L.removeChild(S);
S.rotate=true;
S.src=E;
S.type="tile";
N._.fillpos=[Q,O];
N._.fillsize=[R,M];
L.appendChild(S);
q(N,1,1,0,0,0);
return N
};
m._engine.text=function(E,P,O,Q){var M=H("shape"),S=H("path"),L=H("textpath");
P=P||0;
O=O||0;
Q=Q||"";
S.v=m.format("m{0},{1}l{2},{1}",C(P*b),C(O*b),C(P*b)+1);
S.textpathok=true;
L.string=G(Q);
L.on=true;
M.style.cssText=d;
M.coordsize=b+l+b;
M.coordorigin="0 0";
var K=new v(M,E),N={fill:"#000",stroke:"none",font:m._availableAttrs.font,text:Q};
K.shape=M;
K.path=S;
K.textpath=L;
K.type="text";
K.attrs.text=G(Q);
K.attrs.x=P;
K.attrs.y=O;
K.attrs.w=1;
K.attrs.h=1;
y(K,N);
M.appendChild(L);
M.appendChild(S);
E.canvas.appendChild(M);
var R=H("skew");
R.on=true;
M.appendChild(R);
K.skew=R;
K.transform(r);
return K
};
m._engine.foreignObject=function(E,Q,P,R,M,L){if((typeof R)!=="number"){L=R;
R=L.offsetWidth;
M=L.offsetHeight
}var N=H("group");
N.style.cssText=["position:absolute","left:"+(Q-R/2)+"px","top:"+(P-M/2)+"px","width:"+R+"px","height:"+M+"px"].join(";")+";";
N.coordsize=b+l+b;
N.coordorigin="0 0";
var K=document.createElement("div");
K.innerHTML=L;
N.appendChild(K);
var O=new v(N,E);
O.type="foreignObject";
O.X=O.attrs.x=Q;
O.Y=O.attrs.y=P;
O.W=O.attrs.width=R;
O.H=O.attrs.height=M;
E.canvas.appendChild(N);
return O
};
m._engine.setSize=function(L,E){var K=this.canvas.style;
this.width=L;
this.height=E;
L==+L&&(L+="px");
E==+E&&(E+="px");
K.width=L;
K.height=E;
K.clip="rect(0 "+L+" "+E+" 0)";
if(this._viewBox){m._engine.setViewBox.apply(this,this._viewBox)
}return this
};
m._engine.setViewBox=function(O,N,P,L,M){m.eve("raphael.setViewBox",this,this._viewBox,[O,N,P,L,M]);
var E=this.width,R=this.height,S=1/J(P/E,L/R),Q,K;
if(M){Q=R/L;
K=E/P;
if(P*Q<E){O-=(E-P*Q)/2/Q
}if(L*K<R){N-=(R-L*K)/2/K
}}this._viewBox=[O,N,P,L,!!M];
this._viewBoxShift={dx:-O,dy:-N,scale:S};
this.forEach(function(T){T.transform("...")
});
return this
};
var H;
m._engine.initWin=function(L){var K=L.document;
K.createStyleSheet().addRule(".rvml","behavior:url(#default#VML)");
try{!K.namespaces.rvml&&K.namespaces.add("rvml","urn:schemas-microsoft-com:vml");
H=function(M){return K.createElement("<rvml:"+M+' class="rvml">')
}
}catch(E){H=function(M){return K.createElement("<"+M+' xmlns="urn:schemas-microsoft.com:vml" class="rvml">')
}
}};
m._engine.initWin(m._g.win);
m._engine.create=function(){var L=m._getContainer.apply(0,arguments),E=L.container,R=L.height,S,K=L.width,Q=L.x,P=L.y;
if(!E){throw new Error("VML container not found.")
}var N=new m._Paper,O=N.canvas=m._g.doc.createElement("div"),M=O.style;
Q=Q||0;
P=P||0;
K=K||512;
R=R||342;
N.width=K;
N.height=R;
K==+K&&(K+="px");
R==+R&&(R+="px");
N.coordsize=b*1000+l+b*1000;
N.coordorigin="0 0";
N.span=m._g.doc.createElement("span");
N.span.style.cssText="position:absolute;left:-9999em;top:-9999em;padding:0;margin:0;line-height:1;";
O.appendChild(N.span);
M.cssText=m.format("top:0;left:0;width:{0};height:{1};display:inline-block;position:relative;clip:rect(0 {0} {1} 0);overflow:hidden",K,R);
if(E==1){m._g.doc.body.appendChild(O);
M.left=Q+"px";
M.top=P+"px";
M.position="absolute"
}else{if(E.firstChild){E.insertBefore(O,E.firstChild)
}else{E.appendChild(O)
}}N.renderfix=function(){};
return N
};
m.prototype.clear=function(){m.eve("raphael.clear",this);
this.canvas.innerHTML=r;
this.span=m._g.doc.createElement("span");
this.span.style.cssText="position:absolute;left:-9999em;top:-9999em;padding:0;margin:0;line-height:1;display:inline;";
this.canvas.appendChild(this.span);
this.bottom=this.top=null
};
m.prototype.remove=function(){m.eve("raphael.remove",this);
this.canvas.parentNode.removeChild(this.canvas);
for(var E in this){this[E]=typeof this[E]=="function"?m._removedFactory(E):null
}return true
};
var z=m.st;
for(var g in n){if(n[e](g)&&!z[e](g)){z[g]=(function(E){return function(){var K=arguments;
return this.forEach(function(L){L[E].apply(L,K)
})
}
})(g)
}}}(window.Raphael);
var OG=window.OG||{};
OG.common={};
OG.geometry={};
OG.graph={};
OG.handler={};
OG.layout={};
OG.renderer={};
OG.shape={};
OG.shape.bpmn={};
OG.common.Constants={GEOM_TYPE:{NULL:0,POINT:1,LINE:2,POLYLINE:3,POLYGON:4,RECTANGLE:5,CIRCLE:6,ELLIPSE:7,CURVE:8,BEZIER_CURVE:9,COLLECTION:10},GEOM_NAME:["","Point","Line","PolyLine","Polygon","Rectangle","Circle","Ellipse","Curve","BezierCurve","Collection"],NUM_PRECISION:0,NODE_TYPE:{ROOT:"ROOT",SHAPE:"SHAPE",ETC:"ETC"},SHAPE_TYPE:{GEOM:"GEOM",TEXT:"TEXT",HTML:"HTML",IMAGE:"IMAGE",EDGE:"EDGE",GROUP:"GROUP"},EDGE_TYPE:{STRAIGHT:"straight",PLAIN:"plain",BEZIER:"bezier"},LABEL_SUFFIX:"_LABEL",LABEL_EDITOR_SUFFIX:"_LABEL_EDITOR",FROM_LABEL_SUFFIX:"_FROMLABEL",TO_LABEL_SUFFIX:"_TOLABEL",RUBBER_BAND_ID:"OG_R_BAND",GUIDE_SUFFIX:{GUIDE:"_GUIDE",BBOX:"_GUIDE_BBOX",UL:"_GUIDE_UL",UR:"_GUIDE_UR",LL:"_GUIDE_LL",LR:"_GUIDE_LR",LC:"_GUIDE_LC",UC:"_GUIDE_UC",RC:"_GUIDE_RC",LWC:"_GUIDE_LWC",FROM:"_GUIDE_FROM",TO:"_GUIDE_TO",CTL:"_GUIDE_CTL_",CTL_H:"_GUIDE_CTL_H_",CTL_V:"_GUIDE_CTL_V_",CTL_B:"_GUIDE_CTL_B_",CTL_C:"_GUIDE_CTL_C_"},COLLAPSE_SUFFIX:"_COLLAPSE",COLLAPSE_BBOX_SUFFIX:"_COLLAPSE_BBOX",MOVE_SNAP_SIZE:5,TO_LINE_ANGEL_SIZE:3,DROP_OVER_BBOX_SUFFIX:"_DROP_OVER",TERMINAL_SUFFIX:{GROUP:"_TERMINAL",BOX:"_TERMINAL_BOX"},TERMINAL_TYPE:{C:"C",E:"E",W:"W",S:"S",N:"N",IN:"IN",OUT:"OUT",INOUT:"INOUT"}};
OG.Constants=OG.common.Constants;
if(typeof KeyEvent==="undefined"){var KeyEvent={DOM_VK_CANCEL:3,DOM_VK_HELP:6,DOM_VK_BACK_SPACE:8,DOM_VK_TAB:9,DOM_VK_CLEAR:12,DOM_VK_RETURN:13,DOM_VK_ENTER:14,DOM_VK_SHIFT:16,DOM_VK_CONTROL:17,DOM_VK_ALT:18,DOM_VK_PAUSE:19,DOM_VK_CAPS_LOCK:20,DOM_VK_ESCAPE:27,DOM_VK_SPACE:32,DOM_VK_PAGE_UP:33,DOM_VK_PAGE_DOWN:34,DOM_VK_END:35,DOM_VK_HOME:36,DOM_VK_LEFT:37,DOM_VK_UP:38,DOM_VK_RIGHT:39,DOM_VK_DOWN:40,DOM_VK_PRINTSCREEN:44,DOM_VK_INSERT:45,DOM_VK_DELETE:46,DOM_VK_0:48,DOM_VK_1:49,DOM_VK_2:50,DOM_VK_3:51,DOM_VK_4:52,DOM_VK_5:53,DOM_VK_6:54,DOM_VK_7:55,DOM_VK_8:56,DOM_VK_9:57,DOM_VK_SEMICOLON:59,DOM_VK_EQUALS:61,DOM_VK_A:65,DOM_VK_B:66,DOM_VK_C:67,DOM_VK_D:68,DOM_VK_E:69,DOM_VK_F:70,DOM_VK_G:71,DOM_VK_H:72,DOM_VK_I:73,DOM_VK_J:74,DOM_VK_K:75,DOM_VK_L:76,DOM_VK_M:77,DOM_VK_N:78,DOM_VK_O:79,DOM_VK_P:80,DOM_VK_Q:81,DOM_VK_R:82,DOM_VK_S:83,DOM_VK_T:84,DOM_VK_U:85,DOM_VK_V:86,DOM_VK_W:87,DOM_VK_X:88,DOM_VK_Y:89,DOM_VK_Z:90,DOM_VK_COMMAND:91,DOM_VK_CONTEXT_MENU:93,DOM_VK_NUMPAD0:96,DOM_VK_NUMPAD1:97,DOM_VK_NUMPAD2:98,DOM_VK_NUMPAD3:99,DOM_VK_NUMPAD4:100,DOM_VK_NUMPAD5:101,DOM_VK_NUMPAD6:102,DOM_VK_NUMPAD7:103,DOM_VK_NUMPAD8:104,DOM_VK_NUMPAD9:105,DOM_VK_MULTIPLY:106,DOM_VK_ADD:107,DOM_VK_SEPARATOR:108,DOM_VK_SUBTRACT:109,DOM_VK_DECIMAL:110,DOM_VK_DIVIDE:111,DOM_VK_F1:112,DOM_VK_F2:113,DOM_VK_F3:114,DOM_VK_F4:115,DOM_VK_F5:116,DOM_VK_F6:117,DOM_VK_F7:118,DOM_VK_F8:119,DOM_VK_F9:120,DOM_VK_F10:121,DOM_VK_F11:122,DOM_VK_F12:123,DOM_VK_F13:124,DOM_VK_F14:125,DOM_VK_F15:126,DOM_VK_F16:127,DOM_VK_F17:128,DOM_VK_F18:129,DOM_VK_F19:130,DOM_VK_F20:131,DOM_VK_F21:132,DOM_VK_F22:133,DOM_VK_F23:134,DOM_VK_F24:135,DOM_VK_NUM_LOCK:144,DOM_VK_SCROLL_LOCK:145,DOM_VK_COMMA:188,DOM_VK_PERIOD:190,DOM_VK_SLASH:191,DOM_VK_BACK_QUOTE:192,DOM_VK_OPEN_BRACKET:219,DOM_VK_BACK_SLASH:220,DOM_VK_CLOSE_BRACKET:221,DOM_VK_QUOTE:222,DOM_VK_META:224}
}OG.common.Util={isEmpty:function(b,a){return b===null||b===undefined||((OG.Util.isArray(b)&&!b.length))||(!a?b==="":false)
},isArray:function(a){return Object.prototype.toString.apply(a)==="[object Array]"
},isDate:function(a){return Object.prototype.toString.apply(a)==="[object Date]"
},isObject:function(a){return !!a&&Object.prototype.toString.call(a)==="[object Object]"
},isPrimitive:function(a){return OG.Util.isString(a)||OG.Util.isNumber(a)||OG.Util.isBoolean(a)
},isFunction:function(a){return Object.prototype.toString.apply(a)==="[object Function]"
},isNumber:function(a){return typeof a==="number"&&isFinite(a)
},isString:function(a){return typeof a==="string"
},isBoolean:function(a){return typeof a==="boolean"
},isElement:function(a){return !!a&&a.tagName?true:false
},isDefined:function(a){return typeof a!=="undefined"
},isWebKit:function(){return(/webkit/).test(navigator.userAgent.toLowerCase())
},isGecko:function(){return !OG.Util.isWebKit()&&(/gecko/).test(navigator.userAgent.toLowerCase())
},isOpera:function(){return(/opera/).test(navigator.userAgent.toLowerCase())
},isChrome:function(){return(/\bchrome\b/).test(navigator.userAgent.toLowerCase())
},isSafari:function(){return !OG.Util.isChrome()&&(/safari/).test(navigator.userAgent.toLowerCase())
},isFirefox:function(){return(/firefox/).test(navigator.userAgent.toLowerCase())
},isIE:function(){return !OG.Util.isOpera()&&(/msie/).test(navigator.userAgent.toLowerCase())
},isIE6:function(){return OG.Util.isIE()&&(/msie 6/).test(navigator.userAgent.toLowerCase())
},isIE7:function(){return OG.Util.isIE()&&((/msie 7/).test(navigator.userAgent.toLowerCase())||document.documentMode===7)
},isIE8:function(){return OG.Util.isIE()&&((/msie 8/).test(navigator.userAgent.toLowerCase())||document.documentMode===8)
},isIE9:function(){return OG.Util.isIE()&&((/msie 9/).test(navigator.userAgent.toLowerCase())||document.documentMode===9)
},isWindows:function(){return(/windows|win32/).test(navigator.userAgent.toLowerCase())
},isMac:function(){return(/macintosh|mac os x/).test(navigator.userAgent.toLowerCase())
},isLinux:function(){return(/linux/).test(navigator.userAgent.toLowerCase())
},trim:function(a){return a===null||a===undefined?a:a.replace(/^[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u2028\u2029\u202f\u205f\u3000]+|[\x09\x0a\x0b\x0c\x0d\x20\xa0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u2028\u2029\u202f\u205f\u3000]+$/g,"")
},clone:function(g){if(g===null||g===undefined){return g
}if(g.nodeType&&g.cloneNode){return g.cloneNode(true)
}var e,c,b,h,d,f=Object.prototype.toString.call(g),a=["hasOwnProperty","valueOf","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","constructor"];
if(f==="[object Date]"){return new Date(g.getTime())
}if(f==="[object Array]"){e=g.length;
h=[];
while(e--){h[e]=this.clone(g[e])
}}else{if(f==="[object Object]"&&g.constructor===Object){h={};
for(d in g){h[d]=this.clone(g[d])
}if(a){for(c=a.length;
c--;
){b=a[c];
h[b]=g[b]
}}}}return h||g
},round:function(a){return this.roundPrecision(a,OG.Constants.NUM_PRECISION)
},roundPrecision:function(c,a){var b=Math.pow(10,a);
return Math.round(c*b)/b
},roundGrid:function(a,b){b=b||OG.Constants.MOVE_SNAP_SIZE;
return OG.Util.round(a/b)*b
},apply:function(d,a,c){var b;
if(c){this.apply(d,c)
}if(d&&a&&typeof a==="object"){for(b in a){d[b]=a[b]
}}return d
},extend:(function(){var b=function(d){var c;
for(c in d){this[c]=d[c]
}},a=Object.prototype.constructor;
return function(h,e,g){if(OG.Util.isObject(e)){g=e;
e=h;
h=g.constructor!==a?g.constructor:function(){e.apply(this,arguments)
}
}var d=function(){},f,c=e.prototype;
d.prototype=c;
f=h.prototype=new d();
f.constructor=h;
h.superclass=c;
if(c.constructor===a){c.constructor=e
}h.override=function(j){OG.Util.override(h,j)
};
f.superclass=f.supr=(function(){return c
}());
f.override=b;
OG.Util.override(h,g);
h.extend=function(j){return OG.Util.extend(h,j)
};
return h
}
}()),override:function(a,c){if(c){var b=a.prototype;
OG.Util.apply(b,c);
if((/msie/).test(navigator.userAgent.toLowerCase())&&c.hasOwnProperty("toString")){b.toString=c.toString
}}},xmlToJson:function(c){var b={},a=function(f){var e={};
for(var g in f){if(f.hasOwnProperty(g)){e[g]=f[g]
}}return e
},d=function(g,m,r){if(g.nodeType===3){if(!g.nodeValue.match(/[\S]+/)){return
}if(m["$"] instanceof Array){m["$"].push(g.nodeValue)
}else{if(m["$"] instanceof Object){m["$"]=[m["$"],g.nodeValue]
}else{m["$"]=g.nodeValue
}}}else{if(g.nodeType===1){var f={};
var s=g.nodeName;
for(var n=0;
g.attributes&&n<g.attributes.length;
n++){var q=g.attributes[n];
var e=q.nodeName;
var t=q.nodeValue;
if(e==="xmlns"){r["$"]=t
}else{if(e.indexOf("xmlns:")===0){r[e.substr(e.indexOf(":")+1)]=t
}else{f["@"+e]=t
}}}for(var o in r){if(r.hasOwnProperty(o)){f["@xmlns"]=f["@xmlns"]||{};
f["@xmlns"][o]=r[o]
}}if(m[s] instanceof Array){m[s].push(f)
}else{if(m[s] instanceof Object){m[s]=[m[s],f]
}else{m[s]=f
}}for(var l=0;
l<g.childNodes.length;
l++){d(g.childNodes[l],f,a(r))
}}else{if(g.nodeType===9){for(var h=0;
h<g.childNodes.length;
h++){d(g.childNodes[h],m,a(r))
}}}}};
d(c,b,{});
return b
},jsonToXml:function(d){if(typeof d!=="object"){return null
}var b=function(f){var e={};
for(var g in f){if(f.hasOwnProperty(g)){e[g]=f[g]
}}return e
};
var c=function(n,e,o){var m="";
if(e instanceof Array){for(var k=0;
k<e.length;
k++){m+=c(n,e[k],b(o))
}return m
}else{if(typeof e==="object"){var f="<"+n;
var h="";
var q="";
if(e["@xmlns"]){var g=e["@xmlns"];
for(var l in g){if(g.hasOwnProperty(l)){if(l==="$"){if(o[l]!==g[l]){h+=' xmlns="'+g[l]+'"';
o[l]=g[l]
}}else{if(!o[l]||(o[l]!==g[l])){h+=" xmlns:"+l+'="'+g[l]+'"';
o[l]=g[l]
}}}}}for(var p in e){if(e.hasOwnProperty(p)&&p!=="@xmlns"){var j=e[p];
if(p==="$"){q+=j
}else{if(p.indexOf("@")===0){h+=" "+p.substring(1)+'="'+j+'"'
}else{m+=c(p,j,b(o))
}}}}m=q+m;
return(m!=="")?f+h+">"+m+"</"+n+">":f+h+"/>"
}}};
for(var a in d){if(d.hasOwnProperty(a)&&a.indexOf("@")==-1){return'<?xml version="1.0" encoding="UTF-8"?>'+c(a,d[a],{})
}}return null
},parseXML:function(b){var a,c;
if(window.ActiveXObject){a=new ActiveXObject("Microsoft.XMLDOM");
a.async="false";
a.loadXML(b)
}else{c=new DOMParser();
a=c.parseFromString(b,"text/xml")
}return a
}};
OG.Util=OG.common.Util;
OG.common.CurveUtil={CatmullRomSpline:function(c){var b=[],e,f={},d={},a=function(g){return function(k,j){var h=c.length,l,m;
if(h<2){return NaN
}k=k-1;
if(!j&&b[g]){j=true
}if(!j){f[g]=2*c[0][g]-c[1][g];
d[g]=2*c[h-1][g]-c[h-2][g];
e=[f].concat(c,[d]);
b[g]=[];
for(l=0;
l<h-1;
l++){b[g][l]=[2*e[l+1][g],-e[l][g]+e[l+2][g],2*e[l][g]-5*e[l+1][g]+4*e[l+2][g]-e[l+3][g],-e[l][g]+3*e[l+1][g]-3*e[l+2][g]+e[l+3][g]]
}}h+=2;
if(isNaN(k)){return NaN
}if(k<0){return e[1][g]
}else{if(k>=h-3){return e[h-2][g]
}}l=Math.floor(k);
if(l===k){return e[l][g]
}k-=l;
m=b[g][l];
return 0.5*(((m[3]*k+m[2])*k+m[1])*k+m[0])
}
};
return{getX:a(0),getY:a(1),maxT:c.length+1}
},Bezier:function(c){var a,b=function(d){return function(f,e){var j=Math.floor(f)*3,h=f,g=1-h;
if(!e&&a){e=true
}if(!e){a=Math.floor(c.length/3)
}if(f<0){return c[0][d]
}if(f>=a){return c[c.length-1][d]
}if(isNaN(f)){return NaN
}return g*g*(g*c[j][d]+3*h*c[j+1][d])+(3*g*c[j+2][d]+h*c[j+3][d])*h*h
}
};
return{getX:b(0),getY:b(1),maxT:Math.floor(c.length/3)+0.01}
},BSpline:function(d,a){var e,g=[],f=function(o,h){var l,m=[];
for(l=0;
l<o+h+1;
l++){if(l<h){m[l]=0
}else{if(l<=o){m[l]=l-h+1
}else{m[l]=o-h+2
}}}return m
},c=function(v,x,h,l,w){var o,m,r,q,u,p=[];
if(x[w]<=v&&v<x[w+1]){p[w]=1
}else{p[w]=0
}for(o=2;
o<=l;
o++){for(m=w-o+1;
m<=w;
m++){if(m<=w-o+1||m<0){r=0
}else{r=p[m]
}if(m>=w){q=0
}else{q=p[m+1]
}u=x[m+o-1]-x[m];
if(u===0){p[m]=0
}else{p[m]=(v-x[m])/u*r
}u=x[m+o]-x[m+1];
if(u!==0){p[m]+=(x[m+o]-v)/u*q
}}}return p
},b=function(h){return function(q,m){var l=d.length,v,p,r,u=l-1,o=a;
if(u<=0){return NaN
}if(u+2<=o){o=u+1
}if(q<=0){return d[0][h]
}if(q>=u-o+2){return d[u][h]
}e=f(u,o);
r=Math.floor(q)+o-1;
g=c(q,e,u,o,r);
v=0;
for(p=r-o+1;
p<=r;
p++){if(p<l&&p>=0){v+=d[p][h]*g[p]
}}return v
}
};
return{getX:b(0),getY:b(1),maxT:d.length-2}
}};
OG.CurveUtil=OG.common.CurveUtil;
OG.common.NotSupportedException=function(a){this.name="OG.NotSupportedException";
this.message=a||"Not Supported!"
};
OG.NotSupportedException=OG.common.NotSupportedException;
OG.common.NotImplementedException=function(a){this.name="OG.NotImplementedException";
this.message=a||"Not Implemented!"
};
OG.NotImplementedException=OG.common.NotImplementedException;
OG.common.ParamError=function(a){this.name="OG.ParamError";
this.message=a||"Invalid Parameter Error!"
};
OG.ParamError=OG.common.ParamError;
OG.common.HashMap=function(a){this.map=a||{}
};
OG.common.HashMap.prototype={put:function(a,b){this.map[a]=b
},get:function(a){return this.map[a]
},containsKey:function(a){return this.map.hasOwnProperty(a)
},containsValue:function(a){var b;
for(b in this.map){if(this.map[b]===a){return true
}}return false
},isEmpty:function(){return this.size()===0
},clear:function(){var a;
for(a in this.map){delete this.map[a]
}},remove:function(a){if(this.map[a]){delete this.map[a]
}},keys:function(){var a=[],b;
for(b in this.map){a.push(b)
}return a
},values:function(){var a=[],b;
for(b in this.map){a.push(this.map[b])
}return a
},size:function(){var a=0,b;
for(b in this.map){a++
}return a
},toString:function(){var a=[],b;
for(b in this.map){a.push("'"+b+"':'"+this.map[b]+"'")
}return"{"+a.join()+"}"
}};
OG.common.HashMap.prototype.constructor=OG.common.HashMap;
OG.HashMap=OG.common.HashMap;
OG.common.JSON=new (function(){var useHasOwn=!!{}.hasOwnProperty,USE_NATIVE_JSON=false,isNative=(function(){var useNative=null;
return function(){if(useNative===null){useNative=USE_NATIVE_JSON&&window.JSON&&JSON.toString()==="[object JSON]"
}return useNative
}
}()),m={"\b":"\\b","\t":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},pad=function(n){return n<10?"0"+n:n
},doDecode=function(json){return eval("("+json+")")
},encodeString=function(s){if(/["\\\x00-\x1f]/.test(s)){return'"'+s.replace(/([\x00-\x1f\\"])/g,function(a,b){var c=m[b];
if(c){return c
}c=b.charCodeAt();
return"\\u00"+Math.floor(c/16).toString(16)+(c%16).toString(16)
})+'"'
}return'"'+s+'"'
},encodeArray=function(o){var a=["["],b,i,l=o.length,v;
for(i=0;
i<l;
i+=1){v=o[i];
switch(typeof v){case"undefined":case"function":case"unknown":break;
default:if(b){a.push(",")
}a.push(v===null?"null":OG.common.JSON.encode(v));
b=true
}}a.push("]");
return a.join("")
},doEncode=function(o){if(!OG.Util.isDefined(o)||o===null){return"null"
}else{if(OG.Util.isArray(o)){return encodeArray(o)
}else{if(OG.Util.isDate(o)){return OG.common.JSON.encodeDate(o)
}else{if(OG.Util.isString(o)){return encodeString(o)
}else{if(typeof o==="number"){return isFinite(o)?String(o):"null"
}else{if(OG.Util.isBoolean(o)){return String(o)
}else{var a=["{"],b,i,v;
for(i in o){if(!o.getElementsByTagName){if(!useHasOwn||o.hasOwnProperty(i)){v=o[i];
switch(typeof v){case"undefined":case"function":case"unknown":break;
default:if(b){a.push(",")
}a.push(doEncode(i),":",v===null?"null":doEncode(v));
b=true
}}}}a.push("}");
return a.join("")
}}}}}}};
this.encodeDate=function(o){return'"'+o.getFullYear()+"-"+pad(o.getMonth()+1)+"-"+pad(o.getDate())+"T"+pad(o.getHours())+":"+pad(o.getMinutes())+":"+pad(o.getSeconds())+'"'
};
this.encode=(function(){var ec;
return function(o){if(!ec){ec=dorado.JSON.stringify
}return ec(o)
}
}());
this.decode=(function(){var dc;
return function(json){if(!dc){dc=isNative()?JSON.parse:doDecode
}return dc(json)
}
}())
})();
OG.JSON=OG.common.JSON;
OG.geometry.Style=function(c){var b={},a={};
OG.Util.apply(a,c,b);
OG.geometry.Style.superclass.call(this,a)
};
OG.geometry.Style.prototype=new OG.common.HashMap();
OG.geometry.Style.superclass=OG.common.HashMap;
OG.geometry.Style.prototype.constructor=OG.geometry.Style;
OG.Style=OG.geometry.Style;
OG.geometry.Coordinate=function(a,b){this.x=undefined;
this.y=undefined;
if(arguments.length===1&&a.constructor===Array){this.x=OG.Util.round(a[0]);
this.y=OG.Util.round(a[1])
}else{if(arguments.length===2&&typeof a==="number"&&typeof b==="number"){this.x=OG.Util.round(a);
this.y=OG.Util.round(b)
}else{if(arguments.length!==0){throw new OG.ParamError()
}}}};
OG.geometry.Coordinate.prototype={distance:function(c){if(c.constructor===Array){c=new OG.geometry.Coordinate(c[0],c[1])
}var b=this.x-c.x,a=this.y-c.y;
return OG.Util.round(Math.sqrt(Math.pow(b,2)+Math.pow(a,2)))
},move:function(a,b){this.x+=a;
this.y+=b;
return this
},rotate:function(d,b){if(b.constructor===Array){b=new OG.geometry.Coordinate(b[0],b[1])
}d*=Math.PI/180;
var a=this.distance(b),c=d+Math.atan2(this.y-b.y,this.x-b.x);
this.x=OG.Util.round(b.x+(a*Math.cos(c)));
this.y=OG.Util.round(b.y+(a*Math.sin(c)));
return this
},isEquals:function(a){if(a.constructor===Array){a=new OG.geometry.Coordinate(a[0],a[1])
}if(a&&a instanceof OG.geometry.Coordinate){if(this.x===a.x&&this.y===a.y){return true
}}return false
},toString:function(){var a=[];
a.push(this.x);
a.push(this.y);
return"["+a.join()+"]"
}};
OG.geometry.Coordinate.prototype.constructor=OG.geometry.Coordinate;
OG.Coordinate=OG.geometry.Coordinate;
OG.geometry.Envelope=function(b,c,a){this._upperLeft=null;
this._width=c;
this._height=a;
this._upperRight=null;
this._lowerLeft=null;
this._lowerRight=null;
this._leftCenter=null;
this._leftCenter=null;
this._upperCenter=null;
this._rightCenter=null;
this._lowerCenter=null;
this._centroid=null;
if(b){if(b.constructor===Array){this._upperLeft=new OG.geometry.Coordinate(b)
}else{this._upperLeft=new OG.geometry.Coordinate(b.x,b.y)
}}};
OG.geometry.Envelope.prototype={getUpperLeft:function(){return this._upperLeft
},setUpperLeft:function(a){if(a.constructor===Array){a=new OG.geometry.Coordinate(a[0],a[1])
}this._upperLeft=a;
this._reset()
},getUpperRight:function(){if(!this._upperRight){this._upperRight=new OG.geometry.Coordinate(this._upperLeft.x+this._width,this._upperLeft.y)
}return this._upperRight
},getLowerRight:function(){if(!this._lowerRight){this._lowerRight=new OG.geometry.Coordinate(this._upperLeft.x+this._width,this._upperLeft.y+this._height)
}return this._lowerRight
},getLowerLeft:function(){if(!this._lowerLeft){this._lowerLeft=new OG.geometry.Coordinate(this._upperLeft.x,this._upperLeft.y+this._height)
}return this._lowerLeft
},getLeftCenter:function(){if(!this._leftCenter){this._leftCenter=new OG.geometry.Coordinate(this._upperLeft.x,OG.Util.round(this._upperLeft.y+this._height/2))
}return this._leftCenter
},getUpperCenter:function(){if(!this._upperCenter){this._upperCenter=new OG.geometry.Coordinate(OG.Util.round(this._upperLeft.x+this._width/2),this._upperLeft.y)
}return this._upperCenter
},getRightCenter:function(){if(!this._rightCenter){this._rightCenter=new OG.geometry.Coordinate(this._upperLeft.x+this._width,OG.Util.round(this._upperLeft.y+this._height/2))
}return this._rightCenter
},getLowerCenter:function(){if(!this._lowerCenter){this._lowerCenter=new OG.geometry.Coordinate(OG.Util.round(this._upperLeft.x+this._width/2),this._upperLeft.y+this._height)
}return this._lowerCenter
},getCentroid:function(){if(!this._centroid){this._centroid=new OG.geometry.Coordinate(OG.Util.round(this._upperLeft.x+this._width/2),OG.Util.round(this._upperLeft.y+this._height/2))
}return this._centroid
},setCentroid:function(a){if(a.constructor===Array){a=new OG.geometry.Coordinate(a[0],a[1])
}this.move(a.x-this.getCentroid().x,a.y-this.getCentroid().y)
},getWidth:function(){return this._width
},setWidth:function(a){this._width=a;
this._reset()
},getHeight:function(){return this._height
},setHeight:function(a){this._height=a;
this._reset()
},getVertices:function(){var a=[];
a.push(this.getUpperLeft());
a.push(this.getUpperCenter());
a.push(this.getUpperRight());
a.push(this.getRightCenter());
a.push(this.getLowerRight());
a.push(this.getLowerCenter());
a.push(this.getLowerLeft());
a.push(this.getLeftCenter());
a.push(this.getUpperLeft());
return a
},isContains:function(a){if(a.constructor===Array){return a[0]>=this._upperLeft.x&&a[0]<=this.getLowerRight().x&&a[1]>=this._upperLeft.y&&a[1]<=this.getLowerRight().y
}else{return a.x>=this._upperLeft.x&&a.x<=this.getLowerRight().x&&a.y>=this._upperLeft.y&&a.y<=this.getLowerRight().y
}},isContainsAll:function(b){var a;
for(a=0;
a<b.length;
a++){if(!this.isContains(b[a])){return false
}}return true
},move:function(a,b){this._upperLeft.move(a,b);
this._reset();
return this
},resize:function(c,a,d,b){c=c||0;
a=a||0;
d=d||0;
b=b||0;
if(this._width+(d+b)<0||this._height+(c+a)<0){throw new OG.ParamError()
}this._upperLeft.move(-1*d,-1*c);
this._width+=(d+b);
this._height+=(c+a);
this._reset();
return this
},isEquals:function(a){if(a&&a instanceof OG.geometry.Envelope){if(this.getUpperLeft().isEquals(a.getUpperLeft())&&this.getWidth()===a.getWidth()&&this.getHeight()===a.getHeight()){return true
}}return false
},toString:function(){var a=[];
a.push("upperLeft:"+this.getUpperLeft());
a.push("width:"+this.getWidth());
a.push("height:"+this.getHeight());
a.push("upperRight:"+this.getUpperRight());
a.push("lowerLeft:"+this.getLowerLeft());
a.push("lowerRight:"+this.getLowerRight());
a.push("leftCenter:"+this.getLeftCenter());
a.push("upperCenter:"+this.getUpperCenter());
a.push("rightCenter:"+this.getRightCenter());
a.push("lowerCenter:"+this.getLowerCenter());
a.push("centroid:"+this.getCentroid());
return"{"+a.join()+"}"
},_reset:function(){this._upperRight=null;
this._lowerLeft=null;
this._lowerRight=null;
this._leftCenter=null;
this._upperCenter=null;
this._rightCenter=null;
this._lowerCenter=null;
this._centroid=null
}};
OG.geometry.Envelope.prototype.constructor=OG.geometry.Envelope;
OG.Envelope=OG.geometry.Envelope;
OG.geometry.Geometry=function(){this.TYPE=OG.Constants.GEOM_TYPE.NULL;
this.IS_CLOSED=false;
this.style=null;
this.boundary=null
};
OG.geometry.Geometry.prototype={isEquals:function(a){return a&&a.toString()===this.toString()
},isContains:function(a){throw new OG.NotImplementedException()
},isWithin:function(a){throw new OG.NotImplementedException()
},getBoundary:function(){if(this.boundary===null){var f,e,c,a,b,d,j,h=this.getVertices(),g;
for(g=0;
g<h.length;
g++){if(g===0){f=c=h[g].x;
e=a=h[g].y
}f=h[g].x<f?h[g].x:f;
e=h[g].y<e?h[g].y:e;
c=h[g].x>c?h[g].x:c;
a=h[g].y>a?h[g].y:a
}b=new OG.geometry.Coordinate(f,e);
d=c-f;
j=a-e;
this.boundary=new OG.geometry.Envelope(b,d,j)
}return this.boundary
},getCentroid:function(){return this.getBoundary().getCentroid()
},getVertices:function(){throw new OG.NotImplementedException()
},minDistance:function(c){var d=Number.MAX_VALUE,e=0,a=this.getVertices(),b;
c=this.convertCoordinate(c);
if(a.length===1){return c.distance(a[0])
}for(b=0;
b<a.length-1;
b++){e=this.distanceToLine(c,[a[b],a[b+1]]);
if(e<d){d=e
}}return d
},distance:function(a){return this.getCentroid().distance(a.getCentroid())
},getLength:function(){var c=0,a=this.getVertices(),b;
for(b=0;
b<a.length-1;
b++){c+=a[b].distance(a[b+1])
}return c
},move:function(a,b){throw new OG.NotImplementedException()
},moveCentroid:function(b){var a=this.getCentroid();
b=new OG.geometry.Coordinate(b);
this.move(b.x-a.x,b.y-a.y)
},resize:function(c,a,d,b){throw new OG.NotImplementedException()
},resizeBox:function(d,a){var e=this.getBoundary(),c=OG.Util.round((d-e.getWidth())/2),b=OG.Util.round((a-e.getHeight())/2);
this.resize(b,b,c,c);
return this
},rotate:function(b,a){throw new OG.NotImplementedException()
},fitToBoundary:function(e){var f=this.getBoundary(),c=f.getUpperCenter().y-e.getUpperCenter().y,a=e.getLowerCenter().y-f.getLowerCenter().y,d=f.getLeftCenter().x-e.getLeftCenter().x,b=e.getRightCenter().x-f.getRightCenter().x;
this.resize(c,a,d,b);
return this
},convertCoordinate:function(a){if(a){if(a.constructor===Array){return new OG.geometry.Coordinate(a)
}else{if(a instanceof OG.geometry.Coordinate){return new OG.geometry.Coordinate(a.x,a.y)
}else{throw new OG.ParamError()
}}}else{return undefined
}},distanceToLine:function(e,b){var a=this.convertCoordinate(b[0]),f=this.convertCoordinate(b[1]),d,c;
e=this.convertCoordinate(e);
if(a.isEquals(f)){return e.distance(a)
}d=((e.x-a.x)*(f.x-a.x)+(e.y-a.y)*(f.y-a.y))/((f.x-a.x)*(f.x-a.x)+(f.y-a.y)*(f.y-a.y));
if(d<=0){return e.distance(a)
}if(d>=1){return e.distance(f)
}c=((a.y-e.y)*(f.x-a.x)-(a.x-e.x)*(f.y-a.y))/((f.x-a.x)*(f.x-a.x)+(f.y-a.y)*(f.y-a.y));
return OG.Util.round(Math.abs(c)*Math.sqrt(((f.x-a.x)*(f.x-a.x)+(f.y-a.y)*(f.y-a.y))))
},distanceLineToLine:function(j,g){var f=this.convertCoordinate(j[0]),e=this.convertCoordinate(j[1]),d=this.convertCoordinate(g[0]),b=this.convertCoordinate(g[1]),c,l,k,h,m,a;
if(f.isEquals(e)){return this.distanceToLine(f,[d,b])
}if(d.isEquals(b)){return this.distanceToLine(b,[f,e])
}c=(f.y-d.y)*(b.x-d.x)-(f.x-d.x)*(b.y-d.y);
l=(e.x-f.x)*(b.y-d.y)-(e.y-f.y)*(b.x-d.x);
k=(f.y-d.y)*(e.x-f.x)-(f.x-d.x)*(e.y-f.y);
h=(e.x-f.x)*(b.y-d.y)-(e.y-f.y)*(b.x-d.x);
if((l===0)||(h===0)){return Math.min(this.distanceToLine(f,[d,b]),Math.min(this.distanceToLine(e,[d,b]),Math.min(this.distanceToLine(d,[f,e]),this.distanceToLine(b,[f,e]))))
}m=k/h;
a=c/l;
if((a<0)||(a>1)||(m<0)||(m>1)){return Math.min(this.distanceToLine(f,[d,b]),Math.min(this.distanceToLine(e,[d,b]),Math.min(this.distanceToLine(d,[f,e]),this.distanceToLine(b,[f,e]))))
}return 0
},intersectToLine:function(c){var d=this.getVertices(),b=[],a,f,e=function(h,j){var g;
for(g=0;
g<h.length;
g++){if(h[g].isEquals(j)){return true
}}return false
};
for(f=0;
f<d.length-1;
f++){a=this.intersectLineToLine(c,[d[f],d[f+1]]);
if(a&&!e(b,a)){b.push(a)
}}return b
},intersectLineToLine:function(k,h){var f=this.convertCoordinate(k[0]),e=this.convertCoordinate(k[1]),d=this.convertCoordinate(h[0]),c=this.convertCoordinate(h[1]),o,g,b,m,l,j,a,n;
if(f.isEquals(e)){return this.distanceToLine(f,[d,c])===0?f:undefined
}if(d.isEquals(c)){return this.distanceToLine(d,[f,e])===0?d:undefined
}b=(f.y-d.y)*(c.x-d.x)-(f.x-d.x)*(c.y-d.y);
m=(e.x-f.x)*(c.y-d.y)-(e.y-f.y)*(c.x-d.x);
l=(f.y-d.y)*(e.x-f.x)-(f.x-d.x)*(e.y-f.y);
j=(e.x-f.x)*(c.y-d.y)-(e.y-f.y)*(c.x-d.x);
if(m!==0&&j!==0){a=b/m;
n=l/j;
if(0<=a&&a<=1&&0<=n&&n<=1){g="Intersection";
o=new OG.Coordinate(OG.Util.round(f.x+a*(e.x-f.x)),OG.Util.round(f.y+a*(e.y-f.y)))
}else{g="No Intersection"
}}else{if(b===0||l===0){g="Coincident"
}else{g="Parallel"
}}return o
},intersectCircleToLine:function(c,k,p,q){var r=[],o=(q.x-p.x)*(q.x-p.x)+(q.y-p.y)*(q.y-p.y),n=2*((q.x-p.x)*(p.x-c.x)+(q.y-p.y)*(p.y-c.y)),j=c.x*c.x+c.y*c.y+p.x*p.x+p.y*p.y-2*(c.x*p.x+c.y*p.y)-k*k,d=n*n-4*o*j,m,h=function(e,b,a){return new OG.Coordinate(OG.Util.round(e.x+(b.x-e.x)*a),OG.Util.round(e.y+(b.y-e.y)*a))
},l,g,f;
if(d<0){m="Outside"
}else{if(d===0){m="Tangent"
}else{l=Math.sqrt(d);
g=(-n+l)/(2*o);
f=(-n-l)/(2*o);
if((g<0||g>1)&&(f<0||f>1)){if((g<0&&f<0)||(g>1&&f>1)){m="Outside"
}else{m="Inside"
}}else{m="Intersection";
if(0<=g&&g<=1){r.push(h(p,q,g))
}if(0<=f&&f<=1){r.push(h(p,q,f))
}}}}return r
},reset:function(){this.boundary=null
}};
OG.geometry.Geometry.prototype.constructor=OG.geometry.Geometry;
OG.geometry.PolyLine=function(a){var b;
this.TYPE=OG.Constants.GEOM_TYPE.POLYLINE;
this.style=new OG.geometry.Style();
this.vertices=[];
if(a&&a.length>0){for(b=0;
b<a.length;
b++){this.vertices.push(this.convertCoordinate(a[b]))
}}};
OG.geometry.PolyLine.prototype=new OG.geometry.Geometry();
OG.geometry.PolyLine.superclass=OG.geometry.Geometry;
OG.geometry.PolyLine.prototype.constructor=OG.geometry.PolyLine;
OG.PolyLine=OG.geometry.PolyLine;
OG.geometry.PolyLine.prototype.getVertices=function(){return this.vertices
};
OG.geometry.PolyLine.prototype.move=function(a,c){var b;
this.getBoundary().move(a,c);
for(b=0;
b<this.vertices.length;
b++){this.vertices[b].move(a,c)
}return this
};
OG.geometry.PolyLine.prototype.resize=function(l,g,d,m){var c=this.getBoundary(),h=d+m,f=l+g,b=c.getWidth()+h,n=c.getHeight()+f,k=c.getWidth()===0?1:b/c.getWidth(),j=c.getHeight()===0?1:n/c.getHeight(),a=c.getUpperLeft(),e;
if(b<0||n<0){throw new OG.ParamError()
}for(e=0;
e<this.vertices.length;
e++){this.vertices[e].x=OG.Util.round((a.x-d)+(this.vertices[e].x-a.x)*k);
this.vertices[e].y=OG.Util.round((a.y-l)+(this.vertices[e].y-a.y)*j)
}c.resize(l,g,d,m);
return this
};
OG.geometry.PolyLine.prototype.rotate=function(c,a){var b;
a=a||this.getCentroid();
for(b=0;
b<this.vertices.length;
b++){this.vertices[b].rotate(c,a)
}this.reset();
return this
};
OG.geometry.PolyLine.prototype.toString=function(){var a=[];
a.push("type:'"+OG.Constants.GEOM_NAME[this.TYPE]+"'");
a.push("vertices:["+this.vertices+"]");
return"{"+a.join()+"}"
};
OG.geometry.Curve=function(controlPoints){OG.geometry.Curve.superclass.call(this,controlPoints);
var t,cmRomSpline=OG.CurveUtil.CatmullRomSpline(eval("["+this.vertices.toString()+"]"));
this.vertices=[];
for(t=0;
t<=cmRomSpline.maxT;
t+=0.1){this.vertices.push(new OG.geometry.Coordinate(OG.Util.round(cmRomSpline.getX(t)),OG.Util.round(cmRomSpline.getY(t))))
}this.TYPE=OG.Constants.GEOM_TYPE.CURVE;
this.style=new OG.geometry.Style()
};
OG.geometry.Curve.prototype=new OG.geometry.PolyLine();
OG.geometry.Curve.superclass=OG.geometry.PolyLine;
OG.geometry.Curve.prototype.constructor=OG.geometry.Curve;
OG.Curve=OG.geometry.Curve;
OG.geometry.Curve.prototype.getControlPoints=function(){var a=[],b;
for(b=10;
b<=this.vertices.length-10;
b+=10){a.push(this.vertices[b])
}return a
};
OG.geometry.Curve.prototype.getVertices=function(){var a=[],b;
for(b=10;
b<=this.vertices.length-10;
b++){a.push(this.vertices[b])
}return a
};
OG.geometry.Curve.prototype.toString=function(){var a=[];
a.push("type:'"+OG.Constants.GEOM_NAME[this.TYPE]+"'");
a.push("vertices:["+this.getVertices()+"]");
a.push("controlPoints:["+this.getControlPoints()+"]");
return"{"+a.join()+"}"
};
OG.geometry.Ellipse=function(a,c,b,e){var g=e||0,h=this.convertCoordinate(a),j=[],d,f;
if(h){for(f=-45;
f<=405;
f+=45){d=Math.PI/180*f;
j.push((new OG.geometry.Coordinate(OG.Util.round(h.x+c*Math.cos(d)),OG.Util.round(h.y+b*Math.sin(d)))).rotate(g,h))
}}OG.geometry.Ellipse.superclass.call(this,j);
this.TYPE=OG.Constants.GEOM_TYPE.ELLIPSE;
this.IS_CLOSED=true;
this.style=new OG.geometry.Style()
};
OG.geometry.Ellipse.prototype=new OG.geometry.Curve();
OG.geometry.Ellipse.superclass=OG.geometry.Curve;
OG.geometry.Ellipse.prototype.constructor=OG.geometry.Ellipse;
OG.Ellipse=OG.geometry.Ellipse;
OG.geometry.Ellipse.prototype.getVertices=function(){var a=[],b;
for(b=20;
b<this.vertices.length-20;
b++){a.push(this.vertices[b])
}return a
};
OG.geometry.Ellipse.prototype.getControlPoints=function(){var a=[],b;
for(b=10;
b<=this.vertices.length-10;
b+=10){a.push(this.vertices[b])
}return a
};
OG.geometry.Ellipse.prototype.getLength=function(){var b=this.getControlPoints(),a=this.getCentroid(),d=a.distance(b[1]),c=a.distance(b[3]);
return Math.PI*(5*(d+c)/4-d*c/(d+c))
};
OG.geometry.Ellipse.prototype.toString=function(){var c=[],b=this.getControlPoints(),a=this.getCentroid(),f=a.distance(b[1]),d=a.distance(b[3]),e=OG.Util.round(Math.atan2(b[1].y-a.y,b[1].x-a.x)*180/Math.PI);
c.push("type:'"+OG.Constants.GEOM_NAME[this.TYPE]+"'");
c.push("center:"+a);
c.push("radiusX:"+f);
c.push("radiusY:"+d);
c.push("angle:"+e);
return"{"+c.join()+"}"
};
OG.geometry.BezierCurve=function(controlPoints){var bezier,t,i;
if(!controlPoints&&controlPoints.length!==4){throw new OG.ParamError()
}this.controlPoints=[];
if(controlPoints&&controlPoints.length>0){for(i=0;
i<controlPoints.length;
i++){this.controlPoints.push(this.convertCoordinate(controlPoints[i]))
}}bezier=OG.CurveUtil.Bezier(eval("["+this.controlPoints.toString()+"]"));
this.vertices=[];
for(t=0;
t<=bezier.maxT;
t+=0.02){this.vertices.push(new OG.geometry.Coordinate(OG.Util.round(bezier.getX(t)),OG.Util.round(bezier.getY(t))))
}this.TYPE=OG.Constants.GEOM_TYPE.BEZIER_CURVE;
this.style=new OG.geometry.Style()
};
OG.geometry.BezierCurve.prototype=new OG.geometry.PolyLine();
OG.geometry.BezierCurve.superclass=OG.geometry.PolyLine;
OG.geometry.BezierCurve.prototype.constructor=OG.geometry.BezierCurve;
OG.BezierCurve=OG.geometry.BezierCurve;
OG.geometry.BezierCurve.prototype.getControlPoints=function(){return this.controlPoints
};
OG.geometry.BezierCurve.prototype.getVertices=function(){var bezier,t,i;
if(!this.vertices){bezier=OG.CurveUtil.Bezier(eval("["+this.controlPoints.toString()+"]"));
this.vertices=[];
for(t=0;
t<=bezier.maxT;
t+=0.02){this.vertices.push(new OG.geometry.Coordinate(OG.Util.round(bezier.getX(t)),OG.Util.round(bezier.getY(t))))
}}return this.vertices
};
OG.geometry.BezierCurve.prototype.move=function(a,c){var b;
for(b=0;
b<this.controlPoints.length;
b++){this.controlPoints[b].move(a,c)
}this.reset();
return this
};
OG.geometry.BezierCurve.prototype.resize=function(c,a,d,b){throw new OG.NotSupportedException("OG.geometry.BezierCurve.resize() Not Supported!")
};
OG.geometry.BezierCurve.prototype.rotate=function(c,a){var b;
a=a||this.getCentroid();
for(b=0;
b<this.controlPoints.length;
b++){this.controlPoints[b].rotate(c,a)
}this.reset();
return this
};
OG.geometry.BezierCurve.prototype.toString=function(){var a=[];
a.push("type:'"+OG.Constants.GEOM_NAME[this.TYPE]+"'");
a.push("vertices:["+this.getVertices()+"]");
a.push("controlPoints:["+this.getControlPoints()+"]");
return"{"+a.join()+"}"
};
OG.geometry.BezierCurve.prototype.reset=function(){this.boundary=null;
this.vertices=null
};
OG.geometry.Circle=function(b,a){OG.geometry.Circle.superclass.call(this,b,a,a,0);
this.TYPE=OG.Constants.GEOM_TYPE.CIRCLE;
this.style=new OG.geometry.Style()
};
OG.geometry.Circle.prototype=new OG.geometry.Ellipse();
OG.geometry.Circle.superclass=OG.geometry.Ellipse;
OG.geometry.Circle.prototype.constructor=OG.geometry.Circle;
OG.Circle=OG.geometry.Circle;
OG.geometry.Circle.prototype.getLength=function(){var b=this.getControlPoints(),a=this.getCentroid(),c=a.distance(b[1]);
return 2*Math.PI*c
};
OG.geometry.Circle.prototype.toString=function(){var c=[],b=this.getControlPoints(),a=this.getCentroid(),f=a.distance(b[1]),d=a.distance(b[3]),e=OG.Util.round(Math.atan2(b[1].y-a.y,b[1].x-a.x)*180/Math.PI);
if(f===d){c.push("type:'"+OG.Constants.GEOM_NAME[this.TYPE]+"'");
c.push("center:"+a);
c.push("radius:"+f)
}else{c.push("type:'"+OG.Constants.GEOM_NAME[OG.Constants.GEOM_TYPE.ELLIPSE]+"'");
c.push("center:"+a);
c.push("radiusX:"+f);
c.push("radiusY:"+d);
c.push("angle:"+e)
}return"{"+c.join()+"}"
};
OG.geometry.GeometryCollection=function(a){this.TYPE=OG.Constants.GEOM_TYPE.COLLECTION;
this.style=new OG.geometry.Style();
this.geometries=a
};
OG.geometry.GeometryCollection.prototype=new OG.geometry.Geometry();
OG.geometry.GeometryCollection.superclass=OG.geometry.Geometry;
OG.geometry.GeometryCollection.prototype.constructor=OG.geometry.GeometryCollection;
OG.GeometryCollection=OG.geometry.GeometryCollection;
OG.geometry.GeometryCollection.prototype.getVertices=function(){var b=[],d,c,a;
for(c=0;
c<this.geometries.length;
c++){d=this.geometries[c].getVertices();
for(a=0;
a<d.length;
a++){b.push(d[a])
}}return b
};
OG.geometry.GeometryCollection.prototype.move=function(a,c){var b;
this.getBoundary().move(a,c);
for(b=0;
b<this.geometries.length;
b++){this.geometries[b].move(a,c);
this.geometries[b].reset()
}return this
};
OG.geometry.GeometryCollection.prototype.resize=function(o,h,d,p){var c=this.getBoundary(),k=d+p,g=o+h,b=c.getWidth()+k,q=c.getHeight()+g,n=c.getWidth()===0?1:b/c.getWidth(),m=c.getHeight()===0?1:q/c.getHeight(),a=c.getUpperLeft(),l,f,e;
if(b<0||q<0){throw new OG.ParamError()
}for(f=0;
f<this.geometries.length;
f++){l=this.geometries[f].vertices;
for(e=0;
e<l.length;
e++){l[e].x=OG.Util.round((a.x-d)+(l[e].x-a.x)*n);
l[e].y=OG.Util.round((a.y-o)+(l[e].y-a.y)*m)
}this.geometries[f].reset()
}c.resize(o,h,d,p);
return this
};
OG.geometry.GeometryCollection.prototype.resizeBox=function(d,a){var e=this.getBoundary(),c=OG.Util.round((d-e.getWidth())/2),b=OG.Util.round((a-e.getHeight())/2);
this.resize(b,b,c,c);
return this
};
OG.geometry.GeometryCollection.prototype.rotate=function(c,a){var b;
a=a||this.getCentroid();
for(b=0;
b<this.geometries.length;
b++){this.geometries[b].rotate(c,a);
this.geometries[b].reset()
}this.reset();
return this
};
OG.geometry.GeometryCollection.prototype.fitToBoundary=function(e){var f=this.getBoundary(),c=f.getUpperCenter().y-e.getUpperCenter().y,a=e.getLowerCenter().y-f.getLowerCenter().y,d=f.getLeftCenter().x-e.getLeftCenter().x,b=e.getRightCenter().x-f.getRightCenter().x;
this.resize(c,a,d,b);
return this
};
OG.geometry.GeometryCollection.prototype.toString=function(){var b=[],a;
for(a=0;
a<this.geometries.length;
a++){b.push(this.geometries[a].toString())
}return"{type:'"+OG.Constants.GEOM_NAME[this.TYPE]+"',geometries:["+b.join()+"]}"
};
OG.geometry.Line=function(d,c){var b=this.convertCoordinate(d),a=this.convertCoordinate(c);
OG.geometry.Line.superclass.call(this,[[b.x,b.y],[a.x,a.y]]);
this.TYPE=OG.Constants.GEOM_TYPE.LINE;
this.style=new OG.geometry.Style()
};
OG.geometry.Line.prototype=new OG.geometry.PolyLine();
OG.geometry.Line.superclass=OG.geometry.PolyLine;
OG.geometry.Line.prototype.constructor=OG.geometry.Line;
OG.Line=OG.geometry.Line;
OG.geometry.Line.prototype.toString=function(){var a=[];
a.push("type:'"+OG.Constants.GEOM_NAME[this.TYPE]+"'");
a.push("from:"+this.vertices[0]);
a.push("to:"+this.vertices[1]);
return"{"+a.join()+"}"
};
OG.geometry.Point=function(a){this.TYPE=OG.Constants.GEOM_TYPE.POINT;
this.style=new OG.geometry.Style();
this.coordinate=this.convertCoordinate(a);
this.vertices=[this.coordinate]
};
OG.geometry.Point.prototype=new OG.geometry.Geometry();
OG.geometry.Point.superclass=OG.geometry.Geometry;
OG.geometry.Point.prototype.constructor=OG.geometry.Point;
OG.Point=OG.geometry.Point;
OG.geometry.Point.prototype.getVertices=function(){return this.vertices
};
OG.geometry.Point.prototype.move=function(a,b){this.getBoundary().move(a,b);
this.coordinate.move(a,b);
this.vertices=[this.coordinate];
return this
};
OG.geometry.Point.prototype.moveCentroid=function(a){this.getBoundary().setUpperLeft(a);
this.coordinate=new OG.geometry.Coordinate(a);
this.vertices=[this.coordinate]
};
OG.geometry.Point.prototype.resize=function(c,a,d,b){var e=this.getBoundary();
e.resize(c,a,d,b);
this.coordinate=e.getCentroid();
this.vertices=[this.coordinate];
this.boundary=new OG.Envelope(this.coordinate,0,0);
return this
};
OG.geometry.Point.prototype.resizeBox=function(b,a){return this
};
OG.geometry.Point.prototype.rotate=function(b,a){a=a||this.getCentroid();
this.coordinate.rotate(b,a);
this.vertices=[this.coordinate];
this.reset();
return this
};
OG.geometry.Point.prototype.fitToBoundary=function(a){this.coordinate=a.getCentroid();
this.vertices=[this.coordinate];
this.boundary=new OG.Envelope(this.coordinate,0,0);
return this
};
OG.geometry.Point.prototype.toString=function(){var a=[];
a.push("type:'"+OG.Constants.GEOM_NAME[this.TYPE]+"'");
a.push("coordinate:"+this.coordinate);
return"{"+a.join()+"}"
};
OG.geometry.Polygon=function(a){OG.geometry.Polygon.superclass.call(this,a);
if(this.vertices.length>0&&!this.vertices[0].isEquals(this.vertices[this.vertices.length-1])){this.vertices.push(new OG.geometry.Coordinate(this.vertices[0].x,this.vertices[0].y))
}this.TYPE=OG.Constants.GEOM_TYPE.POLYGON;
this.IS_CLOSED=true;
this.style=new OG.geometry.Style()
};
OG.geometry.Polygon.prototype=new OG.geometry.PolyLine();
OG.geometry.Polygon.superclass=OG.geometry.PolyLine;
OG.geometry.Polygon.prototype.constructor=OG.geometry.Polygon;
OG.Polygon=OG.geometry.Polygon;
OG.geometry.Rectangle=function(c,d,a){var b=this.convertCoordinate(c),e=this.convertCoordinate([b.x+d,b.y+a]);
if(b.x>e.x||b.y>e.y){throw new OG.ParamError()
}OG.geometry.Rectangle.superclass.call(this,[[b.x,b.y],[b.x+(e.x-b.x),b.y],[e.x,e.y],[b.x,b.y+(e.y-b.y)],[b.x,b.y]]);
this.TYPE=OG.Constants.GEOM_TYPE.RECTANGLE;
this.style=new OG.geometry.Style()
};
OG.geometry.Rectangle.prototype=new OG.geometry.Polygon();
OG.geometry.Rectangle.superclass=OG.geometry.Polygon;
OG.geometry.Rectangle.prototype.constructor=OG.geometry.Rectangle;
OG.Rectangle=OG.geometry.Rectangle;
OG.geometry.Rectangle.prototype.toString=function(){var a=[],b=OG.Util.round(Math.atan2(this.vertices[1].y-this.vertices[0].y,this.vertices[1].x-this.vertices[0].x)*180/Math.PI);
a.push("type:'"+OG.Constants.GEOM_NAME[this.TYPE]+"'");
a.push("upperLeft:"+this.vertices[0]);
a.push("width:"+(this.vertices[0].distance(this.vertices[1])));
a.push("height:"+(this.vertices[0].distance(this.vertices[3])));
a.push("angle:"+b);
return"{"+a.join()+"}"
};
OG.shape.IShape=function(){this.TYPE=null;
this.SHAPE_ID=null;
this.geom=null;
this.label=null;
this.isCollapsed=false;
this.SELECTABLE=true;
this.MOVABLE=true;
this.RESIZABLE=true;
this.CONNECTABLE=true;
this.SELF_CONNECTABLE=true;
this.CONNECT_CLONEABLE=true;
this.CONNECT_REQUIRED=true;
this.LABEL_EDITABLE=true
};
OG.shape.IShape.prototype={createTerminal:function(){if(!this.geom){return[]
}var a=this.geom.getBoundary();
return[new OG.Terminal(a.getCentroid(),OG.Constants.TERMINAL_TYPE.C,OG.Constants.TERMINAL_TYPE.INOUT),new OG.Terminal(a.getRightCenter(),OG.Constants.TERMINAL_TYPE.E,OG.Constants.TERMINAL_TYPE.INOUT),new OG.Terminal(a.getLeftCenter(),OG.Constants.TERMINAL_TYPE.W,OG.Constants.TERMINAL_TYPE.INOUT),new OG.Terminal(a.getLowerCenter(),OG.Constants.TERMINAL_TYPE.S,OG.Constants.TERMINAL_TYPE.INOUT),new OG.Terminal(a.getUpperCenter(),OG.Constants.TERMINAL_TYPE.N,OG.Constants.TERMINAL_TYPE.INOUT)]
},createShape:function(){throw new OG.NotImplementedException("OG.shape.IShape.createShape")
},clone:function(){throw new OG.NotImplementedException("OG.shape.IShape.clone")
}};
OG.shape.IShape.prototype.constructor=OG.shape.IShape;
OG.IShape=OG.shape.IShape;
OG.shape.GeomShape=function(){OG.shape.GeomShape.superclass.call(this);
this.TYPE=OG.Constants.SHAPE_TYPE.GEOM
};
OG.shape.GeomShape.prototype=new OG.shape.IShape();
OG.shape.GeomShape.superclass=OG.shape.IShape;
OG.shape.GeomShape.prototype.constructor=OG.shape.GeomShape;
OG.GeomShape=OG.shape.GeomShape;
OG.shape.GeomShape.prototype.clone=function(){var shape=eval("new "+this.SHAPE_ID+"()");
shape.label=this.label;
return shape
};
OG.shape.EdgeShape=function(e,d,a,b,c){OG.shape.EdgeShape.superclass.call(this);
this.TYPE=OG.Constants.SHAPE_TYPE.EDGE;
this.SHAPE_ID="OG.shape.EdgeShape";
this.from=e;
this.to=d;
this.label=a;
this.fromLabel=b;
this.toLabel=c
};
OG.shape.EdgeShape.prototype=new OG.shape.IShape();
OG.shape.EdgeShape.superclass=OG.shape.IShape;
OG.shape.EdgeShape.prototype.constructor=OG.shape.EdgeShape;
OG.EdgeShape=OG.shape.EdgeShape;
OG.shape.EdgeShape.prototype.createShape=function(){if(this.geom){return this.geom
}this.geom=new OG.Line(this.from,this.to);
return this.geom
};
OG.shape.EdgeShape.prototype.createTerminal=function(){return[]
};
OG.shape.EdgeShape.prototype.clone=function(){var shape=eval("new "+this.SHAPE_ID+"()");
shape.from=this.from;
shape.to=this.to;
shape.label=this.label;
shape.fromLabel=this.fromLabel;
shape.toLabel=this.toLabel;
return shape
};
OG.shape.EllipseShape=function(a){OG.shape.EllipseShape.superclass.call(this);
this.SHAPE_ID="OG.shape.EllipseShape";
this.label=a
};
OG.shape.EllipseShape.prototype=new OG.shape.GeomShape();
OG.shape.EllipseShape.superclass=OG.shape.GeomShape;
OG.shape.EllipseShape.prototype.constructor=OG.shape.EllipseShape;
OG.EllipseShape=OG.shape.EllipseShape;
OG.shape.EllipseShape.prototype.createShape=function(){if(this.geom){return this.geom
}this.geom=new OG.geometry.Ellipse([50,50],50,30);
return this.geom
};
OG.shape.CircleShape=function(a){OG.shape.CircleShape.superclass.call(this);
this.SHAPE_ID="OG.shape.CircleShape";
this.label=a
};
OG.shape.CircleShape.prototype=new OG.shape.GeomShape();
OG.shape.CircleShape.superclass=OG.shape.GeomShape;
OG.shape.CircleShape.prototype.constructor=OG.shape.CircleShape;
OG.CircleShape=OG.shape.CircleShape;
OG.shape.CircleShape.prototype.createShape=function(){if(this.geom){return this.geom
}this.geom=new OG.geometry.Circle([50,50],50);
return this.geom
};
OG.shape.GroupShape=function(a){OG.shape.GroupShape.superclass.call(this);
this.TYPE=OG.Constants.SHAPE_TYPE.GROUP;
this.SHAPE_ID="OG.shape.GroupShape";
this.label=a;
this.CONNECTABLE=false;
this.SELF_CONNECTABLE=false;
this.GROUP_DROPABLE=true;
this.GROUP_COLLAPSIBLE=true
};
OG.shape.GroupShape.prototype=new OG.shape.IShape();
OG.shape.GroupShape.superclass=OG.shape.IShape;
OG.shape.GroupShape.prototype.constructor=OG.shape.GroupShape;
OG.GroupShape=OG.shape.GroupShape;
OG.shape.GroupShape.prototype.createShape=function(){if(this.geom){return this.geom
}this.geom=new OG.geometry.Rectangle([0,0],100,100);
this.geom.style=new OG.geometry.Style({stroke:"none"});
return this.geom
};
OG.shape.GroupShape.prototype.clone=function(){var shape=eval("new "+this.SHAPE_ID+"()");
shape.label=this.label;
return shape
};
OG.shape.HorizontalLaneShape=function(a){OG.shape.HorizontalLaneShape.superclass.call(this,a);
this.SHAPE_ID="OG.shape.HorizontalLaneShape"
};
OG.shape.HorizontalLaneShape.prototype=new OG.shape.GroupShape();
OG.shape.HorizontalLaneShape.superclass=OG.shape.GroupShape;
OG.shape.HorizontalLaneShape.prototype.constructor=OG.shape.HorizontalLaneShape;
OG.HorizontalLaneShape=OG.shape.HorizontalLaneShape;
OG.shape.HorizontalLaneShape.prototype.createShape=function(){if(this.geom){return this.geom
}this.geom=new OG.geometry.Rectangle([0,0],100,100);
this.geom.style=new OG.geometry.Style({"label-direction":"vertical","vertical-align":"top"});
return this.geom
};
OG.shape.HtmlShape=function(b,a){OG.shape.HtmlShape.superclass.call(this);
this.TYPE=OG.Constants.SHAPE_TYPE.HTML;
this.SHAPE_ID="OG.shape.HtmlShape";
this.label=a;
this.html=b||"";
this.angle=0;
LABEL_EDITABLE:false
};
OG.shape.HtmlShape.prototype=new OG.shape.IShape();
OG.shape.HtmlShape.superclass=OG.shape.IShape;
OG.shape.HtmlShape.prototype.constructor=OG.shape.HtmlShape;
OG.HtmlShape=OG.shape.HtmlShape;
OG.shape.HtmlShape.prototype.createShape=function(){return this.html
};
OG.shape.HtmlShape.prototype.clone=function(){var shape=eval("new "+this.SHAPE_ID+"()");
shape.html=this.html;
shape.label=this.label;
shape.angle=this.angle;
return shape
};
OG.shape.ImageShape=function(b,a){OG.shape.ImageShape.superclass.call(this);
this.TYPE=OG.Constants.SHAPE_TYPE.IMAGE;
this.SHAPE_ID="OG.shape.ImageShape";
this.label=a;
this.image=b;
this.angle=0;
LABEL_EDITABLE:false
};
OG.shape.ImageShape.prototype=new OG.shape.IShape();
OG.shape.ImageShape.superclass=OG.shape.IShape;
OG.shape.ImageShape.prototype.constructor=OG.shape.ImageShape;
OG.ImageShape=OG.shape.ImageShape;
OG.shape.ImageShape.prototype.createShape=function(){return this.image
};
OG.shape.ImageShape.prototype.clone=function(){var shape=eval("new "+this.SHAPE_ID+"()");
shape.image=this.image;
shape.label=this.label;
shape.angle=this.angle;
return shape
};
OG.shape.RectangleShape=function(a){OG.shape.RectangleShape.superclass.call(this);
this.SHAPE_ID="OG.shape.RectangleShape";
this.label=a
};
OG.shape.RectangleShape.prototype=new OG.shape.GeomShape();
OG.shape.RectangleShape.superclass=OG.shape.GeomShape;
OG.shape.RectangleShape.prototype.constructor=OG.shape.RectangleShape;
OG.RectangleShape=OG.shape.RectangleShape;
OG.shape.RectangleShape.prototype.createShape=function(){if(this.geom){return this.geom
}this.geom=new OG.geometry.Rectangle([0,0],100,100);
return this.geom
};
OG.shape.Terminal=function(a,c,b){this.position=a;
this.direction=c||OG.Constants.TERMINAL_TYPE.E;
this.inout=b||OG.Constants.TERMINAL_TYPE.INOUT
};
OG.shape.Terminal.prototype=new OG.shape.Terminal();
OG.shape.Terminal.prototype.constructor=OG.shape.Terminal;
OG.Terminal=OG.shape.Terminal;
OG.shape.TextShape=function(a){OG.shape.TextShape.superclass.call(this);
this.TYPE=OG.Constants.SHAPE_TYPE.TEXT;
this.SHAPE_ID="OG.shape.TextShape";
this.text=a||"Text Here";
this.angle=0
};
OG.shape.TextShape.prototype=new OG.shape.IShape();
OG.shape.TextShape.superclass=OG.shape.IShape;
OG.shape.TextShape.prototype.constructor=OG.shape.TextShape;
OG.TextShape=OG.shape.TextShape;
OG.shape.TextShape.prototype.createShape=function(){return this.text
};
OG.shape.TextShape.prototype.createTerminal=function(){return[]
};
OG.shape.TextShape.prototype.clone=function(){var shape=eval("new "+this.SHAPE_ID+"()");
shape.text=this.text;
shape.angle=this.angle;
return shape
};
OG.shape.VerticalLaneShape=function(a){OG.shape.VerticalLaneShape.superclass.call(this,a);
this.SHAPE_ID="OG.shape.VerticalLaneShape"
};
OG.shape.VerticalLaneShape.prototype=new OG.shape.GroupShape();
OG.shape.VerticalLaneShape.superclass=OG.shape.GroupShape;
OG.shape.VerticalLaneShape.prototype.constructor=OG.shape.VerticalLaneShape;
OG.VerticalLaneShape=OG.shape.VerticalLaneShape;
OG.shape.VerticalLaneShape.prototype.createShape=function(){if(this.geom){return this.geom
}this.geom=new OG.geometry.Rectangle([0,0],100,100);
this.geom.style=new OG.geometry.Style({"label-direction":"horizontal","vertical-align":"top"});
return this.geom
};
OG.renderer.IRenderer=function(a,e,b,d,c){this._CONFIG=null;
this._PAPER=null;
this._ROOT_GROUP=null;
this._ETC_GROUP=null;
this._ID_PREFIX=Math.round(Math.random()*10000);
this._LAST_ID=0;
this._ELE_MAP=new OG.HashMap()
};
OG.renderer.IRenderer.prototype={_genId:function(){var a="OG_"+this._ID_PREFIX+"_"+this._LAST_ID;
this._LAST_ID++;
return a
},_bezierCurve:function(k,l,j,d){var e=100,g=[1,0],f=[-1,0],c,b,a,h=[];
c=Math.sqrt(Math.pow(k[0]-l[0],2)+Math.pow(k[1]-l[1],2));
if(c<e){e=c/2
}switch(j.toLowerCase()){case"e":g=[1,0];
break;
case"w":g=[-1,0];
break;
case"s":g=[0,1];
break;
case"n":g=[0,-1];
break;
default:g=[1,0];
break
}switch(d.toLowerCase()){case"e":f=[1,0];
break;
case"w":f=[-1,0];
break;
case"s":f=[0,1];
break;
case"n":f=[0,-1];
break;
default:f=[-1,0];
break
}b=[g[0]*e,g[1]*e];
a=[f[0]*e,f[1]*e];
h[0]=k;
h[1]=[k[0]+b[0],k[1]+b[1]];
h[2]=[l[0]+a[0],l[1]+a[1]];
h[3]=l;
return h
},_adjustEdgeDirection:function(c,b,f,e){var a={x:f[0],y:f[1]},d={x:e[0],y:e[1]};
if(c==="c"&&b==="c"){if(a.x<=d.x&&a.y<=d.y){if(Math.abs(d.x-a.x)>Math.abs(d.y-a.y)){c="e";
b="w"
}else{c="s";
b="n"
}}else{if(a.x<=d.x&&a.y>d.y){if(Math.abs(d.x-a.x)>Math.abs(d.y-a.y)){c="e";
b="w"
}else{c="n";
b="s"
}}else{if(a.x>d.x&&a.y<=d.y){if(Math.abs(d.x-a.x)>Math.abs(d.y-a.y)){c="w";
b="e"
}else{c="s";
b="n"
}}else{if(a.x>d.x&&a.y>d.y){if(Math.abs(d.x-a.x)>Math.abs(d.y-a.y)){c="w";
b="e"
}else{c="n";
b="s"
}}}}}}else{if(c==="c"&&b!=="c"){if(a.x<=d.x&&a.y<=d.y){if(Math.abs(d.x-a.x)>Math.abs(d.y-a.y)){c="e"
}else{c="s"
}}else{if(a.x<=d.x&&a.y>d.y){if(Math.abs(d.x-a.x)>Math.abs(d.y-a.y)){c="e"
}else{c="n"
}}else{if(a.x>d.x&&a.y<=d.y){if(Math.abs(d.x-a.x)>Math.abs(d.y-a.y)){c="w"
}else{c="s"
}}else{if(a.x>d.x&&a.y>d.y){if(Math.abs(d.x-a.x)>Math.abs(d.y-a.y)){c="w"
}else{c="n"
}}}}}}else{if(c!=="c"&&b==="c"){if(a.x<=d.x&&a.y<=d.y){if(Math.abs(d.x-a.x)>Math.abs(d.y-a.y)){b="w"
}else{b="n"
}}else{if(a.x<=d.x&&a.y>d.y){if(Math.abs(d.x-a.x)>Math.abs(d.y-a.y)){b="w"
}else{b="s"
}}else{if(a.x>d.x&&a.y<=d.y){if(Math.abs(d.x-a.x)>Math.abs(d.y-a.y)){b="e"
}else{b="n"
}}else{if(a.x>d.x&&a.y>d.y){if(Math.abs(d.x-a.x)>Math.abs(d.y-a.y)){b="e"
}else{b="s"
}}}}}}}}return c+" "+b
},_findFromTerminal:function(c,h,j){var f={x:h[0],y:h[1]},a={x:j[0],y:j[1]},k=this.drawTerminal(c),d=k.terminal.childNodes,g,e,b;
if(Math.abs(a.x-f.x)>Math.abs(a.y-f.y)){if(a.x>f.x){g="e"
}else{g="w"
}}else{if(a.y>f.y){g="s"
}else{g="n"
}}e=d[0];
for(b=0;
b<d.length;
b++){if(d[b].terminal&&d[b].terminal.direction.toLowerCase()===g){e=d[b];
break
}}return e
},_findToTerminal:function(c,g,h){var f={x:g[0],y:g[1]},a={x:h[0],y:h[1]},j=this.drawTerminal(c),d=j.terminal.childNodes,e,k,b;
if(Math.abs(a.x-f.x)>Math.abs(a.y-f.y)){if(a.x>f.x){e="w"
}else{e="e"
}}else{if(a.y>f.y){e="n"
}else{e="s"
}}k=d[0];
for(b=0;
b<d.length;
b++){if(d[b].terminal&&d[b].terminal.direction.toLowerCase()===e){k=d[b];
break
}}return k
},_getShapeFromTerminal:function(a){var b=OG.Util.isElement(a)?a.id:a;
if(b){return this.getElementById(b.substring(0,b.indexOf(OG.Constants.TERMINAL_SUFFIX.GROUP)))
}else{return null
}},drawShape:function(a,b,c,d,e){throw new OG.NotImplementedException()
},drawGeom:function(b,a,c){throw new OG.NotImplementedException()
},drawText:function(a,d,b,c,e){throw new OG.NotImplementedException()
},drawImage:function(a,d,b,c,e){throw new OG.NotImplementedException()
},drawEdge:function(a,c,d,b){throw new OG.NotImplementedException()
},drawLabel:function(a,c,b){throw new OG.NotImplementedException()
},drawEdgeLabel:function(a,c,b){throw new OG.NotImplementedException()
},redrawShape:function(a,b){throw new OG.NotImplementedException()
},redrawEdge:function(a){throw new OG.NotImplementedException()
},redrawConnectedEdge:function(a,b){throw new OG.NotImplementedException()
},connect:function(e,d,c,b,a){throw new OG.NotImplementedException()
},disconnect:function(a){throw new OG.NotImplementedException()
},drawDropOverGuide:function(a){throw new OG.NotImplementedException()
},drawGuide:function(a){throw new OG.NotImplementedException()
},removeGuide:function(a){throw new OG.NotImplementedException()
},removeAllGuide:function(){throw new OG.NotImplementedException()
},drawEdgeGuide:function(a){throw new OG.NotImplementedException()
},drawRubberBand:function(a,b,c){throw new OG.NotImplementedException()
},removeRubberBand:function(a){throw new OG.NotImplementedException()
},drawTerminal:function(a,b){throw new OG.NotImplementedException()
},removeTerminal:function(a){throw new OG.NotImplementedException()
},removeAllTerminal:function(){throw new OG.NotImplementedException()
},drawCollapseGuide:function(a){throw new OG.NotImplementedException()
},removeCollapseGuide:function(a){throw new OG.NotImplementedException()
},group:function(a){throw new OG.NotImplementedException()
},ungroup:function(a){throw new OG.NotImplementedException()
},addToGroup:function(a,b){throw new OG.NotImplementedException()
},collapse:function(a){throw new OG.NotImplementedException()
},expand:function(a){throw new OG.NotImplementedException()
},clear:function(){throw new OG.NotImplementedException()
},removeShape:function(a){throw new OG.NotImplementedException()
},remove:function(a){throw new OG.NotImplementedException()
},removeChild:function(a){throw new OG.NotImplementedException()
},getRootElement:function(){throw new OG.NotImplementedException()
},getRootGroup:function(){return this._ROOT_GROUP.node
},getElementByPoint:function(a){throw new OG.NotImplementedException()
},getElementsByBBox:function(b){var a=[];
$(this.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"]").each(function(c,d){if(d.shape.geom&&b.isContainsAll(d.shape.geom.getVertices())){a.push(d)
}});
return a
},setAttr:function(a,b){throw new OG.NotImplementedException()
},getAttr:function(b,a){throw new OG.NotImplementedException()
},setShapeStyle:function(a,b){throw new OG.NotImplementedException()
},toFront:function(a){throw new OG.NotImplementedException()
},toBack:function(a){throw new OG.NotImplementedException()
},getCanvasSize:function(){throw new OG.NotImplementedException()
},setCanvasSize:function(a){throw new OG.NotImplementedException()
},fitCanvasSize:function(b,a){throw new OG.NotImplementedException()
},setViewBox:function(a,b,c){throw new OG.NotImplementedException()
},getScale:function(){throw new OG.NotImplementedException()
},setScale:function(a){throw new OG.NotImplementedException()
},show:function(a){throw new OG.NotImplementedException()
},hide:function(a){throw new OG.NotImplementedException()
},appendChild:function(a,b){throw new OG.NotImplementedException()
},insertAfter:function(a,b){throw new OG.NotImplementedException()
},insertBefore:function(a,b){throw new OG.NotImplementedException()
},move:function(a,b){throw new OG.NotImplementedException()
},moveCentroid:function(b,a){throw new OG.NotImplementedException()
},rotate:function(a,b){throw new OG.NotImplementedException()
},resize:function(a,b){throw new OG.NotImplementedException()
},resizeBox:function(b,a){throw new OG.NotImplementedException()
},intersectionEdge:function(f,b,j,c,l){var q=this,n,s,p,o,k,g=Number.MAX_VALUE,d,e,r,a,h,m;
if(b){e=$(b).parents("[_collapsed=true]");
if(e.length!==0){r=e[e.length-1].shape.geom.getBoundary();
a=r.getUpperLeft();
h=new OG.geometry.Rectangle(a,q._CONFIG.COLLAPSE_SIZE*3,q._CONFIG.COLLAPSE_SIZE*2)
}}switch(f){case OG.Constants.EDGE_TYPE.PLAIN:case OG.Constants.EDGE_TYPE.BEZIER:n=l?this._findFromTerminal(b,j,c):this._findToTerminal(b,j,c);
s=[n.terminal.position.x,n.terminal.position.y];
p=n.terminal.direction.toLowerCase();
if(h){switch(n.terminal.direction){case OG.Constants.TERMINAL_TYPE.E:m=h.getBoundary().getRightCenter();
break;
case OG.Constants.TERMINAL_TYPE.W:m=h.getBoundary().getLeftCenter();
break;
case OG.Constants.TERMINAL_TYPE.S:m=h.getBoundary().getLowerCenter();
break;
case OG.Constants.TERMINAL_TYPE.N:m=h.getBoundary().getUpperCenter();
break
}if(m){s=[m.x,m.y]
}}break;
case OG.Constants.EDGE_TYPE.STRAIGHT:if(h){m=h.getBoundary().getCentroid();
if(l===true){j=[m.x,m.y]
}else{c=[m.x,m.y]
}o=h.intersectToLine([j,c])
}else{o=b.shape.geom.intersectToLine([j,c])
}s=l?j:c;
p="c";
for(k=0;
k<o.length;
k++){d=o[k].distance(l?c:j);
if(d<g){g=d;
s=[o[k].x,o[k].y];
p="c"
}}break;
default:break
}return{position:s,direction:p}
},clone:function(a){throw new OG.NotImplementedException()
},getElementById:function(a){throw new OG.NotImplementedException()
},getElementsByType:function(c,a){var b=this.getRootGroup();
if(c&&a){return $(b).find("[_type=SHAPE][_shape="+c+"][_shape!="+a+"]")
}else{if(c){return $(b).find("[_type=SHAPE][_shape="+c+"]")
}else{if(a){return $(b).find("[_type=SHAPE][_shape!="+a+"]")
}else{return $(b).find("[_type=SHAPE]")
}}}},getBBox:function(a){throw new OG.NotImplementedException()
},getRootBBox:function(){throw new OG.NotImplementedException()
},getRealRootBBox:function(){var f=Number.MAX_VALUE,d=Number.MAX_VALUE,c=Number.MIN_VALUE,a=Number.MIN_VALUE,e=this.getElementsByType(),j,k,b,h,g,l={width:0,height:0,x:0,y:0,x2:0,y2:0};
for(g=0;
g<e.length;
g++){j=e[g].shape;
if(j&&j.geom){k=j.geom.getBoundary();
b=k.getUpperLeft();
h=k.getLowerRight();
f=f>b.x?b.x:f;
d=d>b.y?b.y:d;
c=c<h.x?h.x:c;
a=a<h.y?h.y:a;
l={width:c-f,height:a-d,x:f,y:d,x2:c,y2:a}
}}return l
},getVerticePath:function(a){var b;
for(i=0;
i<a.length;
i++){if(i===0){b="M"+a[i].x+" "+a[i].y
}else{b+="L"+a[i].x+" "+a[i].y
}}return b
},getFromXYPosition:function(c,a,g){var e=this,d,b,f;
d=OG.Util.isElement(c)?c:e.getElementById(c);
b=e._getShapeFromTerminal($(d).attr("_from"));
f=b.shape.geom.getBoundary().getCentroid();
return e.intersectionEdge(d.shape.geom.style.get("edge-type"),b,[f.x,f.y],[a,g],true).position
},getToXYPosition:function(b,a,g){var d=this,c,e,f;
c=OG.Util.isElement(b)?b:d.getElementById(b);
e=d._getShapeFromTerminal($(c).attr("_to"));
f=e.shape.geom.getBoundary().getCentroid();
return d.intersectionEdge(c.shape.geom.style.get("edge-type"),e,[a,g],[f.x,f.y],false).position
},getVerticeAngle:function(e,d){var f=this,c=-1,k,h,b,j,a,g;
if(d<e.length){k=e[d].x;
h=-e[d].y;
b=e[d-1].x;
j=-e[d-1].y;
a=e[d+1].x;
g=-e[d+1].y;
c=f._calculateAngle(k,h,b,j,a,g)
}return c
},_calculateAngle:function(j,f,b,h,a,g){var l,k,d,c,e;
l=[b-j,h-f];
k=[a-j,g-f];
d=Math.sqrt(l[0]*l[0]+l[1]*l[1]);
c=Math.sqrt(k[0]*k[0]+k[1]*k[1]);
e=(l[0]*k[0]+l[1]*k[1])/(d*c);
return Math.acos(e)*180/Math.PI
},getContainer:function(){throw new OG.NotImplementedException()
},isSVG:function(){throw new OG.NotImplementedException()
},isVML:function(){throw new OG.NotImplementedException()
},getPrevEdges:function(c){var e=$(c).attr("_fromedge"),a=[],f,d,b;
if(e){f=e.split(",");
for(b=0;
b<f.length;
b++){d=this.getElementById(f[b]);
if(d){a.push(d)
}}}return a
},getNextEdges:function(c){var f=$(c).attr("_toedge"),a=[],e,d,b;
if(f){e=f.split(",");
for(b=0;
b<e.length;
b++){d=this.getElementById(e[b]);
if(d){a.push(d)
}}}return a
},getPrevShapes:function(e){var c=this.getPrevEdges(e),a=[],f,b,d;
for(d=0;
d<c.length;
d++){f=$(c[d]).attr("_from");
if(f){f=f.substring(0,f.indexOf(OG.Constants.TERMINAL_SUFFIX.GROUP));
b=this.getElementById(f);
if(b){a.push(b)
}}}return a
},getPrevShapeIds:function(d){var b=this.getPrevEdges(d),a=[],e,c;
for(c=0;
c<b.length;
c++){e=$(b[c]).attr("_from");
if(e){e=e.substring(0,e.indexOf(OG.Constants.TERMINAL_SUFFIX.GROUP));
a.push(e)
}}return a
},getNextShapes:function(e){var f=this.getNextEdges(e),a=[],b,c,d;
for(d=0;
d<f.length;
d++){b=$(f[d]).attr("_to");
if(b){b=b.substring(0,b.indexOf(OG.Constants.TERMINAL_SUFFIX.GROUP));
c=this.getElementById(b);
if(c){a.push(c)
}}}return a
},getNextShapeIds:function(d){var e=this.getNextEdges(d),a=[],b,c;
for(c=0;
c<e.length;
c++){b=$(e[c]).attr("_to");
if(b){b=b.substring(0,b.indexOf(OG.Constants.TERMINAL_SUFFIX.GROUP));
a.push(b)
}}return a
}};
OG.renderer.IRenderer.prototype.constructor=OG.renderer.IRenderer;
OG.renderer.RaphaelRenderer=function(a,e,b,d,c){OG.renderer.RaphaelRenderer.superclass.call(this,arguments);
this._CONFIG=c;
this._PAPER=new Raphael(a,e?e[0]:null,e?e[1]:null);
this._ROOT_GROUP=this._add(this._PAPER.group(),null,OG.Constants.NODE_TYPE.ROOT);
this._ETC_GROUP=this._add(this._PAPER.group(),null,OG.Constants.NODE_TYPE.ETC);
this._PAPER.id="OG_"+this._ID_PREFIX;
this._PAPER.canvas.id="OG_"+this._ID_PREFIX;
this._CANVAS_COLOR=b||this._CONFIG.CANVAS_BACKGROUND;
$(this._PAPER.canvas).css({"background-color":this._CANVAS_COLOR,"user-select":"none","-o-user-select":"none","-moz-user-select":"none","-khtml-user-select":"none","-webkit-user-select":"none"});
if(d){$(this._PAPER.canvas).css({"background-image":d})
}$(this._PAPER.canvas.parentNode).attr("tabindex","0");
$(this._PAPER.canvas.parentNode).css({outline:"none"});
if($(this._PAPER.canvas.parentNode).css("position")==="static"){$(this._PAPER.canvas.parentNode).css({position:"relative",left:"0",top:"0"})
}};
OG.renderer.RaphaelRenderer.prototype=new OG.renderer.IRenderer();
OG.renderer.RaphaelRenderer.superclass=OG.renderer.IRenderer;
OG.renderer.RaphaelRenderer.prototype.constructor=OG.renderer.RaphaelRenderer;
OG.RaphaelRenderer=OG.renderer.RaphaelRenderer;
OG.renderer.RaphaelRenderer.prototype._add=function(b,d,a,c){b.id=d||this._genId();
b.node.id=b.id;
b.node.raphaelid=b.id;
if(a){$(b.node).attr("_type",a)
}if(c){$(b.node).attr("_shape",c)
}this._ELE_MAP.put(b.id,b);
return b
};
OG.renderer.RaphaelRenderer.prototype._remove=function(a){var c,b;
if(a){c=a.node.childNodes;
for(b=c.length-1;
b>=0;
b--){this._remove(this._getREleById(c[b].id))
}this._ELE_MAP.remove(a.id);
a.remove()
}};
OG.renderer.RaphaelRenderer.prototype._removeChild=function(a){var c,b;
if(a){c=a.node.childNodes;
for(b=c.length-1;
b>=0;
b--){this._remove(this._getREleById(c[b].id))
}}};
OG.renderer.RaphaelRenderer.prototype._getREleById=function(a){return this._ELE_MAP.get(a)
};
OG.renderer.RaphaelRenderer.prototype._drawGeometry=function(g,k,a,l){var j=this,e=0,m="",h,d,b,c={},f=function(v,s){var r,q,o,n,p,t=[],u=function(z,y,x){var w=Math.PI/180*x;
return new OG.geometry.Coordinate(OG.Util.round(z.x+y*Math.cos(w)),OG.Util.round(z.y+y*Math.sin(w)))
};
r=OG.JSON.decode(v.toString());
q=v.getVertices();
p=r.angle;
o=u(q[0],s,90+p);
n=u(q[0],s,p);
t=t.concat(["M",o.x,o.y,"Q",q[0].x,q[0].y,n.x,n.y]);
o=u(q[1],s,180+p);
n=u(q[1],s,90+p);
t=t.concat(["L",o.x,o.y,"Q",q[1].x,q[1].y,n.x,n.y]);
o=u(q[2],s,270+p);
n=u(q[2],s,180+p);
t=t.concat(["L",o.x,o.y,"Q",q[2].x,q[2].y,n.x,n.y]);
o=u(q[3],s,p);
n=u(q[3],s,270+p);
t=t.concat(["L",o.x,o.y,"Q",q[3].x,q[3].y,n.x,n.y,"Z"]);
return t.toString()
};
if(l){OG.Util.apply(c,(a instanceof OG.geometry.Style)?a.map:a||{},OG.Util.apply({},k.style.map,OG.Util.apply({},l,j._CONFIG.DEFAULT_STYLE.GEOM)))
}else{OG.Util.apply(c,(a instanceof OG.geometry.Style)?a.map:a||{},OG.Util.apply({},k.style.map,j._CONFIG.DEFAULT_STYLE.GEOM))
}k.style.map=c;
switch(k.TYPE){case OG.Constants.GEOM_TYPE.POINT:d=this._PAPER.circle(k.coordinate.x,k.coordinate.y,0.5);
d.attr(c);
break;
case OG.Constants.GEOM_TYPE.LINE:case OG.Constants.GEOM_TYPE.POLYLINE:case OG.Constants.GEOM_TYPE.POLYGON:m="";
h=k.getVertices();
for(e=0;
e<h.length;
e++){if(e===0){m="M"+h[e].x+" "+h[e].y
}else{m+="L"+h[e].x+" "+h[e].y
}}d=this._PAPER.path(m);
d.attr(c);
break;
case OG.Constants.GEOM_TYPE.RECTANGLE:if((c.r||0)===0){m="";
h=k.getVertices();
for(e=0;
e<h.length;
e++){if(e===0){m="M"+h[e].x+" "+h[e].y
}else{m+="L"+h[e].x+" "+h[e].y
}}}else{m=f(k,c.r||0)
}d=this._PAPER.path(m);
d.attr(c);
break;
case OG.Constants.GEOM_TYPE.CIRCLE:b=OG.JSON.decode(k.toString());
if(b.type===OG.Constants.GEOM_NAME[OG.Constants.GEOM_TYPE.CIRCLE]){d=this._PAPER.circle(b.center[0],b.center[1],b.radius)
}else{if(b.type===OG.Constants.GEOM_NAME[OG.Constants.GEOM_TYPE.ELLIPSE]){if(b.angle===0){d=this._PAPER.ellipse(b.center[0],b.center[1],b.radiusX,b.radiusY)
}else{m="";
h=k.getControlPoints();
m="M"+h[1].x+" "+h[1].y+"A"+b.radiusX+" "+b.radiusY+" "+b.angle+" 1 0 "+h[5].x+" "+h[5].y;
m+="M"+h[1].x+" "+h[1].y+"A"+b.radiusX+" "+b.radiusY+" "+b.angle+" 1 1 "+h[5].x+" "+h[5].y;
d=this._PAPER.path(m)
}}}d.attr(c);
break;
case OG.Constants.GEOM_TYPE.ELLIPSE:b=OG.JSON.decode(k.toString());
if(b.angle===0){d=this._PAPER.ellipse(b.center[0],b.center[1],b.radiusX,b.radiusY)
}else{m="";
h=k.getControlPoints();
m="M"+h[1].x+" "+h[1].y+"A"+b.radiusX+" "+b.radiusY+" "+b.angle+" 1 0 "+h[5].x+" "+h[5].y;
m+="M"+h[1].x+" "+h[1].y+"A"+b.radiusX+" "+b.radiusY+" "+b.angle+" 1 1 "+h[5].x+" "+h[5].y;
d=this._PAPER.path(m)
}d.attr(c);
break;
case OG.Constants.GEOM_TYPE.CURVE:m="";
h=k.getControlPoints();
for(e=0;
e<h.length;
e++){if(e===0){m="M"+h[e].x+" "+h[e].y
}else{if(e===1){m+="R"+h[e].x+" "+h[e].y
}else{m+=" "+h[e].x+" "+h[e].y
}}}d=this._PAPER.path(m);
d.attr(c);
break;
case OG.Constants.GEOM_TYPE.BEZIER_CURVE:m="";
h=k.getControlPoints();
for(e=0;
e<h.length;
e++){if(e===0){m="M"+h[e].x+" "+h[e].y
}else{if(e===1){m+="C"+h[e].x+" "+h[e].y
}else{m+=" "+h[e].x+" "+h[e].y
}}}d=this._PAPER.path(m);
d.attr(c);
break;
case OG.Constants.GEOM_TYPE.COLLECTION:for(e=0;
e<k.geometries.length;
e++){this._drawGeometry(g,k.geometries[e],a,k.style.map)
}break
}if(d){this._add(d);
g.appendChild(d.node);
return d.node
}else{return g
}};
OG.renderer.RaphaelRenderer.prototype._drawLabel=function(w,m,o,t,q,e){var v=this,d=v._CONFIG.LABEL_PADDING,r=o?o[0]-d*2:null,p=o?o[1]-d*2:null,u=o?o[2]||0:0,h,b,a,g={},j,s,f,c,n,l,k;
OG.Util.apply(g,(t instanceof OG.geometry.Style)?t.map:t||{},v._CONFIG.DEFAULT_STYLE.TEXT);
if(q===0||q){h=this._getREleById(q);
if(h){this._removeChild(h)
}else{h=this._PAPER.group();
this._add(h,q)
}}else{h=this._PAPER.group();
this._add(h,q)
}j=g["text-anchor"]||"middle";
g["text-anchor"]="middle";
b=this._PAPER.text(w[0],w[1],m);
b.attr(g);
f=b.getBBox();
r=r?(r>f.width?r:f.width):f.width;
p=p?(p>f.height?p:f.height):f.height;
c=OG.Util.round(w[0]-r/2);
n=OG.Util.round(w[1]-p/2);
s=new OG.Rectangle([c,n],r,p);
if(g["label-direction"]==="vertical"){switch(j){case"start":k=s.getBoundary().getLowerCenter().y;
break;
case"end":k=s.getBoundary().getUpperCenter().y;
break;
case"middle":k=s.getBoundary().getCentroid().y;
break;
default:k=s.getBoundary().getCentroid().y;
break
}switch(g["vertical-align"]){case"top":l=OG.Util.round(s.getBoundary().getLeftCenter().x+f.height/2);
break;
case"bottom":l=OG.Util.round(s.getBoundary().getRightCenter().x-f.height/2);
break;
case"middle":l=s.getBoundary().getCentroid().x;
break;
default:l=s.getBoundary().getCentroid().x;
break
}u=-90
}else{switch(j){case"start":l=s.getBoundary().getLeftCenter().x;
break;
case"end":l=s.getBoundary().getRightCenter().x;
break;
case"middle":l=s.getBoundary().getCentroid().x;
break;
default:l=s.getBoundary().getCentroid().x;
break
}switch(g["vertical-align"]){case"top":k=OG.Util.round(s.getBoundary().getUpperCenter().y+f.height/2);
break;
case"bottom":k=OG.Util.round(s.getBoundary().getLowerCenter().y-f.height/2);
break;
case"middle":k=s.getBoundary().getCentroid().y;
break;
default:k=s.getBoundary().getCentroid().y;
break
}}b.attr({x:l,y:k,stroke:"none",fill:g["font-color"]||v._CONFIG.DEFAULT_STYLE.LABEL["font-color"],"font-size":g["font-size"]||v._CONFIG.DEFAULT_STYLE.LABEL["font-size"],"fill-opacity":1});
if(u||g["label-angle"]){if(u===0){u=parseInt(g["label-angle"],10)
}b.rotate(u)
}b.attr({"text-anchor":j});
if(e&&m){f=b.getBBox();
a=this._PAPER.rect(f.x-d/2,f.y-d/2,f.width+d,f.height+d);
a.attr({stroke:"none",fill:this._CANVAS_COLOR,"fill-opacity":1});
this._add(a);
h.node.appendChild(a.node)
}this._add(b);
h.node.appendChild(b.node);
return h.node
};
OG.renderer.RaphaelRenderer.prototype.drawShape=function(g,h,m,a,b){var c=m?m[0]:100,l=m?m[1]:100,d,j,k,e,f;
if(h instanceof OG.shape.GeomShape){j=h.createShape();
j.moveCentroid(g);
j.resizeBox(c,l);
d=this.drawGeom(j,a,b);
h.geom=d.geom
}else{if(h instanceof OG.shape.TextShape){k=h.createShape();
d=this.drawText(g,k,m,a,b);
h.text=d.text;
h.angle=d.angle;
h.geom=d.geom
}else{if(h instanceof OG.shape.ImageShape){e=h.createShape();
d=this.drawImage(g,e,m,a,b);
h.image=d.image;
h.angle=d.angle;
h.geom=d.geom
}else{if(h instanceof OG.shape.HtmlShape){f=h.createShape();
d=this.drawHtml(g,f,m,a,b);
h.html=d.html;
h.angle=d.angle;
h.geom=d.geom
}else{if(h instanceof OG.shape.EdgeShape){j=h.geom||h.createShape();
d=this.drawEdge(j,a,b);
h.geom=d.geom
}else{if(h instanceof OG.shape.GroupShape){j=h.createShape();
j.moveCentroid(g);
j.resizeBox(c,l);
d=this.drawGroup(j,a,b);
h.geom=d.geom
}}}}}}if(h.geom){d.shape=h
}d.shapeStyle=(a instanceof OG.geometry.Style)?a.map:a;
$(d).attr("_shape_id",h.SHAPE_ID);
if(!(h instanceof OG.shape.TextShape)){this.drawLabel(d);
if(h instanceof OG.shape.EdgeShape){this.drawEdgeLabel(d,null,"TO")
}}if(d.geom){if(OG.Util.isIE7()){d.removeAttribute("geom")
}else{delete d.geom
}}if(d.text){if(OG.Util.isIE7()){d.removeAttribute("text")
}else{delete d.text
}}if(d.image){if(OG.Util.isIE7()){d.removeAttribute("image")
}else{delete d.image
}}if(d.angle){if(OG.Util.isIE7()){d.removeAttribute("angle")
}else{delete d.angle
}}$(this._PAPER.canvas).trigger("drawShape",[d]);
return d
};
OG.renderer.RaphaelRenderer.prototype.drawGeom=function(e,b,f){var c=this,d,a={};
OG.Util.apply(a,(b instanceof OG.geometry.Style)?b.map:b||{});
if(f===0||f){d=this._getREleById(f);
if(d){this._removeChild(d)
}else{d=this._PAPER.group();
this._add(d,f,OG.Constants.NODE_TYPE.SHAPE,OG.Constants.SHAPE_TYPE.GEOM);
this._ROOT_GROUP.node.appendChild(d.node)
}}else{d=this._PAPER.group();
this._add(d,f,OG.Constants.NODE_TYPE.SHAPE,OG.Constants.SHAPE_TYPE.GEOM);
this._ROOT_GROUP.node.appendChild(d.node)
}this._drawGeometry(d.node,e,a);
d.node.geom=e;
d.attr(c._CONFIG.DEFAULT_STYLE.SHAPE);
if(d.node.shape){d.node.shape.geom=e;
if(d.node.geom){if(OG.Util.isIE7()){d.node.removeAttribute("geom")
}else{delete d.node.geom
}}}return d.node
};
OG.renderer.RaphaelRenderer.prototype.drawText=function(s,h,k,p,m){var r=this,n=k?k[0]:null,l=k?k[1]:null,q=k?k[2]||0:0,e,a,d={},o,c,b,j,g,f;
OG.Util.apply(d,(p instanceof OG.geometry.Style)?p.map:p||{},r._CONFIG.DEFAULT_STYLE.TEXT);
if(m===0||m){e=this._getREleById(m);
if(e){this._removeChild(e)
}else{e=this._PAPER.group();
this._add(e,m,OG.Constants.NODE_TYPE.SHAPE,OG.Constants.SHAPE_TYPE.TEXT);
this._ROOT_GROUP.node.appendChild(e.node)
}}else{e=this._PAPER.group();
this._add(e,m,OG.Constants.NODE_TYPE.SHAPE,OG.Constants.SHAPE_TYPE.TEXT);
this._ROOT_GROUP.node.appendChild(e.node)
}a=this._PAPER.text(s[0],s[1],h);
a.attr(d);
c=a.getBBox();
n=n?(n>c.width?n:c.width):c.width;
l=l?(l>c.height?l:c.height):c.height;
b=OG.Util.round(s[0]-n/2);
j=OG.Util.round(s[1]-l/2);
o=new OG.Rectangle([b,j],n,l);
o.style.map=d;
switch(d["text-anchor"]){case"start":g=o.getBoundary().getLeftCenter().x;
break;
case"end":g=o.getBoundary().getRightCenter().x;
break;
case"middle":g=o.getBoundary().getCentroid().x;
break;
default:g=o.getBoundary().getCentroid().x;
break
}switch(d["vertical-align"]){case"top":f=OG.Util.round(o.getBoundary().getUpperCenter().y+c.height/2);
break;
case"bottom":f=OG.Util.round(o.getBoundary().getLowerCenter().y-c.height/2);
break;
case"middle":f=o.getBoundary().getCentroid().y;
break;
default:f=o.getBoundary().getCentroid().y;
break
}a.attr({x:g,y:f});
a.attr({stroke:"none",fill:d["font-color"]||r._CONFIG.DEFAULT_STYLE.LABEL["font-color"],"font-size":d["font-size"]||r._CONFIG.DEFAULT_STYLE.LABEL["font-size"]});
if(q){a.rotate(q)
}this._add(a);
e.node.appendChild(a.node);
e.node.text=h;
e.node.angle=q;
e.node.geom=o;
e.attr(r._CONFIG.DEFAULT_STYLE.SHAPE);
if(e.node.shape){e.node.shape.text=h;
e.node.shape.angle=q;
e.node.shape.geom=o;
if(e.node.text){if(OG.Util.isIE7()){e.node.removeAttribute("text")
}else{delete e.node.text
}}if(e.node.angle){if(OG.Util.isIE7()){e.node.removeAttribute("angle")
}else{delete e.node.angle
}}if(e.node.geom){if(OG.Util.isIE7()){e.node.removeAttribute("geom")
}else{delete e.node.geom
}}}return e.node
};
OG.renderer.RaphaelRenderer.prototype.drawHtml=function(j,h,q,a,b){var k=this,c=q?q[0]:null,o=q?q[1]:null,f=q?q[2]||0:0,n,g,e={},p,m,d,l;
OG.Util.apply(e,(a instanceof OG.geometry.Style)?a.map:a||{},k._CONFIG.DEFAULT_STYLE.HTML);
if(b===0||b){n=this._getREleById(b);
if(n){this._removeChild(n)
}else{n=this._PAPER.group();
this._add(n,b,OG.Constants.NODE_TYPE.SHAPE,OG.Constants.SHAPE_TYPE.HTML);
this._ROOT_GROUP.node.appendChild(n.node)
}}else{n=this._PAPER.group();
this._add(n,b,OG.Constants.NODE_TYPE.SHAPE,OG.Constants.SHAPE_TYPE.HTML);
this._ROOT_GROUP.node.appendChild(n.node)
}g=this._PAPER.foreignObject(h,j[0],j[1],c,o);
g.attr(e);
p=g.getBBox();
c=c||p.width;
o=o||p.height;
d=OG.Util.round(j[0]-c/2);
l=OG.Util.round(j[1]-o/2);
g.attr({x:d,y:l});
m=new OG.Rectangle([d,l],c,o);
if(f){g.rotate(f)
}m.style.map=e;
this._add(g);
n.node.appendChild(g.node);
n.node.html=h;
n.node.angle=f;
n.node.geom=m;
n.attr(k._CONFIG.DEFAULT_STYLE.SHAPE);
if(n.node.shape){n.node.shape.html=h;
n.node.shape.angle=f;
n.node.shape.geom=m;
if(n.node.html){if(OG.Util.isIE7()){n.node.removeAttribute("html")
}else{delete n.node.html
}}if(n.node.angle){if(OG.Util.isIE7()){n.node.removeAttribute("angle")
}else{delete n.node.angle
}}if(n.node.geom){if(OG.Util.isIE7()){n.node.removeAttribute("geom")
}else{delete n.node.geom
}}}return n.node
};
OG.renderer.RaphaelRenderer.prototype.drawImage=function(h,p,q,a,b){var j=this,c=q?q[0]:null,n=q?q[1]:null,f=q?q[2]||0:0,m,g,e={},o,l,d,k;
OG.Util.apply(e,(a instanceof OG.geometry.Style)?a.map:a||{},j._CONFIG.DEFAULT_STYLE.IMAGE);
if(b===0||b){m=this._getREleById(b);
if(m){this._removeChild(m)
}else{m=this._PAPER.group();
this._add(m,b,OG.Constants.NODE_TYPE.SHAPE,OG.Constants.SHAPE_TYPE.IMAGE);
this._ROOT_GROUP.node.appendChild(m.node)
}}else{m=this._PAPER.group();
this._add(m,b,OG.Constants.NODE_TYPE.SHAPE,OG.Constants.SHAPE_TYPE.IMAGE);
this._ROOT_GROUP.node.appendChild(m.node)
}g=this._PAPER.image(p,h[0],h[1],c,n);
g.attr(e);
o=g.getBBox();
c=c||o.width;
n=n||o.height;
d=OG.Util.round(h[0]-c/2);
k=OG.Util.round(h[1]-n/2);
g.attr({x:d,y:k});
l=new OG.Rectangle([d,k],c,n);
if(f){g.rotate(f)
}l.style.map=e;
this._add(g);
m.node.appendChild(g.node);
m.node.image=p;
m.node.angle=f;
m.node.geom=l;
m.attr(j._CONFIG.DEFAULT_STYLE.SHAPE);
if(m.node.shape){m.node.shape.image=p;
m.node.shape.angle=f;
m.node.shape.geom=l;
if(m.node.image){if(OG.Util.isIE7()){m.node.removeAttribute("image")
}else{delete m.node.image
}}if(m.node.angle){if(OG.Util.isIE7()){m.node.removeAttribute("angle")
}else{delete m.node.angle
}}if(m.node.geom){if(OG.Util.isIE7()){m.node.removeAttribute("geom")
}else{delete m.node.geom
}}}return m.node
};
OG.renderer.RaphaelRenderer.prototype.drawEdge=function(p,a,b,e){var g=this,n,d={},f=p.getVertices(),k=f[0],j=f[f.length-1],m=[],c,h,o=function(s,r,q){if(q){return[[s[0],s[1]],[r[0],s[1]],[r[0],r[1]]]
}else{return[[s[0],s[1]],[s[0],r[1]],[r[0],r[1]]]
}},l=function(s,r,q){if(q){return[[s[0],s[1]],[OG.Util.round((s[0]+r[0])/2),s[1]],[OG.Util.round((s[0]+r[0])/2),r[1]],[r[0],r[1]]]
}else{return[[s[0],s[1]],[s[0],OG.Util.round((s[1]+r[1])/2)],[r[0],OG.Util.round((s[1]+r[1])/2)],[r[0],r[1]]]
}};
OG.Util.apply(d,(a instanceof OG.geometry.Style)?a.map:a||{},OG.Util.apply({},p.style.map,g._CONFIG.DEFAULT_STYLE.EDGE));
if(b===0||b){n=this._getREleById(b);
if(n){this._removeChild(n)
}else{n=this._PAPER.group();
this._add(n,b,OG.Constants.NODE_TYPE.SHAPE,OG.Constants.SHAPE_TYPE.EDGE);
this._ROOT_GROUP.node.appendChild(n.node)
}}else{n=this._PAPER.group();
this._add(n,b,OG.Constants.NODE_TYPE.SHAPE,OG.Constants.SHAPE_TYPE.EDGE);
this._ROOT_GROUP.node.appendChild(n.node)
}if(e){m=[[k.x,k.y-g._CONFIG.GUIDE_RECT_SIZE/2],[k.x+g._CONFIG.GUIDE_RECT_SIZE*2,k.y-g._CONFIG.GUIDE_RECT_SIZE],[k.x+g._CONFIG.GUIDE_RECT_SIZE*2,k.y+g._CONFIG.GUIDE_RECT_SIZE],[k.x,k.y+g._CONFIG.GUIDE_RECT_SIZE/2]]
}else{if(p instanceof OG.geometry.Line){switch(d["edge-type"].toLowerCase()){case OG.Constants.EDGE_TYPE.STRAIGHT:m=[k,j];
break;
case OG.Constants.EDGE_TYPE.PLAIN:h=d["edge-direction"].toLowerCase().split(" ");
if(h[0]==="c"||h[1]==="c"){h=this._adjustEdgeDirection(h[0],h[1],[k.x,k.y],[j.x,j.y]).split(" ")
}if(h[0]==="e"){switch(h[1]){case"e":if(k.x<=j.x){m=o([k.x,k.y],[j.x+g._CONFIG.EDGE_PADDING,j.y],true);
m.push([j.x,j.y])
}else{m=[[k.x,k.y]];
m=m.concat(o([k.x+g._CONFIG.EDGE_PADDING,k.y],[j.x,j.y],false))
}break;
case"w":if(k.x<=j.x){m=l([k.x,k.y],[j.x,j.y],true)
}else{m=[[k.x,k.y]];
m=m.concat(l([k.x+g._CONFIG.EDGE_PADDING,k.y],[j.x-g._CONFIG.EDGE_PADDING,j.y],false));
m.push([j.x,j.y])
}break;
case"s":if(k.x<=j.x&&k.y<=j.y){m=l([k.x,k.y],[j.x,j.y+g._CONFIG.EDGE_PADDING],true);
m.push([j.x,j.y])
}else{if(k.x<=j.x&&k.y>j.y){m=o([k.x,k.y],[j.x,j.y],true)
}else{if(k.x>j.x&&k.y<=j.y){m=[[k.x,k.y]];
m=m.concat(o([k.x+g._CONFIG.EDGE_PADDING,k.y],[j.x,j.y+g._CONFIG.EDGE_PADDING],false));
m.push([j.x,j.y])
}else{if(k.x>j.x&&k.y>j.y){m=[[k.x,k.y]];
m=m.concat(l([k.x+g._CONFIG.EDGE_PADDING,k.y],[j.x,j.y],false))
}}}}break;
case"n":if(k.x<=j.x&&k.y<=j.y){m=o([k.x,k.y],[j.x,j.y],true)
}else{if(k.x<=j.x&&k.y>j.y){m=[[k.x,k.y]];
m=m.concat(o([k.x+g._CONFIG.EDGE_PADDING,k.y],[j.x,j.y-g._CONFIG.EDGE_PADDING],false));
m.push([j.x,j.y])
}else{if(k.x>j.x&&k.y<=j.y){m=[[k.x,k.y]];
m=m.concat(l([k.x+g._CONFIG.EDGE_PADDING,k.y],[j.x,j.y],false))
}else{if(k.x>j.x&&k.y>j.y){m=[[k.x,k.y]];
m=m.concat(o([k.x+g._CONFIG.EDGE_PADDING,k.y],[j.x,j.y-g._CONFIG.EDGE_PADDING],false));
m.push([j.x,j.y])
}}}}break
}}else{if(h[0]==="w"){switch(h[1]){case"e":if(k.x<=j.x){m=[[k.x,k.y]];
m=m.concat(l([k.x-g._CONFIG.EDGE_PADDING,k.y],[j.x+g._CONFIG.EDGE_PADDING,j.y],false));
m.push([j.x,j.y])
}else{m=l([k.x,k.y],[j.x,j.y],true)
}break;
case"w":if(k.x<=j.x){m=[[k.x,k.y]];
m=m.concat(o([k.x-g._CONFIG.EDGE_PADDING,k.y],[j.x,j.y],false))
}else{m=o([k.x,k.y],[j.x-g._CONFIG.EDGE_PADDING,j.y],true);
m.push([j.x,j.y])
}break;
case"s":if(k.x<=j.x&&k.y<=j.y){m=[[k.x,k.y]];
m=m.concat(o([k.x-g._CONFIG.EDGE_PADDING,k.y],[j.x,j.y+g._CONFIG.EDGE_PADDING],false));
m.push([j.x,j.y])
}else{if(k.x<=j.x&&k.y>j.y){m=[[k.x,k.y]];
m=m.concat(l([k.x-g._CONFIG.EDGE_PADDING,k.y],[j.x,j.y],false))
}else{if(k.x>j.x&&k.y<=j.y){m=l([k.x,k.y],[j.x,j.y+g._CONFIG.EDGE_PADDING],true);
m.push([j.x,j.y])
}else{if(k.x>j.x&&k.y>j.y){m=o([k.x,k.y],[j.x,j.y],true)
}}}}break;
case"n":if(k.x<=j.x&&k.y<=j.y){m=[[k.x,k.y]];
m=m.concat(l([k.x-g._CONFIG.EDGE_PADDING,k.y],[j.x,j.y],false))
}else{if(k.x<=j.x&&k.y>j.y){m=[[k.x,k.y]];
m=m.concat(o([k.x-g._CONFIG.EDGE_PADDING,k.y],[j.x,j.y-g._CONFIG.EDGE_PADDING],false));
m.push([j.x,j.y])
}else{if(k.x>j.x&&k.y<=j.y){m=m.concat(o([k.x,k.y],[j.x,j.y],true))
}else{if(k.x>j.x&&k.y>j.y){m=l([k.x,k.y],[j.x,j.y-g._CONFIG.EDGE_PADDING],true);
m.push([j.x,j.y])
}}}}break
}}else{if(h[0]==="s"){switch(h[1]){case"e":if(k.x<=j.x&&k.y<=j.y){m=l([k.x,k.y],[j.x+g._CONFIG.EDGE_PADDING,j.y],false);
m.push([j.x,j.y])
}else{if(k.x<=j.x&&k.y>j.y){m=[[k.x,k.y]];
m=m.concat(o([k.x,k.y+g._CONFIG.EDGE_PADDING],[j.x+g._CONFIG.EDGE_PADDING,j.y],true));
m.push([j.x,j.y])
}else{if(k.x>j.x&&k.y<=j.y){m=o([k.x,k.y],[j.x,j.y],false)
}else{if(k.x>j.x&&k.y>j.y){m=[[k.x,k.y]];
m=m.concat(l([k.x,k.y+g._CONFIG.EDGE_PADDING],[j.x,j.y],true))
}}}}break;
case"w":if(k.x<=j.x&&k.y<=j.y){m=o([k.x,k.y],[j.x,j.y],false)
}else{if(k.x<=j.x&&k.y>j.y){m=[[k.x,k.y]];
m=m.concat(l([k.x,k.y+g._CONFIG.EDGE_PADDING],[j.x,j.y],true))
}else{if(k.x>j.x&&k.y<=j.y){m=l([k.x,k.y],[j.x-g._CONFIG.EDGE_PADDING,j.y],false);
m.push([j.x,j.y])
}else{if(k.x>j.x&&k.y>j.y){m=[[k.x,k.y]];
m=m.concat(o([k.x,k.y+g._CONFIG.EDGE_PADDING],[j.x-g._CONFIG.EDGE_PADDING,j.y],true));
m.push([j.x,j.y])
}}}}break;
case"s":if(k.y<=j.y){m=o([k.x,k.y],[j.x,j.y+g._CONFIG.EDGE_PADDING],false);
m.push([j.x,j.y])
}else{m=[[k.x,k.y]];
m=m.concat(o([k.x,k.y+g._CONFIG.EDGE_PADDING],[j.x,j.y],true))
}break;
case"n":if(k.y<=j.y){m=l([k.x,k.y],[j.x,j.y],false)
}else{m=[[k.x,k.y]];
m=m.concat(l([k.x,k.y+g._CONFIG.EDGE_PADDING],[j.x,j.y-g._CONFIG.EDGE_PADDING],true));
m.push([j.x,j.y])
}break
}}else{if(h[0]==="n"){switch(h[1]){case"e":if(k.x<=j.x&&k.y<=j.y){m=[[k.x,k.y]];
m=m.concat(o([k.x,k.y-g._CONFIG.EDGE_PADDING],[j.x+g._CONFIG.EDGE_PADDING,j.y],true));
m.push([j.x,j.y])
}else{if(k.x<=j.x&&k.y>j.y){m=l([k.x,k.y],[j.x+g._CONFIG.EDGE_PADDING,j.y],false);
m.push([j.x,j.y])
}else{if(k.x>j.x&&k.y<=j.y){m=[[k.x,k.y]];
m=m.concat(l([k.x,k.y-g._CONFIG.EDGE_PADDING],[j.x,j.y],true))
}else{if(k.x>j.x&&k.y>j.y){m=o([k.x,k.y],[j.x,j.y],false)
}}}}break;
case"w":if(k.x<=j.x&&k.y<=j.y){m=[[k.x,k.y]];
m=m.concat(l([k.x,k.y-g._CONFIG.EDGE_PADDING],[j.x,j.y],true))
}else{if(k.x<=j.x&&k.y>j.y){m=o([k.x,k.y],[j.x,j.y],false)
}else{if(k.x>j.x&&k.y<=j.y){m=[[k.x,k.y]];
m=m.concat(o([k.x,k.y-g._CONFIG.EDGE_PADDING],[j.x-g._CONFIG.EDGE_PADDING,j.y],true));
m.push([j.x,j.y])
}else{if(k.x>j.x&&k.y>j.y){m=l([k.x,k.y],[j.x-g._CONFIG.EDGE_PADDING,j.y],false);
m.push([j.x,j.y])
}}}}break;
case"s":if(k.y<=j.y){m=[[k.x,k.y]];
m=m.concat(l([k.x,k.y-g._CONFIG.EDGE_PADDING],[j.x,j.y+g._CONFIG.EDGE_PADDING],true));
m.push([j.x,j.y])
}else{m=l([k.x,k.y],[j.x,j.y],false)
}break;
case"n":if(k.y<=j.y){m=[[k.x,k.y]];
m=m.concat(o([k.x,k.y-g._CONFIG.EDGE_PADDING],[j.x,j.y],true))
}else{m=o([k.x,k.y],[j.x,j.y-g._CONFIG.EDGE_PADDING],false);
m.push([j.x,j.y])
}break
}}}}}break;
case OG.Constants.EDGE_TYPE.BEZIER:h=d["edge-direction"].toLowerCase().split(" ");
if(h[0]==="c"||h[1]==="c"){h=this._adjustEdgeDirection(h[0],h[1],[k.x,k.y],[j.x,j.y]).split(" ")
}m=this._bezierCurve([k.x,k.y],[j.x,j.y],h[0],h[1]);
break
}}else{if(p instanceof OG.geometry.Curve){m=p.getControlPoints()
}else{if(p instanceof OG.geometry.BezierCurve){m=p.getControlPoints()
}else{m=f
}}}}if(e){c=new OG.Curve(m)
}else{if(p instanceof OG.geometry.Curve){c=new OG.Curve(m)
}else{if(p instanceof OG.geometry.BezierCurve){c=new OG.BezierCurve(m)
}else{if(d["edge-type"].toLowerCase()===OG.Constants.EDGE_TYPE.BEZIER){c=new OG.BezierCurve(m)
}else{c=new OG.PolyLine(m)
}}}}this._drawGeometry(n.node,c,g._CONFIG.DEFAULT_STYLE.EDGE_HIDDEN);
this._drawGeometry(n.node,c,d);
n.node.geom=c;
n.attr(g._CONFIG.DEFAULT_STYLE.SHAPE);
if(n.node.shape){n.node.shape.geom=c;
if(n.node.geom){if(OG.Util.isIE7()){n.node.removeAttribute("geom")
}else{delete n.node.geom
}}}return n.node
};
OG.renderer.RaphaelRenderer.prototype.drawGroup=function(j,b,c){var h=this,k,m,e={},l,f,d,a,g={};
OG.Util.apply(e,(b instanceof OG.geometry.Style)?b.map:b||{});
if(c===0||c){k=this._getREleById(c);
if(k){l=k.node.childNodes;
for(f=l.length-1;
f>=0;
f--){if($(l[f]).attr("_type")!==OG.Constants.NODE_TYPE.SHAPE){this._remove(this._getREleById(l[f].id))
}}}else{k=this._PAPER.group();
this._add(k,c,OG.Constants.NODE_TYPE.SHAPE,OG.Constants.SHAPE_TYPE.GROUP);
this._ROOT_GROUP.node.appendChild(k.node)
}}else{k=this._PAPER.group();
this._add(k,c,OG.Constants.NODE_TYPE.SHAPE,OG.Constants.SHAPE_TYPE.GROUP);
this._ROOT_GROUP.node.appendChild(k.node)
}m=this._drawGeometry(k.node,j,e);
k.node.geom=j;
k.attr(h._CONFIG.DEFAULT_STYLE.SHAPE);
OG.Util.apply(g,j.style.map,e);
if(g["label-direction"]&&g["vertical-align"]==="top"){d=j.getBoundary();
if(g["label-direction"]==="vertical"){a=new OG.geometry.Line([d.getUpperLeft().x+20,d.getUpperLeft().y],[d.getLowerLeft().x+20,d.getLowerLeft().y])
}else{a=new OG.geometry.Line([d.getUpperLeft().x,d.getUpperLeft().y+20],[d.getUpperRight().x,d.getUpperRight().y+20])
}this._drawGeometry(k.node,a,e)
}if(m.id!==k.node.firstChild.id){k.node.insertBefore(m,k.node.firstChild)
}if(k.node.shape){if(!k.node.shape.isCollapsed||k.node.shape.isCollapsed===false){k.node.shape.geom=j
}if(k.node.geom){if(OG.Util.isIE7()){k.node.removeAttribute("geom")
}else{delete k.node.geom
}}}return k.node
};
OG.renderer.RaphaelRenderer.prototype.drawLabel=function(k,n,b){var g=this._getREleById(OG.Util.isElement(k)?k.id:k),e,h,j,c={},f,o,d,m,l=function(t){var r,w,v,p,u=0,s,q;
if(t.shape.geom.style.get("edge-type")===OG.Constants.EDGE_TYPE.BEZIER){r=t.shape.geom.getControlPoints();
w=r[0];
v=r[r.length-1];
return new OG.geometry.Coordinate(OG.Util.round((w.x+v.x)/2),OG.Util.round((w.y+v.y)/2))
}else{r=t.shape.geom.getVertices();
p=t.shape.geom.getLength();
for(s=0;
s<r.length-1;
s++){u+=r[s].distance(r[s+1]);
if(u>p/2){q=t.shape.geom.intersectCircleToLine(r[s+1],u-p/2,r[s+1],r[s]);
break
}}return q[0]
}},a;
OG.Util.apply(c,(b instanceof OG.geometry.Style)?b.map:b||{});
if(g&&g.node.shape){n=OG.Util.trim(n);
e=g.node;
j=e.shape.geom.getBoundary();
d=e.shape.label;
if(n!==undefined&&n!==d){m=jQuery.Event("beforeLabelChange",{element:e,afterText:n,beforeText:d});
$(this._PAPER.canvas).trigger(m);
if(m.isPropagationStopped()){return false
}n=m.afterText
}OG.Util.apply(e.shape.geom.style.map,c);
e.shape.label=n===undefined?e.shape.label:n;
if(e.shape.label!==undefined){if(e.shape instanceof OG.shape.EdgeShape){a=l(e);
f=[a.x,a.y];
o=[0,0]
}else{switch(e.shape.geom.style.get("label-position")){case"left":f=[j.getCentroid().x-j.getWidth(),j.getCentroid().y];
break;
case"right":f=[j.getCentroid().x+j.getWidth(),j.getCentroid().y];
break;
case"top":f=[j.getCentroid().x,j.getCentroid().y-j.getHeight()];
break;
case"bottom":f=[j.getCentroid().x,j.getCentroid().y+j.getHeight()];
break;
default:f=[j.getCentroid().x,j.getCentroid().y];
break
}o=[j.getWidth(),j.getHeight()]
}if(e.shape instanceof OG.shape.HtmlShape){}else{h=this._drawLabel(f,e.shape.label,o,e.shape.geom.style,e.id+OG.Constants.LABEL_SUFFIX,e.shape instanceof OG.shape.EdgeShape);
e.appendChild(h)
}if(n!==undefined){$(this._PAPER.canvas).trigger("drawLabel",[e,n])
}if(n!==undefined&&n!==d){$(this._PAPER.canvas).trigger("labelChanged",[e,n,d])
}}}return h
};
OG.renderer.RaphaelRenderer.prototype.drawEdgeLabel=function(k,n,g){var u=this,o=this._getREleById(OG.Util.isElement(k)?k.id:k),c,j,b,v,t,e;
if(o&&o.node.shape){n=OG.Util.trim(n);
c=o.node;
if(c.shape instanceof OG.shape.EdgeShape){j=c.shape.geom.getVertices();
if(g==="FROM"){v=[j[0].x,j[0].y+u._CONFIG.FROMTO_LABEL_OFFSET_TOP];
c.shape.fromLabel=n||c.shape.fromLabel;
t=c.shape.fromLabel;
e=OG.Constants.FROM_LABEL_SUFFIX
}else{if(g==="TO"){var h=j.length,m,l,q;
if(h%2==0){q=h/2;
var s=j[q-1].x,r=j[q].x,p=OG.Util.round(Math.abs(r-s)/2);
m=s<r?s+p:r+p;
var f=j[q-1].y,d=j[q].y,a=OG.Util.round(Math.abs(d-f)/2);
l=f<d?f+a:d+a
}else{q=parseInt(h/2);
m=j[q].x;
l=j[q].y
}v=[m,l];
c.shape.toLabel=n||c.shape.toLabel;
t=c.shape.toLabel;
e=OG.Constants.TO_LABEL_SUFFIX
}else{if(g==="CENTER"){v=[j[j.length/2].x,j[j.length/2].y+u._CONFIG.FROMTO_LABEL_OFFSET_TOP];
c.shape.toLabel=n||c.shape.toLabel;
t=c.shape.toLabel;
e=OG.Constants.TO_LABEL_SUFFIX
}else{v=[j[j.length-1].x,j[j.length-1].y+u._CONFIG.FROMTO_LABEL_OFFSET_TOP];
c.shape.toLabel=n||c.shape.toLabel;
t=c.shape.toLabel;
e=OG.Constants.TO_LABEL_SUFFIX
}}}if(t!=undefined){b=this._drawLabel(v,t,[0,0],c.shape.geom.style,c.id+e,false);
c.appendChild(b)
}}}return b
};
OG.renderer.RaphaelRenderer.prototype.redrawShape=function(e,h){var g=this,f,b,c,j,a,d;
d=function(s,n){var t,r,p,l=n.childNodes,k,q,o,m;
for(q=l.length-1;
q>=0;
q--){if($(l[q]).attr("_type")===OG.Constants.NODE_TYPE.SHAPE){d(s,l[q]);
m=false;
t=$(l[q]).attr("_fromedge");
if(t){t=t.split(",");
for(o=0;
o<t.length;
o++){r=g.getElementById(t[o]);
if(r){k=g._getShapeFromTerminal($(r).attr("_from"));
if($(k).parents("#"+s.id).length===0){m=true
}}}}t=$(l[q]).attr("_toedge");
if(t){t=t.split(",");
for(o=0;
o<t.length;
o++){p=g.getElementById(t[o]);
if(p){k=g._getShapeFromTerminal($(p).attr("_to"));
if($(k).parents("#"+s.id).length===0){m=true
}}}}if(m===true){g.redrawConnectedEdge(l[q])
}}}};
if(e&&e.shape.geom){switch($(e).attr("_shape")){case OG.Constants.SHAPE_TYPE.GEOM:e=this.drawGeom(e.shape.geom,{},e.id);
this.redrawConnectedEdge(e,h);
this.drawLabel(e);
break;
case OG.Constants.SHAPE_TYPE.TEXT:f=e.shape.geom.getBoundary();
b=f.getCentroid();
c=f.getWidth();
j=f.getHeight();
e=this.drawText([b.x,b.y],e.shape.text,[c,j,e.shape.angle],e.shape.geom.style,e.id);
this.redrawConnectedEdge(e,h);
break;
case OG.Constants.SHAPE_TYPE.IMAGE:f=e.shape.geom.getBoundary();
b=f.getCentroid();
c=f.getWidth();
j=f.getHeight();
e=this.drawImage([b.x,b.y],e.shape.image,[c,j,e.shape.angle],e.shape.geom.style,e.id);
this.redrawConnectedEdge(e,h);
this.drawLabel(e);
break;
case OG.Constants.SHAPE_TYPE.HTML:f=e.shape.geom.getBoundary();
b=f.getCentroid();
c=f.getWidth();
j=f.getHeight();
e.shape.html=e.shape.html.replace(new RegExp('height="(\\d+)px"',"g"),'height="'+j+'px"');
e=this.drawHtml([b.x,b.y],e.shape.html,[c,j,e.shape.angle],e.shape.geom.style,e.id);
this.redrawConnectedEdge(e,h);
this.drawLabel(e);
break;
case OG.Constants.SHAPE_TYPE.EDGE:e=this.drawEdge(e.shape.geom,e.shape.geom.style,e.id);
this.drawEdgeLabel(e,null,"TO");
break;
case OG.Constants.SHAPE_TYPE.GROUP:if(e.shape.isCollapsed===true){f=e.shape.geom.getBoundary();
a=f.getUpperLeft();
e=this.drawGroup(new OG.geometry.Rectangle(a,g._CONFIG.COLLAPSE_SIZE*3,g._CONFIG.COLLAPSE_SIZE*2),e.shape.geom.style,e.id);
d(e,e);
this.redrawConnectedEdge(e,h)
}else{e=this.drawGroup(e.shape.geom,e.shape.geom.style,e.id);
this.redrawConnectedEdge(e,h);
this.drawLabel(e)
}break
}}$(this._PAPER.canvas).trigger("redrawShape",[e]);
return e
};
OG.renderer.RaphaelRenderer.prototype.redrawEdge=function(b){var D=this,f,A,t,E,p,h,n,q,d,g,B,c,u,v,j,l,k,x,m,s,e,C,a,r,z;
f=OG.Util.isElement(b)?b:this.getElementById(b);
A=$(f).attr("_from");
t=$(f).attr("_to");
if(A){E=this._getShapeFromTerminal(A);
h=parseInt(A.substring(A.lastIndexOf("_")+1),10);
q=E.shape.createTerminal()[h];
B=q.direction.toLowerCase();
u=q.position
}else{g=f.shape.geom.getVertices();
B="c";
u=g[0]
}if(t){p=this._getShapeFromTerminal(t);
n=parseInt(t.substring(t.lastIndexOf("_")+1),10);
d=p.shape.createTerminal()[n];
c=d.direction.toLowerCase();
v=d.position
}else{g=f.shape.geom.getVertices();
c="c";
v=g[g.length-1]
}g=f.shape.geom.getVertices();
j=u;
l=v;
k=B;
x=c;
var y=g.length>2?g[1]:l;
var o=g.length>2?g[g.length-2]:j;
if(E&&B==="c"){m=this.intersectionEdge(f.shape.geom.style.get("edge-type"),E,[j.x,j.y],[y.x,y.y],true);
u=m.position;
B=m.direction
}if(p&&c==="c"){m=this.intersectionEdge(f.shape.geom.style.get("edge-type"),p,[o.x,o.y],[l.x,l.y],false);
v=m.position;
c=m.direction
}s=E&&p&&E.id===p.id;
if(s){u=v=E.shape.geom.getBoundary().getRightCenter()
}else{if(E){e=$(E).parents("[_collapsed=true]");
if(e.length!==0||$(E).attr("_collapsed")==="true"){if(e.length===0){C=E.shape.geom.getBoundary()
}else{C=e[e.length-1].shape.geom.getBoundary()
}a=C.getUpperLeft();
r=new OG.geometry.Rectangle(a,D._CONFIG.COLLAPSE_SIZE*3,D._CONFIG.COLLAPSE_SIZE*2);
switch(B.toUpperCase()){case OG.Constants.TERMINAL_TYPE.E:z=r.getBoundary().getRightCenter();
break;
case OG.Constants.TERMINAL_TYPE.W:z=r.getBoundary().getLeftCenter();
break;
case OG.Constants.TERMINAL_TYPE.S:z=r.getBoundary().getLowerCenter();
break;
case OG.Constants.TERMINAL_TYPE.N:z=r.getBoundary().getUpperCenter();
break
}if(z){u=[z.x,z.y]
}}}if(p){e=$(p).parents("[_collapsed=true]");
if(e.length!==0||$(p).attr("_collapsed")==="true"){if(e.length===0){C=p.shape.geom.getBoundary()
}else{C=e[e.length-1].shape.geom.getBoundary()
}a=C.getUpperLeft();
r=new OG.geometry.Rectangle(a,D._CONFIG.COLLAPSE_SIZE*3,D._CONFIG.COLLAPSE_SIZE*2);
switch(c.toUpperCase()){case OG.Constants.TERMINAL_TYPE.E:z=r.getBoundary().getRightCenter();
break;
case OG.Constants.TERMINAL_TYPE.W:z=r.getBoundary().getLeftCenter();
break;
case OG.Constants.TERMINAL_TYPE.S:z=r.getBoundary().getLowerCenter();
break;
case OG.Constants.TERMINAL_TYPE.N:z=r.getBoundary().getUpperCenter();
break
}if(z){v=[z.x,z.y]
}}}}var w=[];
w.push([u[0],u[1]]);
var g=f.shape.geom.getVertices();
g.each(function(G,F){if(F!=0&&F!=g.length-1){w.push([G.x,G.y])
}});
w.push([v[0],v[1]]);
f=this.drawEdge(new OG.PolyLine(w),OG.Util.apply(f.shape.geom.style.map,{"edge-direction":B+" "+c}),f.id,s);
this.drawEdgeLabel(f,null,"TO");
OG.Util.apply(f.shape.geom.style.map,{"edge-direction":k+" "+x})
};
OG.renderer.RaphaelRenderer.prototype.redrawConnectedEdge=function(a,c){var b=this,d;
d=$(a).attr("_fromedge");
if(d){$.each(d.split(","),function(e,f){if(!c||c.toString().indexOf(f)<0){b.redrawEdge(f)
}})
}d=$(a).attr("_toedge");
if(d){$.each(d.split(","),function(e,f){if(!c||c.toString().indexOf(f)<0){b.redrawEdge(f)
}})
}this.removeAllTerminal()
};
OG.renderer.RaphaelRenderer.prototype.connect=function(p,a,e,s,k){var u=this,j={},v,m,l,o,q,f,g,t,b,h,r,n,d,c=function(y,x,z){var A=$(y).attr(x),B=A?A.split(","):[],w=[];
$.each(B,function(C,D){if(D!==z){w.push(D)
}});
w.push(z);
$(y).attr(x,w.toString());
return y
};
OG.Util.apply(j,(s instanceof OG.geometry.Style)?s.map:s||{},u._CONFIG.DEFAULT_STYLE.EDGE);
if(OG.Util.isElement(p)){v=this._getShapeFromTerminal(p);
o=[p.terminal.position.x,p.terminal.position.y];
t=p.terminal.direction.toLowerCase()
}else{o=p;
t="c"
}if(OG.Util.isElement(a)){m=this._getShapeFromTerminal(a);
q=[a.terminal.position.x,a.terminal.position.y];
b=a.terminal.direction.toLowerCase()
}else{q=a;
b="c"
}if(v&&m){d=jQuery.Event("beforeConnectShape",{edge:e,fromShape:v,toShape:m});
$(this._PAPER.canvas).trigger(d);
if(d.isPropagationStopped()){this.remove(e);
return false
}}f=o;
g=q;
h=t;
r=b;
if(v&&t==="c"){l=this.intersectionEdge(j["edge-type"],v,f,g,true);
o=l.position;
t=l.direction
}if(m&&b==="c"){l=this.intersectionEdge(j["edge-type"],m,f,g,false);
q=l.position;
b=l.direction
}n=v&&m&&v.id===m.id;
if(n){o=q=v.shape.geom.getBoundary().getRightCenter()
}e=this.drawEdge(new OG.Line(o,q),OG.Util.apply(j,{"edge-direction":t+" "+b}),e?e.id:null,n);
this.drawEdgeLabel(e,null,"TO");
OG.Util.apply(e.shape.geom.style.map,{"edge-direction":h+" "+r});
e.shapeStyle=e.shape.geom.style.map;
this.disconnect(e);
if(OG.Util.isElement(p)){$(e).attr("_from",p.id);
c(v,"_toedge",e.id)
}if(OG.Util.isElement(a)){$(e).attr("_to",a.id);
c(m,"_fromedge",e.id)
}this.removeAllTerminal();
if(v&&m){$(this._PAPER.canvas).trigger("connectShape",[e,v,m])
}return e
};
OG.renderer.RaphaelRenderer.prototype.disconnect=function(f){var j=this,k,g,l,d,b,a,h,e,c=function(o,n,p){var q=$(o).attr(n),r=q?q.split(","):[],m=[];
$.each(r,function(s,t){if(t!==p){m.push(t)
}});
$(o).attr(n,m.toString());
return o
};
if(f){if($(f).attr("_shape")===OG.Constants.SHAPE_TYPE.EDGE){k=$(f).attr("_from");
g=$(f).attr("_to");
if(k){l=this._getShapeFromTerminal(k);
c(l,"_toedge",f.id);
$(f).removeAttr("_from")
}if(g){d=this._getShapeFromTerminal(g);
c(d,"_fromedge",f.id);
$(f).removeAttr("_to")
}if(l&&d){$(this._PAPER.canvas).trigger("disconnectShape",[f,l,d])
}}else{b=$(f).attr("_fromedge");
a=$(f).attr("_toedge");
if(b){$.each(b.split(","),function(m,n){h=j.getElementById(n);
k=$(h).attr("_from");
if(k){l=j._getShapeFromTerminal(k);
c(l,"_toedge",n)
}if(l&&f){$(j._PAPER.canvas).trigger("disconnectShape",[h,l,f])
}j.remove(h)
})
}if(a){$.each(a.split(","),function(m,n){e=j.getElementById(n);
g=$(e).attr("_to");
if(g){d=j._getShapeFromTerminal(g);
c(d,"_fromedge",n)
}if(f&&d){$(j._PAPER.canvas).trigger("disconnectShape",[e,f,d])
}j.remove(e)
})
}}}};
OG.renderer.RaphaelRenderer.prototype.drawDropOverGuide=function(b){var f=this,d=this._getREleById(OG.Util.isElement(b)?b.id:b),g=d?d.node.shape.geom:null,e,j,a,h=f._CONFIG.GUIDE_RECT_SIZE/2,c=h/2;
if(d&&g&&$(b).attr("_shape")!==OG.Constants.SHAPE_TYPE.EDGE&&!this._getREleById(d.id+OG.Constants.DROP_OVER_BBOX_SUFFIX)){e=g.getBoundary();
j=e.getUpperLeft();
a=this._PAPER.rect(j.x-c,j.y-c,e.getWidth()+h,e.getHeight()+h);
a.attr(OG.Util.apply({"stroke-width":h},f._CONFIG.DEFAULT_STYLE.DROP_OVER_BBOX));
this._add(a,d.id+OG.Constants.DROP_OVER_BBOX_SUFFIX);
a.insertAfter(d)
}};
OG.renderer.RaphaelRenderer.prototype.drawGuide=function(c){var x=this,t=this._getREleById(OG.Util.isElement(c)?c.id:c),j=t?t.node.shape.geom:null,b,m,y,l,p,e,g,q,o,w,A,f,u,n,s,k,a,d,v,z,h=x._CONFIG.GUIDE_RECT_SIZE,r=OG.Util.round(h/2);
if(t&&j){if($(c).attr("_shape")===OG.Constants.SHAPE_TYPE.EDGE){return this.drawEdgeGuide(c)
}else{b=j.getBoundary();
p=b.getUpperLeft();
e=b.getUpperRight();
g=b.getLowerLeft();
q=b.getLowerRight();
o=b.getLeftCenter();
w=b.getUpperCenter();
A=b.getRightCenter();
f=b.getLowerCenter();
if(this._getREleById(t.id+OG.Constants.GUIDE_SUFFIX.GUIDE)){this._remove(this._getREleById(t.id+OG.Constants.GUIDE_SUFFIX.BBOX));
l=this._PAPER.rect(p.x,p.y,b.getWidth(),b.getHeight());
l.attr(x._CONFIG.DEFAULT_STYLE.GUIDE_BBOX);
this._add(l,t.id+OG.Constants.GUIDE_SUFFIX.BBOX);
l.insertBefore(t);
u=this._getREleById(t.id+OG.Constants.GUIDE_SUFFIX.UL);
n=this._getREleById(t.id+OG.Constants.GUIDE_SUFFIX.UR);
s=this._getREleById(t.id+OG.Constants.GUIDE_SUFFIX.LL);
k=this._getREleById(t.id+OG.Constants.GUIDE_SUFFIX.LR);
a=this._getREleById(t.id+OG.Constants.GUIDE_SUFFIX.LC);
d=this._getREleById(t.id+OG.Constants.GUIDE_SUFFIX.UC);
v=this._getREleById(t.id+OG.Constants.GUIDE_SUFFIX.RC);
z=this._getREleById(t.id+OG.Constants.GUIDE_SUFFIX.LWC);
u.attr({x:p.x-r,y:p.y-r});
n.attr({x:e.x-r,y:e.y-r});
s.attr({x:g.x-r,y:g.y-r});
k.attr({x:q.x-r,y:q.y-r});
a.attr({x:o.x-r,y:o.y-r});
d.attr({x:w.x-r,y:w.y-r});
v.attr({x:A.x-r,y:A.y-r});
z.attr({x:f.x-r,y:f.y-r});
return null
}m=this._getREleById(t.id+OG.Constants.GUIDE_SUFFIX.GUIDE);
if(m){this._remove(m);
this._remove(this._getREleById(t.id+OG.Constants.GUIDE_SUFFIX.BBOX))
}m=this._PAPER.group();
l=this._PAPER.rect(p.x,p.y,b.getWidth(),b.getHeight());
u=this._PAPER.rect(p.x-r,p.y-r,h,h);
n=this._PAPER.rect(e.x-r,e.y-r,h,h);
s=this._PAPER.rect(g.x-r,g.y-r,h,h);
k=this._PAPER.rect(q.x-r,q.y-r,h,h);
a=this._PAPER.rect(o.x-r,o.y-r,h,h);
d=this._PAPER.rect(w.x-r,w.y-r,h,h);
v=this._PAPER.rect(A.x-r,A.y-r,h,h);
z=this._PAPER.rect(f.x-r,f.y-r,h,h);
l.attr(x._CONFIG.DEFAULT_STYLE.GUIDE_BBOX);
u.attr(x._CONFIG.DEFAULT_STYLE.GUIDE_UL);
n.attr(x._CONFIG.DEFAULT_STYLE.GUIDE_UR);
s.attr(x._CONFIG.DEFAULT_STYLE.GUIDE_LL);
k.attr(x._CONFIG.DEFAULT_STYLE.GUIDE_LR);
a.attr(x._CONFIG.DEFAULT_STYLE.GUIDE_LC);
d.attr(x._CONFIG.DEFAULT_STYLE.GUIDE_UC);
v.attr(x._CONFIG.DEFAULT_STYLE.GUIDE_RC);
z.attr(x._CONFIG.DEFAULT_STYLE.GUIDE_LWC);
m.appendChild(u);
m.appendChild(n);
m.appendChild(s);
m.appendChild(k);
m.appendChild(a);
m.appendChild(d);
m.appendChild(v);
m.appendChild(z);
this._add(m,t.id+OG.Constants.GUIDE_SUFFIX.GUIDE);
this._add(l,t.id+OG.Constants.GUIDE_SUFFIX.BBOX);
this._add(u,t.id+OG.Constants.GUIDE_SUFFIX.UL);
this._add(n,t.id+OG.Constants.GUIDE_SUFFIX.UR);
this._add(s,t.id+OG.Constants.GUIDE_SUFFIX.LL);
this._add(k,t.id+OG.Constants.GUIDE_SUFFIX.LR);
this._add(a,t.id+OG.Constants.GUIDE_SUFFIX.LC);
this._add(d,t.id+OG.Constants.GUIDE_SUFFIX.UC);
this._add(v,t.id+OG.Constants.GUIDE_SUFFIX.RC);
this._add(z,t.id+OG.Constants.GUIDE_SUFFIX.LWC);
y={bBox:l.node,group:m.node,ul:u.node,ur:n.node,ll:s.node,lr:k.node,lc:a.node,uc:d.node,rc:v.node,lwc:z.node};
l.insertBefore(t);
m.insertAfter(t);
$(t.node).attr("_selected","true");
return y
}}return null
};
OG.renderer.RaphaelRenderer.prototype.removeGuide=function(c){var b=this._getREleById(OG.Util.isElement(c)?c.id:c),a=this._getREleById(b.id+OG.Constants.GUIDE_SUFFIX.GUIDE),d=this._getREleById(b.id+OG.Constants.GUIDE_SUFFIX.BBOX);
b.node.removeAttribute("_selected");
if(c.shape instanceof bpm.Connection){this.setShapeStyle(c,{"stroke-width":1.5})
}this._remove(a);
this._remove(d)
};
OG.renderer.RaphaelRenderer.prototype.removeAllGuide=function(){var a=this;
$(a.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(b,c){if(OG.Util.isElement(c)&&c.id){a.removeGuide(c)
}})
};
OG.renderer.RaphaelRenderer.prototype.drawEdgeGuide=function(a){var r=this,l=this._getREleById(OG.Util.isElement(a)?a.id:a),d=l?l.node.shape.geom:null,e,n,g,t,o,p,s,h,j,c,m=[],b=r._CONFIG.GUIDE_RECT_SIZE,k=OG.Util.round(b/2),f={},q;
if(l&&d){OG.Util.apply(f,d.style.map,r._CONFIG.DEFAULT_STYLE.EDGE);
e=f["edge-type"]===OG.Constants.EDGE_TYPE.BEZIER?d.getControlPoints():d.getVertices();
n=$(a).attr("_from")&&$(a).attr("_to")&&$(a).attr("_from")===$(a).attr("_to");
if(this._getREleById(l.id+OG.Constants.GUIDE_SUFFIX.GUIDE)){this._remove(this._getREleById(l.id+OG.Constants.GUIDE_SUFFIX.BBOX));
this._remove(this._getREleById(l.id+OG.Constants.GUIDE_SUFFIX.GUIDE))
}if(this._getREleById(l.id+OG.Constants.GUIDE_SUFFIX.GUIDE)){this._remove(this._getREleById(l.id+OG.Constants.GUIDE_SUFFIX.BBOX));
o="";
if(f["edge-type"]===OG.Constants.EDGE_TYPE.BEZIER){for(q=0;
q<e.length;
q++){if(q===0){o="M"+e[q].x+" "+e[q].y
}else{if(q===1){o+="C"+e[q].x+" "+e[q].y
}else{o+=" "+e[q].x+" "+e[q].y
}}}}else{for(q=0;
q<e.length;
q++){if(q===0){o="M"+e[q].x+" "+e[q].y
}else{o+="L"+e[q].x+" "+e[q].y
}}}p=this._PAPER.path(o);
p.attr(r._CONFIG.DEFAULT_STYLE.GUIDE_BBOX);
this._add(p,l.id+OG.Constants.GUIDE_SUFFIX.BBOX);
p.insertBefore(l);
s=this._getREleById(l.id+OG.Constants.GUIDE_SUFFIX.FROM);
s.attr({x:e[0].x-k,y:e[0].y-k});
h=this._getREleById(l.id+OG.Constants.GUIDE_SUFFIX.TO);
h.attr({x:e[e.length-1].x-k,y:e[e.length-1].y-k});
if(!n&&f["edge-type"]!==OG.Constants.EDGE_TYPE.BEZIER){for(q=1;
q<e.length-1;
q++){j=this._getREleById(l.id+OG.Constants.GUIDE_SUFFIX.CTL_B+q);
if(j){j.attr({x:e[q].x-k,y:e[q].y-k})
}}for(q=0;
q<e.length;
q++){if(q!=e.length-1){c=this._getREleById(l.id+OG.Constants.GUIDE_SUFFIX.CTL_C+q);
if(c){c.attr({x:OG.Util.round((e[q].x+e[q+1].x)/2)-k,y:OG.Util.round((e[q].y+e[q+1].y)/2)-k})
}}}}return null
}g=this._getREleById(l.id+OG.Constants.GUIDE_SUFFIX.GUIDE);
if(g){this._remove(g);
this._remove(this._getREleById(l.id+OG.Constants.GUIDE_SUFFIX.BBOX))
}g=this._PAPER.group();
o="";
if(f["edge-type"]===OG.Constants.EDGE_TYPE.BEZIER){for(q=0;
q<e.length;
q++){if(q===0){o="M"+e[q].x+" "+e[q].y
}else{if(q===1){o+="C"+e[q].x+" "+e[q].y
}else{o+=" "+e[q].x+" "+e[q].y
}}}}else{for(q=0;
q<e.length;
q++){if(q===0){o="M"+e[q].x+" "+e[q].y
}else{o+="L"+e[q].x+" "+e[q].y
}}}p=this._PAPER.path(o);
p.attr(r._CONFIG.DEFAULT_STYLE.GUIDE_BBOX);
s=this._PAPER.rect(e[0].x-k,e[0].y-k,b,b);
s.attr(r._CONFIG.DEFAULT_STYLE.GUIDE_FROM);
g.appendChild(s);
this._add(s,l.id+OG.Constants.GUIDE_SUFFIX.FROM);
h=this._PAPER.rect(e[e.length-1].x-k,e[e.length-1].y-k,b,b);
h.attr(r._CONFIG.DEFAULT_STYLE.GUIDE_TO);
g.appendChild(h);
this._add(h,l.id+OG.Constants.GUIDE_SUFFIX.TO);
if(!n&&f["edge-type"]!==OG.Constants.EDGE_TYPE.BEZIER){for(q=1;
q<e.length-1;
q++){j=this._PAPER.rect(e[q].x-k,e[q].y-k,b,b);
j.attr(r._CONFIG.DEFAULT_STYLE.GUIDE_CTL_B);
this._add(j,l.id+OG.Constants.GUIDE_SUFFIX.CTL_B+q);
g.appendChild(j);
m.push(j.node)
}for(q=0;
q<e.length;
q++){if(q!=e.length-1){c=this._PAPER.rect(OG.Util.round((e[q].x+e[q+1].x)/2)-k,OG.Util.round((e[q].y+e[q+1].y)/2)-k,b-2,b-2);
c.attr(r._CONFIG.DEFAULT_STYLE.GUIDE_CTL_C);
this._add(c,l.id+OG.Constants.GUIDE_SUFFIX.CTL_C+q);
g.appendChild(c);
m.push(c.node)
}}}this._add(p,l.id+OG.Constants.GUIDE_SUFFIX.BBOX);
this._add(g,l.id+OG.Constants.GUIDE_SUFFIX.GUIDE);
t={bBox:p.node,group:g.node,from:s.node,to:h.node,controls:m};
p.insertBefore(l);
g.insertAfter(l);
this.setShapeStyle(a,{"stroke-width":2.5});
$(l.node).attr("_selected","true");
return t
}return null
};
OG.renderer.RaphaelRenderer.prototype.drawRubberBand=function(d,k,a){var e=this,h=d?d[0]:0,g=d?d[1]:0,b=k?k[0]:0,j=k?k[1]:0,f=this._getREleById(OG.Constants.RUBBER_BAND_ID),c={};
if(f){f.attr({x:h,y:g,width:Math.abs(b),height:Math.abs(j)});
return f
}OG.Util.apply(c,(a instanceof OG.geometry.Style)?a.map:a||{},e._CONFIG.DEFAULT_STYLE.RUBBER_BAND);
f=this._PAPER.rect(h,g,b,j).attr(c);
this._add(f,OG.Constants.RUBBER_BAND_ID);
this._ETC_GROUP.node.appendChild(f.node);
return f.node
};
OG.renderer.RaphaelRenderer.prototype.removeRubberBand=function(a){this.setAttr(OG.Constants.RUBBER_BAND_ID,{x:0,y:0,width:0,height:0});
$(a).removeData("dragBox_first");
$(a).removeData("rubberBand")
};
OG.renderer.RaphaelRenderer.prototype.drawTerminal=function(a,b){var f=this,c=this._getREleById(OG.Util.isElement(a)?a.id:a),m=c?c.node.shape.createTerminal():null,e=c?c.node.shape.geom.getBoundary():null,l,k,h,j,g,n=f._CONFIG.TERMINAL_SIZE,d=n*2;
if(c&&m&&m.length>0){l=this._getREleById(c.id+OG.Constants.TERMINAL_SUFFIX.GROUP);
h=this._getREleById(c.id+OG.Constants.TERMINAL_SUFFIX.BOX);
if(l||h){return{bBox:h.node,terminal:l.node}
}l=this._PAPER.group();
h=this._PAPER.rect(e.getUpperLeft().x-d,e.getUpperLeft().y-d,e.getWidth()+d*2,e.getHeight()+d*2);
h.attr(f._CONFIG.DEFAULT_STYLE.TERMINAL_BBOX);
this._add(h,c.id+OG.Constants.TERMINAL_SUFFIX.BOX);
$.each(m,function(o,p){if(!b||p.inout.indexOf(b)>=0){j=p.position.x;
g=p.position.y;
if(p.direction=="C"){k=f._PAPER.circle(j,g,n);
k.attr(f._CONFIG.DEFAULT_STYLE.TERMINAL);
k.node.terminal=p;
l.appendChild(k);
f._add(k,c.id+OG.Constants.TERMINAL_SUFFIX.GROUP+"_"+p.direction+"_"+p.inout+"_"+o)
}}});
this._add(l,c.id+OG.Constants.TERMINAL_SUFFIX.GROUP);
h.insertBefore(c);
l.insertAfter(c);
return{bBox:h.node,terminal:l.node}
}return null
};
OG.renderer.RaphaelRenderer.prototype.removeTerminal=function(b){var a=this._getREleById(OG.Util.isElement(b)?b.id:b),d,c;
if(a){d=this._getREleById(a.id+OG.Constants.TERMINAL_SUFFIX.GROUP);
if(d){this._remove(d)
}c=this._getREleById(a.id+OG.Constants.TERMINAL_SUFFIX.BOX);
if(c){this._remove(c)
}}};
OG.renderer.RaphaelRenderer.prototype.removeAllTerminal=function(){var a=this;
$.each(this._ELE_MAP.keys(),function(b,c){a.removeTerminal(c)
})
};
OG.renderer.RaphaelRenderer.prototype.drawCollapseGuide=function(b){var g=this,e=this._getREleById(OG.Util.isElement(b)?b.id:b),j=e?e.node.shape.geom:null,f,k,a,d,h=g._CONFIG.COLLAPSE_SIZE,c=h/2;
if(e&&j&&$(b).attr("_shape")===OG.Constants.SHAPE_TYPE.GROUP){a=this._getREleById(e.id+OG.Constants.COLLAPSE_BBOX_SUFFIX);
if(a){this._remove(a)
}d=this._getREleById(e.id+OG.Constants.COLLAPSE_SUFFIX);
if(d){this._remove(d)
}f=j.getBoundary();
k=f.getUpperLeft();
a=this._PAPER.rect(f.getUpperLeft().x-h,f.getUpperLeft().y-h,f.getWidth()+h*2,f.getHeight()+h*2);
a.attr(g._CONFIG.DEFAULT_STYLE.COLLAPSE_BBOX);
this._add(a,e.id+OG.Constants.COLLAPSE_BBOX_SUFFIX);
if(e.node.shape.isCollapsed===true){d=this._PAPER.path("M"+(k.x+c)+" "+(k.y+c)+"h"+h+"v"+h+"h"+(-1*h)+"v"+(-1*h)+"m1 "+c+"h"+(h-2)+"M"+(k.x+c)+" "+(k.y+c)+"m"+c+" 1v"+(h-2))
}else{d=this._PAPER.path("M"+(k.x+c)+" "+(k.y+c)+"h"+h+"v"+h+"h"+(-1*h)+"v"+(-1*h)+"m1 "+c+"h"+(h-2))
}d.attr(g._CONFIG.DEFAULT_STYLE.COLLAPSE);
this._add(d,e.id+OG.Constants.COLLAPSE_SUFFIX);
a.insertBefore(e);
d.insertAfter(e);
return{bBox:a.node,collapse:d.node}
}return null
};
OG.renderer.RaphaelRenderer.prototype.removeCollapseGuide=function(c){var a=this._getREleById(OG.Util.isElement(c)?c.id:c),d,b;
if(a){d=this._getREleById(a.id+OG.Constants.COLLAPSE_BBOX_SUFFIX);
if(d){this._remove(d)
}b=this._getREleById(a.id+OG.Constants.COLLAPSE_SUFFIX);
if(b){this._remove(b)
}}};
OG.renderer.RaphaelRenderer.prototype.group=function(a){var c,b=[],g,h,e,f,j,d;
if(a&&a.length>1){for(d=0;
d<a.length;
d++){b.push(a[d].shape.geom)
}g=new OG.GeometryCollection(b);
h=g.getBoundary();
e=[h.getCentroid().x,h.getCentroid().y];
f=new OG.GroupShape();
j=[h.getWidth(),h.getHeight()];
c=this.drawShape(e,f,j);
for(d=0;
d<a.length;
d++){c.appendChild(a[d])
}$(this._PAPER.canvas).trigger("group",[c])
}return c
};
OG.renderer.RaphaelRenderer.prototype.ungroup=function(d){var e=[],c,b,a;
if(d&&d.length>0){for(b=0;
b<d.length;
b++){c=$(d[b]).children("[_type='"+OG.Constants.NODE_TYPE.SHAPE+"']");
for(a=0;
a<c.length;
a++){d[b].parentNode.appendChild(c[a]);
e.push(c[a])
}this.removeShape(d[b])
}$(this._PAPER.canvas).trigger("ungroup",[e])
}return e
};
OG.renderer.RaphaelRenderer.prototype.addToGroup=function(b,c){var a;
for(a=0;
a<c.length;
a++){b.appendChild(c[a])
}};
OG.renderer.RaphaelRenderer.prototype.collapse=function(c){var d=this,e,b,a;
a=function(p,k){var q,o,m,g=k.childNodes,f,n,l,h;
for(n=g.length-1;
n>=0;
n--){if($(g[n]).attr("_type")===OG.Constants.NODE_TYPE.SHAPE){a(p,g[n]);
h=false;
q=$(g[n]).attr("_fromedge");
if(q){q=q.split(",");
for(l=0;
l<q.length;
l++){o=d.getElementById(q[l]);
if(o){f=d._getShapeFromTerminal($(o).attr("_from"));
if($(f).parents("#"+p.id).length!==0){d.hide(o)
}else{h=true
}}}}q=$(g[n]).attr("_toedge");
if(q){q=q.split(",");
for(l=0;
l<q.length;
l++){m=d.getElementById(q[l]);
if(m){f=d._getShapeFromTerminal($(m).attr("_to"));
if($(f).parents("#"+p.id).length!==0){d.hide(m)
}else{h=true
}}}}if(h===true){d.redrawConnectedEdge(g[n])
}}}};
if(c.shape){e=c.childNodes;
for(b=e.length-1;
b>=0;
b--){if($(e[b]).attr("_type")===OG.Constants.NODE_TYPE.SHAPE){this.hide(e[b])
}}c.shape.isCollapsed=true;
$(c).attr("_collapsed",true);
a(c,c);
this.redrawShape(c);
$(this._PAPER.canvas).trigger("collapsed",[c])
}};
OG.renderer.RaphaelRenderer.prototype.expand=function(c){var d=this,e,b,a;
a=function(p,k){var q,o,m,g=k.childNodes,f,n,l,h;
for(n=g.length-1;
n>=0;
n--){if($(g[n]).attr("_type")===OG.Constants.NODE_TYPE.SHAPE){a(p,g[n]);
h=false;
q=$(g[n]).attr("_fromedge");
if(q){q=q.split(",");
for(l=0;
l<q.length;
l++){o=d.getElementById(q[l]);
if(o){f=d._getShapeFromTerminal($(o).attr("_from"));
if($(f).parents("#"+p.id).length!==0){d.show(o)
}else{h=true
}}}}q=$(g[n]).attr("_toedge");
if(q){q=q.split(",");
for(l=0;
l<q.length;
l++){m=d.getElementById(q[l]);
if(m){f=d._getShapeFromTerminal($(m).attr("_to"));
if($(f).parents("#"+p.id).length!==0){d.show(m)
}else{h=true
}}}}if(h===true){d.redrawConnectedEdge(g[n])
}}}};
if(c.shape){e=c.childNodes;
for(b=e.length-1;
b>=0;
b--){if($(e[b]).attr("_type")===OG.Constants.NODE_TYPE.SHAPE){this.show(e[b])
}}c.shape.isCollapsed=false;
$(c).attr("_collapsed",false);
a(c,c);
this.redrawShape(c);
$(this._PAPER.canvas).trigger("expanded",[c])
}};
OG.renderer.RaphaelRenderer.prototype.clear=function(){this._PAPER.clear();
this._ELE_MAP.clear();
this._ID_PREFIX=Math.round(Math.random()*10000);
this._LAST_ID=0;
this._ROOT_GROUP=this._add(this._PAPER.group(),null,OG.Constants.NODE_TYPE.ROOT);
this._ETC_GROUP=this._add(this._PAPER.group(),null,OG.Constants.NODE_TYPE.ETC)
};
OG.renderer.RaphaelRenderer.prototype.removeShape=function(d){var a=this._getREleById(OG.Util.isElement(d)?d.id:d),f,c,b,e;
f=a.node.childNodes;
c=jQuery.Event("beforeRemoveShape",{element:a.node});
$(this._PAPER.canvas).trigger(c);
if(c.isPropagationStopped()){return false
}for(b=f.length-1;
b>=0;
b--){if($(f[b]).attr("_type")===OG.Constants.NODE_TYPE.SHAPE){this.removeShape(f[b])
}}this.disconnect(a.node);
this.removeTerminal(a.node);
this.removeGuide(a.node);
this.removeCollapseGuide(a.node);
e=OG.Util.clone(a.node);
this.remove(a.node);
$(this._PAPER.canvas).trigger("removeShape",[e])
};
OG.renderer.RaphaelRenderer.prototype.remove=function(b){var c=OG.Util.isElement(b)?b.id:b,a=this._getREleById(c);
this._remove(a)
};
OG.renderer.RaphaelRenderer.prototype.removeChild=function(b){var c=OG.Util.isElement(b)?b.id:b,a=this._getREleById(c);
this._removeChild(a)
};
OG.renderer.RaphaelRenderer.prototype.getRootElement=function(){return this._PAPER.canvas
};
OG.renderer.RaphaelRenderer.prototype.getElementByPoint=function(a){var b=this._PAPER.getElementByPoint(a[0],a[1]);
return b?b.node.parentNode:null
};
OG.renderer.RaphaelRenderer.prototype.setAttr=function(b,c){var a=this._getREleById(OG.Util.isElement(b)?b.id:b);
if(a){a.attr(c)
}};
OG.renderer.RaphaelRenderer.prototype.getAttr=function(c,b){var a=this._getREleById(OG.Util.isElement(c)?c.id:c);
if(a){return a.attr(b)
}return null
};
OG.renderer.RaphaelRenderer.prototype.setShapeStyle=function(b,c){var a=this._getREleById(OG.Util.isElement(b)?b.id:b);
if(a&&b.shape&&b.shape.geom){OG.Util.apply(b.shape.geom.style.map,c||{});
b.shapeStyle=b.shapeStyle||{};
OG.Util.apply(b.shapeStyle,c||{});
this.redrawShape(b)
}};
OG.renderer.RaphaelRenderer.prototype.toFront=function(b){var a=this._getREleById(OG.Util.isElement(b)?b.id:b);
if(a){a.toFront()
}};
OG.renderer.RaphaelRenderer.prototype.toBack=function(b){var a=this._getREleById(OG.Util.isElement(b)?b.id:b);
if(a){a.toBack()
}};
OG.renderer.RaphaelRenderer.prototype.getCanvasSize=function(){return[this._PAPER.width,this._PAPER.height]
};
OG.renderer.RaphaelRenderer.prototype.setCanvasSize=function(a){this._PAPER.setSize(a[0],a[1])
};
OG.renderer.RaphaelRenderer.prototype.fitCanvasSize=function(a,c){var g=this,h=this.getRealRootBBox(),f,e,d=1,b=h.width+g._CONFIG.FIT_CANVAS_PADDING*2,j=h.height+g._CONFIG.FIT_CANVAS_PADDING*2;
if(h.width!==0&&h.height!==0){f=h.x>g._CONFIG.FIT_CANVAS_PADDING?-1*(h.x-g._CONFIG.FIT_CANVAS_PADDING):g._CONFIG.FIT_CANVAS_PADDING-h.x;
e=h.y>g._CONFIG.FIT_CANVAS_PADDING?-1*(h.y-g._CONFIG.FIT_CANVAS_PADDING):g._CONFIG.FIT_CANVAS_PADDING-h.y;
this.move(this.getRootGroup(),[f,e]);
this.removeAllGuide();
if(a&&a.length===2){if(OG.Util.isDefined(c)&&c===true){d=a[0]/b>a[1]/j?a[1]/j:a[0]/b
}b=b<a[0]?a[0]:b;
j=j<a[1]?a[1]:j
}this.setScale(OG.Util.roundPrecision(d,1));
this.setCanvasSize([b,j])
}};
OG.renderer.RaphaelRenderer.prototype.setViewBox=function(a,b,c){this._PAPER.setViewBox(a[0],a[1],b[0],b[1],c)
};
OG.renderer.RaphaelRenderer.prototype.getScale=function(b){var a=this;
return a._CONFIG.SCALE
};
OG.renderer.RaphaelRenderer.prototype.setScale=function(b){var a=this;
if(a._CONFIG.SCALE_MIN<=b&&b<=a._CONFIG.SCALE_MAX){if(this.isVML()){$(this._ROOT_GROUP.node).css({width:21600/b,height:21600/b});
$(this._ROOT_GROUP.node).find("[_type=SHAPE]").each(function(c,d){$(d).css({width:21600,height:21600})
})
}else{$(this._ROOT_GROUP.node).attr("transform","scale("+b+")");
$(this._ETC_GROUP.node).attr("transform","scale("+b+")")
}this._PAPER.setSize(OG.Util.roundGrid(this._PAPER.width/a._CONFIG.SCALE*b,a._CONFIG.MOVE_SNAP_SIZE),OG.Util.roundGrid(this._PAPER.height/a._CONFIG.SCALE*b,a._CONFIG.MOVE_SNAP_SIZE));
a._CONFIG.SCALE=b
}};
OG.renderer.RaphaelRenderer.prototype.show=function(b){var a=this._getREleById(OG.Util.isElement(b)?b.id:b);
if(a){a.show()
}};
OG.renderer.RaphaelRenderer.prototype.hide=function(b){var a=this._getREleById(OG.Util.isElement(b)?b.id:b);
if(a){a.hide()
}};
OG.renderer.RaphaelRenderer.prototype.appendChild=function(a,b){var c=this._getREleById(OG.Util.isElement(a)?a.id:a),d=this._getREleById(OG.Util.isElement(b)?b.id:b);
d.appendChild(c);
return c
};
OG.renderer.RaphaelRenderer.prototype.insertAfter=function(a,b){var c=this._getREleById(OG.Util.isElement(a)?a.id:a),d=this._getREleById(OG.Util.isElement(b)?b.id:b);
c.insertAfter(d);
return c
};
OG.renderer.RaphaelRenderer.prototype.insertBefore=function(a,b){var c=this._getREleById(OG.Util.isElement(a)?a.id:a),d=this._getREleById(OG.Util.isElement(b)?b.id:b);
c.insertBefore(d);
return c
};
OG.renderer.RaphaelRenderer.prototype.move=function(b,g,e){var d=this,a=this._getREleById(OG.Util.isElement(b)?b.id:b),c=a?a.node.getAttribute("_type"):null,f;
this.removeCollapseGuide(b);
if(a&&c){$(a.node).children("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_shape=EDGE]").each(function(h,j){d.move(j,g,e)
});
$(a.node).children("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_shape!=EDGE]").each(function(h,j){d.move(j,g,e)
});
if(c!==OG.Constants.NODE_TYPE.ROOT&&a.node.shape){f=a.node.shape.geom;
f.move(g[0],g[1]);
this.redrawShape(a.node,e);
$(this._PAPER.canvas).trigger("moveShape",[a.node,g]);
return a.node
}else{return b
}}else{if(a){a.transform("...t"+g[0]+","+g[1]);
$(this._PAPER.canvas).trigger("moveShape",[a.node,g]);
return a.node
}}return null
};
OG.renderer.RaphaelRenderer.prototype.moveCentroid=function(d,b,f){var c=this._getREleById(OG.Util.isElement(d)?d.id:d),g=c?c.node.shape.geom:null,e,a={};
if(c&&g){a=g.getCentroid();
return this.move(d,[b[0]-a.x,b[1]-a.y],f)
}else{if(c){e=c.getBBox();
a.x=e.x+OG.Util.round(e.width/2);
a.y=e.y+OG.Util.round(e.height/2);
return this.move(d,[b[0]-a.x,b[1]-a.y])
}}this.removeCollapseGuide(d);
return null
};
OG.renderer.RaphaelRenderer.prototype.rotate=function(d,c,k){var e=this._getREleById(OG.Util.isElement(d)?d.id:d),h=e?e.node.getAttribute("_shape"):null,j=e?e.node.shape.geom:null,f,g,a,b,l;
if(e&&h&&j){if(h===OG.Constants.SHAPE_TYPE.IMAGE||h===OG.Constants.SHAPE_TYPE.TEXT||h===OG.Constants.SHAPE_TYPE.HTML){f=e.node.shape.clone();
g=j.getBoundary();
a=g.getCentroid();
b=g.getWidth();
l=g.getHeight();
this.drawShape([a.x,a.y],f,[b,l,c],e.node.shapeStyle,e.node.id)
}else{if(e.node.shape.angle){j.rotate(-1*e.node.shape.angle)
}j.rotate(c);
e.node.shape.angle=c;
this.redrawShape(e.node,k)
}$(this._PAPER.canvas).trigger("rotateShape",[e.node,c]);
return e.node
}else{if(e){e.rotate(c);
$(this._PAPER.canvas).trigger("rotateShape",[e.node,c]);
return e.node
}}return null
};
OG.renderer.RaphaelRenderer.prototype.resize=function(d,b,k){var f=this._getREleById(OG.Util.isElement(d)?d.id:d),h=f?f.node.getAttribute("_shape"):null,j=f?f.node.shape.geom:null,n,e,c,a,m,l,g;
this.removeCollapseGuide(d);
if(f&&h&&j){j.resize(b[0],b[1],b[2],b[3]);
this.redrawShape(f.node,k);
$(this._PAPER.canvas).trigger("resizeShape",[f.node,b]);
return f.node
}else{if(f){n=f.getBBox();
e=b[2]+b[3];
c=b[0]+b[1];
a=n.width+e;
m=n.height+c;
l=n.width===0?1:a/n.width;
g=n.height===0?1:m/n.height;
f.transform("...t"+(-1*b[2])+","+(-1*b[0]));
f.transform("...s"+l+","+g+","+n.x+","+n.y);
$(this._PAPER.canvas).trigger("resizeShape",[f.node,b]);
return f.node
}}return null
};
OG.renderer.RaphaelRenderer.prototype.resizeBox=function(d,c){var b=this._getREleById(OG.Util.isElement(d)?d.id:d),g=b?b.node.shape.geom:null,h,f,e,a;
this.removeCollapseGuide(d);
if(b&&g){h=g.getBoundary();
e=OG.Util.round((c[0]-h.getWidth())/2);
a=OG.Util.round((c[1]-h.getHeight())/2);
return this.resize(d,[a,a,e,e])
}else{if(b){f=b.getBBox();
e=OG.Util.round((c[0]-f.width)/2);
a=OG.Util.round((c[1]-f.height)/2);
return this.resize(d,[a,a,e,e])
}}return null
};
OG.renderer.RaphaelRenderer.prototype.clone=function(b){var a=this._getREleById(OG.Util.isElement(b)?b.id:b),c;
c=a.clone();
this._add(c);
this._ROOT_GROUP.node.appendChild(c.node);
return c.node
};
OG.renderer.RaphaelRenderer.prototype.getElementById=function(b){var a=this._getREleById(b);
return a?a.node:null
};
OG.renderer.RaphaelRenderer.prototype.getBBox=function(b){var a=this._getREleById(OG.Util.isElement(b)?b.id:b);
return a.getBBox()
};
OG.renderer.RaphaelRenderer.prototype.getRootBBox=function(){var c=this._PAPER.canvas.parentNode,d=OG.Util.isFirefox()?this._PAPER.canvas.width.baseVal.value:this._PAPER.canvas.scrollWidth,b=OG.Util.isFirefox()?this._PAPER.canvas.height.baseVal.value:this._PAPER.canvas.scrollHeight,a=c.offsetLeft,e=c.offsetTop;
return{width:d,height:b,x:a,y:e,x2:a+d,y2:e+b}
};
OG.renderer.RaphaelRenderer.prototype.getContainer=function(){return this._PAPER.canvas.parentNode
};
OG.renderer.RaphaelRenderer.prototype.isSVG=function(){return Raphael.svg
};
OG.renderer.RaphaelRenderer.prototype.isVML=function(){return Raphael.vml
};
OG.handler.EventHandler=function(b,a){this._RENDERER=b;
this._CONFIG=a
};
OG.handler.EventHandler.prototype={enableEditLabel:function(a){var b=this;
$(a).__bind__({dblclick:function(f){var g=b._RENDERER.getContainer(),n=a.shape.geom.getBoundary(),e=n.getUpperLeft(),r,l=(e.x-1)*b._CONFIG.SCALE,p=(e.y-1)*b._CONFIG.SCALE,j=n.getWidth()*b._CONFIG.SCALE,q=n.getHeight()*b._CONFIG.SCALE,k=a.id+OG.Constants.LABEL_EDITOR_SUFFIX,d,h="center",s,m,o=function(x){var v,A,z,t,y=0,w,u;
if(x.shape.geom.style.get("edge-type")===OG.Constants.EDGE_TYPE.BEZIER){v=x.shape.geom.getControlPoints();
A=v[0];
z=v[v.length-1];
return new OG.geometry.Coordinate(OG.Util.round((A.x+z.x)/2),OG.Util.round((A.y+z.y)/2))
}else{v=x.shape.geom.getVertices();
t=x.shape.geom.getLength();
for(w=0;
w<v.length-1;
w++){y+=v[w].distance(v[w+1]);
if(y>t/2){u=x.shape.geom.intersectCircleToLine(v[w+1],y-t/2,v[w+1],v[w]);
break
}}return u[0]
}},c;
if(a.shape.isCollapsed===false){$(g).append("<input type='text' id='"+a.id+OG.Constants.LABEL_EDITOR_SUFFIX+"'>");
d=$("#"+k);
switch(a.shape.geom.style.get("text-anchor")){case"start":h="left";
break;
case"middle":h="center";
break;
case"end":h="right";
break;
default:h="center";
break
}if($(a).attr("_shape")===OG.Constants.SHAPE_TYPE.HTML){$(d).css(OG.Util.apply(b._CONFIG.DEFAULT_STYLE.LABEL_EDITOR,{left:l,top:p,width:j,height:q,"text-align":"left",overflow:"hidden",resize:"none"}));
$(d).focus();
$(d).val(a.shape.html);
$(d).__bind__({focusout:function(){a.shape.html=this.value;
if(a.shape.html){b._RENDERER.redrawShape(a);
this.parentNode.removeChild(this)
}else{b._RENDERER.removeShape(a);
this.parentNode.removeChild(this)
}}})
}else{if($(a).attr("_shape")===OG.Constants.SHAPE_TYPE.TEXT){$(d).css(OG.Util.apply(b._CONFIG.DEFAULT_STYLE.LABEL_EDITOR,{left:l,top:p,width:j,height:q,"text-align":h,overflow:"hidden",resize:"none"}));
$(d).focus();
$(d).val(a.shape.text);
$(d).__bind__({focusout:function(){a.shape.text=this.value;
if(a.shape.text){b._RENDERER.redrawShape(a);
this.parentNode.removeChild(this)
}else{b._RENDERER.removeShape(a);
this.parentNode.removeChild(this)
}}})
}else{if($(a).attr("_shape")===OG.Constants.SHAPE_TYPE.EDGE){if(a.shape.label&&b._RENDERER.isSVG()){$(a).children("[id$=_LABEL]").each(function(t,u){$(u).find("text").each(function(w,v){r=b._RENDERER.getBBox(v);
l=r.x-10;
p=r.y;
j=r.width+20;
q=r.height
})
})
}else{c=o(a);
l=c.x-b._CONFIG.LABEL_EDITOR_WIDTH/2;
p=c.y-b._CONFIG.LABEL_EDITOR_HEIGHT/2;
j=b._CONFIG.LABEL_EDITOR_WIDTH;
q=b._CONFIG.LABEL_EDITOR_HEIGHT
}$(f.srcElement).parents("[id$=_FROMLABEL]").each(function(t,u){$(u).find("text").each(function(w,v){r=b._RENDERER.getBBox(v);
l=r.x-10;
p=r.y;
j=r.width+20;
q=r.height;
s=a.shape.fromLabel
})
});
$(f.srcElement).parents("[id$=_TOLABEL]").each(function(t,u){$(u).find("text").each(function(w,v){r=b._RENDERER.getBBox(v);
l=r.x-10;
p=r.y;
j=r.width+20;
q=r.height;
m=a.shape.toLabel
})
});
$(d).css(OG.Util.apply(b._CONFIG.DEFAULT_STYLE.LABEL_EDITOR,{left:l*b._CONFIG.SCALE,top:p*b._CONFIG.SCALE,width:j*b._CONFIG.SCALE,height:q*b._CONFIG.SCALE,overflow:"hidden",resize:"none"}));
$(d).focus();
if(s||m){$(d).val(s?a.shape.fromLabel:a.shape.toLabel)
}else{$(d).val(a.shape.label)
}$(d).__bind__({focusout:function(){if(s){b._RENDERER.drawEdgeLabel(a,this.value,"FROM")
}else{if(m){b._RENDERER.drawEdgeLabel(a,this.value,"TO")
}else{b._RENDERER.drawLabel(a,this.value)
}}bpm.onNodeSelected(a);
this.parentNode.removeChild(this)
}});
$(d).__bind__("keydown",function(t){if(t.keyCode==13){if(s){b._RENDERER.drawEdgeLabel(a,this.value,"FROM")
}else{if(m){b._RENDERER.drawEdgeLabel(a,this.value,"TO")
}else{b._RENDERER.drawLabel(a,this.value)
}}bpm.onNodeSelected(a);
this.parentNode.removeChild(this)
}})
}else{$(d).css(OG.Util.apply(b._CONFIG.DEFAULT_STYLE.LABEL_EDITOR,{left:l,top:p,width:j,height:q,"text-align":h,overflow:"hidden",resize:"none"}));
$(d).focus();
$(d).val(a.shape.label);
$(d).__bind__({focusout:function(){b._RENDERER.drawLabel(a,this.value);
this.parentNode.removeChild(this)
}});
$(d).__bind__("keydown",function(t){if(t.keyCode==13){b._RENDERER.drawLabel(a,this.value);
this.parentNode.removeChild(this)
}})
}}}}}})
},enableConnect:function(b){var c=this,d,a=c._RENDERER.getRootGroup();
$(b).__bind__({mouseover:function(){if(b.shape.isCollapsed===false){d=c._RENDERER.drawTerminal(b,$(a).data("dragged_guide")==="to"?OG.Constants.TERMINAL_TYPE.IN:OG.Constants.TERMINAL_TYPE.OUT);
if(d&&d.terminal&&d.terminal.childNodes.length>0){if($(a).data("edge")){$.each(d.terminal.childNodes,function(e,h){var j=$(a).data("from_terminal"),g=j&&OG.Util.isElement(j)?c._getShapeFromTerminal(j):null,f=b&&g&&b.id===g.id;
if(h.terminal&&h.terminal.direction.toLowerCase()==="c"&&(($(a).data("dragged_guide")==="to"&&h.terminal.inout.indexOf(OG.Constants.TERMINAL_TYPE.IN)>=0)||($(a).data("dragged_guide")==="from"&&h.terminal.inout.indexOf(OG.Constants.TERMINAL_TYPE.OUT)>=0))&&(!f||c._isSelfConnectable(b.shape))){c._RENDERER.drawDropOverGuide(b);
$(a).data("edge_terminal",h);
return false
}})
}$(d.bBox).__bind__({mouseout:function(){if(!$(a).data("edge")){c._RENDERER.removeTerminal(b)
}}});
$.each(d.terminal.childNodes,function(e,f){if(f.terminal){$(f).__bind__({mouseover:function(j){var k=$(a).data("from_terminal"),h=k&&OG.Util.isElement(k)?c._getShapeFromTerminal(k):null,g=b&&h&&b.id===h.id;
if((($(a).data("dragged_guide")==="to"&&f.terminal.inout.indexOf(OG.Constants.TERMINAL_TYPE.IN)>=0)||($(a).data("dragged_guide")==="from"&&f.terminal.inout.indexOf(OG.Constants.TERMINAL_TYPE.OUT)>=0)||(!$(a).data("dragged_guide")&&f.terminal.inout.indexOf(OG.Constants.TERMINAL_TYPE.OUT)>=0))&&(!g||c._isSelfConnectable(b.shape))){c._RENDERER.setAttr(f,c._CONFIG.DEFAULT_STYLE.TERMINAL_OVER);
$(a).data("edge_terminal",f)
}},mouseout:function(){c._RENDERER.setAttr(f,c._CONFIG.DEFAULT_STYLE.TERMINAL);
$(a).removeData("edge_terminal")
}});
$(f).draggable({start:function(j){var g=f.terminal.position.x,k=f.terminal.position.y,h=c._RENDERER.drawShape(null,new bpm.Connection([g,k],[g,k]),null,c._CONFIG.DEFAULT_STYLE.EDGE_SHADOW);
$(a).data("edge",h);
$(a).data("from_terminal",f);
$(a).data("dragged_guide","to");
c._RENDERER.removeRubberBand(c._RENDERER.getRootElement());
$(c._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(m,l){if(l.id){c._RENDERER.removeGuide(l)
}})
},drag:function(g){var l=c._getOffset(g),j=$(a).data("edge"),q=$(a).data("from_terminal"),u=$(a).data("edge_terminal"),r=[q.terminal.position.x,q.terminal.position.y],n=u?[u.terminal.position.x,u.terminal.position.y]:[l.x,l.y],s=q.terminal.direction.toLowerCase(),o=u?u.terminal.direction.toLowerCase():"c",m=u?c._getShapeFromTerminal(u):null,h,t,k,p;
$(this).css({position:"",left:"",top:""});
h=r;
t=n;
if(!b.shape.geom.getBoundary().isContains(n)&&s==="c"){k=c._RENDERER.intersectionEdge(j.shape.geom.style.get("edge-type"),b,[h[0],h[1]],[t[0],t[1]],true);
r=k.position;
s=k.direction
}if(m&&o==="c"){k=c._RENDERER.intersectionEdge(j.shape.geom.style.get("edge-type"),m,[h[0],h[1]],[t[0],t[1]],false);
n=k.position;
o=k.direction
}p=b&&m&&b.id===m.id;
if(p){r=n=b.shape.geom.getBoundary().getRightCenter()
}if(!p||c._isSelfConnectable(b.shape)){c._RENDERER.drawEdge(new OG.Line(r,n),OG.Util.apply(j.shape.geom.style.map,{"edge-direction":s+" "+o}),j.id,p)
}},stop:function(g){var s=c._getOffset(g),k=$(a).data("edge"),q=$(a).data("from_terminal"),t=$(a).data("edge_terminal")||[s.x,s.y],l=OG.Util.isElement(t)?c._getShapeFromTerminal(t):null,j,m,r,o,h,n,p;
$(this).css({position:"absolute",left:"0px",top:"0px"});
if(!$(a).data("edge_terminal")&&c._isConnectCloneable(b.shape)){j=b.shape.geom.getBoundary();
m=c._RENDERER.drawShape([s.x,s.y],b.shape.clone(),[j.getWidth(),j.getHeight()],b.shapeStyle);
c.setClickSelectable(m,c._isSelectable(m.shape));
c.setMovable(m,c._isMovable(m.shape));
if(c._CONFIG.GROUP_DROPABLE&&m.shape.GROUP_DROPABLE){c.enableDragAndDropGroup(m)
}if(c._CONFIG.GROUP_COLLAPSIBLE&&m.shape.GROUP_COLLAPSIBLE){c.enableCollapse(m)
}if(c._isConnectable(m.shape)){c.enableConnect(m)
}if(c._isLabelEditable(m.shape)){c.enableEditLabel(m)
}r=c._RENDERER.drawTerminal(m,OG.Constants.TERMINAL_TYPE.IN);
o=r.terminal.childNodes;
t=o[0];
for(n=0;
n<o.length;
n++){if(o[n].terminal&&o[n].terminal.direction.toLowerCase()==="c"){t=o[n];
break
}}}p=b&&l&&b.id===l.id;
if(t&&(OG.Util.isElement(t)||!c._isConnectRequired(b.shape))&&(!p||c._isSelfConnectable(b.shape))){k=c._RENDERER.connect(q,t,k);
if(k){h=c._RENDERER.drawGuide(k);
if(k&&h){c.setClickSelectable(k,c._isSelectable(k.shape));
c.setMovable(k,c._isMovable(k.shape));
c.setResizable(k,h,c._isResizable(k.shape));
if(c._isLabelEditable(k.shape)){c.enableEditLabel(k)
}c._RENDERER.toFront(h.group)
}}}else{c._RENDERER.removeShape(k)
}$(a).removeData("edge");
$(a).removeData("from_terminal");
$(a).removeData("edge_terminal");
$(a).removeData("dragged_guide");
if(l){c._RENDERER.remove(l.id+OG.Constants.DROP_OVER_BBOX_SUFFIX)
}}})
}})
}else{c._RENDERER.removeTerminal(b)
}}},mouseout:function(e){if($(b).attr("_shape")!==OG.Constants.SHAPE_TYPE.EDGE&&$(a).data("edge")){c._RENDERER.remove(b.id+OG.Constants.DROP_OVER_BBOX_SUFFIX);
$(a).removeData("edge_terminal")
}}})
},enableDragAndDropGroup:function(c){var d=this,a=d._RENDERER.getRootGroup(),b;
if(c&&$(c).attr("_shape")===OG.Constants.SHAPE_TYPE.GROUP){$(c).__bind__({mouseover:function(){if(c.shape.isCollapsed===false){if($(a).data("bBoxArray")){b=false;
$.each($(a).data("bBoxArray"),function(e,f){if(c.id===f.id){b=true
}});
if(!b){$(a).data("groupTarget",c);
d._RENDERER.drawDropOverGuide(c)
}}}},mouseout:function(e){d._RENDERER.remove(c.id+OG.Constants.DROP_OVER_BBOX_SUFFIX);
$(a).removeData("groupTarget")
}})
}},enableCollapse:function(c){var d=this,b,a;
a=function(e,f){if(f&&f.bBox&&f.collapse){$(f.collapse).__bind__("click",function(g){if(e.shape.isCollapsed===true){d._RENDERER.expand(e);
f=d._RENDERER.drawCollapseGuide(e);
a(e,f)
}else{d._RENDERER.collapse(e);
f=d._RENDERER.drawCollapseGuide(e);
a(e,f)
}});
$(f.bBox).__bind__("mouseout",function(g){d._RENDERER.remove(e.id+OG.Constants.COLLAPSE_BBOX);
d._RENDERER.remove(e.id+OG.Constants.COLLAPSE_SUFFIX)
})
}};
if(c&&$(c).attr("_shape")===OG.Constants.SHAPE_TYPE.GROUP){$(c).__bind__({mouseover:function(){b=d._RENDERER.drawCollapseGuide(this);
if(b&&b.bBox&&b.collapse){a(c,b)
}}})
}},setMovable:function(c,b){var d=this,a=d._RENDERER.getRootGroup();
if(!c){return
}if(b===true){$(c).draggable({start:function(h){var j=d._getOffset(h),f;
if(d._RENDERER.getElementById(c.id+OG.Constants.GUIDE_SUFFIX.GUIDE)===null){$(d._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(l,m){if(OG.Util.isElement(m)&&m.id){d._RENDERER.removeGuide(m)
}});
d._RENDERER.removeAllTerminal()
}d._RENDERER.removeGuide(c);
f=d._RENDERER.drawGuide(c);
$(this).data("start",{x:j.x,y:j.y});
$(this).data("offset",{x:j.x-d._num(d._RENDERER.getAttr(f.bBox,"x")),y:j.y-d._num(d._RENDERER.getAttr(f.bBox,"y"))});
$(this).data("bBoxStartLocation",{x:d._num(d._RENDERER.getAttr(f.bBox,"x")),y:d._num(d._RENDERER.getAttr(f.bBox,"y"))});
if(c.shape instanceof bpm.Connection){var g=c.shape.geom.getVertices();
function e(r,v,t){var q=-1;
for(var n=0;
n<r.length;
n++){if(n!=r.length-1){var m=r[n].x,u=r[n].y,l=r[n+1].x,s=r[n+1].y,p=false,o=false;
if((m<l&&m<v&&v<l)||(l<m&&l<v&&v<m)){p=true
}if((u<s&&u<t&&t<s)||(s<u&&s<t&&t<u)){o=true
}if(p&&o){q=n
}}}return q
}var k=e(g,j.x,j.y);
$(this).data("dragVerticeIndex",k);
console.log(k)
}$(a).data("bBoxArray",d._getMoveTargets());
d._RENDERER.removeRubberBand(d._RENDERER.getRootElement());
d._RENDERER.removeAllTerminal()
},drag:function(f){var g=d._getOffset(f),k=$(this).data("start"),j=$(a).data("bBoxArray"),e=$(this).data("bBoxStartLocation");
dx=d._grid(g.x-k.x),dy=d._grid(g.y-k.y);
d._autoExtend(g.x,g.y);
var h=$(this).data("dragVerticeIndex");
$(this).css({position:"",left:"",top:""});
$.each(j,function(q,z){if(d._RENDERER.getAttr(z.box,"x")){d._RENDERER.setAttr(z.box,{x:e.x+dx,y:e.y+dy,"stroke-width":1,stroke:"#040FB3"})
}else{if(c.shape instanceof bpm.Connection){var u=d._RENDERER._getREleById(z.box.id),o,v,t,m=OG.Util.isElement(c)?c:d._RENDERER.getElementById(c),y=c.shape.geom.getVertices(),x=d._RENDERER._getShapeFromTerminal($(m).attr("_from")),s=d._RENDERER._getShapeFromTerminal($(m).attr("_to")),p=x.shape.geom.getBoundary().getCentroid(),l=s.shape.geom.getBoundary().getCentroid();
v=d._RENDERER.intersectionEdge(m.shape.geom.style.get("edge-type"),x,[p.x,p.y],[g.x,g.y],true).position;
t=d._RENDERER.intersectionEdge(m.shape.geom.style.get("edge-type"),s,[g.x,g.y],[l.x,l.y],false).position;
function n(E,G,B,F){var D=[];
for(var C=0;
C<=G;
C++){D.push([E[C].x,E[C].y])
}D.push([g.x,g.y]);
for(var C=G+1;
C<E.length;
C++){D.push([E[C].x,E[C].y])
}if(E.length==2){D[0]=B;
D[D.length-1]=F
}else{if(G==0){D[0]=B
}if(G+1==E.length-1){D[D.length-1]=F
}}return D
}function w(B){var C;
for(i=0;
i<B.length;
i++){if(i===0){C="M"+B[i][0]+" "+B[i][1]
}else{C+="L"+B[i][0]+" "+B[i][1]
}}return C
}if(h!=-1){var r=n(y,h,v,t);
var A=w(r);
u.attr({path:A,"arrow-end":"classic-wide-long","stroke-width":2,stroke:"#040FB3"});
$(a).data("verticeArray",r)
}}}});
d._RENDERER.removeAllTerminal()
},stop:function(e){var h=d._getOffset(e),f=$(this).data("start"),o=$(a).data("bBoxArray"),q=d._grid(h.x-f.x),p=d._grid(h.y-f.y),l=$(a).data("groupTarget"),n,g;
$(this).css({position:"",left:"",top:""});
n=d._moveElements(o,q,p);
if(c.shape instanceof bpm.Connection){var j=$(a).data("verticeArray"),m=[];
if(j){for(var k=0;
k<j.length;
k++){m.push(new OG.geometry.Coordinate(j[k][0],j[k][1]))
}c.shape.geom.vertices=m
}d._RENDERER.addToGroup(a,n);
$.each(n,function(r,s){d._RENDERER.removeGuide(s);
if(m.length>0){s.shape.geom.vertices=m
}g=d._RENDERER.drawGuide(s);
d._RENDERER.redrawShape(s);
d.setResizable(s,g,d._isResizable(s.shape));
d._RENDERER.toFront(g.group)
})
}else{if(l&&OG.Util.isElement(l)){d._RENDERER.addToGroup(l,n);
$.each(n,function(r,s){d._RENDERER.removeGuide(s)
});
g=d._RENDERER.drawGuide(l);
d.setResizable(l,g,d._isResizable(l.shape));
d._RENDERER.toFront(g.group);
d._RENDERER.remove(l.id+OG.Constants.DROP_OVER_BBOX_SUFFIX);
$(a).removeData("groupTarget")
}else{d._RENDERER.addToGroup(a,n);
$.each(n,function(r,s){d._RENDERER.removeGuide(s);
g=d._RENDERER.drawGuide(s);
d.setResizable(s,g,d._isResizable(s.shape));
d._RENDERER.toFront(g.group)
})
}}$(a).removeData("bBoxArray");
$(a).removeData("verticeArray")
}});
d._RENDERER.setAttr(c,{cursor:"move"});
OG.Util.apply(c.shape.geom.style.map,{cursor:"move"})
}else{if(!c.shape instanceof bpm.Connection){$(c).draggable("destroy")
}d._RENDERER.setAttr(c,{cursor:d._isSelectable(c.shape)?"pointer":d._CONFIG.DEFAULT_STYLE.SHAPE.cursor});
OG.Util.apply(c.shape.geom.style.map,{cursor:d._isSelectable(c.shape)?"pointer":d._CONFIG.DEFAULT_STYLE.SHAPE.cursor})
}},setResizable:function(c,a,e){var d=this,b=d._RENDERER.getRootGroup();
if(!c||!a){return
}if(e===true){if($(c).attr("_shape")===OG.Constants.SHAPE_TYPE.EDGE){$(a.from).draggable({start:function(m){var l,j,f={},g=$(c).attr("_to"),n,h,k;
f=OG.Util.apply(f,d._CONFIG.DEFAULT_STYLE.EDGE_SHADOW,c.shape.geom.style.map);
l=f["edge-type"].toLowerCase()===OG.Constants.EDGE_TYPE.BEZIER;
j=l?c.shape.geom.getControlPoints():c.shape.geom.getVertices();
k=d._RENDERER.drawEdge(l?new OG.BezierCurve(j):new OG.PolyLine(j),f);
h=[j[j.length-1].x,j[j.length-1].y];
if(g){n=d._getShapeFromTerminal(g);
d._RENDERER.drawTerminal(n);
h=d._RENDERER.getElementById(g)
}$(b).data("to_terminal",h);
$(b).data("edge",k);
$(b).data("dragged_guide","from");
d._RENDERER.removeRubberBand(d._RENDERER.getRootElement());
$(d._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(p,o){if(o.id&&$(o).attr("_shape")!==OG.Constants.SHAPE_TYPE.EDGE){d._RENDERER.removeGuide(o)
}})
},drag:function(f){var k=d._getOffset(f),h=$(b).data("edge"),p=$(b).data("edge_terminal"),u=$(b).data("to_terminal"),q=p?[p.terminal.position.x,p.terminal.position.y]:[k.x,k.y],m=OG.Util.isElement(u)?[u.terminal.position.x,u.terminal.position.y]:u,r=p?p.terminal.direction.toLowerCase():"c",n=OG.Util.isElement(u)?u.terminal.direction.toLowerCase():"c",s=p?d._getShapeFromTerminal(p):null,l=OG.Util.isElement(u)?d._getShapeFromTerminal(u):null,g,t,j,o;
$(this).css({position:"",left:"",top:""});
g=q;
t=m;
if(s&&r==="c"){j=d._RENDERER.intersectionEdge(h.geom.style.get("edge-type"),s,[g[0],g[1]],[t[0],t[1]],true);
q=j.position;
r=j.direction
}if(l&&n==="c"){j=d._RENDERER.intersectionEdge(h.geom.style.get("edge-type"),l,[g[0],g[1]],[t[0],t[1]],false);
m=j.position;
n=j.direction
}o=s&&l&&s.id===l.id;
if(o){q=m=s.shape.geom.getBoundary().getRightCenter()
}if(!o||d._isSelfConnectable(s.shape)){d._RENDERER.drawEdge(new OG.Line(q,m),OG.Util.apply(h.geom.style.map,{"edge-direction":r+" "+n}),h.id,o)
}},stop:function(k){var n=d._getOffset(k),m=$(b).data("edge_terminal")||[n.x,n.y],f=$(b).data("to_terminal"),h=OG.Util.isElement(m)?d._getShapeFromTerminal(m):null,l=OG.Util.isElement(f)?d._getShapeFromTerminal(f):null,j=$(b).data("edge"),g;
$(this).css({position:"absolute",left:"0px",top:"0px"});
$(b).removeData("to_terminal");
$(b).removeData("edge");
$(b).removeData("edge_terminal");
$(b).removeData("dragged_guide");
d._RENDERER.remove(j);
d._RENDERER.removeGuide(c);
if(h){d._RENDERER.remove(h.id+OG.Constants.DROP_OVER_BBOX_SUFFIX)
}g=h&&l&&h.id===l.id;
if(!g||d._isSelfConnectable(h.shape)){if(h){c=d._RENDERER.connect(m,f,c,c.shape.geom.style);
if(c){a=d._RENDERER.drawGuide(c);
if(c&&a){d.setResizable(c,a,true);
d._RENDERER.toFront(a.group)
}}}}}});
$(a.to).draggable({start:function(m){var l,h,g={},f=$(c).attr("_from"),j,n,k;
g=OG.Util.apply(g,d._CONFIG.DEFAULT_STYLE.EDGE_SHADOW,c.shape.geom.style.map);
l=g["edge-type"].toLowerCase()===OG.Constants.EDGE_TYPE.BEZIER;
h=l?c.shape.geom.getControlPoints():c.shape.geom.getVertices();
k=d._RENDERER.drawEdge(l?new OG.BezierCurve(h):new OG.PolyLine(h),g);
n=[h[0].x,h[0].y];
if(f){j=d._getShapeFromTerminal(f);
d._RENDERER.drawTerminal(j);
n=d._RENDERER.getElementById(f)
}$(b).data("from_terminal",n);
$(b).data("edge",k);
$(b).data("dragged_guide","to");
d._RENDERER.removeRubberBand(d._RENDERER.getRootElement());
$(d._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(p,o){if(o.id&&$(o).attr("_shape")!==OG.Constants.SHAPE_TYPE.EDGE){d._RENDERER.removeGuide(o)
}})
},drag:function(f){var k=d._getOffset(f),h=$(b).data("edge"),p=$(b).data("from_terminal"),u=$(b).data("edge_terminal"),q=OG.Util.isElement(p)?[p.terminal.position.x,p.terminal.position.y]:p,m=u?[u.terminal.position.x,u.terminal.position.y]:[k.x,k.y],r=OG.Util.isElement(p)?p.terminal.direction.toLowerCase():"c",n=u?u.terminal.direction.toLowerCase():"c",s=OG.Util.isElement(p)?d._getShapeFromTerminal(p):null,l=u?d._getShapeFromTerminal(u):null,g,t,j,o;
$(this).css({position:"",left:"",top:""});
g=q;
t=m;
if(s&&r==="c"){j=d._RENDERER.intersectionEdge(h.geom.style.get("edge-type"),s,[g[0],g[1]],[t[0],t[1]],true);
q=j.position;
r=j.direction
}if(l&&n==="c"){j=d._RENDERER.intersectionEdge(h.geom.style.get("edge-type"),l,[g[0],g[1]],[t[0],t[1]],false);
m=j.position;
n=j.direction
}o=(s!==null)&&(l!==null)&&s.id===l.id;
if(o){q=m=l.shape.geom.getBoundary().getRightCenter()
}if(!o||d._isSelfConnectable(l.shape)){d._RENDERER.drawEdge(new OG.Line(q,m),OG.Util.apply(h.geom.style.map,{"edge-direction":r+" "+n}),h.id,o)
}},stop:function(k){var n=d._getOffset(k),m=$(b).data("from_terminal"),f=$(b).data("edge_terminal")||[n.x,n.y],h=OG.Util.isElement(m)?d._getShapeFromTerminal(m):null,l=OG.Util.isElement(f)?d._getShapeFromTerminal(f):null,j=$(b).data("edge"),g;
$(this).css({position:"absolute",left:"0px",top:"0px"});
$(b).removeData("from_terminal");
$(b).removeData("edge");
$(b).removeData("edge_terminal");
$(b).removeData("dragged_guide");
d._RENDERER.remove(j);
d._RENDERER.removeGuide(c);
if(l){d._RENDERER.remove(l.id+OG.Constants.DROP_OVER_BBOX_SUFFIX)
}g=h&&l&&h.id===l.id;
if(!g||d._isSelfConnectable(l.shape)){if(l){c=d._RENDERER.connect(m,f,c,c.shape.geom.style);
if(c){a=d._RENDERER.drawGuide(c);
if(a){d.setResizable(c,a,true);
d._RENDERER.toFront(a.group)
}}}}}});
$.each(a.controls,function(f,g){$(g).draggable({start:function(h){var j=d._getOffset(h);
$(this).data("start",{x:j.x,y:j.y});
$(this).data("oldVertices",c.shape.geom.getVertices());
$(this).data("offset",{x:j.x-d._num(d._RENDERER.getAttr(g,"x")),y:j.y-d._num(d._RENDERER.getAttr(g,"y"))});
d._RENDERER.removeRubberBand(d._RENDERER.getRootElement())
},drag:function(j){var p=d._getOffset(j),k=$(this).data("start"),r=$(this).data("offset"),h=p.x-r.x,x=p.y-r.y,u=$(this).data("oldVertices"),t=g.id.indexOf(OG.Constants.GUIDE_SUFFIX.CTL_C)>=0,w=t?parseInt(g.id.replace(c.id+OG.Constants.GUIDE_SUFFIX.CTL_C,""),10):parseInt(g.id.replace(c.id+OG.Constants.GUIDE_SUFFIX.CTL_B,""),10),v,m,s=false,q;
$(this).css({position:"",left:"",top:""});
if(!t){u[w].x=p.x;
u[w].y=p.y
}function n(){var A=[];
for(var z=0;
z<=w;
z++){A.push(u[z])
}if(t){A.push(new OG.geometry.Coordinate(p.x,p.y))
}for(var z=w+1;
z<u.length;
z++){A.push(u[z])
}if(u.length==2){var y=d._RENDERER.getFromXYPosition(c,p.x,p.y);
var B=d._RENDERER.getToXYPosition(c,p.x,p.y);
A[0]=new OG.geometry.Coordinate(y[0],y[1]);
A[A.length-1]=new OG.geometry.Coordinate(B[0],B[1])
}else{if((t&&w==0)||(!t&&w==1)){var y=d._RENDERER.getFromXYPosition(c,p.x,p.y);
A[0]=new OG.geometry.Coordinate(y[0],y[1])
}if(w+1==u.length-1){var B=d._RENDERER.getToXYPosition(c,p.x,p.y);
A[A.length-1]=new OG.geometry.Coordinate(B[0],B[1])
}}return A
}q=n();
v=d._RENDERER.getVerticePath(q);
m=d._RENDERER._getREleById(a.bBox.id);
if(!t){var l=d._RENDERER.getVerticeAngle(q,w);
if(l!=-1&&l>(180-OG.Constants.TO_LINE_ANGEL_SIZE)){s=true
}}if(m){var o={path:v,"arrow-end":"open-wide-long","stroke-width":2,stroke:s?"#00FF00":"#040FB3"};
m.attr(o)
}$(this).data("verticeArray",q)
},stop:function(j){var m=d._getOffset(j),k=$(this).data("start"),n=$(this).data("offset"),h=m.x-n.x,s=m.y-n.y,p=$(this).data("verticeArray"),o,q=g.id.indexOf(OG.Constants.GUIDE_SUFFIX.CTL_C)>=0,r=q?parseInt(g.id.replace(c.id+OG.Constants.GUIDE_SUFFIX.CTL_C,""),10):parseInt(g.id.replace(c.id+OG.Constants.GUIDE_SUFFIX.CTL_B,""),10),l;
$(this).css({position:"absolute",left:"0px",top:"0px"});
if(!q){l=d._RENDERER.getVerticeAngle(p,r);
if(l!=-1&&l>(180-OG.Constants.TO_LINE_ANGEL_SIZE)){p.removeAt(r)
}}d._RENDERER.remove(a.bBox);
c=d._RENDERER.drawEdge(new OG.PolyLine(p),c.shape.geom.style,c.id);
o=d._RENDERER.drawGuide(c);
d.setClickSelectable(c,d._isSelectable(c.shape));
d.setResizable(c,o,d._isResizable(c.shape));
d._RENDERER.removeAllTerminal();
d._RENDERER.toFront(o.group)
}})
})
}else{$(a.rc).draggable({start:function(f){var g=d._getOffset(f);
$(this).data("start",{x:g.x,y:g.y});
$(this).data("offset",{x:g.x-d._num(d._RENDERER.getAttr(a.rc,"x")),y:g.y-d._num(d._RENDERER.getAttr(a.rc,"y"))});
d._RENDERER.removeRubberBand(d._RENDERER.getRootElement())
},drag:function(g){var h=d._getOffset(g),l=$(this).data("start"),k=$(this).data("offset"),j=d._grid(h.x-k.x),f=d._grid(j-d._num(d._RENDERER.getAttr(a.lc,"x")));
$(this).css({position:"",left:"",top:""});
if(f>=d._CONFIG.GUIDE_MIN_SIZE){d._RENDERER.setAttr(a.rc,{x:j});
d._RENDERER.setAttr(a.ur,{x:j});
d._RENDERER.setAttr(a.lr,{x:j});
d._RENDERER.setAttr(a.uc,{x:OG.Util.round((d._num(d._RENDERER.getAttr(a.lc,"x"))+j)/2)});
d._RENDERER.setAttr(a.lwc,{x:OG.Util.round((d._num(d._RENDERER.getAttr(a.lc,"x"))+j)/2)});
d._RENDERER.setAttr(a.bBox,{width:f})
}d._RENDERER.removeAllTerminal()
},stop:function(g){var h=d._getOffset(g),j=$(this).data("start"),f=h.x-j.x;
$(this).css({position:"absolute",left:"0px",top:"0px"});
if(c&&c.shape.geom){if(c.shape.geom.getBoundary().getWidth()+f<d._CONFIG.GUIDE_MIN_SIZE){f=d._CONFIG.GUIDE_MIN_SIZE-c.shape.geom.getBoundary().getWidth()
}d._RENDERER.resize(c,[0,0,0,d._grid(f)]);
d._RENDERER.drawGuide(c)
}}});
$(a.lwc).draggable({start:function(f){var g=d._getOffset(f);
$(this).data("start",{x:g.x,y:g.y});
$(this).data("offset",{x:g.x-d._num(d._RENDERER.getAttr(a.lwc,"x")),y:g.y-d._num(d._RENDERER.getAttr(a.lwc,"y"))});
d._RENDERER.removeRubberBand(d._RENDERER.getRootElement())
},drag:function(g){var h=d._getOffset(g),l=$(this).data("start"),k=$(this).data("offset"),j=d._grid(h.y-k.y),f=d._grid(j-d._num(d._RENDERER.getAttr(a.uc,"y")));
$(this).css({position:"",left:"",top:""});
if(f>=d._CONFIG.GUIDE_MIN_SIZE){d._RENDERER.setAttr(a.lwc,{y:j});
d._RENDERER.setAttr(a.ll,{y:j});
d._RENDERER.setAttr(a.lr,{y:j});
d._RENDERER.setAttr(a.lc,{y:OG.Util.round((d._num(d._RENDERER.getAttr(a.uc,"y"))+j)/2)});
d._RENDERER.setAttr(a.rc,{y:OG.Util.round((d._num(d._RENDERER.getAttr(a.uc,"y"))+j)/2)});
d._RENDERER.setAttr(a.bBox,{height:f})
}d._RENDERER.removeAllTerminal()
},stop:function(g){var h=d._getOffset(g),j=$(this).data("start"),f=h.y-j.y;
$(this).css({position:"absolute",left:"0px",top:"0px"});
if(c&&c.shape.geom){if(c.shape.geom.getBoundary().getHeight()+f<d._CONFIG.GUIDE_MIN_SIZE){f=d._CONFIG.GUIDE_MIN_SIZE-c.shape.geom.getBoundary().getHeight()
}d._RENDERER.resize(c,[0,d._grid(f),0,0]);
d._RENDERER.drawGuide(c)
}}});
$(a.lr).draggable({start:function(f){var g=d._getOffset(f);
$(this).data("start",{x:g.x,y:g.y});
$(this).data("offset",{x:g.x-d._num(d._RENDERER.getAttr(a.lr,"x")),y:g.y-d._num(d._RENDERER.getAttr(a.lr,"y"))});
d._RENDERER.removeRubberBand(d._RENDERER.getRootElement())
},drag:function(h){var j=d._getOffset(h),n=$(this).data("start"),m=$(this).data("offset"),l=d._grid(j.x-m.x),g=d._grid(l-d._num(d._RENDERER.getAttr(a.lc,"x"))),k=d._grid(j.y-m.y),f=d._grid(k-d._num(d._RENDERER.getAttr(a.uc,"y")));
$(this).css({position:"",left:"",top:""});
if(g>=d._CONFIG.GUIDE_MIN_SIZE){d._RENDERER.setAttr(a.rc,{x:l});
d._RENDERER.setAttr(a.ur,{x:l});
d._RENDERER.setAttr(a.lr,{x:l});
d._RENDERER.setAttr(a.uc,{x:OG.Util.round((d._num(d._RENDERER.getAttr(a.lc,"x"))+l)/2)});
d._RENDERER.setAttr(a.lwc,{x:OG.Util.round((d._num(d._RENDERER.getAttr(a.lc,"x"))+l)/2)});
d._RENDERER.setAttr(a.bBox,{width:g})
}if(f>=d._CONFIG.GUIDE_MIN_SIZE){d._RENDERER.setAttr(a.lwc,{y:k});
d._RENDERER.setAttr(a.ll,{y:k});
d._RENDERER.setAttr(a.lr,{y:k});
d._RENDERER.setAttr(a.lc,{y:OG.Util.round((d._num(d._RENDERER.getAttr(a.uc,"y"))+k)/2)});
d._RENDERER.setAttr(a.rc,{y:OG.Util.round((d._num(d._RENDERER.getAttr(a.uc,"y"))+k)/2)});
d._RENDERER.setAttr(a.bBox,{height:f})
}d._RENDERER.removeAllTerminal()
},stop:function(h){var j=d._getOffset(h),k=$(this).data("start"),g=j.x-k.x,f=j.y-k.y;
$(this).css({position:"absolute",left:"0px",top:"0px"});
if(c&&c.shape.geom){if(c.shape.geom.getBoundary().getWidth()+g<d._CONFIG.GUIDE_MIN_SIZE){g=d._CONFIG.GUIDE_MIN_SIZE-c.shape.geom.getBoundary().getWidth()
}if(c.shape.geom.getBoundary().getHeight()+f<d._CONFIG.GUIDE_MIN_SIZE){f=d._CONFIG.GUIDE_MIN_SIZE-c.shape.geom.getBoundary().getHeight()
}d._RENDERER.resize(c,[0,d._grid(f),0,d._grid(g)]);
d._RENDERER.drawGuide(c)
}d._RENDERER.removeAllTerminal()
}});
$(a.lc).draggable({start:function(f){var g=d._getOffset(f);
$(this).data("start",{x:g.x,y:g.y});
$(this).data("offset",{x:g.x-d._num(d._RENDERER.getAttr(a.lc,"x")),y:g.y-d._num(d._RENDERER.getAttr(a.lc,"y"))});
d._RENDERER.removeRubberBand(d._RENDERER.getRootElement())
},drag:function(g){var h=d._getOffset(g),l=$(this).data("start"),k=$(this).data("offset"),j=d._grid(h.x-k.x),f=d._grid(d._num(d._RENDERER.getAttr(a.rc,"x"))-j);
$(this).css({position:"",left:"",top:""});
if(f>=d._CONFIG.GUIDE_MIN_SIZE){d._RENDERER.setAttr(a.lc,{x:j});
d._RENDERER.setAttr(a.ul,{x:j});
d._RENDERER.setAttr(a.ll,{x:j});
d._RENDERER.setAttr(a.uc,{x:OG.Util.round((d._num(d._RENDERER.getAttr(a.rc,"x"))+j)/2)});
d._RENDERER.setAttr(a.lwc,{x:OG.Util.round((d._num(d._RENDERER.getAttr(a.rc,"x"))+j)/2)});
d._RENDERER.setAttr(a.bBox,{x:OG.Util.round(j+d._num(d._RENDERER.getAttr(a.lc,"width"))/2),width:f})
}d._RENDERER.removeAllTerminal()
},stop:function(g){var h=d._getOffset(g),j=$(this).data("start"),f=j.x-h.x;
$(this).css({position:"absolute",left:"0px",top:"0px"});
if(c&&c.shape.geom){if(c.shape.geom.getBoundary().getWidth()+f<d._CONFIG.GUIDE_MIN_SIZE){f=d._CONFIG.GUIDE_MIN_SIZE-c.shape.geom.getBoundary().getWidth()
}d._RENDERER.resize(c,[0,0,d._grid(f),0]);
d._RENDERER.drawGuide(c)
}}});
$(a.ll).draggable({start:function(f){var g=d._getOffset(f);
$(this).data("start",{x:g.x,y:g.y});
$(this).data("offset",{x:g.x-d._num(d._RENDERER.getAttr(a.ll,"x")),y:g.y-d._num(d._RENDERER.getAttr(a.ll,"y"))});
d._RENDERER.removeRubberBand(d._RENDERER.getRootElement())
},drag:function(h){var j=d._getOffset(h),n=$(this).data("start"),m=$(this).data("offset"),l=d._grid(j.x-m.x),k=d._grid(j.y-m.y),g=d._grid(d._num(d._RENDERER.getAttr(a.rc,"x"))-l),f=d._grid(k-d._num(d._RENDERER.getAttr(a.uc,"y")));
$(this).css({position:"",left:"",top:""});
if(g>=d._CONFIG.GUIDE_MIN_SIZE){d._RENDERER.setAttr(a.lc,{x:l});
d._RENDERER.setAttr(a.ul,{x:l});
d._RENDERER.setAttr(a.ll,{x:l});
d._RENDERER.setAttr(a.uc,{x:OG.Util.round((d._num(d._RENDERER.getAttr(a.rc,"x"))+l)/2)});
d._RENDERER.setAttr(a.lwc,{x:OG.Util.round((d._num(d._RENDERER.getAttr(a.rc,"x"))+l)/2)});
d._RENDERER.setAttr(a.bBox,{x:OG.Util.round(l+d._num(d._RENDERER.getAttr(a.lc,"width"))/2),width:g})
}if(f>=d._CONFIG.GUIDE_MIN_SIZE){d._RENDERER.setAttr(a.lwc,{y:k});
d._RENDERER.setAttr(a.ll,{y:k});
d._RENDERER.setAttr(a.lr,{y:k});
d._RENDERER.setAttr(a.lc,{y:OG.Util.round((d._num(d._RENDERER.getAttr(a.uc,"y"))+k)/2)});
d._RENDERER.setAttr(a.rc,{y:OG.Util.round((d._num(d._RENDERER.getAttr(a.uc,"y"))+k)/2)});
d._RENDERER.setAttr(a.bBox,{height:f})
}d._RENDERER.removeAllTerminal()
},stop:function(h){var j=d._getOffset(h),k=$(this).data("start"),g=k.x-j.x,f=j.y-k.y;
$(this).css({position:"absolute",left:"0px",top:"0px"});
if(c&&c.shape.geom){if(c.shape.geom.getBoundary().getWidth()+g<d._CONFIG.GUIDE_MIN_SIZE){g=d._CONFIG.GUIDE_MIN_SIZE-c.shape.geom.getBoundary().getWidth()
}if(c.shape.geom.getBoundary().getHeight()+f<d._CONFIG.GUIDE_MIN_SIZE){f=d._CONFIG.GUIDE_MIN_SIZE-c.shape.geom.getBoundary().getHeight()
}d._RENDERER.resize(c,[0,d._grid(f),d._grid(g),0]);
d._RENDERER.drawGuide(c)
}}});
$(a.uc).draggable({start:function(f){var g=d._getOffset(f);
$(this).data("start",{x:g.x,y:g.y});
$(this).data("offset",{x:g.x-d._num(d._RENDERER.getAttr(a.uc,"x")),y:g.y-d._num(d._RENDERER.getAttr(a.uc,"y"))});
d._RENDERER.removeRubberBand(d._RENDERER.getRootElement())
},drag:function(g){var h=d._getOffset(g),l=$(this).data("start"),k=$(this).data("offset"),j=d._grid(h.y-k.y),f=d._grid(d._num(d._RENDERER.getAttr(a.lwc,"y"))-j);
$(this).css({position:"",left:"",top:""});
if(f>=d._CONFIG.GUIDE_MIN_SIZE){d._RENDERER.setAttr(a.uc,{y:j});
d._RENDERER.setAttr(a.ul,{y:j});
d._RENDERER.setAttr(a.ur,{y:j});
d._RENDERER.setAttr(a.lc,{y:OG.Util.round((d._num(d._RENDERER.getAttr(a.lwc,"y"))+j)/2)});
d._RENDERER.setAttr(a.rc,{y:OG.Util.round((d._num(d._RENDERER.getAttr(a.lwc,"y"))+j)/2)});
d._RENDERER.setAttr(a.bBox,{y:OG.Util.round(j+d._num(d._RENDERER.getAttr(a.uc,"width"))/2),height:f})
}d._RENDERER.removeAllTerminal()
},stop:function(g){var h=d._getOffset(g),j=$(this).data("start"),f=j.y-h.y;
$(this).css({position:"absolute",left:"0px",top:"0px"});
if(c&&c.shape.geom){if(c.shape.geom.getBoundary().getHeight()+f<d._CONFIG.GUIDE_MIN_SIZE){f=d._CONFIG.GUIDE_MIN_SIZE-c.shape.geom.getBoundary().getHeight()
}d._RENDERER.resize(c,[d._grid(f),0,0,0]);
d._RENDERER.drawGuide(c)
}}});
$(a.ul).draggable({start:function(f){var g=d._getOffset(f);
$(this).data("start",{x:g.x,y:g.y});
$(this).data("offset",{x:g.x-d._num(d._RENDERER.getAttr(a.ul,"x")),y:g.y-d._num(d._RENDERER.getAttr(a.ul,"y"))});
d._RENDERER.removeRubberBand(d._RENDERER.getRootElement())
},drag:function(h){var j=d._getOffset(h),n=$(this).data("start"),m=$(this).data("offset"),l=d._grid(j.x-m.x),k=d._grid(j.y-m.y),g=d._grid(d._num(d._RENDERER.getAttr(a.rc,"x"))-l),f=d._grid(d._num(d._RENDERER.getAttr(a.lwc,"y"))-k);
$(this).css({position:"",left:"",top:""});
if(g>=d._CONFIG.GUIDE_MIN_SIZE){d._RENDERER.setAttr(a.lc,{x:l});
d._RENDERER.setAttr(a.ul,{x:l});
d._RENDERER.setAttr(a.ll,{x:l});
d._RENDERER.setAttr(a.uc,{x:OG.Util.round((d._num(d._RENDERER.getAttr(a.rc,"x"))+l)/2)});
d._RENDERER.setAttr(a.lwc,{x:OG.Util.round((d._num(d._RENDERER.getAttr(a.rc,"x"))+l)/2)});
d._RENDERER.setAttr(a.bBox,{x:OG.Util.round(l+d._num(d._RENDERER.getAttr(a.lc,"width"))/2),width:g})
}if(f>=d._CONFIG.GUIDE_MIN_SIZE){d._RENDERER.setAttr(a.uc,{y:k});
d._RENDERER.setAttr(a.ul,{y:k});
d._RENDERER.setAttr(a.ur,{y:k});
d._RENDERER.setAttr(a.lc,{y:OG.Util.round((d._num(d._RENDERER.getAttr(a.lwc,"y"))+k)/2)});
d._RENDERER.setAttr(a.rc,{y:OG.Util.round((d._num(d._RENDERER.getAttr(a.lwc,"y"))+k)/2)});
d._RENDERER.setAttr(a.bBox,{y:OG.Util.round(k+d._num(d._RENDERER.getAttr(a.uc,"height"))/2),height:f})
}d._RENDERER.removeAllTerminal()
},stop:function(h){var j=d._getOffset(h),k=$(this).data("start"),g=k.x-j.x,f=k.y-j.y;
$(this).css({position:"absolute",left:"0px",top:"0px"});
if(c&&c.shape.geom){if(c.shape.geom.getBoundary().getWidth()+g<d._CONFIG.GUIDE_MIN_SIZE){g=d._CONFIG.GUIDE_MIN_SIZE-c.shape.geom.getBoundary().getWidth()
}if(c.shape.geom.getBoundary().getHeight()+f<d._CONFIG.GUIDE_MIN_SIZE){f=d._CONFIG.GUIDE_MIN_SIZE-c.shape.geom.getBoundary().getHeight()
}d._RENDERER.resize(c,[d._grid(f),0,d._grid(g),0]);
d._RENDERER.drawGuide(c)
}}});
$(a.ur).draggable({start:function(f){var g=d._getOffset(f);
$(this).data("start",{x:g.x,y:g.y});
$(this).data("offset",{x:g.x-d._num(d._RENDERER.getAttr(a.ur,"x")),y:g.y-d._num(d._RENDERER.getAttr(a.ur,"y"))});
d._RENDERER.removeRubberBand(d._RENDERER.getRootElement())
},drag:function(h){var j=d._getOffset(h),n=$(this).data("start"),m=$(this).data("offset"),l=d._grid(j.x-m.x),k=d._grid(j.y-m.y),g=d._grid(l-d._num(d._RENDERER.getAttr(a.lc,"x"))),f=d._grid(d._num(d._RENDERER.getAttr(a.lwc,"y"))-k);
$(this).css({position:"",left:"",top:""});
if(g>=d._CONFIG.GUIDE_MIN_SIZE){d._RENDERER.setAttr(a.rc,{x:l});
d._RENDERER.setAttr(a.ur,{x:l});
d._RENDERER.setAttr(a.lr,{x:l});
d._RENDERER.setAttr(a.uc,{x:OG.Util.round((d._num(d._RENDERER.getAttr(a.lc,"x"))+l)/2)});
d._RENDERER.setAttr(a.lwc,{x:OG.Util.round((d._num(d._RENDERER.getAttr(a.lc,"x"))+l)/2)});
d._RENDERER.setAttr(a.bBox,{width:g})
}if(f>=d._CONFIG.GUIDE_MIN_SIZE){d._RENDERER.setAttr(a.uc,{y:k});
d._RENDERER.setAttr(a.ul,{y:k});
d._RENDERER.setAttr(a.ur,{y:k});
d._RENDERER.setAttr(a.lc,{y:OG.Util.round((d._num(d._RENDERER.getAttr(a.lwc,"y"))+k)/2)});
d._RENDERER.setAttr(a.rc,{y:OG.Util.round((d._num(d._RENDERER.getAttr(a.lwc,"y"))+k)/2)});
d._RENDERER.setAttr(a.bBox,{y:OG.Util.round(k+d._num(d._RENDERER.getAttr(a.uc,"width"))/2),height:f})
}d._RENDERER.removeAllTerminal()
},stop:function(h){var j=d._getOffset(h),k=$(this).data("start"),g=j.x-k.x,f=k.y-j.y;
$(this).css({position:"absolute",left:"0px",top:"0px"});
if(c&&c.shape.geom){if(c.shape.geom.getBoundary().getWidth()+g<d._CONFIG.GUIDE_MIN_SIZE){g=d._CONFIG.GUIDE_MIN_SIZE-c.shape.geom.getBoundary().getWidth()
}if(c.shape.geom.getBoundary().getHeight()+f<d._CONFIG.GUIDE_MIN_SIZE){f=d._CONFIG.GUIDE_MIN_SIZE-c.shape.geom.getBoundary().getHeight()
}d._RENDERER.resize(c,[d._grid(f),0,0,d._grid(g)]);
d._RENDERER.drawGuide(c)
}}})
}}else{if($(c).attr("_shape")===OG.Constants.SHAPE_TYPE.EDGE){d._RENDERER.setAttr(a.from,{cursor:"default"});
d._RENDERER.setAttr(a.to,{cursor:"default"});
$.each(a.controls,function(f,g){d._RENDERER.setAttr(g,{cursor:"default"})
})
}else{d._RENDERER.setAttr(a.ul,{cursor:"default"});
d._RENDERER.setAttr(a.ur,{cursor:"default"});
d._RENDERER.setAttr(a.ll,{cursor:"default"});
d._RENDERER.setAttr(a.lr,{cursor:"default"});
d._RENDERER.setAttr(a.lc,{cursor:"default"});
d._RENDERER.setAttr(a.uc,{cursor:"default"});
d._RENDERER.setAttr(a.rc,{cursor:"default"});
d._RENDERER.setAttr(a.lwc,{cursor:"default"})
}}},setClickSelectable:function(b,a){var c=this;
if(a===true){$(b).__bind__("click",function(e){var d;
$(c._RENDERER.getContainer()).focus();
if(b.shape){$(c._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(f,g){if(g.id){c._RENDERER.removeGuide(g)
}});
if($(b).attr("_selected")==="true"){if(e.shiftKey||e.ctrlKey){c._RENDERER.removeGuide(b)
}}else{c._deselectChildren(b);
if(!c._isParentSelected(b)){d=c._RENDERER.drawGuide(b);
if(d){c.setResizable(b,d,c._isResizable(b.shape));
c._RENDERER.removeAllTerminal();
c._RENDERER.toFront(d.group)
}bpm.onNodeSelected(b)
}}return false
}});
if(c._CONFIG.ENABLE_CONTEXTMENU){$(b).__bind__("contextmenu",function(e){var d;
if(b.shape){if($(b).attr("_selected")!=="true"){$(c._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(f,g){if(g.id){c._RENDERER.removeGuide(g)
}});
c._deselectChildren(b);
if(!c._isParentSelected(b)){d=c._RENDERER.drawGuide(b);
if(d){c.setResizable(b,d,c._isResizable(b.shape));
c._RENDERER.removeAllTerminal();
c._RENDERER.toFront(d.group)
}}}return true
}})
}if(a&&c._isMovable(b.shape)){c._RENDERER.setAttr(b,{cursor:"move"});
OG.Util.apply(b.shape.geom.style.map,{cursor:"move"})
}else{c._RENDERER.setAttr(b,{cursor:"pointer"});
OG.Util.apply(b.shape.geom.style.map,{cursor:"pointer"})
}}else{$(b).unbind("click");
c._RENDERER.setAttr(b,{cursor:c._CONFIG.DEFAULT_STYLE.SHAPE.cursor});
OG.Util.apply(b.shape.geom.style.map,{cursor:c._CONFIG.DEFAULT_STYLE.SHAPE.cursor})
}},setDragSelectable:function(a){var c=this,b=c._RENDERER.getRootElement();
$(b).__bind__("click",function(e){var d=$(this).data("dragBox");
$(c._RENDERER.getContainer()).focus();
if(!d||(d&&d.width<1&&d.height<1)){$(c._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(f,g){if(OG.Util.isElement(g)&&g.id){c._RENDERER.removeGuide(g)
}});
c._RENDERER.removeAllTerminal()
}});
if(a===true){$(b).__bind__("mousedown",function(d){var e=c._getOffset(d);
$(this).data("dragBox_first",{x:e.x,y:e.y});
c._RENDERER.drawRubberBand([e.x,e.y])
});
$(b).__bind__("mousemove",function(g){var j=$(this).data("dragBox_first"),h,f,e,d,k;
if(j){h=c._getOffset(g);
f=h.x-j.x;
e=h.y-j.y;
d=f<=0?j.x+f:j.x;
k=e<=0?j.y+e:j.y;
c._RENDERER.drawRubberBand([d,k],[Math.abs(f),Math.abs(e)])
}});
$(b).__bind__("mouseup",function(d){var h=$(this).data("dragBox_first"),g,e,m,l,k,j,f;
c._RENDERER.removeRubberBand(b);
if(h){g=c._getOffset(d);
e=g.x-h.x;
m=g.y-h.y;
l=e<=0?h.x+e:h.x;
k=m<=0?h.y+m:h.y;
j=new OG.Envelope([l,k],Math.abs(e),Math.abs(m));
$(c._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"]").each(function(n,o){if(o.shape.geom&&j.isContainsAll(o.shape.geom.getVertices())){c._deselectChildren(o);
if(!c._isParentSelected(o)){f=c._RENDERER.drawGuide(o);
if(f){c.setResizable(o,f,c._isResizable(o.shape));
c._RENDERER.removeAllTerminal()
}}}});
$(this).data("dragBox",{width:e,height:m,x:l,y:k})
}});
$(b).__bind__("contextmenu",function(d){c._RENDERER.removeRubberBand(b)
})
}else{$(b).unbind("mousedown");
$(b).unbind("mousemove");
$(b).unbind("mouseup");
$(b).unbind("contextmenu")
}},setEnableHotKey:function(b){var a=this;
if(b===true){$(a._RENDERER.getContainer()).__bind__("keydown",function(c){if(!/^textarea$/i.test(c.srcElement.tagName)&&!/^input$/i.test(c.srcElement.tagName)){if(a._CONFIG.ENABLE_HOTKEY_DELETE&&c.keyCode===KeyEvent.DOM_VK_DELETE){c.preventDefault();
a.deleteSelectedShape()
}if(a._CONFIG.ENABLE_HOTKEY_CTRL_A&&a._CONFIG.SELECTABLE&&(c.ctrlKey||c.metaKey)&&c.keyCode===KeyEvent.DOM_VK_A){c.preventDefault()
}if(a._CONFIG.ENABLE_HOTKEY_CTRL_C&&(c.ctrlKey||c.metaKey)&&c.keyCode===KeyEvent.DOM_VK_C){c.preventDefault();
a.copySelectedShape()
}if(a._CONFIG.ENABLE_HOTKEY_CTRL_C&&(c.ctrlKey||c.metaKey)&&c.keyCode===KeyEvent.DOM_VK_X){c.preventDefault();
a.cutSelectedShape()
}if(a._CONFIG.ENABLE_HOTKEY_CTRL_V&&(c.ctrlKey||c.metaKey)&&c.keyCode===KeyEvent.DOM_VK_V){c.preventDefault();
a.pasteSelectedShape()
}if(a._CONFIG.ENABLE_HOTKEY_CTRL_D&&(c.ctrlKey||c.metaKey)&&c.keyCode===KeyEvent.DOM_VK_D){c.preventDefault();
a.duplicateSelectedShape()
}if(a._CONFIG.ENABLE_HOTKEY_CTRL_G&&(c.ctrlKey||c.metaKey)&&c.keyCode===KeyEvent.DOM_VK_G){c.preventDefault()
}if(a._CONFIG.ENABLE_HOTKEY_CTRL_U&&(c.ctrlKey||c.metaKey)&&c.keyCode===KeyEvent.DOM_VK_U){c.preventDefault()
}if(a._CONFIG.ENABLE_HOTKEY_SHIFT_ARROW){if(c.shiftKey&&c.keyCode===KeyEvent.DOM_VK_LEFT){c.preventDefault();
a._moveElements(a._getMoveTargets(),-1*(a._CONFIG.DRAG_GRIDABLE?a._CONFIG.MOVE_SNAP_SIZE:1),0)
}if(c.shiftKey&&c.keyCode===KeyEvent.DOM_VK_RIGHT){c.preventDefault();
a._moveElements(a._getMoveTargets(),(a._CONFIG.DRAG_GRIDABLE?a._CONFIG.MOVE_SNAP_SIZE:1),0)
}if(c.shiftKey&&c.keyCode===KeyEvent.DOM_VK_UP){c.preventDefault();
a._moveElements(a._getMoveTargets(),0,-1*(a._CONFIG.DRAG_GRIDABLE?a._CONFIG.MOVE_SNAP_SIZE:1))
}if(c.shiftKey&&c.keyCode===KeyEvent.DOM_VK_DOWN){c.preventDefault();
a._moveElements(a._getMoveTargets(),0,(a._CONFIG.DRAG_GRIDABLE?a._CONFIG.MOVE_SNAP_SIZE:1))
}}if(a._CONFIG.ENABLE_HOTKEY_ARROW){if(!c.shiftKey&&c.keyCode===KeyEvent.DOM_VK_LEFT){c.preventDefault();
a._moveElements(a._getMoveTargets(),-1*a._CONFIG.MOVE_SNAP_SIZE,0)
}if(!c.shiftKey&&c.keyCode===KeyEvent.DOM_VK_RIGHT){c.preventDefault();
a._moveElements(a._getMoveTargets(),a._CONFIG.MOVE_SNAP_SIZE,0)
}if(!c.shiftKey&&c.keyCode===KeyEvent.DOM_VK_UP){c.preventDefault();
a._moveElements(a._getMoveTargets(),0,-1*a._CONFIG.MOVE_SNAP_SIZE)
}if(!c.shiftKey&&c.keyCode===KeyEvent.DOM_VK_DOWN){c.preventDefault();
a._moveElements(a._getMoveTargets(),0,a._CONFIG.MOVE_SNAP_SIZE)
}}}})
}else{$(a._RENDERER.getContainer()).unbind("keydown")
}},enableRootContextMenu:function(){var a=this;
$.contextMenu({selector:"#"+a._RENDERER.getRootElement().id,build:function(b,f){var d=a._RENDERER.getRootGroup(),c=$(d).data("copied");
$(a._RENDERER.getContainer()).focus();
return{items:{selectAll:{name:"Select All",callback:function(){a.selectAll()
}},sep1:"---------",paste:{name:"Paste",callback:function(){a.pasteSelectedShape()
},disabled:(c?false:true)},sep2:"---------",view:{name:"View",items:{view_actualSize:{name:"Actual Size",callback:function(){a._RENDERER.setScale(1)
}},sep2_1:"---------",view_fitWindow:{name:"Fit Window",callback:function(){a.fitWindow()
}},sep2_2:"---------",view_25:{name:"25%",callback:function(){a._RENDERER.setScale(0.25)
}},view_50:{name:"50%",callback:function(){a._RENDERER.setScale(0.5)
}},view_75:{name:"75%",callback:function(){a._RENDERER.setScale(0.75)
}},view_100:{name:"100%",callback:function(){a._RENDERER.setScale(1)
}},view_150:{name:"150%",callback:function(){a._RENDERER.setScale(1.5)
}},view_200:{name:"200%",callback:function(){a._RENDERER.setScale(2)
}},view_300:{name:"300%",callback:function(){a._RENDERER.setScale(3)
}},view_400:{name:"400%",callback:function(){a._RENDERER.setScale(4)
}},sep2_3:"---------",view_zoomin:{name:"Zoom In",callback:function(){a.zoomIn()
}},view_zoomout:{name:"Zoom Out",callback:function(){a.zoomOut()
}}}}}}
}})
},enableShapeContextMenu:function(){var a=this;
$.contextMenu({selector:"#"+a._RENDERER.getRootElement().id+" [_type=SHAPE]",build:function(b,c){$(a._RENDERER.getContainer()).focus();
return{items:{"delete":{name:"Delete",callback:function(){a.deleteSelectedShape()
}},sep1:"---------",cut:{name:"Cut",callback:function(){a.cutSelectedShape()
}},copy:{name:"Copy",callback:function(){a.copySelectedShape()
}},sep2:"---------",duplicate:{name:"Duplicate",callback:function(){a.duplicateSelectedShape()
}},sep3:"---------",group:{name:"Group",callback:function(){a.groupSelectedShape()
}},unGroup:{name:"UnGroup",callback:function(){a.ungroupSelectedShape()
}},sep4:"---------",shapeRotate:{name:"Rotate",items:{rotate_select:{name:"Select",type:"select",options:{"0":"0","45":"45","90":"90","135":"135","180":"180","-45":"-45","-90":"-90","-135":"-135","-180":"-180"},selected:"0",events:{change:function(d){a.rotateSelectedShape(d.target.value)
}}},sep5_6_1:"---------",rotate_custom:{name:"Custom",type:"text",events:{keyup:function(d){if(d.target.value!==""){a.rotateSelectedShape(d.target.value)
}}}}}},sep5:"---------",format:{name:"Format",items:{fillColor:{name:"Fill Color",items:{fillColor_select:{name:"Select",type:"select",options:{"":"",white:"white",gray:"gray",blue:"blue",red:"red",yellow:"yellow",orange:"orange",green:"green",black:"black"},selected:"",events:{change:function(d){if(d.target.value!==""){a.setFillColorSelectedShape(d.target.value)
}}}},sep5_1_1:"---------",fillColor_custom:{name:"Custom",type:"text",events:{keyup:function(d){if(d.target.value!==""){a.setFillColorSelectedShape(d.target.value)
}}}}}},fillOpacity:{name:"Fill Opacity",items:{fillOpacity_select:{name:"Select",type:"select",options:{"":"","0.0":"0%","0.1":"10%","0.2":"20%","0.3":"30%","0.4":"40%","0.5":"50%","0.6":"60%","0.7":"70%","0.8":"80%","0.9":"90%","1.0":"100%"},selected:"",events:{change:function(d){if(d.target.value!==""){a.setFillOpacitySelectedShape(d.target.value)
}}}}}},sep5_1:"---------",lineType:{name:"Line Type",items:{lineType_straight:{name:"Straight",type:"radio",radio:"lineType",value:"straight",events:{change:function(d){a.setLineTypeSelectedShape(d.target.value)
}}},lineType_plain:{name:"Plain",type:"radio",radio:"lineType",value:"plain",events:{change:function(d){a.setLineTypeSelectedShape(d.target.value)
}}},lineType_bezier:{name:"Curve",type:"radio",radio:"lineType",value:"bezier",events:{change:function(d){a.setLineTypeSelectedShape(d.target.value)
}}}}},lineStyle:{name:"Line Style",items:{lineStyle_1:{name:"──────",type:"radio",radio:"lineStyle",value:"",events:{change:function(d){a.setLineStyleSelectedShape(d.target.value)
}}},lineStyle_2:{name:"---------",type:"radio",radio:"lineStyle",value:"-",events:{change:function(d){a.setLineStyleSelectedShape(d.target.value)
}}},lineStyle_3:{name:"············",type:"radio",radio:"lineStyle",value:".",events:{change:function(d){a.setLineStyleSelectedShape(d.target.value)
}}},lineStyle_4:{name:"-·-·-·-·-·",type:"radio",radio:"lineStyle",value:"-.",events:{change:function(d){a.setLineStyleSelectedShape(d.target.value)
}}},lineStyle_5:{name:"-··-··-··-",type:"radio",radio:"lineStyle",value:"-..",events:{change:function(d){a.setLineStyleSelectedShape(d.target.value)
}}},lineStyle_6:{name:"· · · · · ·",type:"radio",radio:"lineStyle",value:". ",events:{change:function(d){a.setLineStyleSelectedShape(d.target.value)
}}},lineStyle_7:{name:"- - - - -",type:"radio",radio:"lineStyle",value:"- ",events:{change:function(d){a.setLineStyleSelectedShape(d.target.value)
}}},lineStyle_8:{name:"─ ─ ─ ─",type:"radio",radio:"lineStyle",value:"--",events:{change:function(d){a.setLineStyleSelectedShape(d.target.value)
}}},lineStyle_9:{name:"- ·- ·- ·-",type:"radio",radio:"lineStyle",value:"- .",events:{change:function(d){a.setLineStyleSelectedShape(d.target.value)
}}},lineStyle_10:{name:"--·--·--·-",type:"radio",radio:"lineStyle",value:"--.",events:{change:function(d){a.setLineStyleSelectedShape(d.target.value)
}}},lineStyle_11:{name:"--··--··--",type:"radio",radio:"lineStyle",value:"--..",events:{change:function(d){a.setLineStyleSelectedShape(d.target.value)
}}}}},lineColor:{name:"Line Color",items:{lineColor_select:{name:"Select",type:"select",options:{"":"",white:"white",gray:"gray",blue:"blue",red:"red",yellow:"yellow",orange:"orange",green:"green",black:"black"},selected:"",events:{change:function(d){if(d.target.value!==""){a.setLineColorSelectedShape(d.target.value)
}}}},sep5_4_1:"---------",lineColor_custom:{name:"Custom",type:"text",events:{keyup:function(d){if(d.target.value!==""){a.setLineColorSelectedShape(d.target.value)
}}}}}},lineWidth:{name:"Line Width",items:{lineWidth_select:{name:"Select",type:"select",options:{0:"",1:"1px",2:"2px",3:"3px",4:"4px",5:"5px",6:"6px",8:"8px",10:"10px",12:"12px",16:"16px",24:"24px"},selected:0,events:{change:function(d){if(d.target.value!==0){a.setLineWidthSelectedShape(d.target.value)
}}}},sep5_5_1:"---------",lineWidth_custom:{name:"Custom",type:"text",events:{keyup:function(d){if(d.target.value!==""){a.setLineWidthSelectedShape(d.target.value)
}}}}}}}},sep6:"---------",text:{name:"Text",items:{fontFamily:{name:"Font Family",items:{fontFamily_1:{name:'<span style="font-family: Arial">Arial</span>',type:"radio",radio:"fontFamily",value:"Arial",events:{change:function(d){a.setFontFamilySelectedShape(d.target.value)
}}},fontFamily_2:{name:"<span style=\"font-family: 'Comic Sans MS'\">Comic Sans MS</span>",type:"radio",radio:"fontFamily",value:"Comic Sans MS",events:{change:function(d){a.setFontFamilySelectedShape(d.target.value)
}}},fontFamily_3:{name:"<span style=\"font-family: 'Courier New'\">Courier New</span>",type:"radio",radio:"fontFamily",value:"Courier New",events:{change:function(d){a.setFontFamilySelectedShape(d.target.value)
}}},fontFamily_4:{name:'<span style="font-family: Garamond">Garamond</span>',type:"radio",radio:"fontFamily",value:"Garamond",events:{change:function(d){a.setFontFamilySelectedShape(d.target.value)
}}},fontFamily_5:{name:'<span style="font-family: Georgia">Georgia</span>',type:"radio",radio:"fontFamily",value:"Georgia",events:{change:function(d){a.setFontFamilySelectedShape(d.target.value)
}}},fontFamily_6:{name:"<span style=\"font-family: 'Lucida Console'\">Lucida Console</span>",type:"radio",radio:"fontFamily",value:"Lucida Console",events:{change:function(d){a.setFontFamilySelectedShape(d.target.value)
}}},fontFamily_7:{name:"<span style=\"font-family: 'MS Gothic'\">MS Gothic</span>",type:"radio",radio:"fontFamily",value:"MS Gothic",events:{change:function(d){a.setFontFamilySelectedShape(d.target.value)
}}},fontFamily_8:{name:"<span style=\"font-family: 'MS Sans Serif'\">MS Sans Serif</span>",type:"radio",radio:"fontFamily",value:"MS Sans Serif",events:{change:function(d){a.setFontFamilySelectedShape(d.target.value)
}}},fontFamily_9:{name:'<span style="font-family: Verdana">Verdana</span>',type:"radio",radio:"fontFamily",value:"Verdana",events:{change:function(d){a.setFontFamilySelectedShape(d.target.value)
}}},fontFamily_10:{name:"<span style=\"font-family: 'Times New Roman'\">Times New Roman</span>",type:"radio",radio:"fontFamily",value:"Times New Roman",events:{change:function(d){a.setFontFamilySelectedShape(d.target.value)
}}},sep6_1_1:"---------",fontFamily_custom:{name:"Custom",type:"text",events:{keyup:function(d){if(d.target.value!==""){a.setFontFamilySelectedShape(d.target.value)
}}}}}},fontColor:{name:"Font Color",items:{fontColor_select:{name:"Select",type:"select",options:{"":"",white:"white",gray:"gray",blue:"blue",red:"red",yellow:"yellow",orange:"orange",green:"green",black:"black"},selected:"",events:{change:function(d){if(d.target.value!==""){a.setFontColorSelectedShape(d.target.value)
}}}},sep6_1_2:"---------",fontColor_custom:{name:"Custom",type:"text",events:{keyup:function(d){if(d.target.value!==""){a.setFontColorSelectedShape(d.target.value)
}}}}}},fontSize:{name:"Font Size",items:{fontSize_select:{name:"Select",type:"select",options:{"":"","6":"6","8":"8","9":"9","10":"10","11":"11","12":"12","14":"14","18":"18","24":"24","36":"36","48":"48","72":"72"},selected:"",events:{change:function(d){if(d.target.value!==""){a.setFontSizeSelectedShape(d.target.value)
}}}},sep6_1_3:"---------",fontSize_custom:{name:"Custom",type:"text",events:{keyup:function(d){if(d.target.value!==""){a.setFontSizeSelectedShape(d.target.value)
}}}}}},sep6_1:"---------",fontWeight_bold:{name:'<span style="font-weight: bold">Bold</span>',type:"checkbox",events:{change:function(d){if(d.target.checked){a.setFontWeightSelectedShape("bold")
}else{a.setFontWeightSelectedShape("normal")
}}}},fontWeight_italic:{name:'<span style="font-style: italic">Italic</span>',type:"checkbox",events:{change:function(d){if(d.target.checked){a.setFontStyleSelectedShape("italic")
}else{a.setFontStyleSelectedShape("normal")
}}}},sep6_2:"---------",position:{name:"Text Position",items:{position_left:{name:"Left",type:"radio",radio:"position",value:"left",events:{change:function(d){a.setLabelPositionSelectedShape(d.target.value)
}}},position_center:{name:"Center",type:"radio",radio:"position",value:"center",events:{change:function(d){a.setLabelPositionSelectedShape(d.target.value)
}}},position_right:{name:"Right",type:"radio",radio:"position",value:"right",events:{change:function(d){a.setLabelPositionSelectedShape(d.target.value)
}}},position_top:{name:"Top",type:"radio",radio:"position",value:"top",events:{change:function(d){a.setLabelPositionSelectedShape(d.target.value)
}}},position_bottom:{name:"Bottom",type:"radio",radio:"position",value:"bottom",events:{change:function(d){a.setLabelPositionSelectedShape(d.target.value)
}}}}},vertical:{name:"Vertical Align",items:{vertical_top:{name:"Top",type:"radio",radio:"vertical",value:"top",events:{change:function(d){a.setLabelVerticalSelectedShape(d.target.value)
}}},vertical_middle:{name:"Middle",type:"radio",radio:"vertical",value:"middle",events:{change:function(d){a.setLabelVerticalSelectedShape(d.target.value)
}}},vertical_bottom:{name:"Bottom",type:"radio",radio:"vertical",value:"bottom",events:{change:function(d){a.setLabelVerticalSelectedShape(d.target.value)
}}}}},horizontal:{name:"Horizontal Align",items:{vertical_start:{name:"Left",type:"radio",radio:"horizontal",value:"start",events:{change:function(d){a.setLabelHorizontalSelectedShape(d.target.value)
}}},horizontal_middle:{name:"Middle",type:"radio",radio:"horizontal",value:"middle",events:{change:function(d){a.setLabelHorizontalSelectedShape(d.target.value)
}}},horizontal_end:{name:"Right",type:"radio",radio:"horizontal",value:"end",events:{change:function(d){a.setLabelHorizontalSelectedShape(d.target.value)
}}}}},sep6_5:"---------",textRotate:{name:"Text Rotate",items:{textRotate_select:{name:"Select",type:"select",options:{"0":"0","45":"45","90":"90","135":"135","180":"180","-45":"-45","-90":"-90","-135":"-135","-180":"-180"},selected:"0",events:{change:function(d){a.setLabelAngleSelectedShape(d.target.value)
}}},sep6_6_1:"---------",textRotate_custom:{name:"Custom",type:"text",events:{keyup:function(d){if(d.target.value!==""){a.setLabelAngleSelectedShape(d.target.value)
}}}}}}}},sep7:"---------",label:{name:"Label",items:{label_shape:{name:"Cell Label",type:"text",events:{keyup:function(d){a.setLabelSelectedShape(d.target.value)
}}},sep7_1:"---------",label_from:{name:"Edge From",type:"text",events:{keyup:function(d){a.setEdgeFromLabelSelectedShape(d.target.value)
}}},label_to:{name:"Edge To",type:"text",events:{keyup:function(d){a.setEdgeToLabelSelectedShape(d.target.value)
}}}}}}}
}})
},selectShape:function(b){var c=this,a;
if($(b.parentNode).attr("_shape")!==OG.Constants.SHAPE_TYPE.GROUP&&c._isSelectable(b.shape)){a=c._RENDERER.drawGuide(b);
if(a){c.setResizable(b,a,c._isResizable(b.shape));
c._RENDERER.removeTerminal(b)
}}},deleteSelectedShape:function(){var b=this,a=true;
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_shape=EDGE][_selected=true]").each(function(c,d){if(d.id){if(d.shape.REMOVABLE==undefined||d.shape.REMOVABLE===true){b._RENDERER.removeShape(d)
}else{a=false;
dorado.MessageBox.alert("权限不足,不能执行删除节点操作!")
}}});
if(a===false){return
}$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){if(d.id){if(d.shape.REMOVABLE==undefined||d.shape.REMOVABLE===true){b._RENDERER.removeShape(d)
}else{dorado.MessageBox.alert("权限不足,不能执行删除节点操作!")
}}})
},selectAll:function(){var a=this;
$(a._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"]").each(function(b,c){a.selectShape(c)
})
},copySelectedShape:function(){var b=this,a=b._RENDERER.getRootGroup(),c=[];
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(d,e){c.push(e)
});
$(a).data("copied",c)
},cutSelectedShape:function(){var a=this;
a.copySelectedShape();
a.deleteSelectedShape()
},pasteSelectedShape:function(){var c=this,b=c._RENDERER.getRootGroup(),a=$(b).data("copied"),d=[];
if(a){$(c._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(e,f){if(f.id){c._RENDERER.removeGuide(f)
}});
$.each(a,function(e,h){var k=h.shape.geom.getBoundary(),g,j,f;
g=h.shape.clone();
if($(h).attr("_shape")===OG.Constants.SHAPE_TYPE.EDGE){if(h.shape.geom instanceof OG.geometry.BezierCurve){g.geom=new OG.BezierCurve(h.shape.geom.getControlPoints())
}else{g.geom=new OG.PolyLine(h.shape.geom.getVertices())
}g.geom.style=h.shape.geom.style;
g.geom.move(c._CONFIG.COPY_PASTE_PADDING,c._CONFIG.COPY_PASTE_PADDING);
j=c._RENDERER.drawShape(null,g,null,h.shapeStyle)
}else{j=c._RENDERER.drawShape([k.getCentroid().x+c._CONFIG.COPY_PASTE_PADDING,k.getCentroid().y+c._CONFIG.COPY_PASTE_PADDING],g,[k.getWidth(),k.getHeight()],h.shapeStyle)
}j.data=h.data;
f=c._RENDERER.drawGuide(j);
c.setClickSelectable(j,c._isSelectable(j.shape));
c.setMovable(j,c._isMovable(j.shape));
c.setResizable(j,f,c._isResizable(j.shape));
if(c._CONFIG.GROUP_DROPABLE&&j.shape.GROUP_DROPABLE){c.enableDragAndDropGroup(j)
}if(c._CONFIG.GROUP_COLLAPSIBLE&&j.shape.GROUP_COLLAPSIBLE){c.enableCollapse(j)
}if(c._isConnectable(j.shape)){c.enableConnect(j)
}if(c._isLabelEditable(j.shape)){c.enableEditLabel(j)
}c._copyChildren(h,j);
d.push(j)
});
$(b).data("copied",d)
}},duplicateSelectedShape:function(){var a=this;
a.copySelectedShape();
a.pasteSelectedShape()
},groupSelectedShape:function(){var c=this,a,b=c._RENDERER.group($(c._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]"));
if(b){$(c._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(d,e){c._RENDERER.removeGuide(e)
});
a=c._RENDERER.drawGuide(b);
if(a){c.setClickSelectable(b,c._isSelectable(b.shape));
c.setMovable(b,c._isMovable(b.shape));
c.setResizable(b,a,c._isResizable(b.shape));
if(c._CONFIG.GROUP_DROPABLE&&b.shape.GROUP_DROPABLE){c.enableDragAndDropGroup(b)
}c._RENDERER.removeAllTerminal();
c._RENDERER.toFront(a.group)
}}},ungroupSelectedShape:function(){var b=this,a,c=b._RENDERER.ungroup($(b._RENDERER.getRootElement()).find("[_shape="+OG.Constants.SHAPE_TYPE.GROUP+"][_selected=true]"));
$.each(c,function(d,e){a=b._RENDERER.drawGuide(e);
if(a){b._RENDERER.removeAllTerminal();
b._RENDERER.toFront(a.group)
}})
},rotateSelectedShape:function(c){var b=this,a;
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_shape="+OG.Constants.SHAPE_TYPE.EDGE+"][_selected=true]").each(function(d,e){b._RENDERER.removeGuide(e)
});
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(d,e){if(e.shape&&e.shape.TYPE!==OG.Constants.SHAPE_TYPE.EDGE&&e.shape.TYPE!==OG.Constants.SHAPE_TYPE.GROUP){b._RENDERER.rotate(e,c);
b._RENDERER.removeGuide(e);
a=b._RENDERER.drawGuide(e);
b.setResizable(e,a,b._isResizable(e.shape));
b._RENDERER.toFront(a.group)
}})
},setLineWidthSelectedShape:function(a){var b=this;
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){b._RENDERER.setShapeStyle(d,{"stroke-width":a})
})
},setLineColorSelectedShape:function(b){var a=this;
$(a._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){a._RENDERER.setShapeStyle(d,{stroke:b})
})
},setLineTypeSelectedShape:function(c){var b=this,a;
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_shape="+OG.Constants.SHAPE_TYPE.EDGE+"][_selected=true]").each(function(d,e){OG.Util.apply(e.shape.geom.style.map,{"edge-type":c});
e.shapeStyle=e.shapeStyle||{};
OG.Util.apply(e.shapeStyle,{"edge-type":c});
b._RENDERER.redrawEdge(e);
b._RENDERER.removeGuide(e);
a=b._RENDERER.drawGuide(e);
b.setResizable(e,a,b._isResizable(e.shape));
b._RENDERER.toFront(a.group)
})
},setLineStyleSelectedShape:function(a){var b=this;
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){b._RENDERER.setShapeStyle(d,{"stroke-dasharray":a})
})
},setArrowStartSelectedShape:function(b){var a=this;
$(a._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){a._RENDERER.setShapeStyle(d,{"arrow-start":b+"-wide-long"})
})
},setArrowEndSelectedShape:function(b){var a=this;
$(a._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){a._RENDERER.setShapeStyle(d,{"arrow-end":b+"-wide-long"})
})
},setFillColorSelectedShape:function(b){var a=this;
$(a._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){a._RENDERER.setShapeStyle(d,{fill:b,"fill-opacity":1})
})
},setFillOpacitySelectedShape:function(a){var b=this;
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){b._RENDERER.setShapeStyle(d,{"fill-opacity":a})
})
},setFontFamilySelectedShape:function(a){var b=this;
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){b._RENDERER.setShapeStyle(d,{"font-family":a})
})
},setFontSizeSelectedShape:function(b){var a=this;
$(a._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){a._RENDERER.setShapeStyle(d,{"font-size":b})
})
},setFontColorSelectedShape:function(b){var a=this;
$(a._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){a._RENDERER.setShapeStyle(d,{"font-color":b})
})
},setFontWeightSelectedShape:function(a){var b=this;
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){b._RENDERER.setShapeStyle(d,{"font-weight":a})
})
},setFontStyleSelectedShape:function(b){var a=this;
$(a._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){a._RENDERER.setShapeStyle(d,{"font-style":b})
})
},setTextDecorationSelectedShape:function(b){var a=this;
$(a._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){a._RENDERER.setShapeStyle(d,{"text-decoration":b})
})
},setLabelDirectionSelectedShape:function(b){var a=this;
$(a._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){a._RENDERER.setShapeStyle(d,{"label-direction":b})
})
},setLabelAngleSelectedShape:function(a){var b=this;
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){b._RENDERER.setShapeStyle(d,{"label-angle":a})
})
},setLabelPositionSelectedShape:function(b){var a=this;
$(a._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){if(b==="top"){a._RENDERER.setShapeStyle(d,{"label-position":b,"text-anchor":"middle","vertical-align":"bottom"})
}else{if(b==="bottom"){a._RENDERER.setShapeStyle(d,{"label-position":b,"text-anchor":"middle","vertical-align":"top"})
}else{if(b==="left"){a._RENDERER.setShapeStyle(d,{"label-position":b,"text-anchor":"end","vertical-align":"center"})
}else{if(b==="right"){a._RENDERER.setShapeStyle(d,{"label-position":b,"text-anchor":"start","vertical-align":"center"})
}else{if(b==="center"){a._RENDERER.setShapeStyle(d,{"label-position":b,"text-anchor":"middle","vertical-align":"center"})
}}}}}})
},setLabelVerticalSelectedShape:function(b){var a=this;
$(a._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){a._RENDERER.setShapeStyle(d,{"vertical-align":b})
})
},setLabelHorizontalSelectedShape:function(a){var b=this;
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){b._RENDERER.setShapeStyle(d,{"text-anchor":a})
})
},setLabelSelectedShape:function(a){var b=this;
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){b._RENDERER.drawLabel(d,a)
})
},setEdgeFromLabelSelectedShape:function(a){var b=this;
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_shape="+OG.Constants.SHAPE_TYPE.EDGE+"][_selected=true]").each(function(c,d){b._RENDERER.drawEdgeLabel(d,a,"FROM")
})
},setEdgeToLabelSelectedShape:function(a){var b=this;
$(b._RENDERER.getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_shape="+OG.Constants.SHAPE_TYPE.EDGE+"][_selected=true]").each(function(c,d){b._RENDERER.drawEdgeLabel(d,a,"TO")
})
},zoomIn:function(){var a=this;
if(a._CONFIG.SCALE+a._CONFIG.SCALE*0.1<=a._CONFIG.SCALE_MAX){a._RENDERER.setScale(a._CONFIG.SCALE+a._CONFIG.SCALE*0.1)
}},zoomOut:function(){var a=this;
if(a._CONFIG.SCALE-a._CONFIG.SCALE*0.1>=a._CONFIG.SCALE_MIN){a._RENDERER.setScale(a._CONFIG.SCALE-a._CONFIG.SCALE*0.1)
}},fitWindow:function(){var b=this,a=b._RENDERER.getContainer();
b._RENDERER.fitCanvasSize([a.clientWidth,a.clientHeight],true)
},_isContainsConnectedShape:function(a,k){var g=this,h,e,j,b,f=false,d=false,c;
h=$(a).attr("_from");
e=$(a).attr("_to");
if(h){j=g._getShapeFromTerminal(h)
}if(e){b=g._getShapeFromTerminal(e)
}for(c=0;
c<k.length;
c++){if(j&&k[c].id===j.id){f=true
}if(b&&k[c].id===b.id){d=true
}}return{none:!f&&!d,all:f&&d,any:f||d,either:(f&&!d)||(!f&&d),attrEither:(h&&!e)||(!h&&e)}
},_getShapeFromTerminal:function(a){var c=this,b=OG.Util.isElement(a)?a.id:a;
return c._RENDERER.getElementById(b.substring(0,b.indexOf(OG.Constants.TERMINAL_SUFFIX.GROUP)))
},_getOffset:function(c){var b=this,a=b._RENDERER.getContainer();
return{x:(c.pageX-$(a).offset().left+a.scrollLeft)/b._CONFIG.SCALE,y:(c.pageY-$(a).offset().top+a.scrollTop)/b._CONFIG.SCALE}
},_getMoveTargets:function(){var c=this,d=[],b,a=[];
$(c._RENDERER.getRootElement()).find("[id$="+OG.Constants.GUIDE_SUFFIX.BBOX+"]").each(function(e,f){if(f.id){b=c._RENDERER.clone(f);
c._RENDERER.setAttr(b,c._CONFIG.DEFAULT_STYLE.GUIDE_SHADOW);
d.push({id:f.id.replace(OG.Constants.GUIDE_SUFFIX.BBOX,""),box:b})
}});
$.each(d,function(f,g){var h=c._RENDERER.getElementById(g.id),e;
if($(h).attr("_shape")===OG.Constants.SHAPE_TYPE.EDGE){e=c._isContainsConnectedShape(h,d);
if(e.all||e.none||(e.either&&e.attrEither)){a.push(g)
}else{c._RENDERER.remove(g.box);
c._RENDERER.removeGuide(h)
}}});
$.each(d,function(e,f){var g=c._RENDERER.getElementById(f.id);
if($(g).attr("_shape")!==OG.Constants.SHAPE_TYPE.EDGE){a.push(f)
}});
return a
},_moveElements:function(f,b,a){var c=this,e=[],d=[];
$.each(f,function(g,h){var j=c._RENDERER.getElementById(h.id);
if($(j).attr("_shape")===OG.Constants.SHAPE_TYPE.EDGE){e.push(h.id)
}});
$.each(f,function(g,h){var j=c._RENDERER.getElementById(h.id);
c._RENDERER.remove(h.box);
if($(j).attr("_shape")===OG.Constants.SHAPE_TYPE.EDGE){}else{c._RENDERER.move(j,[b,a],e);
c._RENDERER.drawGuide(j)
}d.push(j)
});
return d
},_autoExtend:function(c,b){var d=this,a=d._RENDERER.getRootBBox();
if(d._CONFIG.AUTO_EXTENSIONAL&&a.width<c*d._CONFIG.SCALE){d._RENDERER.setCanvasSize([a.width+d._CONFIG.AUTO_EXTENSION_SIZE,a.height])
}if(d._CONFIG.AUTO_EXTENSIONAL&&a.height<b*d._CONFIG.SCALE){d._RENDERER.setCanvasSize([a.width,a.height+d._CONFIG.AUTO_EXTENSION_SIZE])
}},_copyChildren:function(b,d){var c=this,a=b.childNodes;
$.each(a,function(e,h){if($(h).attr("_type")===OG.Constants.NODE_TYPE.SHAPE){var k=h.shape.geom.getBoundary(),g,j,f;
g=h.shape.clone();
if($(h).attr("_shape")===OG.Constants.SHAPE_TYPE.EDGE){g.geom=new OG.PolyLine(h.shape.geom.getVertices());
g.geom.style=h.shape.geom.style;
g.geom.move(c._CONFIG.COPY_PASTE_PADDING,c._CONFIG.COPY_PASTE_PADDING);
j=c._RENDERER.drawShape(null,g,null,h.shapeStyle)
}else{j=c._RENDERER.drawShape([k.getCentroid().x+c._CONFIG.COPY_PASTE_PADDING,k.getCentroid().y+c._CONFIG.COPY_PASTE_PADDING],g,[k.getWidth(),k.getHeight()],h.shapeStyle)
}j.data=h.data;
d.appendChild(j);
c.setClickSelectable(j,c._isSelectable(j.shape));
c.setMovable(j,c._isMovable(j.shape));
if(c._CONFIG.GROUP_DROPABLE&&j.shape.GROUP_DROPABLE){c.enableDragAndDropGroup(j)
}if(c._CONFIG.GROUP_COLLAPSIBLE&&j.shape.GROUP_COLLAPSIBLE){c.enableCollapse(j)
}if(c._isConnectable(j.shape)){c.enableConnect(j)
}if(c._isLabelEditable(j.shape)){c.enableEditLabel(j)
}if(h.childNodes.length>0){c._copyChildren(h,j)
}}})
},_deselectChildren:function(b){var c=this,a=b.childNodes;
$.each(a,function(d,e){if($(e).attr("_type")===OG.Constants.NODE_TYPE.SHAPE){if(e.childNodes.length>0){c._deselectChildren(e)
}if($(e).attr("_selected")==="true"){c._RENDERER.removeGuide(e);
$(e).draggable("destroy")
}}})
},_isParentSelected:function(b){var c=this,a=b.parentNode;
if(a){if(c._isParentSelected(a)){return true
}if($(a).attr("_type")===OG.Constants.NODE_TYPE.SHAPE&&$(a).attr("_selected")==="true"){return true
}}return false
},_num:function(a){return parseInt(a,10)
},_grid:function(b){var a=this;
return a._CONFIG.DRAG_GRIDABLE?OG.Util.roundGrid(b,a._CONFIG.MOVE_SNAP_SIZE):b
},_isSelectable:function(a){var b=this;
return b._CONFIG.SELECTABLE&&a.SELECTABLE
},_isConnectable:function(a){var b=this;
return b._CONFIG.CONNECTABLE&&a.CONNECTABLE
},_isSelfConnectable:function(a){var b=this;
return b._CONFIG.SELF_CONNECTABLE&&a.SELF_CONNECTABLE
},_isConnectCloneable:function(a){var b=this;
return b._CONFIG.CONNECT_CLONEABLE&&a.CONNECT_CLONEABLE
},_isConnectRequired:function(a){var b=this;
return b._CONFIG.CONNECT_REQUIRED&&a.CONNECT_REQUIRED
},_isMovable:function(a){var b=this;
return(b._CONFIG.SELECTABLE&&a.SELECTABLE)&&(b._CONFIG.MOVABLE&&b._CONFIG.MOVABLE_[a.TYPE]&&a.MOVABLE)
},_isResizable:function(a){var b=this;
return(b._CONFIG.SELECTABLE&&a.SELECTABLE)&&(b._CONFIG.RESIZABLE&&b._CONFIG.RESIZABLE_[a.TYPE]&&a.RESIZABLE)
},_isLabelEditable:function(a){var b=this;
return b._CONFIG.LABEL_EDITABLE&&b._CONFIG.LABEL_EDITABLE_[a.TYPE]&&a.LABEL_EDITABLE
}};
OG.handler.EventHandler.prototype.constructor=OG.handler.EventHandler;
OG.EventHandler=OG.handler.EventHandler;
OG.graph.Canvas=function(a,d,b,c){this._CONFIG={SELECTABLE:true,DRAG_SELECTABLE:true,MOVABLE:true,MOVABLE_:{GEOM:true,TEXT:true,HTML:true,IMAGE:true,EDGE:true,GROUP:true},RESIZABLE:true,RESIZABLE_:{GEOM:true,TEXT:true,HTML:true,IMAGE:true,EDGE:true,GROUP:true},CONNECTABLE:true,SELF_CONNECTABLE:true,CONNECT_CLONEABLE:true,CONNECT_REQUIRED:true,LABEL_EDITABLE:true,LABEL_EDITABLE_:{GEOM:true,TEXT:true,HTML:false,IMAGE:false,EDGE:false,GROUP:true},GROUP_DROPABLE:true,GROUP_COLLAPSIBLE:true,DRAG_GRIDABLE:true,ENABLE_HOTKEY:true,ENABLE_HOTKEY_DELETE:true,ENABLE_HOTKEY_CTRL_A:true,ENABLE_HOTKEY_CTRL_C:true,ENABLE_HOTKEY_CTRL_V:true,ENABLE_HOTKEY_CTRL_D:true,ENABLE_HOTKEY_CTRL_G:true,ENABLE_HOTKEY_CTRL_U:true,ENABLE_HOTKEY_ARROW:true,ENABLE_HOTKEY_SHIFT_ARROW:true,ENABLE_CONTEXTMENU:true,SCALE:1,SCALE_MIN:0.1,SCALE_MAX:10,EDGE_PADDING:20,LABEL_PADDING:5,LABEL_EDITOR_WIDTH:70,LABEL_EDITOR_HEIGHT:16,FROMTO_LABEL_OFFSET_TOP:-15,GUIDE_RECT_SIZE:8,GUIDE_MIN_SIZE:18,COLLAPSE_SIZE:10,MOVE_SNAP_SIZE:5,TERMINAL_SIZE:4,COPY_PASTE_PADDING:20,FIT_CANVAS_PADDING:20,AUTO_EXTENSIONAL:true,AUTO_EXTENSION_SIZE:100,CANVAS_BACKGROUND:"#f9f9f9",DEFAULT_STYLE:{SHAPE:{cursor:"default"},GEOM:{stroke:"black",fill:"white","fill-opacity":0,"label-position":"center"},TEXT:{stroke:"none","text-anchor":"middle"},HTML:{"label-position":"bottom","text-anchor":"middle","vertical-align":"top"},IMAGE:{"label-position":"bottom","text-anchor":"middle","vertical-align":"top"},EDGE:{stroke:"#7384BB",fill:"#00FF00","fill-opacity":0,"stroke-width":1.5,"stroke-opacity":1,"edge-type":"straight","edge-direction":"c c","arrow-start":"none","arrow-end":"classic-wide-long","stroke-dasharray":"","label-position":"center"},EDGE_SHADOW:{stroke:"#00FF00",fill:"none","fill-opacity":0,"stroke-width":2,"stroke-opacity":1,"arrow-start":"none","arrow-end":"none","stroke-dasharray":"- "},EDGE_HIDDEN:{stroke:"white",fill:"none","fill-opacity":0,"stroke-width":5,"stroke-opacity":0},GROUP:{stroke:"none",fill:"white","fill-opacity":0,"label-position":"bottom","text-anchor":"middle","vertical-align":"top"},GUIDE_BBOX:{stroke:"black",fill:"none","stroke-dasharray":"- ","shape-rendering":"crispEdges"},GUIDE_UL:{stroke:"black",fill:"#00FF00",cursor:"nwse-resize","shape-rendering":"crispEdges"},GUIDE_UR:{stroke:"black",fill:"#00FF00",cursor:"nesw-resize","shape-rendering":"crispEdges"},GUIDE_LL:{stroke:"black",fill:"#00FF00",cursor:"nesw-resize","shape-rendering":"crispEdges"},GUIDE_LR:{stroke:"black",fill:"#00FF00",cursor:"nwse-resize","shape-rendering":"crispEdges"},GUIDE_LC:{stroke:"black",fill:"#00FF00",cursor:"ew-resize","shape-rendering":"crispEdges"},GUIDE_UC:{stroke:"black",fill:"#00FF00",cursor:"ns-resize","shape-rendering":"crispEdges"},GUIDE_RC:{stroke:"black",fill:"#00FF00",cursor:"ew-resize","shape-rendering":"crispEdges"},GUIDE_LWC:{stroke:"black",fill:"#00FF00",cursor:"ns-resize","shape-rendering":"crispEdges"},GUIDE_FROM:{stroke:"black",fill:"#00FF00",cursor:"crosshair","shape-rendering":"crispEdges"},GUIDE_TO:{stroke:"black",fill:"#00FF00",cursor:"crosshair","shape-rendering":"crispEdges"},GUIDE_CTL_H:{stroke:"black",fill:"#00FF00",cursor:"ew-resize","shape-rendering":"crispEdges"},GUIDE_CTL_V:{stroke:"black",fill:"#00FF00",cursor:"ns-resize","shape-rendering":"crispEdges"},GUIDE_CTL_B:{stroke:"black",fill:"#00FF00",cursor:"move","shape-rendering":"crispEdges"},GUIDE_CTL_C:{stroke:"black",fill:"#00FF00",cursor:"move","shape-rendering":"crispEdges"},GUIDE_SHADOW:{stroke:"black",fill:"none","stroke-dasharray":"- ","shape-rendering":"crispEdges"},RUBBER_BAND:{stroke:"#0000FF",opacity:0.2,fill:"#0077FF"},TERMINAL:{stroke:"#808080","stroke-width":1,fill:"r(0.5, 0.5)#FFFFFF-#808080","fill-opacity":0.5,cursor:"pointer"},TERMINAL_OVER:{stroke:"#0077FF","stroke-width":4,fill:"r(0.5, 0.5)#66FF66-#0077FF","fill-opacity":1,cursor:"pointer"},TERMINAL_BBOX:{stroke:"none",fill:"white","fill-opacity":0},DROP_OVER_BBOX:{stroke:"#0077FF",fill:"none",opacity:0.6,"shape-rendering":"crispEdges"},LABEL:{"font-size":12,"font-color":"black"},LABEL_EDITOR:{position:"absolute",border:"2px solid #CC6600",overflow:"visible",resize:"none","text-align":"center",display:"block",padding:0},COLLAPSE:{stroke:"black",fill:"white","fill-opacity":0,cursor:"pointer","shape-rendering":"crispEdges"},COLLAPSE_BBOX:{stroke:"none",fill:"white","fill-opacity":0}}};
this._RENDERER=a?new OG.RaphaelRenderer(a,d,b,c,this._CONFIG):null;
this._HANDLER=new OG.EventHandler(this._RENDERER,this._CONFIG);
this._CONTAINER=OG.Util.isElement(a)?a:document.getElementById(a)
};
OG.graph.Canvas.prototype={initConfig:function(a){if(a){this._CONFIG.SELECTABLE=a.selectable===undefined?this._CONFIG.SELECTABLE:a.selectable;
this._CONFIG.DRAG_SELECTABLE=a.dragSelectable===undefined?this._CONFIG.DRAG_SELECTABLE:a.dragSelectable;
this._CONFIG.MOVABLE=a.movable===undefined?this._CONFIG.MOVABLE:a.movable;
this._CONFIG.RESIZABLE=a.resizable===undefined?this._CONFIG.RESIZABLE:a.resizable;
this._CONFIG.CONNECTABLE=a.connectable===undefined?this._CONFIG.CONNECTABLE:a.connectable;
this._CONFIG.SELF_CONNECTABLE=a.selfConnectable===undefined?this._CONFIG.SELF_CONNECTABLE:a.selfConnectable;
this._CONFIG.CONNECT_CLONEABLE=a.connectCloneable===undefined?this._CONFIG.CONNECT_CLONEABLE:a.connectCloneable;
this._CONFIG.CONNECT_REQUIRED=a.connectRequired===undefined?this._CONFIG.CONNECT_REQUIRED:a.connectRequired;
this._CONFIG.LABEL_EDITABLE=a.labelEditable===undefined?this._CONFIG.LABEL_EDITABLE:a.labelEditable;
this._CONFIG.GROUP_DROPABLE=a.groupDropable===undefined?this._CONFIG.GROUP_DROPABLE:a.groupDropable;
this._CONFIG.GROUP_COLLAPSIBLE=a.collapsible===undefined?this._CONFIG.GROUP_COLLAPSIBLE:a.collapsible;
this._CONFIG.ENABLE_HOTKEY=a.enableHotKey===undefined?this._CONFIG.ENABLE_HOTKEY:a.enableHotKey;
this._CONFIG.ENABLE_CONTEXTMENU=a.enableContextMenu===undefined?this._CONFIG.ENABLE_CONTEXTMENU:a.enableContextMenu
}this._HANDLER.setDragSelectable(this._CONFIG.SELECTABLE&&this._CONFIG.DRAG_SELECTABLE);
this._HANDLER.setEnableHotKey(this._CONFIG.ENABLE_HOTKEY);
if(this._CONFIG.ENABLE_CONTEXTMENU){this._HANDLER.enableRootContextMenu();
this._HANDLER.enableShapeContextMenu()
}this.CONFIG_INITIALIZED=true
},getRenderer:function(){return this._RENDERER
},getContainer:function(){return this._CONTAINER
},getEventHandler:function(){return this._HANDLER
},drawShape:function(a,b,e,f,h,g,c){if(this._CONFIG.DRAG_GRIDABLE&&(!OG.Util.isDefined(c)||c===true)){if(a){a[0]=OG.Util.roundGrid(a[0],this._CONFIG.MOVE_SNAP_SIZE);
a[1]=OG.Util.roundGrid(a[1],this._CONFIG.MOVE_SNAP_SIZE)
}if(e){e[0]=OG.Util.roundGrid(e[0],this._CONFIG.MOVE_SNAP_SIZE*2);
e[1]=OG.Util.roundGrid(e[1],this._CONFIG.MOVE_SNAP_SIZE*2)
}}var d=this._RENDERER.drawShape(a,b,e,f,h);
if(a&&(b.TYPE===OG.Constants.SHAPE_TYPE.EDGE)){d=this._RENDERER.move(d,a)
}if(g&&this._RENDERER.getElementById(g)){this._RENDERER.appendChild(d,g)
}if(!this.CONFIG_INITIALIZED){this.initConfig()
}this._HANDLER.setClickSelectable(d,this._HANDLER._isSelectable(d.shape));
this._HANDLER.setMovable(d,this._HANDLER._isMovable(d.shape));
if(this._HANDLER._isConnectable(d.shape)){this._HANDLER.enableConnect(d)
}if(this._HANDLER._isLabelEditable(d.shape)){this._HANDLER.enableEditLabel(d)
}if(this._CONFIG.GROUP_DROPABLE&&d.shape.GROUP_DROPABLE){this._HANDLER.enableDragAndDropGroup(d)
}if(this._CONFIG.GROUP_COLLAPSIBLE&&d.shape.GROUP_COLLAPSIBLE){this._HANDLER.enableCollapse(d)
}return d
},setShapeStyle:function(a,b){this._RENDERER.setShapeStyle(a,b)
},drawLabel:function(a,c,b){return this._RENDERER.drawLabel(a,c,b)
},redrawConnectedEdge:function(a,b){this._RENDERER.redrawConnectedEdge(a,b)
},connect:function(h,d,a,j){var k,f,g,l,e,c,b;
k=this._RENDERER.drawTerminal(h,OG.Constants.TERMINAL_TYPE.OUT);
f=k.terminal.childNodes;
g=f[0];
for(e=0;
e<f.length;
e++){if(f[e].terminal&&f[e].terminal.direction.toLowerCase()==="c"){g=f[e];
break
}}this._RENDERER.removeTerminal(h);
k=this._RENDERER.drawTerminal(d,OG.Constants.TERMINAL_TYPE.IN);
f=k.terminal.childNodes;
l=f[0];
for(e=0;
e<f.length;
e++){if(f[e].terminal&&f[e].terminal.direction.toLowerCase()==="c"){l=f[e];
break
}}this._RENDERER.removeTerminal(d);
c=this._RENDERER.drawShape(null,new bpm.Connection(g.terminal.position,l.terminal.position));
c=this._RENDERER.connect(g,l,c,a,j);
if(c){b=this._RENDERER.drawGuide(c);
if(c&&b){this._HANDLER.setClickSelectable(c,c.shape.SELECTABLE);
this._HANDLER.setMovable(c,c.shape.SELECTABLE&&c.shape.MOVABLE);
this._HANDLER.setResizable(c,b,c.shape.SELECTABLE&&c.shape.RESIZABLE);
if(c.shape.LABEL_EDITABLE){this._HANDLER.enableEditLabel(c)
}this._RENDERER.toFront(b.group)
}}return c
},disconnect:function(a){this._RENDERER.disconnect(a)
},group:function(a){var b=this._RENDERER.group(a);
this._HANDLER.setClickSelectable(b,b.shape.SELECTABLE);
this._HANDLER.setMovable(b,b.shape.SELECTABLE&&b.shape.MOVABLE);
if(b.shape.LABEL_EDITABLE){this._HANDLER.enableEditLabel(b)
}return b
},ungroup:function(a){return this._RENDERER.ungroup(a)
},addToGroup:function(a,b){this._RENDERER.addToGroup(a,b)
},collapse:function(a){this._RENDERERDERER.collapse(a)
},expand:function(a){this._RENDERER.expand(a)
},clear:function(){this._RENDERER.clear()
},removeShape:function(a){this._RENDERER.removeShape(a)
},removeChild:function(a){this._RENDERER.removeChild(a)
},removeGuide:function(a){this._RENDERER.removeGuide(a)
},removeAllGuide:function(){this._RENDERER.removeAllGuide()
},getRootElement:function(){return this._RENDERER.getRootElement()
},getRootGroup:function(){return this._RENDERER.getRootGroup()
},getElementByPoint:function(a){return this._RENDERER.getElementByPoint(a)
},getElementsByBBox:function(a){return this._RENDERER.getElementsByBBox(a)
},setAttr:function(a,b){this._RENDERER.setAttr(a,b)
},getAttr:function(b,a){return this._RENDERER.getAttr(b,a)
},toFront:function(a){this._RENDERER.toFront(a)
},toBack:function(a){this._RENDERER.toBack(a)
},getCanvasSize:function(){this._RENDERER.getCanvasSize()
},setCanvasSize:function(a){this._RENDERER.setCanvasSize(a)
},fitCanvasSize:function(b,a){this._RENDERER.fitCanvasSize(b,a)
},setViewBox:function(a,b,c){this._RENDERER.setViewBox(a,b,c)
},getScale:function(){return this._RENDERER.getScale()
},setScale:function(a){this._RENDERER.setScale(a)
},show:function(a){this._RENDERER.show(a)
},hide:function(a){this._RENDERER.hide(a)
},appendChild:function(a,b){return this._RENDERER.appendChild(a,b)
},insertAfter:function(a,b){return this._RENDERER.insertAfter(a,b)
},insertBefore:function(a,b){return this._RENDERER.insertBefore(a,b)
},move:function(a,c,b){return this._RENDERER.move(a,c,b)
},moveCentroid:function(b,a,c){return this._RENDERER.moveCentroid(b,a,c)
},rotate:function(a,c,b){return this._RENDERER.rotate(a,c,b)
},resize:function(a,c,b){return this._RENDERER.resize(a,c,b)
},resizeBox:function(b,a){return this._RENDERER.resizeBox(b,a)
},clone:function(a){return this._RENDERER.clone(a)
},getElementById:function(a){return this._RENDERER.getElementById(a)
},getElementsByType:function(b,a){return this._RENDERER.getElementsByType(b,a)
},getElementsByShapeId:function(b){var a=this.getRootGroup();
return $(a).find("[_type=SHAPE][_shape_id='"+b+"']")
},getRelatedElementsFromEdge:function(b){var d=this,c=OG.Util.isElement(b)?b:this.getElementById(b),a=function(e){var f=OG.Util.isElement(e)?e.id:e;
if(f){return d._RENDERER.getElementById(f.substring(0,f.indexOf(OG.Constants.TERMINAL_SUFFIX.GROUP)))
}else{return null
}};
if($(c).attr("_shape")===OG.Constants.SHAPE_TYPE.EDGE){return{from:a($(b).attr("_from")),to:a($(b).attr("_to"))}
}else{return{from:null,to:null}
}},getBBox:function(a){return this._RENDERER.getBBox(a)
},getRootBBox:function(){return this._RENDERER.getRootBBox()
},getRealRootBBox:function(){return this._RENDERER.getRealRootBBox()
},isSVG:function(){return this._RENDERER.isSVG()
},isVML:function(){return this._RENDERER.isVML()
},setCustomData:function(b,c){var a=OG.Util.isElement(b)?b:document.getElementById(b);
a.data=c
},getCustomData:function(b){var a=OG.Util.isElement(b)?b:document.getElementById(b);
return a.data
},toXML:function(){return OG.Util.jsonToXml(this.toJSON())
},toJSON:function(){var b=this,c=this._RENDERER.getRootBBox(),e=this._RENDERER.getRootGroup(),a={"@width":c.width,"@height":c.height,cell:[]},g={opengraph:a},f;
if(b.entityData){var d=b.entityData;
g.opengraph["@entityData"]=escape(OG.JSON.encode(d))
}f=function(j,h){$(j).children("[_type=SHAPE]").each(function(u,w){var n=w.shape,k=w.shapeStyle,q=n.geom,o=q.getBoundary(),v={},m,t,s,l,r;
v["@id"]=$(w).attr("id");
if(!h){v["@parent"]=$(j).attr("id")
}v["@shapeType"]=n.TYPE;
v["@shapeId"]=n.SHAPE_ID;
v["@x"]=o.getCentroid().x;
v["@y"]=o.getCentroid().y;
v["@width"]=o.getWidth();
v["@height"]=o.getHeight();
if(k){v["@style"]=escape(OG.JSON.encode(k))
}if(n.TYPE===OG.Constants.SHAPE_TYPE.EDGE){if($(w).attr("_from")){v["@from"]=$(w).attr("_from")
}if($(w).attr("_to")){v["@to"]=$(w).attr("_to")
}}else{l=b.getPrevShapeIds(w);
r=b.getNextShapeIds(w);
if(l.length>0){v["@from"]=l.toString()
}if(r.length>0){v["@to"]=r.toString()
}}if($(w).attr("_fromedge")){v["@fromEdge"]=$(w).attr("_fromedge")
}if($(w).attr("_toedge")){v["@toEdge"]=$(w).attr("_toedge")
}if(n.label){v["@label"]=escape(n.label)
}if(n.nodeEntryId){v["@nodeEntryId"]=n.nodeEntryId
}if(n.fromLabel){v["@fromLabel"]=escape(n.fromLabel)
}if(n.toLabel){v["@toLabel"]=escape(n.toLabel)
}if(n.angle&&n.angle!==0){v["@angle"]=n.angle
}if(n instanceof OG.shape.ImageShape){v["@value"]=n.image
}else{if(n instanceof OG.shape.HtmlShape){v["@value"]=escape(n.html)
}else{if(n instanceof OG.shape.TextShape){v["@value"]=escape(n.text)
}else{if(n instanceof bpm.Connection){m=q.getVertices();
t=m[0];
s=m[m.length-1];
v["@value"]=t+","+s;
v["@vertices"]=m
}}}}if(q){v["@geom"]=escape(q.toString())
}if(w.data){v["@data"]=escape(OG.JSON.encode(w.data))
}if(n.clazz){v["@clazz"]=n.clazz
}if(n.entityData){var p=n.entityData;
v["@entityData"]=escape(OG.JSON.encode(p))
}g.opengraph.cell.push(v);
f(w,false)
})
};
if(e.data){g.opengraph["@data"]=escape(OG.JSON.encode(e.data))
}f(e,true);
return g
},loadXML:function(a){if(!OG.Util.isElement(a)){a=OG.Util.parseXML(a)
}return this.loadJSON(OG.Util.xmlToJson(a))
},loadJSON:function(json){var canvasWidth,canvasHeight,rootGroup,minX=Number.MAX_VALUE,minY=Number.MAX_VALUE,maxX=Number.MIN_VALUE,maxY=Number.MIN_VALUE,i,cell,shape,id,parent,shapeType,shapeId,x,y,width,height,style,geom,from,to,fromEdge,toEdge,label,fromLabel,toLabel,angle,value,data,entityData,element,nodeEntryId,nodeEntryData;
this._RENDERER.clear();
if(json&&json.opengraph){canvasWidth=json.opengraph["@width"];
canvasHeight=json.opengraph["@height"];
data=json.opengraph["@data"];
if(data){rootGroup=this.getRootGroup();
rootGroup.data=OG.JSON.decode(unescape(data))
}var processEntityData=json.opengraph["@entityData"];
if(processEntityData){this.entityData=OG.JSON.decode(unescape(processEntityData))
}var processAttributes=json.opengraph["@processAttributes"];
if(processAttributes){this.processAttributes=OG.JSON.decode(unescape(processAttributes))
}var nodeSecurityAttributes=json.opengraph["@nodeSecurityAttributes"];
if(nodeSecurityAttributes){this.nodeSecurityAttributes=OG.JSON.decode(unescape(nodeSecurityAttributes))
}if(!json.opengraph.cell){json.opengraph.cell=[]
}if(OG.Util.isObject(json.opengraph.cell)){json.opengraph.cell=[json.opengraph.cell]
}cell=json.opengraph.cell;
for(i=0;
i<cell.length;
i++){id=cell[i]["@id"];
parent=cell[i]["@parent"];
shapeType=cell[i]["@shapeType"];
shapeId=cell[i]["@shapeId"];
x=parseInt(cell[i]["@x"],10);
y=parseInt(cell[i]["@y"],10);
width=parseInt(cell[i]["@width"],10);
height=parseInt(cell[i]["@height"],10);
style=unescape(cell[i]["@style"]);
geom=unescape(cell[i]["@geom"]);
from=cell[i]["@from"];
to=cell[i]["@to"];
fromEdge=cell[i]["@fromEdge"];
toEdge=cell[i]["@toEdge"];
label=cell[i]["@label"];
fromLabel=cell[i]["@fromLabel"];
toLabel=cell[i]["@toLabel"];
angle=cell[i]["@angle"];
value=cell[i]["@value"];
data=cell[i]["@data"];
entityData=cell[i]["@entityData"];
nodeEntryId=cell[i]["@nodeEntryId"];
nodeEntryData=cell[i]["@nodeEntryData"];
label=label?unescape(label):label;
minX=(minX>(x-width/2))?(x-width/2):minX;
minY=(minY>(y-height/2))?(y-height/2):minY;
maxX=(maxX<(x+width/2))?(x+width/2):maxX;
maxY=(maxY<(y+height/2))?(y+height/2):maxY;
switch(shapeType){case OG.Constants.SHAPE_TYPE.GEOM:case OG.Constants.SHAPE_TYPE.GROUP:shape=eval("new "+shapeId+"()");
if(label){shape.label=label
}element=this.drawShape([x,y],shape,[width,height],OG.JSON.decode(style),id,parent,false);
break;
case OG.Constants.SHAPE_TYPE.EDGE:shape=eval("new "+shapeId+"("+value+")");
if(label){shape.label=label
}if(fromLabel){shape.fromLabel=unescape(fromLabel)
}if(toLabel){shape.toLabel=unescape(toLabel)
}if(geom){geom=OG.JSON.decode(geom);
if(geom.type===OG.Constants.GEOM_NAME[OG.Constants.GEOM_TYPE.POLYLINE]){geom=new OG.geometry.PolyLine(geom.vertices);
shape.geom=geom
}else{if(geom.type===OG.Constants.GEOM_NAME[OG.Constants.GEOM_TYPE.CURVE]){geom=new OG.geometry.Curve(geom.controlPoints);
shape.geom=geom
}}}if(nodeEntryId){shape.nodeEntryId=nodeEntryId
}if(nodeEntryData){shape.nodeEntryData=OG.JSON.decode(unescape(nodeEntryData))
}if(shape.nodeEntryData){shape.MOVABLE=shape.nodeEntryData.modifiable;
shape.RESIZABLE=shape.nodeEntryData.modifiable
}element=this.drawShape(null,shape,null,OG.JSON.decode(style),id,parent,false);
break;
case OG.Constants.SHAPE_TYPE.HTML:shape=eval("new "+shapeId+"()");
if(value){shape.html=unescape(value)
}if(label){shape.label=label
}if(nodeEntryId){shape.nodeEntryId=nodeEntryId
}if(nodeEntryData){shape.nodeEntryData=OG.JSON.decode(unescape(nodeEntryData))
}if(shape.nodeEntryData){shape.MOVABLE=shape.nodeEntryData.modifiable;
shape.RESIZABLE=shape.nodeEntryData.modifiable
}element=this.drawShape([x,y],shape,[width,height,angle],OG.JSON.decode(style),id,parent,false);
break;
case OG.Constants.SHAPE_TYPE.IMAGE:shape=eval("new "+shapeId+"('"+value+"')");
if(label){shape.label=label
}if(nodeEntryId){shape.nodeEntryId=nodeEntryId
}if(nodeEntryData){shape.nodeEntryData=OG.JSON.decode(unescape(nodeEntryData))
}if(shape.nodeEntryData){shape.MOVABLE=shape.nodeEntryData.modifiable;
shape.RESIZABLE=shape.nodeEntryData.modifiable
}element=this.drawShape([x,y],shape,[width,height,angle],OG.JSON.decode(style),id,parent,false);
break;
case OG.Constants.SHAPE_TYPE.TEXT:shape=eval("new "+shapeId+"()");
if(value){shape.text=unescape(value)
}element=this.drawShape([x,y],shape,[width,height,angle],OG.JSON.decode(style),id,parent,false);
break
}if(from){$(element).attr("_from",from)
}if(to){$(element).attr("_to",to)
}if(fromEdge){$(element).attr("_fromedge",fromEdge)
}if(toEdge){$(element).attr("_toedge",toEdge)
}if(data){element.data=OG.JSON.decode(unescape(data))
}if(shape&&entityData){shape.entityData=OG.JSON.decode(unescape(entityData))
}}this.setCanvasSize([canvasWidth,canvasHeight]);
return{width:maxX-minX,height:maxY-minY,x:minX,y:minY,x2:maxX,y2:maxY}
}return{width:0,height:0,x:0,y:0,x2:0,y2:0}
},getPrevEdges:function(a){return this._RENDERER.getPrevEdges(a)
},getNextEdges:function(a){return this._RENDERER.getNextEdges(a)
},getPrevShapes:function(a){return this._RENDERER.getPrevShapes(a)
},getPrevShapeIds:function(a){return this._RENDERER.getPrevShapeIds(a)
},getNextShapes:function(a){return this._RENDERER.getNextShapes(a)
},getNextShapeIds:function(a){return this._RENDERER.getNextShapeIds(a)
},onDrawShape:function(a){$(this.getRootElement()).bind("drawShape",function(c,b){a(c,b)
})
},onDrawLabel:function(a){$(this.getRootElement()).bind("drawLabel",function(d,b,c){a(d,b,c)
})
},onLabelChanged:function(a){$(this.getRootElement()).bind("labelChanged",function(e,c,b,d){a(e,c,b,d)
})
},onBeforeLabelChange:function(a){$(this.getRootElement()).bind("beforeLabelChange",function(b){if(a(b,b.element,b.afterText,b.beforeText)===false){b.stopPropagation()
}})
},onRedrawShape:function(a){$(this.getRootElement()).bind("redrawShape",function(c,b){a(c,b)
})
},onRemoveShape:function(a){$(this.getRootElement()).bind("removeShape",function(c,b){a(c,b)
})
},onRotateShape:function(a){$(this.getRootElement()).bind("rotateShape",function(c,b,d){a(c,b,d)
})
},onMoveShape:function(a){$(this.getRootElement()).bind("moveShape",function(c,b,d){a(c,b,d)
})
},onResizeShape:function(a){$(this.getRootElement()).bind("resizeShape",function(c,b,d){a(c,b,d)
})
},onBeforeConnectShape:function(a){$(this.getRootElement()).bind("beforeConnectShape",function(b){if(a(b,b.edge,b.fromShape,b.toShape)===false){b.stopPropagation()
}})
},onBeforeRemoveShape:function(a){$(this.getRootElement()).bind("beforeRemoveShape",function(b){if(a(b,b.element)===false){b.stopPropagation()
}})
},onConnectShape:function(a){$(this.getRootElement()).bind("connectShape",function(d,c,e,b){a(d,c,e,b)
})
},onDisconnectShape:function(a){$(this.getRootElement()).bind("disconnectShape",function(d,c,e,b){a(d,c,e,b)
})
},onGroup:function(a){$(this.getRootElement()).bind("group",function(c,b){a(c,b)
})
},onUnGroup:function(a){$(this.getRootElement()).bind("ungroup",function(b,c){a(b,c)
})
},onCollapsed:function(a){$(this.getRootElement()).bind("collapsed",function(c,b){a(c,b)
})
},onExpanded:function(a){$(this.getRootElement()).bind("expanded",function(c,b){a(c,b)
})
}};
OG.graph.Canvas.prototype.constructor=OG.graph.Canvas;
OG.Canvas=OG.graph.Canvas;
$.ui.draggable.prototype.options.useShim=false;
var canvas;
var bpm={scale:1,backgroundImage:"url(dorado/res/dorado/resources/icons/bg/bg4.gif)",backgroundImageData:["url(dorado/res/dorado/resources/icons/bg/bg1.png)","url(dorado/res/dorado/resources/icons/bg/bg2.png)","url(dorado/res/dorado/resources/icons/bg/bg3.png)","url(dorado/res/dorado/resources/icons/bg/bg4.gif)"],init:function(){var _bpm=this,canvasHolder=_bpm.getDoradoView().get("#bpm_canvas").getContentContainer();
canvas=new OG.Canvas(canvasHolder,[10000,10000],"white",_bpm.backgroundImage);
canvas._CONFIG.DEFAULT_STYLE.EDGE["edge-type"]="straight";
canvas.initConfig({selectable:true,dragSelectable:true,movable:true,resizable:true,connectable:true,selfConnectable:false,connectCloneable:false,connectRequired:true,labelEditable:true,groupDropable:true,collapsible:true,enableHotKey:true,enableContextMenu:false});
$(".bpm-node > .icon_shape").draggable({start:function(){$(canvasHolder).data("DRAG_SHAPE",{_shape_type:$(this).attr("_shape_type"),_shape_id:$(this).attr("_shape_id"),_width:$(this).attr("_width"),_height:$(this).attr("_height")})
},helper:"clone",appendTo:canvasHolder});
$(canvasHolder).droppable({drop:function(event,ui){var shapeInfo=$(canvasHolder).data("DRAG_SHAPE"),shape,element;
var view=_bpm.getDoradoView();
if(shapeInfo){if(canvas.addable===false){$(canvasHolder).removeData("DRAG_SHAPE");
dorado.MessageBox.alert("权限不足,不能执行添加节点操作!")
}else{shape=eval("new "+shapeInfo._shape_id+"()");
var eventOffset=canvas.getEventHandler()._getOffset(event);
var w=parseInt(shapeInfo._width,10);
var h=parseInt(shapeInfo._height,10);
element=canvas.drawShape([eventOffset.x,eventOffset.y],shape,[w,h]);
$(canvasHolder).removeData("DRAG_SHAPE")
}}}});
canvas.onMoveShape(function(event,shapeElement,offset){if(shapeElement.shape.SHAPE_ID!="bpm.Connection"){_bpm.onNodeSelected(shapeElement)
}});
canvas.onConnectShape(function(event,shapeElement,offset){var fromTerminalId=$(shapeElement).attr("_from"),toTerminalId=$(shapeElement).attr("_to"),fromShapeElement=canvas._HANDLER._getShapeFromTerminal(fromTerminalId),toShapeElement=canvas._HANDLER._getShapeFromTerminal(toTerminalId);
canvas.getRenderer().drawEdgeLabel(shapeElement,"to "+toShapeElement.shape.label,"TO");
_bpm.onNodeSelected(shapeElement)
});
canvas.onLabelChanged(function(event,shapeElement,offset){_bpm.onNodeLabelChanged(shapeElement)
});
$(canvas.getRootElement()).bind("click",function(){var nodeCardBook=_bpm.getNodeCardBook();
_bpm.getConfigNodePanel().set("caption","流程配置");
if(nodeCardBook.get("currentControl")!=nodeCardBook.getControl("processNode")){nodeCardBook.set("currentControl",nodeCardBook.getControl("processNode"))
}_bpm.checkProcessAttributeSecurity()
})
},checkProcessAttributeSecurity:function(){if(canvas.processAttributes){var a,c;
a=this.getDoradoView();
c=canvas.processAttributes||[];
c.each(function(f){var d,g,e;
d=f.name;
g=f.authorityType==="Read"?true:false;
e=a.get("^p_"+d);
bpm.setWidgetsAuthorityType(e,g)
})
}else{var b=canvas.nodeSecurityAttributes||[],a=this.getDoradoView();
b.each(function(d){if(d.name==="process"){d.attributes.each(function(f){var e=a.get("^p_"+f);
bpm.setWidgetsAuthorityType(e,false)
});
return false
}})
}},checkNodeAttributeSecurity:function(d){var c=d.shape,g=c.SHAPE_ID,b,a=this.getDoradoView();
b=c.nodeEntryData;
if(b){var f=b.nodeAttributeList||[];
c.REMOVABLE=b.removable;
if(b.modifiable===false){c.MOVABLE=false;
c.RESIZABLE=false;
canvas._HANDLER.setMovable(d,canvas._HANDLER._isMovable(c))
}f.each(function(k){var h,l,j;
h=k.name;
if(b.modifiable===false){l=true
}else{l=k.authorityType==="Read"?true:false
}j=a.get("^n_"+h);
bpm.setWidgetsAuthorityType(j,l)
})
}else{var e=canvas.nodeSecurityAttributes||[];
e.each(function(h){if(g.toLowerCase().indexOf(h.name)!=-1){h.attributes.each(function(k){var j=a.get("^n_"+k);
bpm.setWidgetsAuthorityType(j,false)
});
return false
}})
}},setWidgetsAuthorityType:function(a,b){a.each(function(c){if(c instanceof dorado.widget.FormElement||c instanceof dorado.widget.DataGrid||c instanceof dorado.widget.AutoForm||c instanceof dorado.widget.NumberSpinner||c instanceof dorado.widget.RadioGroup){c.set("readOnly",b)
}else{if(c instanceof dorado.widget.Button||c instanceof dorado.widget.DataPilot){c.set("disabled",b)
}}})
},getDoradoView:function(){return window.$topView.get("children").first.data
},getNodeCardBook:function(){var a=this;
return a.getDoradoView().get("#nodeCardBook")
},getConfigNodePanel:function(){var a=this;
return a.getDoradoView().get("#configNodePanel")
},setNodeLabel:function(a){var b=this;
if(a){$(canvas.getRenderer().getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(d,e){if($(e).attr("_shape")==OG.Constants.SHAPE_TYPE.HTML){e.shape.label=a;
var f=false;
if(e.shape.entityData){var c=e.shape.entityData.taskType;
if(c&&c=="Countersign"){f=true
}}e.shape.html=b.createShapeHtml(f==true?e.shape.icon2:e.shape.icon,a);
canvas.getRenderer().redrawShape(e)
}else{canvas.getRenderer().drawLabel(e,a)
}})
}},setConnectionLabel:function(a){$(canvas.getRenderer().getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(c,d){var b=a;
if(!b){b="";
d.shape.toLabel=""
}canvas.getRenderer().drawEdgeLabel(d,b,"TO")
})
},setCanvasControlTabCaption:function(b){var c=this,a=c.getDoradoView();
a.get("^controlTabProcess").set("caption",b)
},onNodeLabelChanged:function(d){var e=this,b=d.shape,f=b.SHAPE_ID,a=e.getDoradoView(),c=a.get("#dataSet"+f.split(".").peek());
c.getData("#").set("name",b.label)
},onLoadGraphData:function(){var c=this,a=c.getDoradoView(),d=c.getNodeCardBook(),b;
b=a.get("#dataSetProcess");
if(canvas.entityData){b.clear();
b.insert(canvas.entityData);
c.setCanvasControlTabCaption(canvas.entityData.name)
}$(canvas.getRenderer().getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"]").each(function(e,f){canvas.move(f,[0,0])
});
c.getConfigNodePanel().set("caption","流程配置");
if(d.get("currentControl")!=d.getControl("processNode")){d.set("currentControl",d.getControl("processNode"))
}d.get("currentControl").set("currentIndex",0);
c.checkProcessAttributeSecurity()
},setFormUrl:function(){var d=this,a=d.getDoradoView(),c;
c=a.get("#dataSetTableInfo").getData("#.#formInfos");
if(c){var b=c.get("url"),e=d.getNodeCardBook().get("currentControl").get("id");
if(e=="processNode"){a.get("#dataSetProcess").getData("#").set("startProcessUrl",b)
}else{if(e=="taskNode"){a.get("#dataSetTask").getData("#").set("url",b)
}else{if(e=="startNode"){a.get("#dataSetStart").getData("#").set("url",b)
}}}a.get("#dialogTableInfo").hide()
}else{dorado.MessageBox.alert("请选择一条记录！")
}},onNodeSelected:function(m){var d=this,a,p,w,k,o,q,l,v;
q=d.getDoradoView();
a=m.shape;
p=a.entityData;
w=a.SHAPE_ID;
k=d.getNodeCardBook();
bpm.getConfigNodePanel().set("caption",a.nodeName+"节点配置");
o=k.getControl(a.controlId);
if(k.get("currentControl")!=o){k.set("currentControl",o)
}v=q.get("#dataSet"+w.split(".").peek());
v.clear();
o=k.get("currentControl");
o.set("currentIndex",0);
l=a instanceof bpm.Connection?a.toLabel:a.label;
if(p){p.name=l;
v.insert(p)
}else{v.insert({name:l})
}var x=v.getData("#");
if(a instanceof bpm.Connection){var t=x.get("conditionType");
if(t=="None"){q.get("^handlerBean").set("visible",false);
q.get("^expression").set("visible",false)
}else{if(t=="Expression"){q.get("^handlerBean").set("visible",false);
q.get("^expression").set("visible",true)
}else{if(t=="Handler"){q.get("^handlerBean").set("visible",true);
q.get("^expression").set("visible",false)
}}}}else{if(a instanceof bpm.Task){var g=x.get("taskType");
if(g=="Normal"){q.get("^countersign").set("visible",false)
}else{if(g=="Countersign"){q.get("^countersign").set("visible",true)
}}var r=x.get("counterSignType");
if(r=="countersignMultiplicity"){q.get("^countersignPercentMultiplicity").set("visible",false);
q.get("^countersignExpression").set("visible",false);
q.get("^countersignHandler").set("visible",false);
q.get("^countersignMultiplicity").set("visible",true)
}else{if(r=="countersignPercentMultiplicity"){q.get("^countersignMultiplicity").set("visible",false);
q.get("^countersignExpression").set("visible",false);
q.get("^countersignHandler").set("visible",false);
q.get("^countersignPercentMultiplicity").set("visible",true)
}else{if(r=="countersignExpression"){q.get("^countersignMultiplicity").set("visible",false);
q.get("^countersignHandler").set("visible",false);
q.get("^countersignPercentMultiplicity").set("visible",false);
q.get("^countersignExpression").set("visible",true)
}else{if(r=="countersignHandler"){q.get("^countersignMultiplicity").set("visible",false);
q.get("^countersignExpression").set("visible",false);
q.get("^countersignPercentMultiplicity").set("visible",false);
q.get("^countersignHandler").set("visible",true)
}else{q.get("^countersignMultiplicity").set("visible",false);
q.get("^countersignPercentMultiplicity").set("visible",false);
q.get("^countersignExpression").set("visible",false);
q.get("^countersignHandler").set("visible",false)
}}}}var n=x.get("assignmentType");
if(n=="Swimlane"){q.get("^swimlane").set("visible",true);
q.get("^expression").set("visible",false);
q.get("^assignmentHandlerBean").set("visible",false);
q.get("^taskAssignee").set("visible",false)
}else{if(n=="Expression"){q.get("^swimlane").set("visible",false);
q.get("^expression").set("visible",true);
q.get("^assignmentHandlerBean").set("visible",false);
q.get("^taskAssignee").set("visible",false)
}else{if(n=="Handler"){q.get("^swimlane").set("visible",false);
q.get("^expression").set("visible",false);
q.get("^assignmentHandlerBean").set("visible",true);
q.get("^taskAssignee").set("visible",false)
}else{if(n=="Assignee"){q.get("^swimlane").set("visible",false);
q.get("^expression").set("visible",false);
q.get("^assignmentHandlerBean").set("visible",false);
q.get("^taskAssignee").set("visible",true)
}else{if(n=="ProcessPromoter"){q.get("^swimlane").set("visible",false);
q.get("^expression").set("visible",false);
q.get("^assignmentHandlerBean").set("visible",false);
q.get("^taskAssignee").set("visible",false)
}}}}}var s=x.get("useDue");
if(s==true){q.get("^useTaskDue").set("visible",true)
}else{q.get("^useTaskDue").set("visible",false)
}var e=x.get("useDueAction");
if(e==true){q.get("^useDueAction").set("visible",true)
}else{q.get("^useDueAction").set("visible",false)
}var f=x.get("reminderType");
if(f=="none"){q.get("^period").set("visible",false);
q.get("^once").set("visible",false)
}else{if(f=="once"){q.get("^period").set("visible",false);
q.get("^once").set("visible",true)
}else{if(f=="period"){q.get("^period").set("visible",true)
}}}}else{if(a instanceof bpm.SubProcess){var j=x.get("subprocessType");
if(j=="Name"){q.get("^subprocessName").set("visible",true);
q.get("^subprocessKey").set("visible",false);
q.get("^subprocessId").set("visible",false)
}else{if(j=="Key"){q.get("^subprocessName").set("visible",false);
q.get("^subprocessId").set("visible",false);
q.get("^subprocessKey").set("visible",true)
}else{if(j=="Id"){q.get("^subprocessName").set("visible",false);
q.get("^subprocessKey").set("visible",false);
q.get("^subprocessId").set("visible",true)
}}}}else{if(a instanceof bpm.Decision){var u=x.get("decisionType");
if(u=="Expression"){q.get("^expression").set("visible",true);
q.get("^handlerBean").set("visible",false)
}else{if(u=="Handler"){q.get("^expression").set("visible",false);
q.get("^handlerBean").set("visible",true)
}else{q.get("^expression").set("visible",false);
q.get("^handlerBean").set("visible",false)
}}}else{if(a instanceof bpm.Foreach){var h=x.get("foreachType");
if(h=="In"){q.get("^in").set("visible",true);
q.get("^handlerBean").set("visible",false)
}else{if(h=="Handler"){q.get("^in").set("visible",false);
q.get("^handlerBean").set("visible",true)
}else{q.get("^in").set("visible",false);
q.get("^handlerBean").set("visible",false)
}}}else{if(a instanceof bpm.Join){var c=x.get("useMultiplicity"),b=x.get("multiplicityType");
if(c==false){q.get("^multiplicityType").set("readOnly",true);
q.get("^multiplicity").set("visible",false);
q.get("^percentMultiplicity").set("visible",false)
}else{if(b=="multiplicity"){q.get("^multiplicityType").set("readOnly",false);
q.get("^multiplicity").set("visible",true);
q.get("^percentMultiplicity").set("visible",false)
}else{if(b=="percentMultiplicity"){q.get("^multiplicityType").set("readOnly",false);
q.get("^percentMultiplicity").set("visible",true);
q.get("^multiplicity").set("visible",false)
}}}}}}}}}d.checkNodeAttributeSecurity(m)
},onNodeDataChanged:function(c){var f=this,a=f.getDoradoView(),b=c.dataType,e=b.get("name");
if(e=="dataTypeProcess"||e=="dataTypeSwimlane"||e=="dataTypeSwimlaneAssignee"){var d=a.get("#dataSetProcess").getData("#").toJSON({generateDataType:false,includeDeletedEntity:false,entityFilter:function(g){if(g.state==dorado.Entity.STATE_DELETED){return false
}else{return true
}}});
canvas.entityData=d
}else{$(canvas.getRenderer().getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(h,l){var g=l.shape,m=g.SHAPE_ID,j=a.get("#dataSet"+m.split(".").peek());
var k=j.getData("#").toJSON({generateDataType:false,includeDeletedEntity:false,entityFilter:function(n){if(n.state==dorado.Entity.STATE_DELETED){return false
}else{return true
}}});
g.entityData=k
})
}},setTaskIcon:function(a){var b=this;
$(canvas.getRenderer().getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(d,e){var c=e.shape;
c.html=b.createShapeHtml(a=="Normal"?c.icon:c.icon2,c.label);
canvas.getRenderer().redrawShape(e)
})
},setEndImage:function(a){var b=this;
$(canvas.getRenderer().getRootElement()).find("[_type="+OG.Constants.NODE_TYPE.SHAPE+"][_selected=true]").each(function(d,e){var c=e.shape;
c.image=a==true?c.icon:c.icon2;
canvas.getRenderer().redrawShape(e)
})
},saveDesignData:function(){var b=this.getDoradoView(),c,a;
c=b.get("#ajaxActionSaveDesignData");
a=canvas.getRenderer()._PAPER.canvas.parentNode;
c.set("parameter",{xmlData:canvas.toXML()}).execute(function(d){if(d){window.location.href="dorado/uflo/designer/file.downlaod?key="+d
}else{dorado.MessageBox.alert("生成流程文件失败！")
}})
},loadGraphData:function(c){var e=this,b=e.getDoradoView(),d,a;
d=b.get("#ajaxActionLoadGraphData");
a=canvas.getRenderer()._PAPER.canvas.parentNode;
d.set("parameter",c).execute(function(f){canvas.processId=null;
canvas.addable=true;
canvas.modifiable=true;
canvas.processAttributes=null;
canvas.loadXML(f);
e.onLoadGraphData()
})
},deployProcess:function(){var b=this.getDoradoView(),c,a;
dorado.MessageBox.confirm("您确定要发布一个新的流程模板吗？",function(){c=b.get("#ajaxActionDeployProcess");
a=b.get("#autoFormDeployProcess").get("entity").serverUrl;
if(!a){dorado.MessageBox.alert("服务器地址不能为空!");
return
}c.set("parameter",{xmlData:canvas.toXML(),serverUrl:a}).execute(function(d){dorado.MessageBox.alert(d!=null?d:"部署流程成功！")
})
})
},updateProcess:function(){var a=this.getDoradoView(),b;
b=a.get("#ajaxActionUpdateProcess");
if(!canvas.processId){dorado.MessageBox.alert("流程ID不存在！");
return
}dorado.MessageBox.confirm("保存成功后会覆盖原有的流程模板，您确定要保存此流程模板吗?",function(){b.set("parameter",{xmlData:canvas.toXML(),processId:canvas.processId}).execute()
})
},modifyProcess:function(){var e=this,a=this.getDoradoView(),c,d,b=a.get("#dataSetProcessDefinition").getData("#");
if(!b){dorado.MessageBox.alert("请先选择流程模版!");
return
}c=a.get("#ajaxActionFindProcessDefinitionXml");
d=b.get("id");
c.set("parameter",b.get("id"));
c.execute(function(f){if(f.nologin){dorado.MessageBox.alert("请先登录!")
}else{if(f.modifiable===true){a.get("#dialogProcessDefinition").hide();
canvas.processId=d;
canvas.modifiable=f.modifiable;
canvas.addable=f.addable;
canvas.loadXML(f.data);
e.onLoadGraphData();
a.get("^buttonSaveProcess").set("disabled",false)
}else{dorado.MessageBox.alert("权限不足,不能执行修改操作!")
}}})
},zoomIn:function(){var c=this,a=c.getDoradoView(),b=c.scale;
b=parseFloat((b+0.1).toFixed(1).toString());
canvas._RENDERER.setScale(b);
c.scale=b;
a.get("#textEditorCanvasPercent").set("text",parseInt(b*100)+"%")
},zoomOut:function(){var c=this,a=c.getDoradoView(),b=c.scale;
b=parseFloat((b-0.1).toFixed(1).toString());
if(b>0){canvas._RENDERER.setScale(b);
c.scale=b;
a.get("#textEditorCanvasPercent").set("text",parseInt(b*100)+"%")
}},actualSize:function(){var b=this,a=b.getDoradoView();
canvas._RENDERER.setScale(1);
b.scale=1;
a.get("#textEditorCanvasPercent").set("text","100%")
},setScaleSize:function(b){var c=this,a=b.substring(0,b.length-1);
a=parseInt(a)/100;
canvas._RENDERER.setScale(a);
c.scale=a
},setBackgroundImage:function(){var d=this,b,c,a=d.backgroundImageData;
a.each(function(e,f){if(e==d.backgroundImage){b=f;
return false
}});
c=b==a.length-1?a[0]:a[b+1];
d.backgroundImage=c;
$(canvas._RENDERER._PAPER.canvas).css({"background-image":c})
},createShapeHtml:function(c,b){var a='<table width="100%" height="40px" cellspacing="0"\n\tstyle="table-layout : fixed; border-radius: 10px; -moz-border-radius: 10px; -webkit-border-radius:10px; border: 2px #040FB3 solid; background-color: #EBE8E9;">\n\t<tr >\n\t\t<td style="white-space: nowrap; overflow: hidden;"><div style="vertical-align: middle; text-align: center;">\n\t           <img src="'+c+'" style="vertical-align: middle" /><span style="vertical-align: middle">'+b+"</span>\n\t\t</div></td>\n\t</tr>\n</table>";
return a
},deleteSelectedShape:function(){canvas._HANDLER.deleteSelectedShape()
},cutSelectedShape:function(){canvas._HANDLER.cutSelectedShape()
},copySelectedShape:function(){canvas._HANDLER.duplicateSelectedShape()
},pasteSelectedShape:function(){canvas._HANDLER.pasteSelectedShape()
}};
var _bpm_action_id=1;
bpm.Action=function(b,a){bpm.Action.superclass.call(this);
this.SHAPE_ID="bpm.Action";
this.nodeName="动作",this.icon="dorado/res/dorado/resources/icons/action32.png";
this.label=a||this.nodeName+_bpm_action_id++;
this.controlId="actionNode";
this.clazz="com.bstek.uflo.designer.model.node.Action";
this.html=bpm.createShapeHtml(this.icon,this.label)
};
bpm.Action.prototype=new OG.shape.HtmlShape();
bpm.Action.superclass=OG.shape.HtmlShape;
bpm.Connection=function(c,b,a){bpm.Connection.superclass.call(this,c,b,a);
this.SHAPE_ID="bpm.Connection";
this.nodeName="连线";
this.controlId="connectionNode";
this.clazz="com.bstek.uflo.designer.model.edge.Connection";
this.MOVABLE=false;
this.LABEL_EDITABLE=false
};
bpm.Connection.prototype=new OG.shape.EdgeShape();
bpm.Connection.superclass=OG.shape.EdgeShape;
bpm.Connection.prototype.createShape=function(){if(this.geom){return this.geom
}this.geom=new OG.Line(this.from||[0,0],this.to||[80,0]);
this.geom.style=new OG.geometry.Style({"edge-type":"straight","arrow-start":"none","arrow-end":"classic-wide-long","stroke-width":2,stroke:"#040FB3",fill:"#EBE8E9","fill-opacity":1,"font-color":"#2b2a2a","font-size":"12px"});
return this.geom
};
var _bpm_decision_id=1;
bpm.Decision=function(b,a){bpm.Decision.superclass.call(this);
this.SHAPE_ID="bpm.Decision";
this.nodeName="路由决策";
this.label=a||this.nodeName+_bpm_decision_id++;
this.image=b||"dorado/res/dorado/resources/icons/decision32.png";
this.angle=0;
this.controlId="decisionNode";
this.clazz="com.bstek.uflo.designer.model.node.Decision";
this.RESIZABLE=false;
this.SELF_CONNECTABLE=false;
this.CONNECT_CLONEABLE=false
};
bpm.Decision.prototype=new OG.shape.ImageShape();
bpm.Decision.superclass=OG.shape.ImageShape;
var _bpm_end_id=1;
bpm.End=function(b,a){bpm.End.superclass.call(this);
this.SHAPE_ID="bpm.End";
this.nodeName="结束";
this.label=a||this.nodeName+_bpm_end_id++;
this.icon="dorado/res/dorado/resources/icons/end-terminate32.png";
this.icon2="dorado/res/dorado/resources/icons/end32.png";
this.image=b||this.icon;
this.angle=0;
this.controlId="endNode";
this.clazz="com.bstek.uflo.designer.model.node.End";
this.RESIZABLE=true;
this.SELF_CONNECTABLE=false;
this.CONNECT_CLONEABLE=false
};
bpm.End.prototype=new OG.shape.ImageShape();
bpm.End.superclass=OG.shape.ImageShape;
var _bpm_foreach_id=1;
bpm.Foreach=function(b,a){bpm.Foreach.superclass.call(this);
this.SHAPE_ID="bpm.Foreach";
this.nodeName="动态分支";
this.label=a||this.nodeName+_bpm_foreach_id++;
this.image=b||"dorado/res/dorado/resources/icons/foreach32.png";
this.angle=0;
this.controlId="foreachNode";
this.clazz="com.bstek.uflo.designer.model.node.Foreach";
this.RESIZABLE=false;
this.SELF_CONNECTABLE=false;
this.CONNECT_CLONEABLE=false
};
bpm.Foreach.prototype=new OG.shape.ImageShape();
bpm.Foreach.superclass=OG.shape.ImageShape;
var _bpm_fork_id=1;
bpm.Fork=function(b,a){bpm.Fork.superclass.call(this);
this.SHAPE_ID="bpm.Fork";
this.nodeName="分支";
this.label=a||this.nodeName+_bpm_fork_id++;
this.image=b||"dorado/res/dorado/resources/icons/fork32.png";
this.angle=0;
this.controlId="forkNode";
this.clazz="com.bstek.uflo.designer.model.node.Fork";
this.RESIZABLE=false;
this.SELF_CONNECTABLE=false;
this.CONNECT_CLONEABLE=false
};
bpm.Fork.prototype=new OG.shape.ImageShape();
bpm.Fork.superclass=OG.shape.ImageShape;
var _bpm_join_id=1;
bpm.Join=function(b,a){bpm.Join.superclass.call(this);
this.SHAPE_ID="bpm.Join";
this.nodeName="聚合";
this.label=a||this.nodeName+_bpm_join_id++;
this.image=b||"dorado/res/dorado/resources/icons/join32.png";
this.angle=0;
this.controlId="joinNode";
this.clazz="com.bstek.uflo.designer.model.node.Join";
this.RESIZABLE=false;
this.SELF_CONNECTABLE=false;
this.CONNECT_CLONEABLE=false
};
bpm.Join.prototype=new OG.shape.ImageShape();
bpm.Join.superclass=OG.shape.ImageShape;
var _bpm_start_id=1;
bpm.Start=function(b,a){bpm.Start.superclass.call(this);
this.SHAPE_ID="bpm.Start";
this.nodeName="开始";
this.label=a||this.nodeName+_bpm_start_id++;
this.image="dorado/res/dorado/resources/icons/start32.png";
this.angle=0;
this.controlId="startNode";
this.clazz="com.bstek.uflo.designer.model.node.Start";
this.RESIZABLE=true;
this.SELF_CONNECTABLE=false;
this.CONNECT_CLONEABLE=false
};
bpm.Start.prototype=new OG.shape.ImageShape();
bpm.Start.superclass=OG.shape.ImageShape;
var _bpm_subprocess_id=1;
bpm.SubProcess=function(a){bpm.SubProcess.superclass.call(this);
this.SHAPE_ID="bpm.SubProcess";
this.nodeName="子流程";
this.icon="dorado/res/dorado/resources/icons/subprocess32.png";
this.label=a||this.nodeName+_bpm_subprocess_id++;
this.controlId="subProcessNode";
this.clazz="com.bstek.uflo.designer.model.node.SubProcess";
this.html=bpm.createShapeHtml(this.icon,this.label)
};
bpm.SubProcess.prototype=new OG.shape.HtmlShape();
bpm.SubProcess.superclass=OG.shape.HtmlShape;
var _bpm_task_id=1;
bpm.Task=function(b,a){bpm.Task.superclass.call(this);
this.SHAPE_ID="bpm.Task";
this.nodeName="人工任务";
this.icon="dorado/res/dorado/resources/icons/task32.png";
this.icon2="dorado/res/dorado/resources/icons/task-countersign32.png";
this.label=a||this.nodeName+_bpm_task_id++;
this.controlId="taskNode";
this.clazz="com.bstek.uflo.designer.model.node.Task";
this.html=bpm.createShapeHtml(this.icon,this.label)
};
bpm.Task.prototype=new OG.shape.HtmlShape();
bpm.Task.superclass=OG.shape.HtmlShape;