package com.bstek.uflo.designer.serializer.impl;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.node.Join;
/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
@Service
public class JoinSerializer extends NodeSerializer {
	public void serializerPrivateAttribute(Element joinElement, Shape shape) {
		Join join = (Join) shape;
		String multiplicityType = join.getMultiplicityType();
		if (StringUtils.isNotEmpty(multiplicityType)) {
			if (multiplicityType.equals("multiplicity")) {
				joinElement.addAttribute("multiplicity", String.valueOf(join.getMultiplicity()));
			} else if (multiplicityType.equals("percentMultiplicity")) {
				joinElement.addAttribute("percent-multiplicity", String.valueOf(join.getPercentMultiplicity()));
			}
		}
	}

	public boolean support(Shape shape) {
		return shape instanceof Join ? true : false;
	}

}
