package com.bstek.uflo.designer.serializer.impl;

import org.dom4j.Element;
import org.springframework.stereotype.Service;

import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.node.End;
/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
@Service
public class EndSerializer extends NodeSerializer {

	public void serializerPrivateAttribute(Element endElement, Shape shape) {
		End end = (End) shape;
		endElement.addAttribute("terminate", String.valueOf(end.isTerminate()));
	}

	public boolean support(Shape shape) {
		return shape instanceof End ? true : false;
	}

}
