package com.bstek.uflo.designer.serializer.impl;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

import com.bstek.uflo.designer.model.DecisionType;
import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.node.Decision;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
@Service
public class DecisionSerializer extends NodeSerializer {
	public void serializerPrivateAttribute(Element decisionElement, Shape shape) {
		Decision decision = (Decision) shape;
		String decisionType = decision.getDecisionType();
		if (StringUtils.isNotEmpty(decisionType)) {
			decisionElement.addAttribute("decision-type", decisionType);
			if (decisionType.equals(DecisionType.Expression.name())) {
				decisionElement.addAttribute("expression", decision.getExpression());
			} else if (decisionType.equals(DecisionType.Handler.name())) {
				decisionElement.addAttribute("handler-bean", decision.getHandlerBean());
			}
		}
	}

	public boolean support(Shape shape) {
		return shape instanceof Decision ? true : false;
	}

}
