package com.bstek.uflo.designer.security.manager;

import java.util.Collection;
import java.util.List;

import com.bstek.uflo.designer.security.AuthorizeAttribute;
import com.bstek.uflo.designer.security.model.NodeAttribute;
import com.bstek.uflo.designer.security.model.NodeEntry;
import com.bstek.uflo.designer.security.model.ProcessAttribute;
import com.bstek.uflo.designer.security.model.ProcessEntry;
import com.bstek.uflo.designer.security.model.ProcessEntryAssignee;
import com.bstek.uflo.model.ProcessDefinition;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
public interface SecurityManager {

	public static final String BEAN_ID = "uflo.designer.SecurityManager";

	public List<ProcessDefinition> findDbProcess() throws Exception;

	public List<ProcessEntry> findDbProcessEntry(long processId) throws Exception;

	public List<ProcessEntryAssignee> findDbProcessEntryAssignee(String processEntryId) throws Exception;

	public List<NodeEntry> findNodeEntryByProcessId(String processEntryId, long processId) throws Exception;

	public List<NodeEntry> findDbNodeEntry(String processEntryId) throws Exception;

	public NodeEntry findDbNodeEntryByNodeName(String processEntryId, String nodeName) throws Exception;

	public List<NodeAttribute> findDbNodeAttribute(String nodeEntryId) throws Exception;

	public List<NodeAttribute> findNodeAttributeByNodeType(String nodeEntryId, String nodeType) throws Exception;

	public List<ProcessAttribute> findProcessAttribute(String processEntryId) throws Exception;

	public List<ProcessAttribute> findDbProcessAttribute(String processEntryId) throws Exception;

	public Collection<AuthorizeAttribute> getAuthorizeAttributes() throws Exception;

	public void updateNodeEntry(String nodeEntryId, String nodeName) throws Exception;

}
