package com.bstek.uflo.designer.model.process;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnore;

import com.bstek.dorado.annotation.PropertyDef;
import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.edge.Connection;
import com.bstek.uflo.designer.model.node.Node;
import com.bstek.uflo.designer.security.annotation.SecurityAttribute;
import com.bstek.uflo.designer.security.model.ProcessEntry;

public class Process extends Shape {

	@PropertyDef(label = "名称")
	@SecurityAttribute
	private String name;

	@PropertyDef(label = "关键字")
	@SecurityAttribute
	private String key;

	@PropertyDef(label = "URL")
	@SecurityAttribute
	private String startProcessUrl;

	@PropertyDef(label = "事件Bean")
	@SecurityAttribute
	private String eventHandlerBean;

	@PropertyDef(label = "生效日期")
	@SecurityAttribute
	private Date effectDate;

	@PropertyDef(label = "分类ID")
	@SecurityAttribute
	private String categoryId;

	@PropertyDef(label = "描述")
	@SecurityAttribute
	private String description;

	@SecurityAttribute(label = "泳道配置")
	private List<Swimlane> swimlanes = new ArrayList<Swimlane>();

	@JsonIgnore
	private List<Node> nodes = new ArrayList<Node>();

	@JsonIgnore
	private ProcessEntry processEntry;

	public Process() {
	}

	public Process(String name) {
		this.setName(name);
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getCategoryId() {
		return categoryId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getStartProcessUrl() {
		return startProcessUrl;
	}

	public void setStartProcessUrl(String startProcessUrl) {
		this.startProcessUrl = startProcessUrl;
	}

	public String getEventHandlerBean() {
		return eventHandlerBean;
	}

	public void setEventHandlerBean(String eventHandlerBean) {
		this.eventHandlerBean = eventHandlerBean;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getEffectDate() {
		return effectDate;
	}

	public void setEffectDate(Date effectDate) {
		this.effectDate = effectDate;
	}

	public void setCategoryId(String categoryId) {
		this.categoryId = categoryId;
	}

	public List<Swimlane> getSwimlanes() {
		return swimlanes;
	}

	public void setSwimlanes(List<Swimlane> swimlanes) {
		this.swimlanes = swimlanes;
	}

	public List<Node> getNodes() {
		return nodes;
	}

	public void setNodes(List<Node> nodes) {
		this.nodes = nodes;
	}

	public void cleanUselessValue() {
		processEntry = null;
		this.getNodes().clear();
	}

	@JsonIgnore
	public List<Connection> getConnections() {
		List<Connection> connections = new ArrayList<Connection>();
		for (Node node : this.nodes) {
			connections.addAll(node.getOutConnections());
		}
		return connections;
	}

	public ProcessEntry getProcessEntry() {
		return processEntry;
	}

	public void setProcessEntry(ProcessEntry processEntry) {
		this.processEntry = processEntry;
	}

}
