package com.bstek.uflo.designer.model.node;

import java.util.ArrayList;
import java.util.List;

import com.bstek.dorado.annotation.PropertyDef;
import com.bstek.uflo.designer.model.SubProcessVariable;
import com.bstek.uflo.designer.security.annotation.SecurityAttribute;

public class SubProcess extends RectNode {

	@PropertyDef(label = "子流程类型")
	@SecurityAttribute(label = "子流程类型配置")
	private String subprocessType = "Name";

	@PropertyDef(label = "子流程名称")
	private String subprocessName;

	@PropertyDef(label = "子流程Key")
	private String subprocessKey;

	@PropertyDef(label = "子流程Id")
	private String subprocessId;

	@SecurityAttribute(label = "子流程变量配置")
	private List<SubProcessVariable> outVariables = new ArrayList<SubProcessVariable>();

	public String getSubprocessType() {
		return subprocessType;
	}

	public void setSubprocessType(String subprocessType) {
		this.subprocessType = subprocessType;
	}

	public String getSubprocessName() {
		return subprocessName;
	}

	public void setSubprocessName(String subprocessName) {
		this.subprocessName = subprocessName;
	}

	public String getSubprocessKey() {
		return subprocessKey;
	}

	public void setSubprocessKey(String subprocessKey) {
		this.subprocessKey = subprocessKey;
	}

	public String getSubprocessId() {
		return subprocessId;
	}

	public void setSubprocessId(String subprocessId) {
		this.subprocessId = subprocessId;
	}

	public List<SubProcessVariable> getOutVariables() {
		return outVariables;
	}

	public void setOutVariables(List<SubProcessVariable> outVariables) {
		this.outVariables = outVariables;
	}

}
