package com.bstek.uflo.designer.model.node;

import java.util.ArrayList;
import java.util.List;

import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.edge.Connection;
import com.bstek.uflo.designer.security.annotation.SecurityAttribute;
import com.bstek.uflo.designer.utils.ShapeUtils;

public abstract class Node extends Shape {

	@SecurityAttribute(label = "名称")
	private String name;

	@SecurityAttribute(label = "事件Bean")
	private String eventHandlerBean;

	@SecurityAttribute(label = "描述")
	private String description;

	private String fromNodeId;

	private String fromConnectionId;

	private String toNodeId;

	private String toConnectionId;

	private List<Connection> outConnections = new ArrayList<Connection>();

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getEventHandlerBean() {
		return eventHandlerBean;
	}

	public void setEventHandlerBean(String eventHandlerBean) {
		this.eventHandlerBean = eventHandlerBean;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public List<Connection> getOutConnections() {
		return outConnections;
	}

	public void setOutConnections(List<Connection> outConnections) {
		this.outConnections = outConnections;
	}

	public String getFromNodeId() {
		return fromNodeId;
	}

	public void setFromNodeId(String fromNodeId) {
		this.fromNodeId = fromNodeId;
	}

	public String getFromConnectionId() {
		return fromConnectionId;
	}

	public void setFromConnectionId(String fromConnectionId) {
		this.fromConnectionId = fromConnectionId;
	}

	public String getToNodeId() {
		return toNodeId;
	}

	public void setToNodeId(String toNodeId) {
		this.toNodeId = toNodeId;
	}

	public String getToConnectionId() {
		return toConnectionId;
	}

	public void setToConnectionId(String toConnectionId) {
		this.toConnectionId = toConnectionId;
	}

	public abstract String getShapeType();

	public abstract String getShapeValue();

	public String getShapeId() {
		return ShapeUtils.getShapeObjectId(this);
	}

	public String getShapeGeomValue() {
		int x = getRectangle().getPoint().getX();
		int y = getRectangle().getPoint().getY();
		int width = getRectangle().getWidth();
		int height = getRectangle().getHeight();
		int upperLeftX = x - width / 2;
		int upperLeftY = y - height / 2;
		return "{type:'Rectangle',upperLeft:[" + upperLeftX + "," + upperLeftY + "],width:" + width + ",height:" + height + ",angle:0}";
	}

	public void cleanUselessValue() {
		this.fromNodeId = null;
		this.fromConnectionId = null;
		this.toNodeId = null;
		this.toConnectionId = null;
		setNodeEntryId(null);
		this.outConnections.clear();

	}

}
