package com.bstek.uflo.designer.model.edge;

import com.bstek.dorado.annotation.PropertyDef;
import com.bstek.uflo.designer.security.annotation.SecurityAttribute;

public class Connection extends Edge {

	@PropertyDef(label = "名称")
	@SecurityAttribute
	private String name;

	@PropertyDef(label = "连接条件类型")
	@SecurityAttribute(label = "连接条件配置")
	private String conditionType;

	@PropertyDef(label = "条件表达式")
	private String expression;

	@PropertyDef(label = "条件Bean")
	private String handlerBean;

	public Connection() {
	}

	public Connection(String name) {
		super();
		this.setName(name);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getExpression() {
		return expression;
	}

	public void setExpression(String expression) {
		this.expression = expression;
	}

	public String getHandlerBean() {
		return handlerBean;
	}

	public void setHandlerBean(String handlerBean) {
		this.handlerBean = handlerBean;
	}

	public String getConditionType() {
		return conditionType;
	}

	public void setConditionType(String conditionType) {
		this.conditionType = conditionType;
	}

}