package com.bstek.uflo.designer.deserializer.impl;

import org.dom4j.Element;
import org.springframework.stereotype.Service;

import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.node.Start;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
@Service
public class StartDeserializer extends NodeDeserializer {

	public Shape execute(Element currentElement) throws Exception {
		Start start = new Start();
		super.deserializeCommonAttribute(start, currentElement);
		String taskName = currentElement.attributeValue("task-name");
		String url = currentElement.attributeValue("url");
		start.setTaskName(taskName);
		start.setUrl(url);
		return start;
	}

	public boolean support(String name) {
		return name.equals("start") ? true : false;
	}

}
