package com.bstek.uflo.designer.deserializer.impl;

import org.dom4j.Element;
import org.springframework.stereotype.Service;
import org.apache.commons.lang.StringUtils;

import com.bstek.uflo.designer.model.ForeachType;
import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.node.Foreach;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
@Service
public class ForeachDeserializer extends NodeDeserializer {

	public Shape execute(Element currentElement) throws Exception {
		Foreach foreach = new Foreach();
		super.deserializeCommonAttribute(foreach, currentElement);
		String var = currentElement.attributeValue("var");
		foreach.setVar(var);
		String handlerBean = currentElement.attributeValue("handler-bean");
		String in = currentElement.attributeValue("in");
		if (StringUtils.isNotEmpty(handlerBean)) {
			foreach.setForeachType(ForeachType.Handler.name());
		} else {
			foreach.setForeachType(ForeachType.In.name());
		}
		foreach.setIn(in);
		foreach.setHandlerBean(handlerBean);
		return foreach;

	}

	public boolean support(String name) {
		return name.equals("foreach") ? true : false;
	}

}
