package com.bstek.uflo.designer.convert;

import java.io.File;

import com.bstek.uflo.designer.model.process.Process;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
public interface ConvertService {

	public static final String BEAN_ID = "uflo.designer.convertService";

	public Process graphToModel(String graphXmlData) throws Exception;

	public Process ufloToModel(String ufloXmlData) throws Exception;

	public Process ufloToModel(String ufloXmlData, long processId) throws Exception;

	public File modelToUflo(Process process) throws Exception;

	public String modelToGraph(Process process) throws Exception;

	public String findProcessDefinitionXml(long processId) throws Exception;

}
