package com.bstek.uflo.designer.command;

import org.hibernate.criterion.DetachedCriteria;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
public class QueryUniqueResultCommand<T> implements Command<T> {

	private DetachedCriteria detachedCriteria;

	public QueryUniqueResultCommand(DetachedCriteria detachedCriteria) {
		this.detachedCriteria = detachedCriteria;
	}

	@SuppressWarnings("unchecked")
	public T execute(Context context) {
		return (T) detachedCriteria.getExecutableCriteria(context.getSession()).uniqueResult();
	}

}
