package com.bstek.uflo.designer.utils;

import java.util.List;

import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.TaskType;
import com.bstek.uflo.designer.model.node.Action;
import com.bstek.uflo.designer.model.node.Decision;
import com.bstek.uflo.designer.model.node.End;
import com.bstek.uflo.designer.model.node.Foreach;
import com.bstek.uflo.designer.model.node.Fork;
import com.bstek.uflo.designer.model.node.Join;
import com.bstek.uflo.designer.model.node.Node;
import com.bstek.uflo.designer.model.node.Start;
import com.bstek.uflo.designer.model.node.SubProcess;
import com.bstek.uflo.designer.model.node.Task;

public class ShapeUtils {

	public static String getShapeIcon(Shape shape) {
		if (shape instanceof Start) {
			return "start32.png";
		} else if (shape instanceof End) {
			return  ((End) shape).isTerminate()? "end-terminate32.png" :"end32.png";
		} else if (shape instanceof Decision) {
			return "decision32.png";
		} else if (shape instanceof Fork) {
			return "fork32.png";
		} else if (shape instanceof Join) {
			return "join32.png";
		} else if (shape instanceof Foreach) {
			return "foreach32.png";
		} else if (shape instanceof Task) {
			return ((Task) shape).getTaskType().equals(TaskType.Countersign.name()) ? "task-countersign32.png" : "task32.png";
		} else if (shape instanceof Action) {
			return "action32.png";
		} else if (shape instanceof SubProcess) {
			return "subprocess32.png";
		}
		return null;
	}

	public static String getShapeObjectId(Shape shape) {
		if (shape instanceof Start) {
			return "bpm.Start";
		} else if (shape instanceof End) {
			return "bpm.End";
		} else if (shape instanceof Task) {
			return "bpm.Task";
		} else if (shape instanceof Action) {
			return "bpm.Action";
		} else if (shape instanceof SubProcess) {
			return "bpm.SubProcess";
		} else if (shape instanceof Decision) {
			return "bpm.Decision";
		} else if (shape instanceof Fork) {
			return "bpm.Fork";
		} else if (shape instanceof Join) {
			return "bpm.Join";
		} else if (shape instanceof Foreach) {
			return "bpm.Foreach";
		}
		return null;
	}

	public static String getShapXmlName(Shape shape) {
		if (shape instanceof Start) {
			return "start";
		} else if (shape instanceof End) {
			return "end";
		} else if (shape instanceof Task) {
			return "task";
		} else if (shape instanceof Action) {
			return "action";
		} else if (shape instanceof SubProcess) {
			return "subprocess";
		} else if (shape instanceof Decision) {
			return "decision";
		} else if (shape instanceof Fork) {
			return "fork";
		} else if (shape instanceof Join) {
			return "join";
		} else if (shape instanceof Foreach) {
			return "foreach";
		}
		return null;
	}
	

	public static Node findNodeById(List<Node> nodes, String nodeId) {
		for (Node node : nodes) {
			if (node.getId().equals(nodeId)) {
				return node;
			}
		}
		return null;
	}

	public static Node findNodeByName(List<Node> nodes, String nodeName) {
		for (Node node : nodes) {
			if (node.getName().equals(nodeName)) {
				return node;
			}
		}
		return null;
	}

}
