package com.bstek.uflo.designer.utils;

import java.io.StringWriter;

import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.DeserializationConfig.Feature;
import org.codehaus.jackson.map.ObjectMapper;

public class JSONUtils {

	public static String toJSON(Object object) throws Exception {
		StringWriter value = new StringWriter();
		JsonGenerator generator = new JsonFactory().createJsonGenerator(value);
		getObjectMapper().writeValue(generator, object);
		return value.toString();
	}

	public static <T> T fromJSON(String data, Class<T> clazz) throws Exception {
		return getObjectMapper().readValue(data, clazz);
	}

	public static ObjectMapper getObjectMapper() {
		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
		return mapper;
	}

}
