package com.bstek.uflo.designer.serializer.impl;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

import com.bstek.uflo.designer.model.AssignmentType;
import com.bstek.uflo.designer.model.CalendarInfo;
import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.TaskAssignee;
import com.bstek.uflo.designer.model.TaskType;
import com.bstek.uflo.designer.model.UserData;
import com.bstek.uflo.designer.model.node.Task;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
@Service
public class TaskSerializer extends NodeSerializer {

	public void serializerPrivateAttribute(Element taskElement, Shape shape) {
		Task task = (Task) shape;
		String taskName = task.getTaskName();
		if (StringUtils.isNotEmpty(taskName)) {
			taskElement.addAttribute("task-name", task.getTaskName());
		}
		String url = task.getUrl();
		if (StringUtils.isNotEmpty(url)) {
			taskElement.addAttribute("url", task.getUrl());
		}
		String taskListenerBean=task.getTaskListenerBean();
		if(StringUtils.isNotEmpty(taskListenerBean)){
			taskElement.addAttribute("task-listener-bean", taskListenerBean);
		}
		String taskType = task.getTaskType();
		taskElement.addAttribute("task-type", taskType);
		if (taskType.equals(TaskType.Countersign.name())) {
			String counterSignType = task.getCounterSignType();
			if (counterSignType.equals("countersignMultiplicity")) {
				taskElement.addAttribute("countersign-multiplicity", String.valueOf(task.getCountersignMultiplicity()));
			} else if (counterSignType.equals("countersignPercentMultiplicity")) {
				taskElement.addAttribute("countersign-percent-multiplicity", String.valueOf(task.getCountersignPercentMultiplicity()));
			} else if (counterSignType.equals("countersignExpression")) {
				taskElement.addAttribute("countersign-expression", task.getCountersignExpression());
			} else if (counterSignType.equals("countersignHandler")) {
				taskElement.addAttribute("countersign-handler", task.getCountersignHandler());
			}
		}
		taskElement.addAttribute("allow-specify-assignee", String.valueOf(task.isAllowSpecifyAssignee()));
		String assignmentType = task.getAssignmentType();
		taskElement.addAttribute("assignment-type", assignmentType);
		if (assignmentType.equals(AssignmentType.Swimlane.name())) {
			taskElement.addAttribute("swimlane", task.getSwimlane());
		} else if (assignmentType.equals(AssignmentType.Expression.name())) {
			taskElement.addAttribute("expression", task.getExpression());
		} else if (assignmentType.equals(AssignmentType.Handler.name())) {
			taskElement.addAttribute("assignment-handler-bean", task.getAssignmentHandlerBean());
		} else if (assignmentType.equals(AssignmentType.Assignee.name())) {
			List<TaskAssignee> taskAssignees = task.getTaskAssignees();
			if (taskAssignees != null) {
				for (TaskAssignee taskAssignee : taskAssignees) {
					Element taskAssigneeElement = taskElement.addElement("assignee");
					taskAssigneeElement.addAttribute("id", taskAssignee.getId());
					taskAssigneeElement.addAttribute("name", taskAssignee.getName());
					taskAssigneeElement.addAttribute("provider-id", taskAssignee.getProviderId());
				}
			}
		}
		if (task.isUseDue()) {
			Element dueElement = taskElement.addElement("due");
			int dueDay = task.getDueDay();
			int dueDour = task.getDueDour();
			int dueMinute = task.getDueMinute();
			dueElement.addAttribute("day", String.valueOf(dueDay));
			dueElement.addAttribute("hour", String.valueOf(dueDour));
			dueElement.addAttribute("minute", String.valueOf(dueMinute));
			List<CalendarInfo> dueCalendarInfos = task.getDueCalendarInfos();
			if (dueCalendarInfos != null) {
				for (CalendarInfo calendarInfo : dueCalendarInfos) {
					Element calendarInfoElement = dueElement.addElement("calendar-provider");
					calendarInfoElement.addAttribute("id", calendarInfo.getId());
					calendarInfoElement.addAttribute("name", calendarInfo.getName());
				}
			}
			String reminderType = task.getReminderType();
			if (reminderType.equals("once")) {
				Element onceElement = dueElement.addElement("once-reminder");
				String reminderHandlerBean = task.getReminderHandlerBean();
				if (StringUtils.isNotEmpty(reminderHandlerBean)) {
					onceElement.addAttribute("handler-bean", reminderHandlerBean);
				}
			} else if (reminderType.equals("period")) {
				Element periodElement = dueElement.addElement("period-reminder");
				String reminderHandlerBean = task.getReminderHandlerBean();
				if (StringUtils.isNotEmpty(reminderHandlerBean)) {
					periodElement.addAttribute("handler-bean", reminderHandlerBean);
				}
				int reminderRepeat = task.getReminderRepeat();
				periodElement.addAttribute("unit", task.getReminderDateUnit());
				periodElement.addAttribute("repeat", String.valueOf(reminderRepeat));
				List<CalendarInfo> reminderCalendarInfos = task.getReminderCalendarInfos();
				if (reminderCalendarInfos != null) {
					for (CalendarInfo calendarInfo : reminderCalendarInfos) {
						Element calendarInfoElement = periodElement.addElement("calendar-provider");
						calendarInfoElement.addAttribute("id", calendarInfo.getId());
						calendarInfoElement.addAttribute("name", calendarInfo.getName());
					}
				}
			}
			if(task.isUseDueAction()){
				Element dueActionElement = dueElement.addElement("due-action");
				int dueActionDay = task.getDueActionDay();
				int dueActionDour = task.getDueActionDour();
				int dueActionMinute = task.getDueActionMinute();
				String dueActionHandlerBean = task.getDueActionHandlerBean();
				dueActionElement.addAttribute("day", String.valueOf(dueActionDay));
				dueActionElement.addAttribute("hour", String.valueOf(dueActionDour));
				dueActionElement.addAttribute("minute", String.valueOf(dueActionMinute));
				if (StringUtils.isNotEmpty(dueActionHandlerBean)) {
					dueActionElement.addAttribute("handler-bean", dueActionHandlerBean);
				}
				List<CalendarInfo> dueActionCalendarInfos = task.getDueActionCalendarInfos();
				if (dueActionCalendarInfos != null) {
					for (CalendarInfo calendarInfo : dueActionCalendarInfos) {
						Element calendarInfoElement = dueActionElement.addElement("calendar-provider");
						calendarInfoElement.addAttribute("id", calendarInfo.getId());
						calendarInfoElement.addAttribute("name", calendarInfo.getName());
					}
				}
			}
		}
		List<UserData> userDataList = task.getUserData();
		if (userDataList != null) {
			for (UserData userData : userDataList) {
				Element userDataElement = taskElement.addElement("user-data");
				userDataElement.addAttribute("value", userData.getValue());
				userDataElement.addAttribute("key", userData.getKey());
			}
		}
	}

	public boolean support(Shape shape) {
		return shape instanceof Task ? true : false;
	}

}
