package com.bstek.uflo.designer.serializer.impl;

import java.util.List;

import org.dom4j.Element;
import org.springframework.stereotype.Service;

import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.SubProcessType;
import com.bstek.uflo.designer.model.SubProcessVariable;
import com.bstek.uflo.designer.model.node.SubProcess;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
@Service
public class SubProcessSerializer extends NodeSerializer {

	public void serializerPrivateAttribute(Element subProcessElement, Shape shape) {
		SubProcess subProcess = (SubProcess) shape;
		String subprocessType = subProcess.getSubprocessType();
		subProcessElement.addAttribute("subprocess-type", subprocessType);
		if (subprocessType.equals(SubProcessType.Id.name())) {
			subProcessElement.addAttribute("subprocess-id", subProcess.getSubprocessId());
		} else if (subprocessType.equals(SubProcessType.Name.name())) {
			subProcessElement.addAttribute("subprocess-name", subProcess.getSubprocessName());
		} else if (subprocessType.equals(SubProcessType.Key.name())) {
			subProcessElement.addAttribute("subprocess-key", subProcess.getSubprocessKey());
		}
		List<SubProcessVariable> outVariables = subProcess.getOutVariables();
		if (outVariables != null) {
			for (SubProcessVariable subProcessVariable : outVariables) {
				Element subProcessVariableElement = subProcessElement.addElement("out-subprocess-variable");
				subProcessVariableElement.addAttribute("out-parameter-key", subProcessVariable.getOutParameterKey());
				subProcessVariableElement.addAttribute("in-parameter-key", subProcessVariable.getInParameterKey());
			}
		}
	}

	public boolean support(Shape shape) {
		return shape instanceof SubProcess ? true : false;
	}

}
