package com.bstek.uflo.designer.serializer.impl;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.node.Start;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
@Service
public class StartSerializer extends NodeSerializer {

	public void serializerPrivateAttribute(Element startElement, Shape shape) {
		Start start = (Start) shape;
		String taskName = start.getTaskName();
		if (StringUtils.isNotEmpty(taskName)) {
			startElement.addAttribute("task-name", taskName);
		}
		String url = start.getUrl();
		if (StringUtils.isNotEmpty(url)) {
			startElement.addAttribute("url", url);
		}
	}

	public boolean support(Shape shape) {
		return shape instanceof Start ? true : false;
	}

}
