package com.bstek.uflo.designer.serializer.impl;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

import com.bstek.uflo.designer.model.ForeachType;
import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.node.Foreach;
/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
@Service
public class ForeachSerializer extends NodeSerializer {
	
	public void serializerPrivateAttribute(Element foreachElement, Shape shape) {
		Foreach foreach = (Foreach) shape;
		String var = foreach.getVar();
		if (StringUtils.isNotEmpty(var)) {
			foreachElement.addAttribute("var", var);
		}
		String foreachType = foreach.getForeachType();
		if (StringUtils.isNotEmpty(foreachType)) {
			foreachElement.addAttribute("foreach-type", foreach.getForeachType());
			if (foreachType.equals(ForeachType.In.name())) {
				foreachElement.addAttribute("in", foreach.getIn());
			} else if (foreachType.equals(ForeachType.Handler.name())) {
				foreachElement.addAttribute("handler-bean", foreach.getIn());
			}
		}
	}

	public boolean support(Shape shape) {
		return shape instanceof Foreach ? true : false;
	}

}
