package com.bstek.uflo.designer.serializer.impl;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.node.Action;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
@Service
public class ActionSerializer extends NodeSerializer {

	public void serializerPrivateAttribute(Element actionElement, Shape shape) {
		Action action = (Action) shape;
		String handlerBean = action.getHandlerBean();
		if (StringUtils.isNotEmpty(handlerBean)) {
			actionElement.addAttribute("handler-bean", handlerBean);
		}
	}

	public boolean support(Shape shape) {
		return shape instanceof Action ? true : false;
	}

}
