package com.bstek.uflo.designer.security.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "UFLO_D_NODE_ATTRIBUTE")
public class NodeAttribute implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@Column(name = "ID_", length = 36)
	private String id;

	@Column(name = "NAME_", length = 64)
	private String name;

	@Column(name = "LABEL_", length = 64)
	private String label;

	@Column(name = "AUTHORITY_TYPE_", length = 10)
	@Enumerated(EnumType.STRING)
	private AuthorityType authorityType = AuthorityType.Write;

	@Column(name = "NODE_ENTRY_ID_", length = 64, nullable = true)
	private String nodeEntryId;

	public NodeAttribute() {
		super();
	}

	public NodeAttribute(String id, String name, String label, AuthorityType authorityType) {
		super();
		this.id = id;
		this.name = name;
		this.label = label;
		this.authorityType = authorityType;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public AuthorityType getAuthorityType() {
		return authorityType;
	}

	public void setAuthorityType(AuthorityType authorityType) {
		this.authorityType = authorityType;
	}

	public String getNodeEntryId() {
		return nodeEntryId;
	}

	public void setNodeEntryId(String nodeEntryId) {
		this.nodeEntryId = nodeEntryId;
	}

}
