package com.bstek.uflo.designer.security.command;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.designer.security.model.NodeEntry;
import com.bstek.uflo.env.Context;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
public class UpdateNodeEntryCommand implements Command<NodeEntry> {
	
	private String nodeEntryId;
	private String nodeName;

	public UpdateNodeEntryCommand(String nodeEntryId, String nodeName) {
		this.nodeEntryId = nodeEntryId;
		this.nodeName = nodeName;
	}

	public NodeEntry execute(Context context) {
		String hql = " update " + NodeEntry.class.getName() + " n set n.name=:name where n.id=:id";
		context.getSession().createQuery(hql).setParameter("name", nodeName).setParameter("id", nodeEntryId).executeUpdate();
		return null;
	}

}
