package com.bstek.uflo.designer.model.node;

import java.util.ArrayList;
import java.util.List;

import com.bstek.dorado.annotation.PropertyDef;
import com.bstek.uflo.designer.model.CalendarInfo;
import com.bstek.uflo.designer.model.ComponentAuthority;
import com.bstek.uflo.designer.model.FormElement;
import com.bstek.uflo.designer.model.TaskAssignee;
import com.bstek.uflo.designer.model.UserData;
import com.bstek.uflo.designer.security.annotation.SecurityAttribute;

public class Task extends RectNode {

	@SecurityAttribute(label = "组件权限配置")
	private List<ComponentAuthority> componentAuthorities = new ArrayList<ComponentAuthority>();

	@PropertyDef(label = "任务名称")
	@SecurityAttribute
	private String taskName;

	@PropertyDef(label = "URL")
	@SecurityAttribute
	private String url;
	
	@PropertyDef(label = "监听Bean")
	@SecurityAttribute
	private String taskListenerBean;

	@PropertyDef(label = "任务类型")
	@SecurityAttribute(label = "任务类型配置")
	private String taskType = "Normal";

	@PropertyDef(label = "会签类型")
	private String counterSignType = "countersignNone";

	@PropertyDef(label = "完成任务数")
	private int countersignMultiplicity;

	@PropertyDef(label = "完成百分比")
	private int countersignPercentMultiplicity;

	@PropertyDef(label = "表达式")
	private String countersignExpression;

	@PropertyDef(label = "指定Bean")
	private String countersignHandler;

	@PropertyDef(label = "处理类型")
	@SecurityAttribute(label = "任务处理人配置")
	private String assignmentType = "ProcessPromoter";

	@PropertyDef(label = "指定泳道")
	private String swimlane;

	@PropertyDef(label = "EL表达式")
	private String expression;

	@PropertyDef(label = "指定Bean")
	private String assignmentHandlerBean;

	@PropertyDef(label = "指定参与者")
	private List<TaskAssignee> taskAssignees = new ArrayList<TaskAssignee>();

	@SecurityAttribute
	@PropertyDef(label = "允许上一节点为当前节点指定任务处理人")
	private boolean allowSpecifyAssignee;

	@PropertyDef(label = "启用任务过期功能")
	@SecurityAttribute(label = "任务过期配置")
	private boolean useDue;

	@PropertyDef(label = "过期天")
	private int dueDay = 0;

	@PropertyDef(label = "过期小时")
	private int dueDour = 0;

	@PropertyDef(label = "过期分钟")
	private int dueMinute = 0;

	private List<CalendarInfo> dueCalendarInfos = new ArrayList<CalendarInfo>();

	@PropertyDef(label = "提醒方式")
	@SecurityAttribute(label = "任务过期提醒配置")
	private String reminderType = "none";

	@PropertyDef(label = "提醒Bean")
	private String reminderHandlerBean;
	// none ,once ,period
	@PropertyDef(label = "提醒间隔")
	private int reminderRepeat = 0;

	@PropertyDef(label = "提醒间隔单位")
	private String reminderDateUnit;

	private List<CalendarInfo> reminderCalendarInfos = new ArrayList<CalendarInfo>();
	
	@PropertyDef(label = "启用任务过期动作")
	@SecurityAttribute(label = "任务过期动作配置")
	private boolean useDueAction;
	
	@PropertyDef(label = "动作Bean")
	private String dueActionHandlerBean; 
	
	@PropertyDef(label = "动作过期天")
	private int dueActionDay = 0;

	@PropertyDef(label = "动作过期小时")
	private int dueActionDour = 0;

	@PropertyDef(label = "动作过期分钟")
	private int dueActionMinute = 0;
	
	private List<CalendarInfo> dueActionCalendarInfos = new ArrayList<CalendarInfo>();

	@PropertyDef(label = "渲染表单模板")
	@SecurityAttribute
	private String formTemplate;

	@SecurityAttribute(label = "表单元素配置")
	private List<FormElement> formElements = new ArrayList<FormElement>();

	@SecurityAttribute(label = "自定义数据配置")
	private List<UserData> userData = new ArrayList<UserData>();

	public String getTaskName() {
		return taskName;
	}

	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getTaskListenerBean() {
		return taskListenerBean;
	}

	public void setTaskListenerBean(String taskListenerBean) {
		this.taskListenerBean = taskListenerBean;
	}

	public String getTaskType() {
		return taskType;
	}

	public void setTaskType(String taskType) {
		this.taskType = taskType;
	}

	public boolean isAllowSpecifyAssignee() {
		return allowSpecifyAssignee;
	}

	public void setAllowSpecifyAssignee(boolean allowSpecifyAssignee) {
		this.allowSpecifyAssignee = allowSpecifyAssignee;
	}

	public String getCounterSignType() {
		return counterSignType;
	}

	public void setCounterSignType(String counterSignType) {
		this.counterSignType = counterSignType;
	}

	public int getCountersignMultiplicity() {
		return countersignMultiplicity;
	}

	public void setCountersignMultiplicity(int countersignMultiplicity) {
		this.countersignMultiplicity = countersignMultiplicity;
	}

	public int getCountersignPercentMultiplicity() {
		return countersignPercentMultiplicity;
	}

	public void setCountersignPercentMultiplicity(int countersignPercentMultiplicity) {
		this.countersignPercentMultiplicity = countersignPercentMultiplicity;
	}

	public String getAssignmentType() {
		return assignmentType;
	}

	public void setAssignmentType(String assignmentType) {
		this.assignmentType = assignmentType;
	}

	public String getSwimlane() {
		return swimlane;
	}

	public void setSwimlane(String swimlane) {
		this.swimlane = swimlane;
	}

	public String getExpression() {
		return expression;
	}

	public void setExpression(String expression) {
		this.expression = expression;
	}

	public String getAssignmentHandlerBean() {
		return assignmentHandlerBean;
	}

	public void setAssignmentHandlerBean(String assignmentHandlerBean) {
		this.assignmentHandlerBean = assignmentHandlerBean;
	}

	public List<TaskAssignee> getTaskAssignees() {
		return taskAssignees;
	}

	public void setTaskAssignees(List<TaskAssignee> taskAssignees) {
		this.taskAssignees = taskAssignees;
	}

	public List<ComponentAuthority> getComponentAuthorities() {
		return componentAuthorities;
	}

	public void setComponentAuthorities(List<ComponentAuthority> componentAuthorities) {
		this.componentAuthorities = componentAuthorities;
	}

	public boolean isUseDue() {
		return useDue;
	}

	public void setUseDue(boolean useDue) {
		this.useDue = useDue;
	}

	public int getDueDay() {
		return dueDay;
	}

	public List<UserData> getUserData() {
		return userData;
	}

	public void setUserData(List<UserData> userData) {
		this.userData = userData;
	}

	public void setDueDay(int dueDay) {
		this.dueDay = dueDay;
	}

	public int getDueDour() {
		return dueDour;
	}

	public void setDueDour(int dueDour) {
		this.dueDour = dueDour;
	}

	public int getDueMinute() {
		return dueMinute;
	}

	public void setDueMinute(int dueMinute) {
		this.dueMinute = dueMinute;
	}

	public List<CalendarInfo> getDueCalendarInfos() {
		return dueCalendarInfos;
	}

	public void setDueCalendarInfos(List<CalendarInfo> dueCalendarInfos) {
		this.dueCalendarInfos = dueCalendarInfos;
	}

	public String getReminderHandlerBean() {
		return reminderHandlerBean;
	}

	public void setReminderHandlerBean(String reminderHandlerBean) {
		this.reminderHandlerBean = reminderHandlerBean;
	}

	public String getReminderType() {
		return reminderType;
	}

	public void setReminderType(String reminderType) {
		this.reminderType = reminderType;
	}

	public int getReminderRepeat() {
		return reminderRepeat;
	}

	public void setReminderRepeat(int reminderRepeat) {
		this.reminderRepeat = reminderRepeat;
	}

	public String getReminderDateUnit() {
		return reminderDateUnit;
	}

	public void setReminderDateUnit(String reminderDateUnit) {
		this.reminderDateUnit = reminderDateUnit;
	}

	public List<CalendarInfo> getReminderCalendarInfos() {
		return reminderCalendarInfos;
	}

	public void setReminderCalendarInfos(List<CalendarInfo> reminderCalendarInfos) {
		this.reminderCalendarInfos = reminderCalendarInfos;
	}

	public boolean isUseDueAction() {
		return useDueAction;
	}

	public String getDueActionHandlerBean() {
		return dueActionHandlerBean;
	}

	public int getDueActionDay() {
		return dueActionDay;
	}

	public int getDueActionDour() {
		return dueActionDour;
	}

	public int getDueActionMinute() {
		return dueActionMinute;
	}

	public List<CalendarInfo> getDueActionCalendarInfos() {
		return dueActionCalendarInfos;
	}

	public void setUseDueAction(boolean useDueAction) {
		this.useDueAction = useDueAction;
	}

	public void setDueActionHandlerBean(String dueActionHandlerBean) {
		this.dueActionHandlerBean = dueActionHandlerBean;
	}

	public void setDueActionDay(int dueActionDay) {
		this.dueActionDay = dueActionDay;
	}

	public void setDueActionDour(int dueActionDour) {
		this.dueActionDour = dueActionDour;
	}

	public void setDueActionMinute(int dueActionMinute) {
		this.dueActionMinute = dueActionMinute;
	}

	public void setDueActionCalendarInfos(List<CalendarInfo> dueActionCalendarInfos) {
		this.dueActionCalendarInfos = dueActionCalendarInfos;
	}

	public String getFormTemplate() {
		return formTemplate;
	}

	public void setFormTemplate(String formTemplate) {
		this.formTemplate = formTemplate;
	}

	public List<FormElement> getFormElements() {
		return formElements;
	}

	public void setFormElements(List<FormElement> formElements) {
		this.formElements = formElements;
	}

	public String getCountersignExpression() {
		return countersignExpression;
	}

	public void setCountersignExpression(String countersignExpression) {
		this.countersignExpression = countersignExpression;
	}

	public String getCountersignHandler() {
		return countersignHandler;
	}

	public void setCountersignHandler(String countersignHandler) {
		this.countersignHandler = countersignHandler;
	}

}
