package com.bstek.uflo.designer.model.node;

import java.util.ArrayList;
import java.util.List;

import com.bstek.dorado.annotation.PropertyDef;
import com.bstek.uflo.designer.model.ComponentAuthority;
import com.bstek.uflo.designer.model.FormElement;
import com.bstek.uflo.designer.security.annotation.SecurityAttribute;

public class Start extends ImageNode {
	
	@SecurityAttribute(label = "组件权限配置")
	private List<ComponentAuthority> componentAuthorities = new ArrayList<ComponentAuthority>();

	@PropertyDef(label = "任务名称")
	@SecurityAttribute
	private String taskName;

	@PropertyDef(label = "URL")
	@SecurityAttribute
	private String url;

	@PropertyDef(label = "渲染表单模板")
	@SecurityAttribute
	private String formTemplate;

	@SecurityAttribute(label = "表单元素配置")
	private List<FormElement> formElements = new ArrayList<FormElement>();

	public String getTaskName() {
		return taskName;
	}

	public void setTaskName(String taskName) {
		this.taskName = taskName;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getFormTemplate() {
		return formTemplate;
	}

	public void setFormTemplate(String formTemplate) {
		this.formTemplate = formTemplate;
	}

	public List<FormElement> getFormElements() {
		return formElements;
	}

	public void setFormElements(List<FormElement> formElements) {
		this.formElements = formElements;
	}

	public List<ComponentAuthority> getComponentAuthorities() {
		return componentAuthorities;
	}

	public void setComponentAuthorities(List<ComponentAuthority> componentAuthorities) {
		this.componentAuthorities = componentAuthorities;
	}
}
