package com.bstek.uflo.designer.model.edge;

import java.util.ArrayList;
import java.util.List;

import com.bstek.uflo.designer.model.Point;
import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.node.Node;

public class Edge extends Shape {

	private Node fromNode;

	private String fromNodeId;
	
	private String fromNodeName;

	private Node toNode;

	private String toNodeId;
	
	private String toNodeName;

	private List<Point> vertices = new ArrayList<Point>();

	public Node getFromNode() {
		return fromNode;
	}

	public void setFromNode(Node fromNode) {
		this.fromNode = fromNode;
	}

	public String getFromNodeId() {
		return fromNodeId;
	}

	public void setFromNodeId(String fromNodeId) {
		this.fromNodeId = fromNodeId;
	}

	public String getFromNodeName() {
		return fromNodeName;
	}

	public void setFromNodeName(String fromNodeName) {
		this.fromNodeName = fromNodeName;
	}

	public Node getToNode() {
		return toNode;
	}

	public void setToNode(Node toNode) {
		this.toNode = toNode;
	}

	public String getToNodeId() {
		return toNodeId;
	}

	public void setToNodeId(String toNodeId) {
		this.toNodeId = toNodeId;
	}

	public String getToNodeName() {
		return toNodeName;
	}

	public void setToNodeName(String toNodeName) {
		this.toNodeName = toNodeName;
	}

	public List<Point> getVertices() {
		return vertices;
	}

	public void setVertices(List<Point> vertices) {
		this.vertices = vertices;
	}

	public String getShapeId() {
		return "bpm.Connection";
	}

	public String getShapeType() {
		return "EDGE";
	}

	public String getEdgeStyle() {
		String connectionStyle = "{\"stroke\":\"#7384BB\",\"fill\":\"#00FF00\",\"fill-opacity\":0,\"label-position\":\"center\",\"stroke-width\":1.5,\"stroke-opacity\":1,\"edge-type\":\"straight\",\"edge-direction\":\"c c\",\"arrow-start\":\"none\",\"arrow-end\":\"classic-wide-long\",\"stroke-dasharray\":\"\",\"cursor\":\"move\"}";
		return connectionStyle;
	}

	public String getEdgeValue(Node fromNode, Node toNode) {
		int fromX = fromNode.getRectangle().getPoint().getX();
		int fromY = fromNode.getRectangle().getPoint().getY();
		int toX = toNode.getRectangle().getPoint().getX();
		int toY = toNode.getRectangle().getPoint().getY();
		return "[" + fromX + "," + fromY + "],[" + toX + "," + toY + "]";
	}

	public String getEdgeGeomValue(Node fromNode, Node toNode) {
		int fromX = fromNode.getRectangle().getPoint().getX();
		int fromY = fromNode.getRectangle().getPoint().getY();
		int toX = toNode.getRectangle().getPoint().getX();
		int toY = toNode.getRectangle().getPoint().getY();
		List<String> vertices = new ArrayList<String>();
		vertices.add("[" + fromX + "," + fromY + "]");
		for (Point point : this.getVertices()) {
			vertices.add("[" + point.getX() + "," + point.getY() + "]");
		}
		vertices.add("[" + toX + "," + toY + "]");
		String verticesValue = org.apache.commons.lang.StringUtils.join(vertices, ",");
		String geom = "{type:'PolyLine',vertices:[" + verticesValue + "]}";
		return geom;
	}

	public String getEdgeFromValue() {
		return this.getFromNodeId() + "_TERMINAL_C_INOUT_0";
	}

	public String getEdgeToValue() {
		return this.getToNodeId() + "_TERMINAL_C_INOUT_0";
	}

	public void cleanUselessValue() {
		this.fromNode = null;
		this.fromNodeId = null;
		this.fromNodeName = null;

		this.toNode = null;
		this.toNodeId = null;
		this.toNodeName = null;
		
		setNodeEntryId(null);
		
		this.getVertices().clear();
	}

}
