package com.bstek.uflo.designer.deserializer.impl;

import org.dom4j.Element;
import org.springframework.stereotype.Service;
import org.apache.commons.lang.StringUtils;

import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.node.End;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
@Service
public class EndDeserializer extends NodeDeserializer {

	public Shape execute(Element currentElement) throws Exception {
		End end = new End();
		super.deserializeCommonAttribute(end, currentElement);
		String isTerminate = currentElement.attributeValue("terminate");
		if (StringUtils.isNotEmpty(isTerminate)) {
			end.setTerminate(Boolean.valueOf(isTerminate));
		}
		return end;
	}

	public boolean support(String name) {
		return name.equals("end") ? true : false;
	}

}
