package com.bstek.uflo.designer.deserializer.impl;

import org.dom4j.Element;
import org.springframework.stereotype.Service;

import com.bstek.uflo.designer.model.Shape;
import com.bstek.uflo.designer.model.node.Action;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
@Service
public class ActionDeserializer extends NodeDeserializer {

	public Shape execute(Element currentElement) throws Exception {
		Action action = new Action();
		super.deserializeCommonAttribute(action, currentElement);
		String handlerBean = currentElement.attributeValue("handler-bean");
		action.setHandlerBean(handlerBean);
		return action;

	}

	public boolean support(String name) {
		return name.equals("action") ? true : false;
	}

}
