package com.bstek.uflo.designer.command;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.Blob;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
public class QueryProcessBlobCommand implements Command<Blob> {
	private long processId;

	public QueryProcessBlobCommand(long processId) {
		this.processId = processId;
	}

	public Blob execute(Context context) {
		String hql = "from " + Blob.class.getName() + " where processId=:processId";
		return (Blob) context.getSession().createQuery(hql).setLong("processId", processId).uniqueResult();
	}

}
