package com.bstek.uflo.designer.command;

import java.util.List;

import org.hibernate.criterion.DetachedCriteria;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;

/**
 * @author matt.yao@bstek.com
 * @since 1.0
 */
public class QueryListCommand implements Command<List<?>> {

	private DetachedCriteria detachedCriteria;

	public QueryListCommand(DetachedCriteria detachedCriteria) {
		this.detachedCriteria = detachedCriteria;
	}

	public List<?> execute(Context context) {
		return detachedCriteria.getExecutableCriteria(context.getSession()).list();
	}

}
