/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.bdf3.security.ui.service;

import com.bstek.bdf3.dorado.jpa.JpaUtil;
import com.bstek.bdf3.dorado.jpa.lin.Linq;
import com.bstek.bdf3.dorado.jpa.policy.SaveContext;
import com.bstek.bdf3.dorado.jpa.policy.SavePolicy;
import com.bstek.bdf3.dorado.jpa.policy.impl.SmartSavePolicyAdapter;
import com.bstek.bdf3.security.orm.RoleGrantedAuthority;
import com.bstek.bdf3.security.orm.User;
import com.bstek.bdf3.security.ui.service.UserService;
import com.bstek.dorado.data.provider.Criteria;
import com.bstek.dorado.data.provider.Page;
import java.io.Serializable;
import java.util.List;
import org.malagu.linq.lin.Lind;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ui.userService")
@Transactional(readOnly=true)
public class UserServiceImpl
implements UserService {
    @Autowired
    protected PasswordEncoder passwordEncoder;

    @Override
    public void load(Page<User> page, Criteria criteria) {
        JpaUtil.linq(User.class).where(criteria).paging(page);
    }

    @Override
    public String validateOldPassword(String oldPassword) {
        UserDetails user;
        String password;
        if (oldPassword != null && this.passwordEncoder.matches((CharSequence)oldPassword, password = ((User)JpaUtil.getOne(User.class, (Serializable)((Object)(user = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername()))).getPassword())) {
            return null;
        }
        return "\u539f\u6765\u5bc6\u7801\u8f93\u5165\u4e0d\u6b63\u786e\u3002";
    }

    @Override
    @Transactional
    public void save(List<User> users) {
        JpaUtil.save(users, (SavePolicy)new SmartSavePolicyAdapter(){

            public boolean beforeInsert(SaveContext context) {
                User user = (User)context.getEntity();
                user.setPassword(UserServiceImpl.this.passwordEncoder.encode((CharSequence)user.getPassword()));
                return true;
            }

            public boolean beforeDelete(SaveContext context) {
                User user = (User)context.getEntity();
                ((Lind)JpaUtil.lind(RoleGrantedAuthority.class).equal("actorId", (Object)user.getUsername())).delete();
                return true;
            }
        });
    }

    @Override
    @Transactional
    public void changePassword(String username, String newPassword) {
        User u = (User)JpaUtil.getOne(User.class, (Serializable)((Object)username));
        u.setPassword(this.passwordEncoder.encode((CharSequence)newPassword));
    }

    @Override
    public boolean isExist(String username) {
        return ((Linq)JpaUtil.linq(User.class).equal("username", (Object)username)).exists();
    }

    @Override
    @Transactional
    public void save(User user) {
        user.setPassword(this.passwordEncoder.encode((CharSequence)user.getPassword()));
        JpaUtil.persistAndFlush((Object)user);
    }
}

