/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.bdf3.security.ui.service;

import com.bstek.bdf3.dorado.jpa.JpaUtil;
import com.bstek.bdf3.dorado.jpa.policy.SaveContext;
import com.bstek.bdf3.dorado.jpa.policy.SavePolicy;
import com.bstek.bdf3.dorado.jpa.policy.impl.SmartSavePolicyAdapter;
import com.bstek.bdf3.security.cache.SecurityCacheEvict;
import com.bstek.bdf3.security.orm.Permission;
import com.bstek.bdf3.security.orm.Url;
import com.bstek.bdf3.security.ui.service.UrlService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.malagu.linq.lin.Lind;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="ui.urlService")
@Transactional(readOnly=true)
public class UrlServiceImpl
implements UrlService {
    @Override
    public List<Url> load() {
        ArrayList<Url> result = new ArrayList<Url>();
        HashMap childrenMap = new HashMap();
        List urls = JpaUtil.linq(Url.class).asc(new String[]{"order"}).list();
        for (Url url : urls) {
            List<Url> children;
            if (childrenMap.containsKey(url.getId())) {
                url.setChildren((List)childrenMap.get(url.getId()));
            } else {
                url.setChildren(new ArrayList());
                childrenMap.put(url.getId(), url.getChildren());
            }
            if (url.getParentId() == null) {
                result.add(url);
                continue;
            }
            if (childrenMap.containsKey(url.getParentId())) {
                children = (List)childrenMap.get(url.getParentId());
            } else {
                children = new ArrayList();
                childrenMap.put(url.getParentId(), children);
            }
            children.add(url);
        }
        return result;
    }

    @Override
    @SecurityCacheEvict
    @Transactional
    public void save(List<Url> urls) {
        JpaUtil.save(urls, (SavePolicy)new SmartSavePolicyAdapter(){

            public boolean beforeDelete(SaveContext context) {
                Url url = (Url)context.getEntity();
                ((Lind)((Lind)JpaUtil.lind(Permission.class).equal("resourceId", (Object)url.getId())).equal("resourceType", (Object)"URL")).delete();
                return true;
            }

            public void apply(SaveContext context) {
                Url parent;
                Url url = (Url)context.getEntity();
                if (url.getParentId() == null && (parent = (Url)context.getParent()) != null) {
                    url.setParentId(parent.getId());
                }
                super.apply(context);
            }
        });
    }
}

