/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.bdf3.security.ui.service;

import com.bstek.bdf3.dorado.jpa.JpaUtil;
import com.bstek.bdf3.dorado.jpa.policy.SaveContext;
import com.bstek.bdf3.dorado.jpa.policy.SavePolicy;
import com.bstek.bdf3.dorado.jpa.policy.impl.SmartSavePolicyAdapter;
import com.bstek.bdf3.security.cache.SecurityCacheEvict;
import com.bstek.bdf3.security.orm.Permission;
import com.bstek.bdf3.security.orm.Role;
import com.bstek.bdf3.security.orm.RoleGrantedAuthority;
import com.bstek.bdf3.security.ui.service.RoleService;
import com.bstek.dorado.data.provider.Criteria;
import com.bstek.dorado.data.provider.Page;
import java.util.List;
import org.malagu.linq.lin.Lind;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RoleServiceImpl
implements RoleService {
    private SavePolicy roleSavePolicy = new RoleSavePolicy();

    @Override
    public void load(Page<Role> page, Criteria criteria) {
        JpaUtil.linq(Role.class).where(criteria).paging(page);
    }

    @Override
    @SecurityCacheEvict
    @Transactional
    public void save(List<Role> roles) {
        JpaUtil.save(roles, (SavePolicy)this.roleSavePolicy);
    }

    class RoleSavePolicy
    extends SmartSavePolicyAdapter {
        RoleSavePolicy() {
        }

        public boolean beforeDelete(SaveContext context) {
            if (context.getEntity() instanceof Role) {
                Role role = (Role)context.getEntity();
                ((Lind)JpaUtil.lind(Permission.class).equal("roleId", (Object)role.getId())).delete();
                ((Lind)JpaUtil.lind(RoleGrantedAuthority.class).equal("roleId", (Object)role.getId())).delete();
            }
            return true;
        }
    }
}

