/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.bdf3.security.ui.service;

import com.bstek.bdf3.dorado.jpa.JpaUtil;
import com.bstek.bdf3.dorado.jpa.lin.Linq;
import com.bstek.bdf3.security.orm.Component;
import com.bstek.bdf3.security.orm.Permission;
import com.bstek.bdf3.security.orm.Role;
import com.bstek.bdf3.security.orm.RoleGrantedAuthority;
import com.bstek.bdf3.security.orm.Url;
import com.bstek.bdf3.security.orm.User;
import com.bstek.bdf3.security.service.UrlService;
import com.bstek.bdf3.security.ui.service.PersonalCenterService;
import com.bstek.dorado.data.entity.EntityState;
import com.bstek.dorado.data.entity.EntityUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PersonalCenterServiceImpl
implements PersonalCenterService {
    @Autowired
    private UrlService urlService;

    @Override
    public User getUser(String username) {
        User user = (User)JpaUtil.getOne(User.class, (Serializable)((Object)username));
        JpaUtil.getEntityManager().detach((Object)user);
        user.setPassword(null);
        try {
            user = (User)EntityUtils.toEntity((Object)user);
            EntityUtils.setValue((Object)user, (String)"roles", this.getRoles(username));
            EntityUtils.setValue((Object)user, (String)"urls", this.getUrls(username));
            EntityUtils.setValue((Object)user, (String)"permissions", this.getPermissions(username));
            EntityUtils.setState((Object)user, (EntityState)EntityState.NONE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return user;
    }

    @Override
    public List<Role> getRoles(String username) {
        return ((Linq)((Linq)((Linq)((Linq)JpaUtil.linq(Role.class).exists(RoleGrantedAuthority.class)).equalProperty("roleId", "id")).equal("actorId", (Object)username)).end()).list();
    }

    @Override
    public List<Url> getUrls(String username) {
        return this.urlService.getAccessibleUrlsByUsername(username);
    }

    @Override
    public List<Permission> getPermissions(String username) {
        Set components;
        List permissions = ((Linq)((Linq)((Linq)((Linq)((Linq)JpaUtil.linq(Permission.class).toEntity().collect(Role.class, new String[]{"roleId"}).collect(Component.class, new String[]{"resourceId"}).equal("resourceType", (Object)"COMPONENT")).exists(RoleGrantedAuthority.class)).equalProperty("roleId", "roleId")).equal("actorId", (Object)username)).end()).list();
        if (!permissions.isEmpty() && !(components = JpaUtil.collect((Collection)permissions, (String)"component")).isEmpty()) {
            List urls = ((Linq)JpaUtil.linq(Url.class).in("id", JpaUtil.collect((Collection)components, (String)"urlId"))).list();
            Map componentMap = JpaUtil.index((Collection)components);
            Map urlMap = JpaUtil.index((Collection)urls);
            for (Permission p : permissions) {
                Url url = (Url)urlMap.get(((Component)componentMap.get(p.getResourceId())).getUrlId());
                EntityUtils.setValue((Object)p, (String)"url", (Object)url);
            }
        }
        return permissions;
    }
}

