/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.bdf3.security.ui.service;

import com.bstek.bdf3.dorado.jpa.JpaUtil;
import com.bstek.bdf3.dorado.jpa.lin.Linq;
import com.bstek.bdf3.security.cache.SecurityCacheEvict;
import com.bstek.bdf3.security.orm.Component;
import com.bstek.bdf3.security.orm.Permission;
import com.bstek.bdf3.security.ui.builder.ViewBuilder;
import com.bstek.bdf3.security.ui.builder.ViewComponent;
import com.bstek.bdf3.security.ui.service.PermissionService;
import com.bstek.dorado.data.entity.EntityState;
import com.bstek.dorado.data.entity.EntityUtils;
import com.bstek.dorado.view.View;
import com.bstek.dorado.view.ViewState;
import com.bstek.dorado.view.manager.ViewConfig;
import com.bstek.dorado.view.manager.ViewConfigManager;
import com.bstek.dorado.web.DoradoContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PermissionServiceImpl
implements PermissionService {
    @Autowired
    private ViewConfigManager viewConfigManager;
    @Autowired
    private ViewBuilder viewBuilder;

    @Override
    public Collection<ViewComponent> loadComponents(String viewName) {
        if (StringUtils.isEmpty((String)viewName)) {
            return Collections.EMPTY_LIST;
        }
        viewName = StringUtils.substringBeforeLast((String)viewName, (String)".d");
        String VIEWSTATE_KEY = ViewState.class.getName();
        DoradoContext context = DoradoContext.getCurrent();
        context.setAttribute(VIEWSTATE_KEY, (Object)ViewState.rendering);
        try {
            ViewComponent root = new ViewComponent();
            ViewConfig viewConfig = (ViewConfig)context.getAttribute(viewName);
            if (viewConfig == null) {
                viewConfig = this.viewConfigManager.getViewConfig(viewName);
                context.setAttribute(viewName, (Object)viewConfig);
            }
            if (viewConfig != null && viewConfig.getView() != null && this.viewBuilder.support(viewConfig.getView())) {
                View view = viewConfig.getView();
                this.viewBuilder.build(view, root, root);
            }
            Collection<ViewComponent> collection = root.getChildren();
            return collection;
        }
        catch (Exception e) {
            List<ViewComponent> list = Collections.emptyList();
            return list;
        }
        finally {
            context.setAttribute(VIEWSTATE_KEY, (Object)ViewState.servcing);
        }
    }

    @Override
    public List<Permission> loadPermissions(String roleId, String urlId) {
        return ((Linq)((Linq)((Linq)((Linq)((Linq)JpaUtil.linq(Permission.class).toEntity().collect(Component.class, new String[]{"resourceId"}).equal("roleId", (Object)roleId)).equal("resourceType", (Object)"COMPONENT")).exists(Component.class)).equalProperty("id", "resourceId")).equal("urlId", (Object)urlId)).list();
    }

    @Override
    @SecurityCacheEvict
    @Transactional
    public void save(Permission permission) {
        Component component = (Component)EntityUtils.getValue((Object)permission, (String)"component");
        if (permission.getResourceId() == null) {
            component.setId(UUID.randomUUID().toString());
            permission.setResourceId(component.getId());
            JpaUtil.persist((Object)component);
        } else {
            JpaUtil.save((Object)component);
        }
        if (EntityState.NONE.equals((Object)EntityUtils.getState((Object)component)) && EntityState.NONE.equals((Object)EntityUtils.getState((Object)permission))) {
            JpaUtil.remove((Object)((Component)JpaUtil.merge((Object)component)));
            JpaUtil.remove((Object)((Permission)JpaUtil.merge((Object)permission)));
        } else {
            JpaUtil.save((Object)permission);
        }
    }
}

