/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.bdf3.security.ui.filter;

import com.bstek.bdf3.security.orm.Component;
import com.bstek.bdf3.security.orm.ComponentType;
import com.bstek.bdf3.security.orm.Resource;
import com.bstek.bdf3.security.ui.filter.AbstractFilter;
import com.bstek.bdf3.security.ui.utils.ControlUtils;
import com.bstek.bdf3.security.ui.utils.UrlUtils;
import com.bstek.dorado.common.MetaDataSupport;
import com.bstek.dorado.view.AbstractViewElement;
import com.bstek.dorado.view.widget.base.menu.BaseMenuItem;
import com.bstek.dorado.view.widget.base.menu.TextMenuItem;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

@org.springframework.stereotype.Component
public class MenuTextFilter
extends AbstractFilter<TextMenuItem> {
    @Override
    public void invoke(TextMenuItem menuItem) {
        if (ControlUtils.isNoSecurtiy((MetaDataSupport)menuItem)) {
            return;
        }
        if (ControlUtils.supportControlType((AbstractViewElement)menuItem)) {
            String path = UrlUtils.getRequestPath();
            String componentId = this.getId(menuItem);
            if (componentId != null) {
                Component component = new Component();
                component.setComponentId(componentId);
                component.setPath(path);
                component.setComponentType(ComponentType.ReadWrite);
                if (!this.securityDecisionManager.decide((Resource)component)) {
                    component.setComponentType(ComponentType.Read);
                    if (!this.securityDecisionManager.decide((Resource)component)) {
                        menuItem.setIgnored(true);
                        return;
                    }
                    menuItem.setDisabled(true);
                }
            }
        }
        this.filterChildren(menuItem);
    }

    @Override
    protected Collection<BaseMenuItem> getChildren(TextMenuItem menuItem) {
        return menuItem.getItems();
    }

    @Override
    protected String getId(TextMenuItem menuItem) {
        String id = menuItem.getName();
        if (StringUtils.isEmpty((String)id)) {
            id = menuItem.getCaption();
        }
        return id;
    }

    @Override
    public boolean support(Object control) {
        return TextMenuItem.class.isAssignableFrom(control.getClass());
    }
}

