/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.bdf3.security.ui.filter;

import com.bstek.bdf3.security.orm.Component;
import com.bstek.bdf3.security.orm.ComponentType;
import com.bstek.bdf3.security.orm.Resource;
import com.bstek.bdf3.security.ui.filter.AbstractFilter;
import com.bstek.bdf3.security.ui.utils.ControlUtils;
import com.bstek.bdf3.security.ui.utils.UrlUtils;
import com.bstek.dorado.common.MetaDataSupport;
import com.bstek.dorado.data.type.EntityDataType;
import com.bstek.dorado.data.type.property.PropertyDef;
import com.bstek.dorado.view.AbstractViewElement;
import com.bstek.dorado.view.ViewElement;
import com.bstek.dorado.view.widget.Control;
import com.bstek.dorado.view.widget.form.FormElement;
import com.bstek.dorado.view.widget.form.autoform.AutoForm;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@org.springframework.stereotype.Component
public class FormElementFilter
extends AbstractFilter<FormElement> {
    @Override
    public void invoke(FormElement element) {
        if (ControlUtils.isNoSecurtiy((MetaDataSupport)element)) {
            return;
        }
        if (ControlUtils.supportControlType((AbstractViewElement)element)) {
            String path = UrlUtils.getRequestPath();
            String componentId = this.getId(element);
            if (componentId != null) {
                Component component = new Component();
                component.setComponentId(componentId);
                component.setPath(path);
                component.setComponentType(ComponentType.ReadWrite);
                if (!this.securityDecisionManager.decide((Resource)component)) {
                    component.setComponentType(ComponentType.Read);
                    if (!this.securityDecisionManager.decide((Resource)component)) {
                        element.setIgnored(true);
                        return;
                    }
                    element.setReadOnly(true);
                }
            }
        }
        this.filterChildren(element);
    }

    @Override
    protected Collection<Control> getChildren(FormElement element) {
        if (element.getEditor() != null) {
            return Arrays.asList(element.getEditor());
        }
        return null;
    }

    @Override
    protected String getId(FormElement element) {
        ViewElement viewElement;
        String id = element.getId();
        if (StringUtils.isEmpty((String)id)) {
            id = element.getProperty();
        }
        if (StringUtils.isEmpty((String)id)) {
            id = element.getLabel();
        }
        if (StringUtils.isEmpty((String)id) && (viewElement = element.getParent()) instanceof AutoForm) {
            EntityDataType entityDataType = ((AutoForm)viewElement).getDataType();
            Map dataTypePropertyDefs = null;
            if (entityDataType != null) {
                dataTypePropertyDefs = entityDataType.getPropertyDefs();
            }
            id = this.getFormElementLabel(element, dataTypePropertyDefs);
        }
        return id;
    }

    private String getFormElementLabel(FormElement element, Map<String, PropertyDef> dataTypePropertyDefs) {
        PropertyDef pd;
        String property = element.getProperty();
        if (StringUtils.isNotEmpty((String)property) && dataTypePropertyDefs != null && (pd = dataTypePropertyDefs.get(property)) != null && StringUtils.isNotEmpty((String)pd.getLabel())) {
            return pd.getLabel();
        }
        return property;
    }

    @Override
    public boolean support(Object control) {
        return FormElement.class.isAssignableFrom(control.getClass());
    }
}

