/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.bdf3.security.ui.filter;

import com.bstek.bdf3.security.orm.Component;
import com.bstek.bdf3.security.orm.ComponentType;
import com.bstek.bdf3.security.orm.Resource;
import com.bstek.bdf3.security.ui.filter.AbstractFilter;
import com.bstek.bdf3.security.ui.utils.ControlUtils;
import com.bstek.bdf3.security.ui.utils.UrlUtils;
import com.bstek.dorado.common.MetaDataSupport;
import com.bstek.dorado.view.AbstractViewElement;
import com.bstek.dorado.view.widget.grid.Column;
import com.bstek.dorado.view.widget.grid.ColumnGroup;
import com.bstek.dorado.view.widget.grid.DataColumn;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

@org.springframework.stereotype.Component
public class ColumnFilter
extends AbstractFilter<Column> {
    @Override
    public void invoke(Column column) {
        if (ControlUtils.isNoSecurtiy((MetaDataSupport)column)) {
            return;
        }
        if (ControlUtils.supportControlType((AbstractViewElement)column)) {
            String path = UrlUtils.getRequestPath();
            String componentId = this.getId(column);
            if (componentId != null) {
                Component component = new Component();
                component.setComponentId(componentId);
                component.setPath(path);
                component.setComponentType(ComponentType.ReadWrite);
                if (column instanceof DataColumn) {
                    if (!this.securityDecisionManager.decide((Resource)component)) {
                        component.setComponentType(ComponentType.Read);
                        if (!this.securityDecisionManager.decide((Resource)component)) {
                            column.setIgnored(true);
                            return;
                        }
                        ((DataColumn)column).setReadOnly(true);
                    }
                } else {
                    component.setComponentType(ComponentType.Read);
                    if (!this.securityDecisionManager.decide((Resource)component)) {
                        column.setIgnored(true);
                        return;
                    }
                }
            }
        }
        this.filterChildren(column);
    }

    @Override
    protected String getId(Column column) {
        String id = column.getName();
        if (StringUtils.isEmpty((String)id)) {
            id = column.getCaption();
        }
        return id;
    }

    @Override
    protected Collection<Column> getChildren(Column column) {
        if (column instanceof ColumnGroup) {
            return ((ColumnGroup)column).getColumns();
        }
        return null;
    }

    @Override
    public boolean support(Object control) {
        return Column.class.isAssignableFrom(control.getClass());
    }
}

