/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.bdf3.security.ui.filter;

import com.bstek.bdf3.security.orm.Component;
import com.bstek.bdf3.security.orm.ComponentType;
import com.bstek.bdf3.security.orm.Resource;
import com.bstek.bdf3.security.ui.filter.AbstractFilter;
import com.bstek.bdf3.security.ui.utils.ControlUtils;
import com.bstek.bdf3.security.ui.utils.UrlUtils;
import com.bstek.dorado.common.MetaDataSupport;
import com.bstek.dorado.view.AbstractViewElement;
import com.bstek.dorado.view.widget.base.Button;
import com.bstek.dorado.view.widget.base.menu.BaseMenuItem;
import com.bstek.dorado.view.widget.base.toolbar.MenuButton;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;

@org.springframework.stereotype.Component
public class ButtonFilter
extends AbstractFilter<Button> {
    @Override
    public void invoke(Button button) {
        if (ControlUtils.isNoSecurtiy((MetaDataSupport)button)) {
            return;
        }
        if (ControlUtils.supportControlType((AbstractViewElement)button)) {
            String path = UrlUtils.getRequestPath();
            String componentId = this.getId(button);
            if (componentId != null) {
                Component component = new Component();
                component.setComponentId(componentId);
                component.setPath(path);
                component.setComponentType(ComponentType.ReadWrite);
                if (!this.securityDecisionManager.decide((Resource)component)) {
                    component.setComponentType(ComponentType.Read);
                    if (!this.securityDecisionManager.decide((Resource)component)) {
                        button.setIgnored(true);
                        return;
                    }
                    button.setDisabled(true);
                }
            }
        }
        this.filterChildren(button);
    }

    @Override
    protected Collection<BaseMenuItem> getChildren(Button button) {
        if (MenuButton.class.isAssignableFrom(button.getClass())) {
            return ((MenuButton)button).getItems();
        }
        return Collections.emptyList();
    }

    @Override
    protected String getId(Button button) {
        String id = button.getId();
        if (StringUtils.isEmpty((String)id)) {
            id = button.getCaption();
        }
        return id;
    }

    @Override
    public boolean support(Object control) {
        return Button.class.isAssignableFrom(control.getClass());
    }
}

