/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.bdf3.security.ui.filter;

import com.bstek.bdf3.security.decision.manager.SecurityDecisionManager;
import com.bstek.bdf3.security.orm.Component;
import com.bstek.bdf3.security.orm.ComponentType;
import com.bstek.bdf3.security.orm.Resource;
import com.bstek.bdf3.security.ui.filter.DefaultFilter;
import com.bstek.bdf3.security.ui.filter.Filter;
import com.bstek.bdf3.security.ui.utils.ControlUtils;
import com.bstek.bdf3.security.ui.utils.UrlUtils;
import com.bstek.dorado.view.AbstractViewElement;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractFilter<T extends AbstractViewElement>
implements Filter<T> {
    @Autowired
    protected Collection<Filter> filters;
    @Autowired
    private DefaultFilter defaultFilter;
    @Autowired
    protected SecurityDecisionManager securityDecisionManager;

    @Override
    public void invoke(T control) {
        if (ControlUtils.isNoSecurtiy(control)) {
            return;
        }
        if (ControlUtils.supportControlType(control)) {
            String path = UrlUtils.getRequestPath();
            String componentId = this.getId(control);
            if (componentId != null) {
                Component component = new Component();
                component.setComponentId(componentId);
                component.setPath(path);
                component.setComponentType(ComponentType.Read);
                if (!this.securityDecisionManager.decide((Resource)component)) {
                    control.setIgnored(true);
                    return;
                }
            }
        }
        this.filterChildren(control);
    }

    protected void filterChildren(T control) {
        Collection children = this.getChildren(control);
        if (children != null) {
            for (Object child : children) {
                if (!(child instanceof AbstractViewElement)) continue;
                boolean exist = false;
                AbstractViewElement c = (AbstractViewElement)child;
                for (Filter filter : this.filters) {
                    if (!filter.support(c)) continue;
                    exist = true;
                    filter.invoke(c);
                    break;
                }
                if (exist) continue;
                this.defaultFilter.invoke(c);
            }
        }
    }

    protected String getId(T control) {
        return control.getId();
    }

    protected Collection getChildren(T control) {
        return Collections.EMPTY_LIST;
    }
}

