/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.bdf3.security.ui.configure;

import com.bstek.bdf3.security.WebSecurityConfigurer;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@Order(value=120)
public class DoradoWebSecurityConfigurer
extends WebSecurityConfigurer {
    private static final String URL_PREFIX = "/";
    @Value(value="${bdf3.loginPath}")
    private String loginPath;
    @Value(value="${bdf3.logoutPath}")
    private String logoutPath;
    @Value(value="${bdf3.systemAnonymous}")
    private String systemAnonymous;
    @Value(value="${bdf3.customAnonymous}")
    private String customAnonymous;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(this.mergeAnonymous())).permitAll().anyRequest()).authenticated().and()).formLogin().successHandler((AuthenticationSuccessHandler)new CustomAuthenticationSuccessHandler())).loginPage(URL_PREFIX + this.loginPath).permitAll()).and()).logout().logoutUrl(URL_PREFIX + this.logoutPath).permitAll().and()).rememberMe();
        super.configure(http);
    }

    private String[] mergeAnonymous() {
        String[] anonymous = null;
        if (StringUtils.hasText((String)this.systemAnonymous) && StringUtils.hasText((String)this.customAnonymous)) {
            anonymous = (String.valueOf(this.systemAnonymous) + "," + this.customAnonymous).split(",");
        } else if (StringUtils.hasText((String)this.systemAnonymous)) {
            anonymous = this.systemAnonymous.split(",");
        } else if (StringUtils.hasText((String)this.customAnonymous)) {
            anonymous = this.customAnonymous.split(",");
        }
        return anonymous;
    }

    class CustomAuthenticationSuccessHandler
    extends SavedRequestAwareAuthenticationSuccessHandler {
        private RequestCache requestCache = new HttpSessionRequestCache();

        public CustomAuthenticationSuccessHandler() {
            this.setRequestCache(this.requestCache);
        }

        public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
            SavedRequest savedRequest = this.requestCache.getRequest(request, response);
            if (savedRequest != null && savedRequest.getRedirectUrl().endsWith("/dorado/view-service")) {
                this.getRedirectStrategy().sendRedirect(request, response, this.getDefaultTargetUrl());
            } else {
                super.onAuthenticationSuccess(request, response, authentication);
            }
        }
    }
}

