/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.bdf3.security.ui.builder;

import com.bstek.bdf3.security.ui.builder.AbstractBuilder;
import com.bstek.dorado.data.type.EntityDataType;
import com.bstek.dorado.data.type.property.PropertyDef;
import com.bstek.dorado.view.ViewElement;
import com.bstek.dorado.view.widget.Control;
import com.bstek.dorado.view.widget.form.FormElement;
import com.bstek.dorado.view.widget.form.autoform.AutoForm;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="maintain.formElementBuilder")
public class FormElementBuilder
extends AbstractBuilder<FormElement> {
    @Override
    protected Collection<Control> getChildren(FormElement element) {
        if (element.getEditor() != null) {
            return Arrays.asList(element.getEditor());
        }
        return null;
    }

    @Override
    protected String getId(FormElement element) {
        ViewElement viewElement;
        String id = element.getId();
        if (StringUtils.isEmpty((String)id)) {
            id = element.getProperty();
        }
        if (StringUtils.isEmpty((String)id)) {
            id = element.getLabel();
        }
        if (StringUtils.isEmpty((String)id) && (viewElement = element.getParent()) instanceof AutoForm) {
            EntityDataType entityDataType = ((AutoForm)viewElement).getDataType();
            Map dataTypePropertyDefs = null;
            if (entityDataType != null) {
                dataTypePropertyDefs = entityDataType.getPropertyDefs();
            }
            id = this.getFormElementLabel(element, dataTypePropertyDefs);
        }
        return id;
    }

    private String getFormElementLabel(FormElement element, Map<String, PropertyDef> dataTypePropertyDefs) {
        PropertyDef pd;
        String property = element.getProperty();
        if (StringUtils.isNotEmpty((String)property) && dataTypePropertyDefs != null && (pd = dataTypePropertyDefs.get(property)) != null && StringUtils.isNotEmpty((String)pd.getLabel())) {
            return pd.getLabel();
        }
        return property;
    }
}

